// third_party/blink/public/mojom/choosers/file_chooser.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileChooserParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileChooserParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileChooserParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::FileChooserParams_Mode>(
        Traits::mode(input),
        &fragment->mode);

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in FileChooserParams struct");

      decltype(Traits::default_file_name(input)) in_default_file_name = Traits::default_file_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_file_name)::BaseType> default_file_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_default_file_name,
        default_file_name_fragment);

      fragment->default_file_name.Set(
          default_file_name_fragment.is_null() ? nullptr : default_file_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_file_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_file_name in FileChooserParams struct");

      decltype(Traits::selected_files(input)) in_selected_files = Traits::selected_files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selected_files)::BaseType>
          selected_files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& selected_files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>, send_validation>(
        in_selected_files,
        selected_files_fragment,
        &selected_files_validate_params);

      fragment->selected_files.Set(
          selected_files_fragment.is_null() ? nullptr : selected_files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selected_files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selected_files in FileChooserParams struct");

      decltype(Traits::accept_types(input)) in_accept_types = Traits::accept_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accept_types)::BaseType>
          accept_types_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& accept_types_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_accept_types,
        accept_types_fragment,
        &accept_types_validate_params);

      fragment->accept_types.Set(
          accept_types_fragment.is_null() ? nullptr : accept_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accept_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_types in FileChooserParams struct");

      fragment->need_local_path = Traits::need_local_path(input);

      fragment->use_media_capture = Traits::use_media_capture(input);

      fragment->open_writable = Traits::open_writable(input);

      decltype(Traits::requestor(input)) in_requestor = Traits::requestor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->requestor)::BaseType> requestor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_requestor,
        requestor_fragment);

      fragment->requestor.Set(
          requestor_fragment.is_null() ? nullptr : requestor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->requestor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requestor in FileChooserParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::NativeFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NativeFileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NativeFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::file_path(input)) in_file_path = Traits::file_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_path)::BaseType> file_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_file_path,
        file_path_fragment);

      fragment->file_path.Set(
          file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->file_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null file_path in NativeFileInfo struct");

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in NativeFileInfo struct");

      decltype(Traits::base_subdirs(input)) in_base_subdirs = Traits::base_subdirs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->base_subdirs)::BaseType>
          base_subdirs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& base_subdirs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_base_subdirs,
        base_subdirs_fragment,
        &base_subdirs_validate_params);

      fragment->base_subdirs.Set(
          base_subdirs_fragment.is_null() ? nullptr : base_subdirs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->base_subdirs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null base_subdirs in NativeFileInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileSystemFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemFileInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in FileSystemFileInfo struct");

      decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_modification_time,
        modification_time_fragment);

      fragment->modification_time.Set(
          modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->modification_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modification_time in FileSystemFileInfo struct");

      fragment->length = Traits::length(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileChooserResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileChooserResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileChooserResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::files(input)) in_files = Traits::files(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->files)::BaseType>
          files_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileChooserFileInfoDataView>, send_validation>(
        in_files,
        files_fragment,
        &files_validate_params);

      fragment->files.Set(
          files_fragment.is_null() ? nullptr : files_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->files.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null files in FileChooserResult struct");

      decltype(Traits::base_directory(input)) in_base_directory = Traits::base_directory(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->base_directory)::BaseType> base_directory_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_base_directory,
        base_directory_fragment);

      fragment->base_directory.Set(
          base_directory_fragment.is_null() ? nullptr : base_directory_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->base_directory.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null base_directory in FileChooserResult struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FileChooserFileInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FileChooserFileInfoDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FileChooserFileInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FileChooserFileInfoDataView::Tag::kNativeFile: {
    decltype(Traits::native_file(input))
    in_native_file = Traits::native_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_native_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::NativeFileInfoDataView, send_validation>(
  in_native_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null native_file in FileChooserFileInfo union");
    fragment->data.f_native_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::FileChooserFileInfoDataView::Tag::kFileSystem: {
    decltype(Traits::file_system(input))
    in_file_system = Traits::file_system(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_system)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FileSystemFileInfoDataView, send_validation>(
  in_file_system,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_system in FileChooserFileInfo union");
    fragment->data.f_file_system.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SEND_VALIDATION_H_