// third_party/blink/public/mojom/choosers/file_chooser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class FileChooserParamsDataView;

class NativeFileInfoDataView;

class FileSystemFileInfoDataView;

class FileChooserResultDataView;

class FileChooserFileInfoDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FileChooserParamsDataView> {
  using Data = ::blink::mojom::internal::FileChooserParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::NativeFileInfoDataView> {
  using Data = ::blink::mojom::internal::NativeFileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileSystemFileInfoDataView> {
  using Data = ::blink::mojom::internal::FileSystemFileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileChooserResultDataView> {
  using Data = ::blink::mojom::internal::FileChooserResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileChooserFileInfoDataView> {
  using Data = ::blink::mojom::internal::FileChooserFileInfo_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FileChooserParams_Mode : int32_t {
  
  kOpen = 0,
  
  kOpenMultiple = 1,
  
  kUploadFolder = 2,
  
  kOpenDirectory = 3,
  
  kSave = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FileChooserParams_Mode value);
inline bool IsKnownEnumValue(FileChooserParams_Mode value) {
  return internal::FileChooserParams_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileChooserInterfaceBase {};

using FileChooserPtrDataView =
    mojo::InterfacePtrDataView<FileChooserInterfaceBase>;
using FileChooserRequestDataView =
    mojo::InterfaceRequestDataView<FileChooserInterfaceBase>;
using FileChooserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileChooserInterfaceBase>;
using FileChooserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileChooserInterfaceBase>;


class FileChooserParamsDataView {
 public:
  FileChooserParamsDataView() = default;

  FileChooserParamsDataView(
      internal::FileChooserParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::FileChooserParams_Mode>(
        data_value, output);
  }
  FileChooserParams_Mode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FileChooserParams_Mode>(data_->mode));
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDefaultFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultFileName(UserType* output) {
    
    auto* pointer = data_->default_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedFiles(UserType* output) {
    
    auto* pointer = data_->selected_files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
  inline void GetAcceptTypesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptTypes(UserType* output) {
    
    auto* pointer = data_->accept_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  bool need_local_path() const {
    return data_->need_local_path;
  }
  bool use_media_capture() const {
    return data_->use_media_capture;
  }
  bool open_writable() const {
    return data_->open_writable;
  }
  inline void GetRequestorDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestor(UserType* output) {
    
    auto* pointer = data_->requestor.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileChooserParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativeFileInfoDataView {
 public:
  NativeFileInfoDataView() = default;

  NativeFileInfoDataView(
      internal::NativeFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBaseSubdirsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseSubdirs(UserType* output) {
    
    auto* pointer = data_->base_subdirs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::NativeFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileSystemFileInfoDataView {
 public:
  FileSystemFileInfoDataView() = default;

  FileSystemFileInfoDataView(
      internal::FileSystemFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModificationTime(UserType* output) {
    
    auto* pointer = data_->modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  int64_t length() const {
    return data_->length;
  }
 private:
  internal::FileSystemFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileChooserResultDataView {
 public:
  FileChooserResultDataView() = default;

  FileChooserResultDataView(
      internal::FileChooserResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesDataView(
      mojo::ArrayDataView<FileChooserFileInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FileChooserFileInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetBaseDirectoryDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseDirectory(UserType* output) {
    
    auto* pointer = data_->base_directory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileChooserResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileChooserFileInfoDataView {
 public:
  using Tag = internal::FileChooserFileInfo_Data::FileChooserFileInfo_Tag;

  FileChooserFileInfoDataView() = default;

  FileChooserFileInfoDataView(
      internal::FileChooserFileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_native_file() const { return data_->tag == Tag::kNativeFile; }
  inline void GetNativeFileDataView(
      NativeFileInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNativeFile(UserType* output) const {
    
    CHECK(is_native_file());
    return mojo::internal::Deserialize<::blink::mojom::NativeFileInfoDataView>(
        data_->data.f_native_file.Get(), output, message_);
  }
  bool is_file_system() const { return data_->tag == Tag::kFileSystem; }
  inline void GetFileSystemDataView(
      FileSystemFileInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystem(UserType* output) const {
    
    CHECK(is_file_system());
    return mojo::internal::Deserialize<::blink::mojom::FileSystemFileInfoDataView>(
        data_->data.f_file_system.Get(), output, message_);
  }

 private:
  internal::FileChooserFileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_DATA_VIEW_H_