// third_party/blink/public/mojom/choosers/date_time_chooser.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"


namespace blink::mojom {
class DateTimeSuggestionDataView;

class DateTimeDialogValueDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DateTimeSuggestionDataView> {
  using Data = ::blink::mojom::internal::DateTimeSuggestion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DateTimeDialogValueDataView> {
  using Data = ::blink::mojom::internal::DateTimeDialogValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class DateTimeChooserInterfaceBase {};

using DateTimeChooserPtrDataView =
    mojo::InterfacePtrDataView<DateTimeChooserInterfaceBase>;
using DateTimeChooserRequestDataView =
    mojo::InterfaceRequestDataView<DateTimeChooserInterfaceBase>;
using DateTimeChooserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DateTimeChooserInterfaceBase>;
using DateTimeChooserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DateTimeChooserInterfaceBase>;


class DateTimeSuggestionDataView {
 public:
  DateTimeSuggestionDataView() = default;

  DateTimeSuggestionDataView(
      internal::DateTimeSuggestion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
  inline void GetLocalizedValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalizedValue(UserType* output) {
    
    auto* pointer = data_->localized_value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::DateTimeSuggestion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DateTimeDialogValueDataView {
 public:
  DateTimeDialogValueDataView() = default;

  DateTimeDialogValueDataView(
      internal::DateTimeDialogValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDialogType(UserType* output) const {
    auto data_value = data_->dialog_type;
    return mojo::internal::Deserialize<::ui::mojom::TextInputType>(
        data_value, output);
  }
  ::ui::mojom::TextInputType dialog_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputType>(data_->dialog_type));
  }
  double dialog_value() const {
    return data_->dialog_value;
  }
  double minimum() const {
    return data_->minimum;
  }
  double maximum() const {
    return data_->maximum;
  }
  double step() const {
    return data_->step;
  }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<DateTimeSuggestionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DateTimeSuggestionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DateTimeDialogValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_DATE_TIME_CHOOSER_MOJOM_DATA_VIEW_H_