// third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-params-data.h"
#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/choosers/date_time_chooser.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DateTimeSuggestion::DateTimeSuggestion()
    : value(),
      localized_value(),
      label() {}

DateTimeSuggestion::DateTimeSuggestion(
    double value_in,
    const ::blink::String& localized_value_in,
    const ::blink::String& label_in)
    : value(std::move(value_in)),
      localized_value(std::move(localized_value_in)),
      label(std::move(label_in)) {}

DateTimeSuggestion::~DateTimeSuggestion() = default;

void DateTimeSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "localized_value"), this->localized_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DateTimeSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DateTimeDialogValue::DateTimeDialogValue()
    : dialog_type(),
      dialog_value(),
      minimum(),
      maximum(),
      step(),
      suggestions() {}

DateTimeDialogValue::DateTimeDialogValue(
    ::ui::TextInputType dialog_type_in,
    double dialog_value_in,
    double minimum_in,
    double maximum_in,
    double step_in,
    ::blink::Vector<DateTimeSuggestionPtr> suggestions_in)
    : dialog_type(std::move(dialog_type_in)),
      dialog_value(std::move(dialog_value_in)),
      minimum(std::move(minimum_in)),
      maximum(std::move(maximum_in)),
      step(std::move(step_in)),
      suggestions(std::move(suggestions_in)) {}

DateTimeDialogValue::~DateTimeDialogValue() = default;

void DateTimeDialogValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dialog_type"), this->dialog_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::TextInputType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dialog_value"), this->dialog_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum"), this->minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum"), this->maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "step"), this->step,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<DateTimeSuggestionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DateTimeDialogValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DateTimeChooser::IPCStableHashFunction DateTimeChooser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DateTimeChooser>(message.name())) {
    case messages::DateTimeChooser::kOpenDateTimeDialog: {
      return &DateTimeChooser::OpenDateTimeDialog_Sym::IPCStableHash;
    }
    case messages::DateTimeChooser::kCloseDateTimeDialog: {
      return &DateTimeChooser::CloseDateTimeDialog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DateTimeChooser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DateTimeChooser>(message.name())) {
      case messages::DateTimeChooser::kOpenDateTimeDialog:
            return "Receive blink::mojom::DateTimeChooser::OpenDateTimeDialog";
      case messages::DateTimeChooser::kCloseDateTimeDialog:
            return "Receive blink::mojom::DateTimeChooser::CloseDateTimeDialog";
    }
  } else {
    switch (static_cast<messages::DateTimeChooser>(message.name())) {
      case messages::DateTimeChooser::kOpenDateTimeDialog:
            return "Receive reply blink::mojom::DateTimeChooser::OpenDateTimeDialog";
      case messages::DateTimeChooser::kCloseDateTimeDialog:
            return "Receive reply blink::mojom::DateTimeChooser::CloseDateTimeDialog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DateTimeChooser::OpenDateTimeDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1056a592;  // IPCStableHash for blink::mojom::DateTimeChooser::OpenDateTimeDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DateTimeChooser::CloseDateTimeDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2524906;  // IPCStableHash for blink::mojom::DateTimeChooser::CloseDateTimeDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DateTimeChooser_OpenDateTimeDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DateTimeChooser_OpenDateTimeDialog_ForwardToCallback(
      DateTimeChooser::OpenDateTimeDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  DateTimeChooser_OpenDateTimeDialog_ForwardToCallback(const DateTimeChooser_OpenDateTimeDialog_ForwardToCallback&) = delete;
  DateTimeChooser_OpenDateTimeDialog_ForwardToCallback& operator=(const DateTimeChooser_OpenDateTimeDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DateTimeChooser::OpenDateTimeDialogCallback callback_;
};

DateTimeChooserProxy::DateTimeChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DateTimeChooserProxy::OpenDateTimeDialog(
    DateTimeDialogValuePtr in_value, OpenDateTimeDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DateTimeChooser::OpenDateTimeDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type DateTimeDialogValuePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DateTimeChooser::kOpenDateTimeDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DateTimeChooser_OpenDateTimeDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DateTimeDialogValueDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in DateTimeChooser.OpenDateTimeDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DateTimeChooser::Name_);
  message.set_method_name("OpenDateTimeDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DateTimeChooser_OpenDateTimeDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DateTimeChooserProxy::CloseDateTimeDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DateTimeChooser::CloseDateTimeDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DateTimeChooser::kCloseDateTimeDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DateTimeChooser_CloseDateTimeDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DateTimeChooser::Name_);
  message.set_method_name("CloseDateTimeDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DateTimeChooser_OpenDateTimeDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DateTimeChooser::OpenDateTimeDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DateTimeChooser_OpenDateTimeDialog_ProxyToResponder> proxy(
        new DateTimeChooser_OpenDateTimeDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DateTimeChooser_OpenDateTimeDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DateTimeChooser_OpenDateTimeDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DateTimeChooser_OpenDateTimeDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DateTimeChooser::OpenDateTimeDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, double in_dialog_value);
};

bool DateTimeChooser_OpenDateTimeDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DateTimeChooser_OpenDateTimeDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DateTimeChooser_OpenDateTimeDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DateTimeChooser.0
  bool success = true;
  bool p_success{};
  double p_dialog_value{};
  DateTimeChooser_OpenDateTimeDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_dialog_value = input_data_view.dialog_value();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DateTimeChooser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_dialog_value));
  }
  return true;
}

void DateTimeChooser_OpenDateTimeDialog_ProxyToResponder::Run(
    bool in_success, double in_dialog_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DateTimeChooser::OpenDateTimeDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dialog_value"), in_dialog_value,
                        "<value of type double>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DateTimeChooser::kOpenDateTimeDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DateTimeChooser_OpenDateTimeDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->dialog_value = in_dialog_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DateTimeChooser::Name_);
  message.set_method_name("OpenDateTimeDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DateTimeChooserStubDispatch::Accept(
    DateTimeChooser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DateTimeChooser>(message->header()->name)) {
    case messages::DateTimeChooser::kOpenDateTimeDialog: {
      break;
    }
    case messages::DateTimeChooser::kCloseDateTimeDialog: {
      DCHECK(message->is_serialized());
      internal::DateTimeChooser_CloseDateTimeDialog_Params_Data* params =
          reinterpret_cast<internal::DateTimeChooser_CloseDateTimeDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DateTimeChooser.1
      bool success = true;
      DateTimeChooser_CloseDateTimeDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DateTimeChooser::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseDateTimeDialog(        );
      return true;
    }
  }
  return false;
}

// static
bool DateTimeChooserStubDispatch::AcceptWithResponder(
    DateTimeChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DateTimeChooser>(message->header()->name)) {
    case messages::DateTimeChooser::kOpenDateTimeDialog: {
      internal::DateTimeChooser_OpenDateTimeDialog_Params_Data* params =
          reinterpret_cast<
              internal::DateTimeChooser_OpenDateTimeDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DateTimeChooser.0
      bool success = true;
      DateTimeDialogValuePtr p_value{};
      DateTimeChooser_OpenDateTimeDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DateTimeChooser::Name_, 0, false);
        return false;
      }
      auto callback =
          DateTimeChooser_OpenDateTimeDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDateTimeDialog(        
        std::move(p_value), std::move(callback));
      return true;
    }
    case messages::DateTimeChooser::kCloseDateTimeDialog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDateTimeChooserValidationInfo[] = {
    { &internal::DateTimeChooser_OpenDateTimeDialog_Params_Data::Validate,
     &internal::DateTimeChooser_OpenDateTimeDialog_ResponseParams_Data::Validate},
    { &internal::DateTimeChooser_CloseDateTimeDialog_Params_Data::Validate,
     nullptr /* no response */},
};

bool DateTimeChooserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DateTimeChooser::Name_,
    kDateTimeChooserValidationInfo);
}

bool DateTimeChooserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::DateTimeChooser::Name_,
    kDateTimeChooserValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DateTimeSuggestion::DataView, ::blink::mojom::blink::DateTimeSuggestionPtr>::Read(
    ::blink::mojom::blink::DateTimeSuggestion::DataView input,
    ::blink::mojom::blink::DateTimeSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DateTimeSuggestionPtr result(::blink::mojom::blink::DateTimeSuggestion::New());
  
      if (success)
        result->value = input.value();
      if (success && !input.ReadLocalizedValue(&result->localized_value))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DateTimeDialogValue::DataView, ::blink::mojom::blink::DateTimeDialogValuePtr>::Read(
    ::blink::mojom::blink::DateTimeDialogValue::DataView input,
    ::blink::mojom::blink::DateTimeDialogValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DateTimeDialogValuePtr result(::blink::mojom::blink::DateTimeDialogValue::New());
  
      if (success && !input.ReadDialogType(&result->dialog_type))
        success = false;
      if (success)
        result->dialog_value = input.dialog_value();
      if (success)
        result->minimum = input.minimum();
      if (success)
        result->maximum = input.maximum();
      if (success)
        result->step = input.step();
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DateTimeChooserInterceptorForTesting::OpenDateTimeDialog(DateTimeDialogValuePtr value, OpenDateTimeDialogCallback callback) {
  GetForwardingInterface()->OpenDateTimeDialog(
    std::move(value)
    , std::move(callback));
}
void DateTimeChooserInterceptorForTesting::CloseDateTimeDialog() {
  GetForwardingInterface()->CloseDateTimeDialog();
}
DateTimeChooserAsyncWaiter::DateTimeChooserAsyncWaiter(
    DateTimeChooser* proxy) : proxy_(proxy) {}

DateTimeChooserAsyncWaiter::~DateTimeChooserAsyncWaiter() = default;


void DateTimeChooserAsyncWaiter::OpenDateTimeDialog(
    DateTimeDialogValuePtr value, bool* out_success, double* out_dialog_value) {
  base::RunLoop loop;
  proxy_->OpenDateTimeDialog(
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             double* out_dialog_value
,
             bool success,
             double dialog_value) {*out_success = std::move(success);*out_dialog_value = std::move(dialog_value);
            loop->Quit();
          },
          &loop,
          out_success,
          out_dialog_value));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif