// third_party/blink/public/mojom/choosers/color_chooser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-params-data.h"
#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-import-headers.h"
#include "third_party/blink/public/mojom/choosers/color_chooser.mojom-test-utils.h"


namespace blink::mojom {
ColorSuggestion::ColorSuggestion()
    : color(),
      label() {}

ColorSuggestion::ColorSuggestion(
    uint32_t color_in,
    const std::string& label_in)
    : color(std::move(color_in)),
      label(std::move(label_in)) {}

ColorSuggestion::~ColorSuggestion() = default;
size_t ColorSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->color);
  seed = mojo::internal::Hash(seed, this->label);
  return seed;
}

void ColorSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ColorChooserFactory::IPCStableHashFunction ColorChooserFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ColorChooserFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

ColorChooserFactoryProxy::ColorChooserFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ColorChooserFactoryStubDispatch::Accept(
    ColorChooserFactory* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ColorChooserFactoryStubDispatch::AcceptWithResponder(
    ColorChooserFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool ColorChooserFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::blink::mojom::ColorChooserFactory::Name_,
    {});
}

// The declaration includes the definition on other builds.

ColorChooser::IPCStableHashFunction ColorChooser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ColorChooser>(message.name())) {
    case messages::ColorChooser::kSetSelectedColor: {
      return &ColorChooser::SetSelectedColor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ColorChooser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ColorChooser>(message.name())) {
      case messages::ColorChooser::kSetSelectedColor:
            return "Receive blink::mojom::ColorChooser::SetSelectedColor";
    }
  } else {
    switch (static_cast<messages::ColorChooser>(message.name())) {
      case messages::ColorChooser::kSetSelectedColor:
            return "Receive reply blink::mojom::ColorChooser::SetSelectedColor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ColorChooser::SetSelectedColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x690338f2;  // IPCStableHash for blink::mojom::ColorChooser::SetSelectedColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ColorChooserProxy::ColorChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ColorChooserProxy::SetSelectedColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ColorChooser::SetSelectedColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ColorChooser::kSetSelectedColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ColorChooser_SetSelectedColor_Params_Data> params(
          message);
  params.Allocate();

  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ColorChooser::Name_);
  message.set_method_name("SetSelectedColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ColorChooserStubDispatch::Accept(
    ColorChooser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ColorChooser>(message->header()->name)) {
    case messages::ColorChooser::kSetSelectedColor: {
      DCHECK(message->is_serialized());
      internal::ColorChooser_SetSelectedColor_Params_Data* params =
          reinterpret_cast<internal::ColorChooser_SetSelectedColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ColorChooser.0
      bool success = true;
      uint32_t p_color{};
      ColorChooser_SetSelectedColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ColorChooser::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelectedColor(        
        std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool ColorChooserStubDispatch::AcceptWithResponder(
    ColorChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ColorChooser>(message->header()->name)) {
    case messages::ColorChooser::kSetSelectedColor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kColorChooserValidationInfo[] = {
    { &internal::ColorChooser_SetSelectedColor_Params_Data::Validate,
     nullptr /* no response */},
};

bool ColorChooserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ColorChooser::Name_,
    kColorChooserValidationInfo);
}

// The declaration includes the definition on other builds.

ColorChooserClient::IPCStableHashFunction ColorChooserClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ColorChooserClient>(message.name())) {
    case messages::ColorChooserClient::kDidChooseColor: {
      return &ColorChooserClient::DidChooseColor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ColorChooserClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ColorChooserClient>(message.name())) {
      case messages::ColorChooserClient::kDidChooseColor:
            return "Receive blink::mojom::ColorChooserClient::DidChooseColor";
    }
  } else {
    switch (static_cast<messages::ColorChooserClient>(message.name())) {
      case messages::ColorChooserClient::kDidChooseColor:
            return "Receive reply blink::mojom::ColorChooserClient::DidChooseColor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ColorChooserClient::DidChooseColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x467c0b1c;  // IPCStableHash for blink::mojom::ColorChooserClient::DidChooseColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ColorChooserClientProxy::ColorChooserClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ColorChooserClientProxy::DidChooseColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ColorChooserClient::DidChooseColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ColorChooserClient::kDidChooseColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ColorChooserClient_DidChooseColor_Params_Data> params(
          message);
  params.Allocate();

  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ColorChooserClient::Name_);
  message.set_method_name("DidChooseColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ColorChooserClientStubDispatch::Accept(
    ColorChooserClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ColorChooserClient>(message->header()->name)) {
    case messages::ColorChooserClient::kDidChooseColor: {
      DCHECK(message->is_serialized());
      internal::ColorChooserClient_DidChooseColor_Params_Data* params =
          reinterpret_cast<internal::ColorChooserClient_DidChooseColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ColorChooserClient.0
      bool success = true;
      uint32_t p_color{};
      ColorChooserClient_DidChooseColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ColorChooserClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChooseColor(        
        std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool ColorChooserClientStubDispatch::AcceptWithResponder(
    ColorChooserClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ColorChooserClient>(message->header()->name)) {
    case messages::ColorChooserClient::kDidChooseColor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kColorChooserClientValidationInfo[] = {
    { &internal::ColorChooserClient_DidChooseColor_Params_Data::Validate,
     nullptr /* no response */},
};

bool ColorChooserClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ColorChooserClient::Name_,
    kColorChooserClientValidationInfo);
}

// The declaration includes the definition on other builds.

EyeDropperChooser::IPCStableHashFunction EyeDropperChooser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EyeDropperChooser>(message.name())) {
    case messages::EyeDropperChooser::kChoose: {
      return &EyeDropperChooser::Choose_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EyeDropperChooser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EyeDropperChooser>(message.name())) {
      case messages::EyeDropperChooser::kChoose:
            return "Receive blink::mojom::EyeDropperChooser::Choose";
    }
  } else {
    switch (static_cast<messages::EyeDropperChooser>(message.name())) {
      case messages::EyeDropperChooser::kChoose:
            return "Receive reply blink::mojom::EyeDropperChooser::Choose";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EyeDropperChooser::Choose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x296c62df;  // IPCStableHash for blink::mojom::EyeDropperChooser::Choose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class EyeDropperChooser_Choose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  EyeDropperChooser_Choose_ForwardToCallback(
      EyeDropperChooser::ChooseCallback callback
      ) : callback_(std::move(callback)) {
  }

  EyeDropperChooser_Choose_ForwardToCallback(const EyeDropperChooser_Choose_ForwardToCallback&) = delete;
  EyeDropperChooser_Choose_ForwardToCallback& operator=(const EyeDropperChooser_Choose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  EyeDropperChooser::ChooseCallback callback_;
};

EyeDropperChooserProxy::EyeDropperChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EyeDropperChooserProxy::Choose(
    ChooseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::EyeDropperChooser::Choose");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EyeDropperChooser::kChoose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EyeDropperChooser_Choose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EyeDropperChooser::Name_);
  message.set_method_name("Choose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new EyeDropperChooser_Choose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class EyeDropperChooser_Choose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static EyeDropperChooser::ChooseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<EyeDropperChooser_Choose_ProxyToResponder> proxy(
        new EyeDropperChooser_Choose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&EyeDropperChooser_Choose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~EyeDropperChooser_Choose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  EyeDropperChooser_Choose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "EyeDropperChooser::ChooseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint32_t in_color);
};

bool EyeDropperChooser_Choose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::EyeDropperChooser_Choose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::EyeDropperChooser_Choose_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for EyeDropperChooser.0
  bool success = true;
  bool p_success{};
  uint32_t p_color{};
  EyeDropperChooser_Choose_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_color = input_data_view.color();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        EyeDropperChooser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_color));
  }
  return true;
}

void EyeDropperChooser_Choose_ProxyToResponder::Run(
    bool in_success, uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::EyeDropperChooser::Choose", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EyeDropperChooser::kChoose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EyeDropperChooser_Choose_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EyeDropperChooser::Name_);
  message.set_method_name("Choose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool EyeDropperChooserStubDispatch::Accept(
    EyeDropperChooser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EyeDropperChooser>(message->header()->name)) {
    case messages::EyeDropperChooser::kChoose: {
      break;
    }
  }
  return false;
}

// static
bool EyeDropperChooserStubDispatch::AcceptWithResponder(
    EyeDropperChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EyeDropperChooser>(message->header()->name)) {
    case messages::EyeDropperChooser::kChoose: {
      internal::EyeDropperChooser_Choose_Params_Data* params =
          reinterpret_cast<
              internal::EyeDropperChooser_Choose_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for EyeDropperChooser.0
      bool success = true;
      EyeDropperChooser_Choose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EyeDropperChooser::Name_, 0, false);
        return false;
      }
      auto callback =
          EyeDropperChooser_Choose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Choose(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEyeDropperChooserValidationInfo[] = {
    { &internal::EyeDropperChooser_Choose_Params_Data::Validate,
     &internal::EyeDropperChooser_Choose_ResponseParams_Data::Validate},
};

bool EyeDropperChooserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EyeDropperChooser::Name_,
    kEyeDropperChooserValidationInfo);
}

bool EyeDropperChooserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::EyeDropperChooser::Name_,
    kEyeDropperChooserValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ColorSuggestion::DataView, ::blink::mojom::ColorSuggestionPtr>::Read(
    ::blink::mojom::ColorSuggestion::DataView input,
    ::blink::mojom::ColorSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::ColorSuggestionPtr result(::blink::mojom::ColorSuggestion::New());
  
      if (success)
        result->color = input.color();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


ColorChooserFactoryAsyncWaiter::ColorChooserFactoryAsyncWaiter(
    ColorChooserFactory* proxy) : proxy_(proxy) {}

ColorChooserFactoryAsyncWaiter::~ColorChooserFactoryAsyncWaiter() = default;





void ColorChooserInterceptorForTesting::SetSelectedColor(uint32_t color) {
  GetForwardingInterface()->SetSelectedColor(
    std::move(color)
    );
}
ColorChooserAsyncWaiter::ColorChooserAsyncWaiter(
    ColorChooser* proxy) : proxy_(proxy) {}

ColorChooserAsyncWaiter::~ColorChooserAsyncWaiter() = default;





void ColorChooserClientInterceptorForTesting::DidChooseColor(uint32_t color) {
  GetForwardingInterface()->DidChooseColor(
    std::move(color)
    );
}
ColorChooserClientAsyncWaiter::ColorChooserClientAsyncWaiter(
    ColorChooserClient* proxy) : proxy_(proxy) {}

ColorChooserClientAsyncWaiter::~ColorChooserClientAsyncWaiter() = default;





void EyeDropperChooserInterceptorForTesting::Choose(ChooseCallback callback) {
  GetForwardingInterface()->Choose(std::move(callback));
}
EyeDropperChooserAsyncWaiter::EyeDropperChooserAsyncWaiter(
    EyeDropperChooser* proxy) : proxy_(proxy) {}

EyeDropperChooserAsyncWaiter::~EyeDropperChooserAsyncWaiter() = default;


void EyeDropperChooserAsyncWaiter::Choose(
    bool* out_success, uint32_t* out_color) {
  base::RunLoop loop;
  proxy_->Choose(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint32_t* out_color
,
             bool success,
             uint32_t color) {*out_success = std::move(success);*out_color = std::move(color);
            loop->Quit();
          },
          &loop,
          out_success,
          out_color));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif