// third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec
} from '../tokens/tokens.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CallStackGeneratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CallStackGenerator', scope);
  }
}

/** @interface */
export class CallStackGeneratorInterface {
  
  /**
   * @return {!Promise<{
        javascriptCallStack: !string,
        frameToken: ?blink_mojom_LocalFrameToken,
   *  }>}
   */

  collectJavaScriptCallStack() {}
}

/**
 * @implements { CallStackGeneratorInterface }
 */
export class CallStackGeneratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CallStackGeneratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CallStackGeneratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CallStackGeneratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        javascriptCallStack: !string,
        frameToken: ?blink_mojom_LocalFrameToken,
   *  }>}
   */

  collectJavaScriptCallStack() {
    return this.proxy.sendMessage(
        0,
        CallStackGenerator_CollectJavaScriptCallStack_ParamsSpec.$,
        CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CallStackGenerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CallStackGeneratorReceiver {
  /**
   * @param {!CallStackGeneratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CallStackGeneratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CallStackGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CallStackGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CallStackGenerator_CollectJavaScriptCallStack_ParamsSpec.$,
        CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsSpec.$,
        impl.collectJavaScriptCallStack.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CallStackGenerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CallStackGenerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CallStackGeneratorRemote}
   */
  static getRemote() {
    let remote = new CallStackGeneratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CallStackGenerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CallStackGeneratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CallStackGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CallStackGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collectJavaScriptCallStack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CallStackGenerator_CollectJavaScriptCallStack_ParamsSpec.$,
        CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsSpec.$,
        this.collectJavaScriptCallStack.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CallStackGenerator_CollectJavaScriptCallStack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CallStackGenerator_CollectJavaScriptCallStack_ParamsSpec.$,
    'CallStackGenerator_CollectJavaScriptCallStack_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CallStackGenerator_CollectJavaScriptCallStack_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CallStackGenerator_CollectJavaScriptCallStack_ResponseParamsSpec.$,
    'CallStackGenerator_CollectJavaScriptCallStack_ResponseParams',
    [
      mojo.internal.StructField(
        'javascriptCallStack', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameToken', 8,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CallStackGenerator_CollectJavaScriptCallStack_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.javascriptCallStack;
    /** @type { (blink_mojom_LocalFrameToken|undefined) } */
    this.frameToken;
  }
}

