// third_party/blink/public/mojom/cache_storage/cache_storage.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BlobReaderClientRemote as blink_mojom_BlobReaderClientRemote,
  BlobReaderClientPendingReceiver as blink_mojom_BlobReaderClientPendingReceiver
} from '../blob/blob.mojom.m.js';

import {
  FetchAPIRequest as blink_mojom_FetchAPIRequest,
  FetchAPIRequestSpec as blink_mojom_FetchAPIRequestSpec
} from '../fetch/fetch_api_request.mojom.m.js';

import {
  FetchAPIResponse as blink_mojom_FetchAPIResponse,
  FetchAPIResponseSpec as blink_mojom_FetchAPIResponseSpec
} from '../fetch/fetch_api_response.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CacheStorageErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CacheStorageError = {
  
  kSuccess: 0,
  kErrorExists: 1,
  kErrorStorage: 2,
  kErrorNotFound: 3,
  kErrorQuotaExceeded: 4,
  kErrorCacheNameNotFound: 5,
  kErrorQueryTooLarge: 6,
  kErrorNotImplemented: 7,
  kErrorDuplicateOperation: 8,
  kErrorCrossOriginResourcePolicy: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OperationType = {
  
  kUndefined: 0,
  kPut: 1,
  kDelete: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CacheStorageCachePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CacheStorageCache', scope);
  }
}

/** @interface */
export class CacheStorageCacheInterface {
  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_Match_ResponseParam_Result,
   *  }>}
   */

  match(request, queryOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {}
  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_MatchAll_ResponseParam_Result,
   *  }>}
   */

  matchAll(request, queryOptions, traceId) {}
  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result,
   *  }>}
   */

  getAllMatchedEntries(request, queryOptions, traceId) {}
  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_Keys_ResponseParam_Result,
   *  }>}
   */

  keys(request, queryOptions, traceId) {}
  
  /**
   * @param { !Array<!BatchOperation> } batchOperations
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageVerboseError,
   *  }>}
   */

  batch(batchOperations, traceId) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  writeSideData(url, expectedResponseTime, data, traceId) {}
}

/**
 * @implements { CacheStorageCacheInterface }
 */
export class CacheStorageCacheRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CacheStorageCachePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CacheStorageCachePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CacheStorageCachePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_Match_ResponseParam_Result,
   *  }>}
   */

  match(
      request,
      queryOptions,
      inRelatedFetchEvent,
      inRangeFetchEvent,
      traceId) {
    return this.proxy.sendMessage(
        0,
        CacheStorageCache_Match_ParamsSpec.$,
        CacheStorageCache_Match_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          inRelatedFetchEvent,
          inRangeFetchEvent,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_MatchAll_ResponseParam_Result,
   *  }>}
   */

  matchAll(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        1,
        CacheStorageCache_MatchAll_ParamsSpec.$,
        CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result,
   *  }>}
   */

  getAllMatchedEntries(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        2,
        CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { ?blink_mojom_FetchAPIRequest } request
   * @param { !CacheQueryOptions } queryOptions
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageCache_Keys_ResponseParam_Result,
   *  }>}
   */

  keys(
      request,
      queryOptions,
      traceId) {
    return this.proxy.sendMessage(
        3,
        CacheStorageCache_Keys_ParamsSpec.$,
        CacheStorageCache_Keys_ResponseParamsSpec.$,
        [
          request,
          queryOptions,
          traceId
        ],
        true);
  }

  
  /**
   * @param { !Array<!BatchOperation> } batchOperations
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageVerboseError,
   *  }>}
   */

  batch(
      batchOperations,
      traceId) {
    return this.proxy.sendMessage(
        4,
        CacheStorageCache_Batch_ParamsSpec.$,
        CacheStorageCache_Batch_ResponseParamsSpec.$,
        [
          batchOperations,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  writeSideData(
      url,
      expectedResponseTime,
      data,
      traceId) {
    return this.proxy.sendMessage(
        5,
        CacheStorageCache_WriteSideData_ParamsSpec.$,
        CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        [
          url,
          expectedResponseTime,
          data,
          traceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CacheStorageCache
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CacheStorageCacheReceiver {
  /**
   * @param {!CacheStorageCacheInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CacheStorageCacheRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CacheStorageCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CacheStorageCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CacheStorageCache_Match_ParamsSpec.$,
        CacheStorageCache_Match_ResponseParamsSpec.$,
        impl.match.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        1,
        CacheStorageCache_MatchAll_ParamsSpec.$,
        CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        impl.matchAll.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        impl.getAllMatchedEntries.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        3,
        CacheStorageCache_Keys_ParamsSpec.$,
        CacheStorageCache_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        CacheStorageCache_Batch_ParamsSpec.$,
        CacheStorageCache_Batch_ResponseParamsSpec.$,
        impl.batch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CacheStorageCache_WriteSideData_ParamsSpec.$,
        CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        impl.writeSideData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CacheStorageCache {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CacheStorageCache";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CacheStorageCacheRemote}
   */
  static getRemote() {
    let remote = new CacheStorageCacheRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CacheStorageCache
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CacheStorageCacheCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CacheStorageCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CacheStorageCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.match =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CacheStorageCache_Match_ParamsSpec.$,
        CacheStorageCache_Match_ResponseParamsSpec.$,
        this.match.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CacheStorageCache_MatchAll_ParamsSpec.$,
        CacheStorageCache_MatchAll_ResponseParamsSpec.$,
        this.matchAll.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllMatchedEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
        CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
        this.getAllMatchedEntries.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CacheStorageCache_Keys_ParamsSpec.$,
        CacheStorageCache_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.batch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CacheStorageCache_Batch_ParamsSpec.$,
        CacheStorageCache_Batch_ResponseParamsSpec.$,
        this.batch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSideData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CacheStorageCache_WriteSideData_ParamsSpec.$,
        CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
        this.writeSideData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CacheStoragePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CacheStorage', scope);
  }
}

/** @interface */
export class CacheStorageInterface {
  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  has(cacheName, traceId) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  delete(cacheName, traceId) {}
  
  /**
   * @param { !bigint } traceId
   * @return {!Promise<{
        keys: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  keys(traceId) {}
  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { !MultiCacheQueryOptions } matchOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorage_Match_ResponseParam_Result,
   *  }>}
   */

  match(request, matchOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorage_Open_ResponseParam_Result,
   *  }>}
   */

  open(cacheName, traceId) {}
}

/**
 * @implements { CacheStorageInterface }
 */
export class CacheStorageRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CacheStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CacheStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CacheStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  has(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        0,
        CacheStorage_Has_ParamsSpec.$,
        CacheStorage_Has_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorageError,
   *  }>}
   */

  delete(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        1,
        CacheStorage_Delete_ParamsSpec.$,
        CacheStorage_Delete_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        false);
  }

  
  /**
   * @param { !bigint } traceId
   * @return {!Promise<{
        keys: !Array<!mojoBase_mojom_String16>,
   *  }>}
   */

  keys(
      traceId) {
    return this.proxy.sendMessage(
        2,
        CacheStorage_Keys_ParamsSpec.$,
        CacheStorage_Keys_ResponseParamsSpec.$,
        [
          traceId
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FetchAPIRequest } request
   * @param { !MultiCacheQueryOptions } matchOptions
   * @param { !boolean } inRelatedFetchEvent
   * @param { !boolean } inRangeFetchEvent
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorage_Match_ResponseParam_Result,
   *  }>}
   */

  match(
      request,
      matchOptions,
      inRelatedFetchEvent,
      inRangeFetchEvent,
      traceId) {
    return this.proxy.sendMessage(
        3,
        CacheStorage_Match_ParamsSpec.$,
        CacheStorage_Match_ResponseParamsSpec.$,
        [
          request,
          matchOptions,
          inRelatedFetchEvent,
          inRangeFetchEvent,
          traceId
        ],
        true);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } cacheName
   * @param { !bigint } traceId
   * @return {!Promise<{
        result: !CacheStorage_Open_ResponseParam_Result,
   *  }>}
   */

  open(
      cacheName,
      traceId) {
    return this.proxy.sendMessage(
        4,
        CacheStorage_Open_ParamsSpec.$,
        CacheStorage_Open_ResponseParamsSpec.$,
        [
          cacheName,
          traceId
        ],
        true);
  }
}

/**
 * An object which receives request messages for the CacheStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CacheStorageReceiver {
  /**
   * @param {!CacheStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CacheStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CacheStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CacheStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CacheStorage_Has_ParamsSpec.$,
        CacheStorage_Has_ResponseParamsSpec.$,
        impl.has.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CacheStorage_Delete_ParamsSpec.$,
        CacheStorage_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CacheStorage_Keys_ParamsSpec.$,
        CacheStorage_Keys_ResponseParamsSpec.$,
        impl.keys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CacheStorage_Match_ParamsSpec.$,
        CacheStorage_Match_ResponseParamsSpec.$,
        impl.match.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        CacheStorage_Open_ParamsSpec.$,
        CacheStorage_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CacheStorage {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CacheStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CacheStorageRemote}
   */
  static getRemote() {
    let remote = new CacheStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CacheStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CacheStorageCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CacheStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CacheStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.has =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CacheStorage_Has_ParamsSpec.$,
        CacheStorage_Has_ResponseParamsSpec.$,
        this.has.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CacheStorage_Delete_ParamsSpec.$,
        CacheStorage_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CacheStorage_Keys_ParamsSpec.$,
        CacheStorage_Keys_ResponseParamsSpec.$,
        this.keys.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.match =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CacheStorage_Match_ParamsSpec.$,
        CacheStorage_Match_ResponseParamsSpec.$,
        this.match.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CacheStorage_Open_ParamsSpec.$,
        CacheStorage_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        true);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageVerboseErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheQueryOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MultiCacheQueryOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BatchOperationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EagerResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Match_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Match_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_MatchAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_MatchAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_GetAllMatchedEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Batch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_Batch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_WriteSideData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorageCache_WriteSideData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Has_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Has_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Keys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Keys_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Match_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Match_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CacheStorage_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const MatchResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorageCache_Match_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorageCache_MatchAll_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorageCache_Keys_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorage_Match_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CacheStorage_Open_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CacheStorageVerboseErrorSpec.$,
    'CacheStorageVerboseError',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        CacheStorageErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageVerboseError {
  constructor() {
    /** @type { !CacheStorageError } */
    this.value;
    /** @type { (string|undefined) } */
    this.message;
  }
}



mojo.internal.Struct(
    CacheQueryOptionsSpec.$,
    'CacheQueryOptions',
    [
      mojo.internal.StructField(
        'ignoreSearch', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ignoreMethod', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ignoreVary', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheQueryOptions {
  constructor() {
    /** @type { !boolean } */
    this.ignoreSearch;
    /** @type { !boolean } */
    this.ignoreMethod;
    /** @type { !boolean } */
    this.ignoreVary;
  }
}



mojo.internal.Struct(
    MultiCacheQueryOptionsSpec.$,
    'MultiCacheQueryOptions',
    [
      mojo.internal.StructField(
        'queryOptions', 0,
        0,
        CacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MultiCacheQueryOptions {
  constructor() {
    /** @type { !CacheQueryOptions } */
    this.queryOptions;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.cacheName;
  }
}



mojo.internal.Struct(
    BatchOperationSpec.$,
    'BatchOperation',
    [
      mojo.internal.StructField(
        'operationType', 0,
        0,
        OperationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 16,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchOptions', 24,
        0,
        CacheQueryOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class BatchOperation {
  constructor() {
    /** @type { !OperationType } */
    this.operationType;
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { (blink_mojom_FetchAPIResponse|undefined) } */
    this.response;
    /** @type { (CacheQueryOptions|undefined) } */
    this.matchOptions;
  }
}



mojo.internal.Struct(
    EagerResponseSpec.$,
    'EagerResponse',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pipe', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientReceiver', 12,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_BlobReaderClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EagerResponse {
  constructor() {
    /** @type { !blink_mojom_FetchAPIResponse } */
    this.response;
    /** @type { !MojoHandle } */
    this.pipe;
    /** @type { !blink_mojom_BlobReaderClientPendingReceiver } */
    this.clientReceiver;
  }
}



mojo.internal.Struct(
    CacheEntrySpec.$,
    'CacheEntry',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink_mojom_FetchAPIResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheEntry {
  constructor() {
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { !blink_mojom_FetchAPIResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Match_ParamsSpec.$,
    'CacheStorageCache_Match_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        CacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inRelatedFetchEvent', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inRangeFetchEvent', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CacheStorageCache_Match_Params {
  constructor() {
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { !CacheQueryOptions } */
    this.queryOptions;
    /** @type { !boolean } */
    this.inRelatedFetchEvent;
    /** @type { !boolean } */
    this.inRangeFetchEvent;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Match_ResponseParamsSpec.$,
    'CacheStorageCache_Match_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageCache_Match_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageCache_Match_ResponseParams {
  constructor() {
    /** @type { !CacheStorageCache_Match_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorageCache_MatchAll_ParamsSpec.$,
    'CacheStorageCache_MatchAll_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        CacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CacheStorageCache_MatchAll_Params {
  constructor() {
    /** @type { (blink_mojom_FetchAPIRequest|undefined) } */
    this.request;
    /** @type { !CacheQueryOptions } */
    this.queryOptions;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_MatchAll_ResponseParamsSpec.$,
    'CacheStorageCache_MatchAll_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageCache_MatchAll_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageCache_MatchAll_ResponseParams {
  constructor() {
    /** @type { !CacheStorageCache_MatchAll_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorageCache_GetAllMatchedEntries_ParamsSpec.$,
    'CacheStorageCache_GetAllMatchedEntries_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        CacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CacheStorageCache_GetAllMatchedEntries_Params {
  constructor() {
    /** @type { (blink_mojom_FetchAPIRequest|undefined) } */
    this.request;
    /** @type { !CacheQueryOptions } */
    this.queryOptions;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_GetAllMatchedEntries_ResponseParamsSpec.$,
    'CacheStorageCache_GetAllMatchedEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageCache_GetAllMatchedEntries_ResponseParams {
  constructor() {
    /** @type { !CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Keys_ParamsSpec.$,
    'CacheStorageCache_Keys_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryOptions', 8,
        0,
        CacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CacheStorageCache_Keys_Params {
  constructor() {
    /** @type { (blink_mojom_FetchAPIRequest|undefined) } */
    this.request;
    /** @type { !CacheQueryOptions } */
    this.queryOptions;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Keys_ResponseParamsSpec.$,
    'CacheStorageCache_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageCache_Keys_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageCache_Keys_ResponseParams {
  constructor() {
    /** @type { !CacheStorageCache_Keys_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Batch_ParamsSpec.$,
    'CacheStorageCache_Batch_Params',
    [
      mojo.internal.StructField(
        'batchOperations', 0,
        0,
        mojo.internal.Array(BatchOperationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorageCache_Batch_Params {
  constructor() {
    /** @type { !Array<!BatchOperation> } */
    this.batchOperations;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_Batch_ResponseParamsSpec.$,
    'CacheStorageCache_Batch_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageVerboseErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorageCache_Batch_ResponseParams {
  constructor() {
    /** @type { !CacheStorageVerboseError } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorageCache_WriteSideData_ParamsSpec.$,
    'CacheStorageCache_WriteSideData_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 32,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class CacheStorageCache_WriteSideData_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_Time } */
    this.expectedResponseTime;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorageCache_WriteSideData_ResponseParamsSpec.$,
    'CacheStorageCache_WriteSideData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorageCache_WriteSideData_ResponseParams {
  constructor() {
    /** @type { !CacheStorageError } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorage_Has_ParamsSpec.$,
    'CacheStorage_Has_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorage_Has_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.cacheName;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorage_Has_ResponseParamsSpec.$,
    'CacheStorage_Has_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorage_Has_ResponseParams {
  constructor() {
    /** @type { !CacheStorageError } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorage_Delete_ParamsSpec.$,
    'CacheStorage_Delete_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorage_Delete_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.cacheName;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorage_Delete_ResponseParamsSpec.$,
    'CacheStorage_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorageErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorage_Delete_ResponseParams {
  constructor() {
    /** @type { !CacheStorageError } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorage_Keys_ParamsSpec.$,
    'CacheStorage_Keys_Params',
    [
      mojo.internal.StructField(
        'traceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorage_Keys_Params {
  constructor() {
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorage_Keys_ResponseParamsSpec.$,
    'CacheStorage_Keys_ResponseParams',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CacheStorage_Keys_ResponseParams {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_String16> } */
    this.keys;
  }
}



mojo.internal.Struct(
    CacheStorage_Match_ParamsSpec.$,
    'CacheStorage_Match_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink_mojom_FetchAPIRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchOptions', 8,
        0,
        MultiCacheQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inRelatedFetchEvent', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inRangeFetchEvent', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CacheStorage_Match_Params {
  constructor() {
    /** @type { !blink_mojom_FetchAPIRequest } */
    this.request;
    /** @type { !MultiCacheQueryOptions } */
    this.matchOptions;
    /** @type { !boolean } */
    this.inRelatedFetchEvent;
    /** @type { !boolean } */
    this.inRangeFetchEvent;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorage_Match_ResponseParamsSpec.$,
    'CacheStorage_Match_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorage_Match_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorage_Match_ResponseParams {
  constructor() {
    /** @type { !CacheStorage_Match_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    CacheStorage_Open_ParamsSpec.$,
    'CacheStorage_Open_Params',
    [
      mojo.internal.StructField(
        'cacheName', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorage_Open_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.cacheName;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    CacheStorage_Open_ResponseParamsSpec.$,
    'CacheStorage_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        CacheStorage_Open_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CacheStorage_Open_ResponseParams {
  constructor() {
    /** @type { !CacheStorage_Open_ResponseParam_Result } */
    this.result;
  }
}

mojo.internal.Union(
    MatchResponseSpec.$, 'MatchResponse',
    {
      'response': {
        'ordinal': 0,
        'type': blink_mojom_FetchAPIResponseSpec.$,
      },
      'eagerResponse': {
        'ordinal': 1,
        'type': EagerResponseSpec.$,
      },
    });

/**
 * @typedef { {
 *   response: (!blink_mojom_FetchAPIResponse|undefined),
 *   eagerResponse: (!EagerResponse|undefined),
 * } }
 */
export const MatchResponse = {};
mojo.internal.Union(
    CacheStorageCache_Match_ResponseParam_ResultSpec.$, 'CacheStorageCache_Match_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': MatchResponseSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!MatchResponse|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorageCache_Match_ResponseParam_Result = {};
mojo.internal.Union(
    CacheStorageCache_MatchAll_ResponseParam_ResultSpec.$, 'CacheStorageCache_MatchAll_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink_mojom_FetchAPIResponseSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink_mojom_FetchAPIResponse>|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorageCache_MatchAll_ResponseParam_Result = {};
mojo.internal.Union(
    CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultSpec.$, 'CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(CacheEntrySpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!CacheEntry>|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result = {};
mojo.internal.Union(
    CacheStorageCache_Keys_ResponseParam_ResultSpec.$, 'CacheStorageCache_Keys_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Array(blink_mojom_FetchAPIRequestSpec.$, false),
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Array<!blink_mojom_FetchAPIRequest>|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorageCache_Keys_ResponseParam_Result = {};
mojo.internal.Union(
    CacheStorage_Match_ResponseParam_ResultSpec.$, 'CacheStorage_Match_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': MatchResponseSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!MatchResponse|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorage_Match_ResponseParam_Result = {};
mojo.internal.Union(
    CacheStorage_Open_ResponseParam_ResultSpec.$, 'CacheStorage_Open_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.AssociatedInterfaceProxy(CacheStorageCacheRemote),
      },
      'failure': {
        'ordinal': 1,
        'type': CacheStorageErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!Object|undefined),
 *   failure: (!CacheStorageError|undefined),
 * } }
 */
export const CacheStorage_Open_ResponseParam_Result = {};
