// third_party/blink/public/mojom/cache_storage/cache_storage.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/cache_storage/cache_storage.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var read_only_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/read_only_buffer.mojom', '../../../../../mojo/public/mojom/base/read_only_buffer.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', '../blob/blob.mojom.js');
  }
  var fetch_api_response$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fetch/fetch_api_response.mojom', '../fetch/fetch_api_response.mojom.js');
  }
  var fetch_api_request$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fetch/fetch_api_request.mojom', '../fetch/fetch_api_request.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var CacheStorageError = {};
  CacheStorageError.kSuccess = 0;
  CacheStorageError.kErrorExists = 1;
  CacheStorageError.kErrorStorage = 2;
  CacheStorageError.kErrorNotFound = 3;
  CacheStorageError.kErrorQuotaExceeded = 4;
  CacheStorageError.kErrorCacheNameNotFound = 5;
  CacheStorageError.kErrorQueryTooLarge = 6;
  CacheStorageError.kErrorNotImplemented = 7;
  CacheStorageError.kErrorDuplicateOperation = 8;
  CacheStorageError.kErrorCrossOriginResourcePolicy = 9;
  CacheStorageError.MIN_VALUE = 0;
  CacheStorageError.MAX_VALUE = 9;

  CacheStorageError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  CacheStorageError.toKnownEnumValue = function(value) {
    return value;
  };

  CacheStorageError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var OperationType = {};
  OperationType.kUndefined = 0;
  OperationType.kPut = 1;
  OperationType.kDelete = 2;
  OperationType.MIN_VALUE = 0;
  OperationType.MAX_VALUE = 2;

  OperationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  OperationType.toKnownEnumValue = function(value) {
    return value;
  };

  OperationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CacheStorageVerboseError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageVerboseError.prototype.initDefaults_ = function() {
    this.value = 0;
    this.message = null;
  };
  CacheStorageVerboseError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageVerboseError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageVerboseError.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageVerboseError.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageVerboseError.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageVerboseError.decode = function(decoder) {
    var packed;
    var val = new CacheStorageVerboseError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(CacheStorageError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CacheStorageVerboseError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageVerboseError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  function CacheQueryOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheQueryOptions.prototype.initDefaults_ = function() {
    this.ignoreSearch = false;
    this.ignoreMethod = false;
    this.ignoreVary = false;
  };
  CacheQueryOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheQueryOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  CacheQueryOptions.encodedSize = codec.kStructHeaderSize + 8;

  CacheQueryOptions.decode = function(decoder) {
    var packed;
    var val = new CacheQueryOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.ignoreSearch = (packed >> 0) & 1 ? true : false;
    val.ignoreMethod = (packed >> 1) & 1 ? true : false;
    val.ignoreVary = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CacheQueryOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheQueryOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.ignoreSearch & 1) << 0
    packed |= (val.ignoreMethod & 1) << 1
    packed |= (val.ignoreVary & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MultiCacheQueryOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MultiCacheQueryOptions.prototype.initDefaults_ = function() {
    this.queryOptions = null;
    this.cacheName = null;
  };
  MultiCacheQueryOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MultiCacheQueryOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MultiCacheQueryOptions.queryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MultiCacheQueryOptions.cacheName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MultiCacheQueryOptions.encodedSize = codec.kStructHeaderSize + 16;

  MultiCacheQueryOptions.decode = function(decoder) {
    var packed;
    var val = new MultiCacheQueryOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.queryOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    val.cacheName =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  MultiCacheQueryOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MultiCacheQueryOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CacheQueryOptions, val.queryOptions);
    encoder.encodeStructPointer(string16$.String16, val.cacheName);
  };
  function BatchOperation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BatchOperation.prototype.initDefaults_ = function() {
    this.operationType = 0;
    this.request = null;
    this.response = null;
    this.matchOptions = null;
  };
  BatchOperation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BatchOperation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BatchOperation.operationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, OperationType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BatchOperation.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, fetch_api_request$.FetchAPIRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BatchOperation.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, fetch_api_response$.FetchAPIResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BatchOperation.matchOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, CacheQueryOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BatchOperation.encodedSize = codec.kStructHeaderSize + 32;

  BatchOperation.decode = function(decoder) {
    var packed;
    var val = new BatchOperation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.operationType =
        decoder.decodeStruct(new codec.Enum(OperationType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.response =
        decoder.decodeStructPointer(fetch_api_response$.FetchAPIResponse);
    val.matchOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    return val;
  };

  BatchOperation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BatchOperation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.operationType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(fetch_api_response$.FetchAPIResponse, val.response);
    encoder.encodeStructPointer(CacheQueryOptions, val.matchOptions);
  };
  function EagerResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EagerResponse.prototype.initDefaults_ = function() {
    this.response = null;
    this.pipe = null;
    this.clientReceiver = new bindings.InterfaceRequest();
  };
  EagerResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EagerResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EagerResponse.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_response$.FetchAPIResponse, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EagerResponse.pipe
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EagerResponse.clientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EagerResponse.encodedSize = codec.kStructHeaderSize + 16;

  EagerResponse.decode = function(decoder) {
    var packed;
    var val = new EagerResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStructPointer(fetch_api_response$.FetchAPIResponse);
    val.pipe =
        decoder.decodeStruct(codec.Handle);
    val.clientReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    return val;
  };

  EagerResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EagerResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_response$.FetchAPIResponse, val.response);
    encoder.encodeStruct(codec.Handle, val.pipe);
    encoder.encodeStruct(codec.InterfaceRequest, val.clientReceiver);
  };
  function CacheEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheEntry.prototype.initDefaults_ = function() {
    this.request = null;
    this.response = null;
  };
  CacheEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheEntry.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheEntry.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, fetch_api_response$.FetchAPIResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheEntry.encodedSize = codec.kStructHeaderSize + 16;

  CacheEntry.decode = function(decoder) {
    var packed;
    var val = new CacheEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.response =
        decoder.decodeStructPointer(fetch_api_response$.FetchAPIResponse);
    return val;
  };

  CacheEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(fetch_api_response$.FetchAPIResponse, val.response);
  };
  function CacheStorageCache_Match_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Match_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.queryOptions = null;
    this.inRelatedFetchEvent = false;
    this.inRangeFetchEvent = false;
    this.traceId = 0;
  };
  CacheStorageCache_Match_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Match_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Match_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Match_Params.queryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  CacheStorageCache_Match_Params.encodedSize = codec.kStructHeaderSize + 32;

  CacheStorageCache_Match_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Match_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.queryOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    packed = decoder.readUint8();
    val.inRelatedFetchEvent = (packed >> 0) & 1 ? true : false;
    val.inRangeFetchEvent = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_Match_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Match_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(CacheQueryOptions, val.queryOptions);
    packed = 0;
    packed |= (val.inRelatedFetchEvent & 1) << 0
    packed |= (val.inRangeFetchEvent & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_Match_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Match_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorageCache_Match_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Match_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Match_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorageCache_Match_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_Match_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageCache_Match_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Match_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorageCache_Match_ResponseParam_Result);
    return val;
  };

  CacheStorageCache_Match_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Match_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorageCache_Match_ResponseParam_Result, val.result);
  };
  function CacheStorageCache_MatchAll_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_MatchAll_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.queryOptions = null;
    this.traceId = 0;
  };
  CacheStorageCache_MatchAll_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_MatchAll_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_MatchAll_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_MatchAll_Params.queryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorageCache_MatchAll_Params.encodedSize = codec.kStructHeaderSize + 24;

  CacheStorageCache_MatchAll_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_MatchAll_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.queryOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_MatchAll_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_MatchAll_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(CacheQueryOptions, val.queryOptions);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_MatchAll_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_MatchAll_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorageCache_MatchAll_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_MatchAll_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_MatchAll_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorageCache_MatchAll_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_MatchAll_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageCache_MatchAll_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_MatchAll_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorageCache_MatchAll_ResponseParam_Result);
    return val;
  };

  CacheStorageCache_MatchAll_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_MatchAll_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorageCache_MatchAll_ResponseParam_Result, val.result);
  };
  function CacheStorageCache_GetAllMatchedEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_GetAllMatchedEntries_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.queryOptions = null;
    this.traceId = 0;
  };
  CacheStorageCache_GetAllMatchedEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_GetAllMatchedEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_GetAllMatchedEntries_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_GetAllMatchedEntries_Params.queryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorageCache_GetAllMatchedEntries_Params.encodedSize = codec.kStructHeaderSize + 24;

  CacheStorageCache_GetAllMatchedEntries_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_GetAllMatchedEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.queryOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_GetAllMatchedEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_GetAllMatchedEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(CacheQueryOptions, val.queryOptions);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_GetAllMatchedEntries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_GetAllMatchedEntries_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorageCache_GetAllMatchedEntries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_GetAllMatchedEntries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_GetAllMatchedEntries_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_GetAllMatchedEntries_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageCache_GetAllMatchedEntries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_GetAllMatchedEntries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result);
    return val;
  };

  CacheStorageCache_GetAllMatchedEntries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_GetAllMatchedEntries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result, val.result);
  };
  function CacheStorageCache_Keys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Keys_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.queryOptions = null;
    this.traceId = 0;
  };
  CacheStorageCache_Keys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Keys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Keys_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Keys_Params.queryOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorageCache_Keys_Params.encodedSize = codec.kStructHeaderSize + 24;

  CacheStorageCache_Keys_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Keys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.queryOptions =
        decoder.decodeStructPointer(CacheQueryOptions);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_Keys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Keys_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(CacheQueryOptions, val.queryOptions);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_Keys_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Keys_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorageCache_Keys_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Keys_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Keys_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorageCache_Keys_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_Keys_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageCache_Keys_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Keys_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorageCache_Keys_ResponseParam_Result);
    return val;
  };

  CacheStorageCache_Keys_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Keys_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorageCache_Keys_ResponseParam_Result, val.result);
  };
  function CacheStorageCache_Batch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Batch_Params.prototype.initDefaults_ = function() {
    this.batchOperations = null;
    this.traceId = 0;
  };
  CacheStorageCache_Batch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Batch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Batch_Params.batchOperations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(BatchOperation), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorageCache_Batch_Params.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorageCache_Batch_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Batch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.batchOperations =
        decoder.decodeArrayPointer(new codec.PointerTo(BatchOperation));
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_Batch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Batch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(BatchOperation), val.batchOperations);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_Batch_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_Batch_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorageCache_Batch_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_Batch_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_Batch_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CacheStorageVerboseError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_Batch_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorageCache_Batch_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_Batch_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(CacheStorageVerboseError);
    return val;
  };

  CacheStorageCache_Batch_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_Batch_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CacheStorageVerboseError, val.result);
  };
  function CacheStorageCache_WriteSideData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_WriteSideData_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.expectedResponseTime = null;
    this.data = null;
    this.traceId = 0;
  };
  CacheStorageCache_WriteSideData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_WriteSideData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_WriteSideData_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_WriteSideData_Params.expectedResponseTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_WriteSideData_Params.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorageCache_WriteSideData_Params.encodedSize = codec.kStructHeaderSize + 40;

  CacheStorageCache_WriteSideData_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_WriteSideData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.expectedResponseTime =
        decoder.decodeStructPointer(time$.Time);
    val.data =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorageCache_WriteSideData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_WriteSideData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(time$.Time, val.expectedResponseTime);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.data);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorageCache_WriteSideData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorageCache_WriteSideData_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  CacheStorageCache_WriteSideData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorageCache_WriteSideData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorageCache_WriteSideData_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorageCache_WriteSideData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorageCache_WriteSideData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorageCache_WriteSideData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CacheStorageError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CacheStorageCache_WriteSideData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorageCache_WriteSideData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CacheStorage_Has_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Has_Params.prototype.initDefaults_ = function() {
    this.cacheName = null;
    this.traceId = 0;
  };
  CacheStorage_Has_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Has_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Has_Params.cacheName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorage_Has_Params.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorage_Has_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Has_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheName =
        decoder.decodeStructPointer(string16$.String16);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorage_Has_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Has_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.cacheName);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorage_Has_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Has_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  CacheStorage_Has_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Has_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Has_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorage_Has_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorage_Has_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Has_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CacheStorageError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CacheStorage_Has_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Has_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CacheStorage_Delete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Delete_Params.prototype.initDefaults_ = function() {
    this.cacheName = null;
    this.traceId = 0;
  };
  CacheStorage_Delete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Delete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Delete_Params.cacheName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorage_Delete_Params.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorage_Delete_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Delete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheName =
        decoder.decodeStructPointer(string16$.String16);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorage_Delete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Delete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.cacheName);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorage_Delete_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Delete_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  CacheStorage_Delete_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Delete_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Delete_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorage_Delete_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorage_Delete_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Delete_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CacheStorageError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CacheStorage_Delete_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Delete_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CacheStorage_Keys_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Keys_Params.prototype.initDefaults_ = function() {
    this.traceId = 0;
  };
  CacheStorage_Keys_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Keys_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorage_Keys_Params.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorage_Keys_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Keys_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorage_Keys_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Keys_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorage_Keys_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Keys_ResponseParams.prototype.initDefaults_ = function() {
    this.keys = null;
  };
  CacheStorage_Keys_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Keys_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Keys_ResponseParams.keys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(string16$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorage_Keys_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheStorage_Keys_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Keys_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keys =
        decoder.decodeArrayPointer(new codec.PointerTo(string16$.String16));
    return val;
  };

  CacheStorage_Keys_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Keys_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(string16$.String16), val.keys);
  };
  function CacheStorage_Match_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Match_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.matchOptions = null;
    this.inRelatedFetchEvent = false;
    this.inRangeFetchEvent = false;
    this.traceId = 0;
  };
  CacheStorage_Match_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Match_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Match_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, fetch_api_request$.FetchAPIRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Match_Params.matchOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MultiCacheQueryOptions, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  CacheStorage_Match_Params.encodedSize = codec.kStructHeaderSize + 32;

  CacheStorage_Match_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Match_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(fetch_api_request$.FetchAPIRequest);
    val.matchOptions =
        decoder.decodeStructPointer(MultiCacheQueryOptions);
    packed = decoder.readUint8();
    val.inRelatedFetchEvent = (packed >> 0) & 1 ? true : false;
    val.inRangeFetchEvent = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorage_Match_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Match_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(fetch_api_request$.FetchAPIRequest, val.request);
    encoder.encodeStructPointer(MultiCacheQueryOptions, val.matchOptions);
    packed = 0;
    packed |= (val.inRelatedFetchEvent & 1) << 0
    packed |= (val.inRangeFetchEvent & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorage_Match_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Match_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorage_Match_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Match_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Match_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorage_Match_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorage_Match_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorage_Match_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Match_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorage_Match_ResponseParam_Result);
    return val;
  };

  CacheStorage_Match_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Match_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorage_Match_ResponseParam_Result, val.result);
  };
  function CacheStorage_Open_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Open_Params.prototype.initDefaults_ = function() {
    this.cacheName = null;
    this.traceId = 0;
  };
  CacheStorage_Open_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Open_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Open_Params.cacheName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CacheStorage_Open_Params.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorage_Open_Params.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Open_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheName =
        decoder.decodeStructPointer(string16$.String16);
    val.traceId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CacheStorage_Open_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Open_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.cacheName);
    encoder.encodeStruct(codec.Int64, val.traceId);
  };
  function CacheStorage_Open_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheStorage_Open_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  CacheStorage_Open_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheStorage_Open_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheStorage_Open_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CacheStorage_Open_ResponseParam_Result, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheStorage_Open_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CacheStorage_Open_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheStorage_Open_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(CacheStorage_Open_ResponseParam_Result);
    return val;
  };

  CacheStorage_Open_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheStorage_Open_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CacheStorage_Open_ResponseParam_Result, val.result);
  };

  function MatchResponse(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  MatchResponse.Tags = {
    response: 0,
    eagerResponse: 1,
  };

  MatchResponse.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  MatchResponse.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "response",
        "eagerResponse",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a MatchResponse member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(MatchResponse.prototype, "response", {
    get: function() {
      if (this.$tag != MatchResponse.Tags.response) {
        throw new ReferenceError(
            "MatchResponse.response is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = MatchResponse.Tags.response;
      this.$data = value;
    }
  });
  Object.defineProperty(MatchResponse.prototype, "eagerResponse", {
    get: function() {
      if (this.$tag != MatchResponse.Tags.eagerResponse) {
        throw new ReferenceError(
            "MatchResponse.eagerResponse is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = MatchResponse.Tags.eagerResponse;
      this.$data = value;
    }
  });


    MatchResponse.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case MatchResponse.Tags.response:
          encoder.encodeStructPointer(fetch_api_response$.FetchAPIResponse, val.response);
          break;
        case MatchResponse.Tags.eagerResponse:
          encoder.encodeStructPointer(EagerResponse, val.eagerResponse);
          break;
      }
      encoder.align();
    };


    MatchResponse.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new MatchResponse();
      var tag = decoder.readUint32();
      switch (tag) {
        case MatchResponse.Tags.response:
          result.response = decoder.decodeStructPointer(fetch_api_response$.FetchAPIResponse);
          break;
        case MatchResponse.Tags.eagerResponse:
          result.eagerResponse = decoder.decodeStructPointer(EagerResponse);
          break;
      }
      decoder.align();

      return result;
    };


    MatchResponse.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case MatchResponse.Tags.response:
          

    // validate MatchResponse.response
    err = messageValidator.validateStructPointer(data_offset, fetch_api_response$.FetchAPIResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case MatchResponse.Tags.eagerResponse:
          

    // validate MatchResponse.eagerResponse
    err = messageValidator.validateStructPointer(data_offset, EagerResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  MatchResponse.encodedSize = 16;

  function CacheStorageCache_Match_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorageCache_Match_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorageCache_Match_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorageCache_Match_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorageCache_Match_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorageCache_Match_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorageCache_Match_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorageCache_Match_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_Match_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorageCache_Match_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorageCache_Match_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorageCache_Match_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_Match_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorageCache_Match_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorageCache_Match_ResponseParam_Result.Tags.success:
          encoder.encodeStructPointer(MatchResponse, val.success);
          break;
        case CacheStorageCache_Match_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorageCache_Match_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorageCache_Match_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorageCache_Match_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStructPointer(MatchResponse);
          break;
        case CacheStorageCache_Match_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorageCache_Match_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorageCache_Match_ResponseParam_Result.Tags.success:
          
    // validate CacheStorageCache_Match_ResponseParam_Result.success
    err = messageValidator.validateNestedUnion(data_offset, MatchResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorageCache_Match_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorageCache_Match_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorageCache_Match_ResponseParam_Result.encodedSize = 16;

  function CacheStorageCache_MatchAll_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorageCache_MatchAll_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorageCache_MatchAll_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorageCache_MatchAll_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorageCache_MatchAll_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorageCache_MatchAll_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorageCache_MatchAll_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorageCache_MatchAll_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_MatchAll_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorageCache_MatchAll_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorageCache_MatchAll_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorageCache_MatchAll_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_MatchAll_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorageCache_MatchAll_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(new codec.PointerTo(fetch_api_response$.FetchAPIResponse), val.success);
          break;
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorageCache_MatchAll_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorageCache_MatchAll_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(new codec.PointerTo(fetch_api_response$.FetchAPIResponse));
          break;
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorageCache_MatchAll_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.success:
          

    // validate CacheStorageCache_MatchAll_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(fetch_api_response$.FetchAPIResponse), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorageCache_MatchAll_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorageCache_MatchAll_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorageCache_MatchAll_ResponseParam_Result.encodedSize = 16;

  function CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(new codec.PointerTo(CacheEntry), val.success);
          break;
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(new codec.PointerTo(CacheEntry));
          break;
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.success:
          

    // validate CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(CacheEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result.encodedSize = 16;

  function CacheStorageCache_Keys_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorageCache_Keys_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorageCache_Keys_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorageCache_Keys_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorageCache_Keys_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorageCache_Keys_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorageCache_Keys_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorageCache_Keys_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_Keys_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorageCache_Keys_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorageCache_Keys_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorageCache_Keys_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorageCache_Keys_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorageCache_Keys_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.success:
          encoder.encodeArrayPointer(new codec.PointerTo(fetch_api_request$.FetchAPIRequest), val.success);
          break;
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorageCache_Keys_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorageCache_Keys_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeArrayPointer(new codec.PointerTo(fetch_api_request$.FetchAPIRequest));
          break;
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorageCache_Keys_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.success:
          

    // validate CacheStorageCache_Keys_ResponseParam_Result.success
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(fetch_api_request$.FetchAPIRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorageCache_Keys_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorageCache_Keys_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorageCache_Keys_ResponseParam_Result.encodedSize = 16;

  function CacheStorage_Match_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorage_Match_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorage_Match_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorage_Match_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorage_Match_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorage_Match_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorage_Match_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorage_Match_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorage_Match_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorage_Match_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorage_Match_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorage_Match_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorage_Match_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorage_Match_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorage_Match_ResponseParam_Result.Tags.success:
          encoder.encodeStructPointer(MatchResponse, val.success);
          break;
        case CacheStorage_Match_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorage_Match_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorage_Match_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorage_Match_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStructPointer(MatchResponse);
          break;
        case CacheStorage_Match_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorage_Match_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorage_Match_ResponseParam_Result.Tags.success:
          
    // validate CacheStorage_Match_ResponseParam_Result.success
    err = messageValidator.validateNestedUnion(data_offset, MatchResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorage_Match_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorage_Match_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorage_Match_ResponseParam_Result.encodedSize = 16;

  function CacheStorage_Open_ResponseParam_Result(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CacheStorage_Open_ResponseParam_Result.Tags = {
    success: 0,
    failure: 1,
  };

  CacheStorage_Open_ResponseParam_Result.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CacheStorage_Open_ResponseParam_Result.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "failure",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CacheStorage_Open_ResponseParam_Result member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CacheStorage_Open_ResponseParam_Result.prototype, "success", {
    get: function() {
      if (this.$tag != CacheStorage_Open_ResponseParam_Result.Tags.success) {
        throw new ReferenceError(
            "CacheStorage_Open_ResponseParam_Result.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorage_Open_ResponseParam_Result.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(CacheStorage_Open_ResponseParam_Result.prototype, "failure", {
    get: function() {
      if (this.$tag != CacheStorage_Open_ResponseParam_Result.Tags.failure) {
        throw new ReferenceError(
            "CacheStorage_Open_ResponseParam_Result.failure is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CacheStorage_Open_ResponseParam_Result.Tags.failure;
      this.$data = value;
    }
  });


    CacheStorage_Open_ResponseParam_Result.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CacheStorage_Open_ResponseParam_Result.Tags.success:
          encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.success);
          break;
        case CacheStorage_Open_ResponseParam_Result.Tags.failure:
          encoder.encodeStruct(codec.Int32, val.failure);
          break;
      }
      encoder.align();
    };


    CacheStorage_Open_ResponseParam_Result.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CacheStorage_Open_ResponseParam_Result();
      var tag = decoder.readUint32();
      switch (tag) {
        case CacheStorage_Open_ResponseParam_Result.Tags.success:
          result.success = decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
          break;
        case CacheStorage_Open_ResponseParam_Result.Tags.failure:
          result.failure = decoder.decodeStruct(new codec.Enum(CacheStorageError));
          break;
      }
      decoder.align();

      return result;
    };


    CacheStorage_Open_ResponseParam_Result.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CacheStorage_Open_ResponseParam_Result.Tags.success:
          

    // validate CacheStorage_Open_ResponseParam_Result.success
    err = messageValidator.validateAssociatedInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CacheStorage_Open_ResponseParam_Result.Tags.failure:
          

    // validate CacheStorage_Open_ResponseParam_Result.failure
    err = messageValidator.validateEnum(data_offset, CacheStorageError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CacheStorage_Open_ResponseParam_Result.encodedSize = 16;
  var kCacheStorageCache_Match_Name = 0;
  var kCacheStorageCache_MatchAll_Name = 1;
  var kCacheStorageCache_GetAllMatchedEntries_Name = 2;
  var kCacheStorageCache_Keys_Name = 3;
  var kCacheStorageCache_Batch_Name = 4;
  var kCacheStorageCache_WriteSideData_Name = 5;

  function CacheStorageCachePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CacheStorageCache,
                                                   handleOrPtrInfo);
  }

  function CacheStorageCacheAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CacheStorageCache, associatedInterfacePtrInfo);
  }

  CacheStorageCacheAssociatedPtr.prototype =
      Object.create(CacheStorageCachePtr.prototype);
  CacheStorageCacheAssociatedPtr.prototype.constructor =
      CacheStorageCacheAssociatedPtr;

  function CacheStorageCacheProxy(receiver) {
    this.receiver_ = receiver;
  }
  CacheStorageCachePtr.prototype.match = function() {
    return CacheStorageCacheProxy.prototype.match
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.match = function(request, queryOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {
    var params_ = new CacheStorageCache_Match_Params();
    params_.request = request;
    params_.queryOptions = queryOptions;
    params_.inRelatedFetchEvent = inRelatedFetchEvent;
    params_.inRangeFetchEvent = inRangeFetchEvent;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_Match_Name,
          codec.align(CacheStorageCache_Match_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_Match_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_Match_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStorageCachePtr.prototype.matchAll = function() {
    return CacheStorageCacheProxy.prototype.matchAll
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.matchAll = function(request, queryOptions, traceId) {
    var params_ = new CacheStorageCache_MatchAll_Params();
    params_.request = request;
    params_.queryOptions = queryOptions;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_MatchAll_Name,
          codec.align(CacheStorageCache_MatchAll_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_MatchAll_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_MatchAll_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStorageCachePtr.prototype.getAllMatchedEntries = function() {
    return CacheStorageCacheProxy.prototype.getAllMatchedEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.getAllMatchedEntries = function(request, queryOptions, traceId) {
    var params_ = new CacheStorageCache_GetAllMatchedEntries_Params();
    params_.request = request;
    params_.queryOptions = queryOptions;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_GetAllMatchedEntries_Name,
          codec.align(CacheStorageCache_GetAllMatchedEntries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_GetAllMatchedEntries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_GetAllMatchedEntries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStorageCachePtr.prototype.keys = function() {
    return CacheStorageCacheProxy.prototype.keys
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.keys = function(request, queryOptions, traceId) {
    var params_ = new CacheStorageCache_Keys_Params();
    params_.request = request;
    params_.queryOptions = queryOptions;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_Keys_Name,
          codec.align(CacheStorageCache_Keys_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_Keys_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_Keys_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStorageCachePtr.prototype.batch = function() {
    return CacheStorageCacheProxy.prototype.batch
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.batch = function(batchOperations, traceId) {
    var params_ = new CacheStorageCache_Batch_Params();
    params_.batchOperations = batchOperations;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_Batch_Name,
          codec.align(CacheStorageCache_Batch_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_Batch_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_Batch_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStorageCachePtr.prototype.writeSideData = function() {
    return CacheStorageCacheProxy.prototype.writeSideData
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageCacheProxy.prototype.writeSideData = function(url, expectedResponseTime, data, traceId) {
    var params_ = new CacheStorageCache_WriteSideData_Params();
    params_.url = url;
    params_.expectedResponseTime = expectedResponseTime;
    params_.data = data;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorageCache_WriteSideData_Name,
          codec.align(CacheStorageCache_WriteSideData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorageCache_WriteSideData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorageCache_WriteSideData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CacheStorageCacheStub(delegate) {
    this.delegate_ = delegate;
  }
  CacheStorageCacheStub.prototype.match = function(request, queryOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {
    return this.delegate_ && this.delegate_.match && this.delegate_.match(request, queryOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId);
  }
  CacheStorageCacheStub.prototype.matchAll = function(request, queryOptions, traceId) {
    return this.delegate_ && this.delegate_.matchAll && this.delegate_.matchAll(request, queryOptions, traceId);
  }
  CacheStorageCacheStub.prototype.getAllMatchedEntries = function(request, queryOptions, traceId) {
    return this.delegate_ && this.delegate_.getAllMatchedEntries && this.delegate_.getAllMatchedEntries(request, queryOptions, traceId);
  }
  CacheStorageCacheStub.prototype.keys = function(request, queryOptions, traceId) {
    return this.delegate_ && this.delegate_.keys && this.delegate_.keys(request, queryOptions, traceId);
  }
  CacheStorageCacheStub.prototype.batch = function(batchOperations, traceId) {
    return this.delegate_ && this.delegate_.batch && this.delegate_.batch(batchOperations, traceId);
  }
  CacheStorageCacheStub.prototype.writeSideData = function(url, expectedResponseTime, data, traceId) {
    return this.delegate_ && this.delegate_.writeSideData && this.delegate_.writeSideData(url, expectedResponseTime, data, traceId);
  }

  CacheStorageCacheStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CacheStorageCacheStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCacheStorageCache_Match_Name:
      var params = reader.decodeStruct(CacheStorageCache_Match_Params);
      this.match(params.request, params.queryOptions, params.inRelatedFetchEvent, params.inRangeFetchEvent, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_Match_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_Match_Name,
            codec.align(CacheStorageCache_Match_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_Match_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorageCache_MatchAll_Name:
      var params = reader.decodeStruct(CacheStorageCache_MatchAll_Params);
      this.matchAll(params.request, params.queryOptions, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_MatchAll_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_MatchAll_Name,
            codec.align(CacheStorageCache_MatchAll_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_MatchAll_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorageCache_GetAllMatchedEntries_Name:
      var params = reader.decodeStruct(CacheStorageCache_GetAllMatchedEntries_Params);
      this.getAllMatchedEntries(params.request, params.queryOptions, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_GetAllMatchedEntries_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_GetAllMatchedEntries_Name,
            codec.align(CacheStorageCache_GetAllMatchedEntries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_GetAllMatchedEntries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorageCache_Keys_Name:
      var params = reader.decodeStruct(CacheStorageCache_Keys_Params);
      this.keys(params.request, params.queryOptions, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_Keys_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_Keys_Name,
            codec.align(CacheStorageCache_Keys_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_Keys_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorageCache_Batch_Name:
      var params = reader.decodeStruct(CacheStorageCache_Batch_Params);
      this.batch(params.batchOperations, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_Batch_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_Batch_Name,
            codec.align(CacheStorageCache_Batch_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_Batch_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorageCache_WriteSideData_Name:
      var params = reader.decodeStruct(CacheStorageCache_WriteSideData_Params);
      this.writeSideData(params.url, params.expectedResponseTime, params.data, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorageCache_WriteSideData_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorageCache_WriteSideData_Name,
            codec.align(CacheStorageCache_WriteSideData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorageCache_WriteSideData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCacheStorageCacheRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCacheStorageCache_Match_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_Match_Params;
      break;
      case kCacheStorageCache_MatchAll_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_MatchAll_Params;
      break;
      case kCacheStorageCache_GetAllMatchedEntries_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_GetAllMatchedEntries_Params;
      break;
      case kCacheStorageCache_Keys_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_Keys_Params;
      break;
      case kCacheStorageCache_Batch_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_Batch_Params;
      break;
      case kCacheStorageCache_WriteSideData_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorageCache_WriteSideData_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCacheStorageCacheResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCacheStorageCache_Match_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_Match_ResponseParams;
        break;
      case kCacheStorageCache_MatchAll_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_MatchAll_ResponseParams;
        break;
      case kCacheStorageCache_GetAllMatchedEntries_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_GetAllMatchedEntries_ResponseParams;
        break;
      case kCacheStorageCache_Keys_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_Keys_ResponseParams;
        break;
      case kCacheStorageCache_Batch_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_Batch_ResponseParams;
        break;
      case kCacheStorageCache_WriteSideData_Name:
        if (message.isResponse())
          paramsClass = CacheStorageCache_WriteSideData_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CacheStorageCache = {
    name: 'blink.mojom.CacheStorageCache',
    kVersion: 0,
    ptrClass: CacheStorageCachePtr,
    proxyClass: CacheStorageCacheProxy,
    stubClass: CacheStorageCacheStub,
    validateRequest: validateCacheStorageCacheRequest,
    validateResponse: validateCacheStorageCacheResponse,
  };
  CacheStorageCacheStub.prototype.validator = validateCacheStorageCacheRequest;
  CacheStorageCacheProxy.prototype.validator = validateCacheStorageCacheResponse;
  var kCacheStorage_Has_Name = 0;
  var kCacheStorage_Delete_Name = 1;
  var kCacheStorage_Keys_Name = 2;
  var kCacheStorage_Match_Name = 3;
  var kCacheStorage_Open_Name = 4;

  function CacheStoragePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CacheStorage,
                                                   handleOrPtrInfo);
  }

  function CacheStorageAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CacheStorage, associatedInterfacePtrInfo);
  }

  CacheStorageAssociatedPtr.prototype =
      Object.create(CacheStoragePtr.prototype);
  CacheStorageAssociatedPtr.prototype.constructor =
      CacheStorageAssociatedPtr;

  function CacheStorageProxy(receiver) {
    this.receiver_ = receiver;
  }
  CacheStoragePtr.prototype.has = function() {
    return CacheStorageProxy.prototype.has
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageProxy.prototype.has = function(cacheName, traceId) {
    var params_ = new CacheStorage_Has_Params();
    params_.cacheName = cacheName;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorage_Has_Name,
          codec.align(CacheStorage_Has_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorage_Has_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorage_Has_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStoragePtr.prototype.delete = function() {
    return CacheStorageProxy.prototype.delete
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageProxy.prototype.delete = function(cacheName, traceId) {
    var params_ = new CacheStorage_Delete_Params();
    params_.cacheName = cacheName;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorage_Delete_Name,
          codec.align(CacheStorage_Delete_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorage_Delete_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorage_Delete_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStoragePtr.prototype.keys = function() {
    return CacheStorageProxy.prototype.keys
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageProxy.prototype.keys = function(traceId) {
    var params_ = new CacheStorage_Keys_Params();
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorage_Keys_Name,
          codec.align(CacheStorage_Keys_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorage_Keys_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorage_Keys_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStoragePtr.prototype.match = function() {
    return CacheStorageProxy.prototype.match
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageProxy.prototype.match = function(request, matchOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {
    var params_ = new CacheStorage_Match_Params();
    params_.request = request;
    params_.matchOptions = matchOptions;
    params_.inRelatedFetchEvent = inRelatedFetchEvent;
    params_.inRangeFetchEvent = inRangeFetchEvent;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheStorage_Match_Name,
          codec.align(CacheStorage_Match_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheStorage_Match_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorage_Match_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CacheStoragePtr.prototype.open = function() {
    return CacheStorageProxy.prototype.open
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheStorageProxy.prototype.open = function(cacheName, traceId) {
    var params_ = new CacheStorage_Open_Params();
    params_.cacheName = cacheName;
    params_.traceId = traceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kCacheStorage_Open_Name,
          codec.align(CacheStorage_Open_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(CacheStorage_Open_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheStorage_Open_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CacheStorageStub(delegate) {
    this.delegate_ = delegate;
  }
  CacheStorageStub.prototype.has = function(cacheName, traceId) {
    return this.delegate_ && this.delegate_.has && this.delegate_.has(cacheName, traceId);
  }
  CacheStorageStub.prototype.delete = function(cacheName, traceId) {
    return this.delegate_ && this.delegate_.delete && this.delegate_.delete(cacheName, traceId);
  }
  CacheStorageStub.prototype.keys = function(traceId) {
    return this.delegate_ && this.delegate_.keys && this.delegate_.keys(traceId);
  }
  CacheStorageStub.prototype.match = function(request, matchOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId) {
    return this.delegate_ && this.delegate_.match && this.delegate_.match(request, matchOptions, inRelatedFetchEvent, inRangeFetchEvent, traceId);
  }
  CacheStorageStub.prototype.open = function(cacheName, traceId) {
    return this.delegate_ && this.delegate_.open && this.delegate_.open(cacheName, traceId);
  }

  CacheStorageStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CacheStorageStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCacheStorage_Has_Name:
      var params = reader.decodeStruct(CacheStorage_Has_Params);
      this.has(params.cacheName, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorage_Has_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorage_Has_Name,
            codec.align(CacheStorage_Has_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorage_Has_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorage_Delete_Name:
      var params = reader.decodeStruct(CacheStorage_Delete_Params);
      this.delete(params.cacheName, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorage_Delete_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorage_Delete_Name,
            codec.align(CacheStorage_Delete_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorage_Delete_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorage_Keys_Name:
      var params = reader.decodeStruct(CacheStorage_Keys_Params);
      this.keys(params.traceId).then(function(response) {
        var responseParams =
            new CacheStorage_Keys_ResponseParams();
        responseParams.keys = response.keys;
        var builder = new codec.MessageV1Builder(
            kCacheStorage_Keys_Name,
            codec.align(CacheStorage_Keys_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorage_Keys_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorage_Match_Name:
      var params = reader.decodeStruct(CacheStorage_Match_Params);
      this.match(params.request, params.matchOptions, params.inRelatedFetchEvent, params.inRangeFetchEvent, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorage_Match_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCacheStorage_Match_Name,
            codec.align(CacheStorage_Match_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheStorage_Match_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCacheStorage_Open_Name:
      var params = reader.decodeStruct(CacheStorage_Open_Params);
      this.open(params.cacheName, params.traceId).then(function(response) {
        var responseParams =
            new CacheStorage_Open_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kCacheStorage_Open_Name,
            codec.align(CacheStorage_Open_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(CacheStorage_Open_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCacheStorageRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCacheStorage_Has_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorage_Has_Params;
      break;
      case kCacheStorage_Delete_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorage_Delete_Params;
      break;
      case kCacheStorage_Keys_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorage_Keys_Params;
      break;
      case kCacheStorage_Match_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorage_Match_Params;
      break;
      case kCacheStorage_Open_Name:
        if (message.expectsResponse())
          paramsClass = CacheStorage_Open_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCacheStorageResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCacheStorage_Has_Name:
        if (message.isResponse())
          paramsClass = CacheStorage_Has_ResponseParams;
        break;
      case kCacheStorage_Delete_Name:
        if (message.isResponse())
          paramsClass = CacheStorage_Delete_ResponseParams;
        break;
      case kCacheStorage_Keys_Name:
        if (message.isResponse())
          paramsClass = CacheStorage_Keys_ResponseParams;
        break;
      case kCacheStorage_Match_Name:
        if (message.isResponse())
          paramsClass = CacheStorage_Match_ResponseParams;
        break;
      case kCacheStorage_Open_Name:
        if (message.isResponse())
          paramsClass = CacheStorage_Open_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CacheStorage = {
    name: 'blink.mojom.CacheStorage',
    kVersion: 0,
    ptrClass: CacheStoragePtr,
    proxyClass: CacheStorageProxy,
    stubClass: CacheStorageStub,
    validateRequest: validateCacheStorageRequest,
    validateResponse: validateCacheStorageResponse,
  };
  CacheStorageStub.prototype.validator = validateCacheStorageRequest;
  CacheStorageProxy.prototype.validator = validateCacheStorageResponse;
  exports.CacheStorageError = CacheStorageError;
  exports.OperationType = OperationType;
  exports.CacheStorageVerboseError = CacheStorageVerboseError;
  exports.CacheQueryOptions = CacheQueryOptions;
  exports.MultiCacheQueryOptions = MultiCacheQueryOptions;
  exports.BatchOperation = BatchOperation;
  exports.EagerResponse = EagerResponse;
  exports.CacheEntry = CacheEntry;
  exports.MatchResponse = MatchResponse;
  exports.CacheStorageCache_Match_ResponseParam_Result = CacheStorageCache_Match_ResponseParam_Result;
  exports.CacheStorageCache_MatchAll_ResponseParam_Result = CacheStorageCache_MatchAll_ResponseParam_Result;
  exports.CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result = CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result;
  exports.CacheStorageCache_Keys_ResponseParam_Result = CacheStorageCache_Keys_ResponseParam_Result;
  exports.CacheStorage_Match_ResponseParam_Result = CacheStorage_Match_ResponseParam_Result;
  exports.CacheStorage_Open_ResponseParam_Result = CacheStorage_Open_ResponseParam_Result;
  exports.CacheStorageCache = CacheStorageCache;
  exports.CacheStorageCachePtr = CacheStorageCachePtr;
  exports.CacheStorageCacheAssociatedPtr = CacheStorageCacheAssociatedPtr;
  exports.CacheStorage = CacheStorage;
  exports.CacheStoragePtr = CacheStoragePtr;
  exports.CacheStorageAssociatedPtr = CacheStorageAssociatedPtr;
})();