// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink-forward.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-blink.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/types/expected.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class CacheStorageCacheProxy;

template <typename ImplRefTraits>
class CacheStorageCacheStub;

class CacheStorageCacheRequestValidator;
class CacheStorageCacheResponseValidator;


class PLATFORM_EXPORT CacheStorageCache
    : public CacheStorageCacheInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.CacheStorageCache";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageCacheInterfaceBase;
  using Proxy_ = CacheStorageCacheProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageCacheStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageCacheRequestValidator;
  using ResponseValidator_ = CacheStorageCacheResponseValidator;
  enum MethodMinVersions : uint32_t {
    kMatchMinVersion = 0,
    kMatchAllMinVersion = 0,
    kGetAllMatchedEntriesMinVersion = 0,
    kKeysMinVersion = 0,
    kBatchMinVersion = 0,
    kWriteSideDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Match_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MatchAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllMatchedEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Keys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Batch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteSideData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorageCache() = default;

  using MatchCallback = base::OnceCallback<void(base::expected<
  MatchResponsePtr,
  CacheStorageError>)>;
  using MatchResult = base::expected<
  MatchResponsePtr,
  CacheStorageError>;
  using MatchMojoCallback = base::OnceCallback<void(CacheStorageCache_Match_ResponseParam_ResultPtr)>;

  virtual void Match(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) = 0;

  using MatchAllCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>,
  CacheStorageError>)>;
  using MatchAllResult = base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>,
  CacheStorageError>;
  using MatchAllMojoCallback = base::OnceCallback<void(CacheStorageCache_MatchAll_ResponseParam_ResultPtr)>;

  virtual void MatchAll(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) = 0;

  using GetAllMatchedEntriesCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<CacheEntryPtr>,
  CacheStorageError>)>;
  using GetAllMatchedEntriesResult = base::expected<
  ::blink::Vector<CacheEntryPtr>,
  CacheStorageError>;
  using GetAllMatchedEntriesMojoCallback = base::OnceCallback<void(CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr)>;

  virtual void GetAllMatchedEntries(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) = 0;

  using KeysCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>,
  CacheStorageError>)>;
  using KeysResult = base::expected<
  ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>,
  CacheStorageError>;
  using KeysMojoCallback = base::OnceCallback<void(CacheStorageCache_Keys_ResponseParam_ResultPtr)>;

  virtual void Keys(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) = 0;

  using BatchCallback = base::OnceCallback<void(CacheStorageVerboseErrorPtr)>;
  using BatchMojoCallback = base::OnceCallback<void(CacheStorageVerboseErrorPtr)>;

  virtual void Batch(::blink::Vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) = 0;

  using WriteSideDataCallback = base::OnceCallback<void(CacheStorageError)>;
  using WriteSideDataMojoCallback = base::OnceCallback<void(CacheStorageError)>;

  virtual void WriteSideData(const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) = 0;
};

class CacheStorageProxy;

template <typename ImplRefTraits>
class CacheStorageStub;

class CacheStorageRequestValidator;
class CacheStorageResponseValidator;


class PLATFORM_EXPORT CacheStorage
    : public CacheStorageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.CacheStorage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageInterfaceBase;
  using Proxy_ = CacheStorageProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageRequestValidator;
  using ResponseValidator_ = CacheStorageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasMinVersion = 0,
    kDeleteMinVersion = 0,
    kKeysMinVersion = 0,
    kMatchMinVersion = 0,
    kOpenMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Has_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Keys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Match_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Open_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorage() = default;

  using HasCallback = base::OnceCallback<void(CacheStorageError)>;
  using HasMojoCallback = base::OnceCallback<void(CacheStorageError)>;

  virtual void Has(const ::blink::String& cache_name, int64_t trace_id, HasCallback callback) = 0;

  using DeleteCallback = base::OnceCallback<void(CacheStorageError)>;
  using DeleteMojoCallback = base::OnceCallback<void(CacheStorageError)>;

  virtual void Delete(const ::blink::String& cache_name, int64_t trace_id, DeleteCallback callback) = 0;

  using KeysCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;
  using KeysMojoCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;

  virtual void Keys(int64_t trace_id, KeysCallback callback) = 0;

  using MatchCallback = base::OnceCallback<void(base::expected<
  MatchResponsePtr,
  CacheStorageError>)>;
  using MatchResult = base::expected<
  MatchResponsePtr,
  CacheStorageError>;
  using MatchMojoCallback = base::OnceCallback<void(CacheStorage_Match_ResponseParam_ResultPtr)>;

  virtual void Match(::blink::mojom::blink::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) = 0;

  using OpenCallback = base::OnceCallback<void(base::expected<
  ::mojo::PendingAssociatedRemote<CacheStorageCache>,
  CacheStorageError>)>;
  using OpenResult = base::expected<
  ::mojo::PendingAssociatedRemote<CacheStorageCache>,
  CacheStorageError>;
  using OpenMojoCallback = base::OnceCallback<void(CacheStorage_Open_ResponseParam_ResultPtr)>;

  virtual void Open(const ::blink::String& cache_name, int64_t trace_id, OpenCallback callback) = 0;
};



class PLATFORM_EXPORT CacheStorageCacheProxy
    : public CacheStorageCache {
 public:
  using InterfaceType = CacheStorageCache;

  explicit CacheStorageCacheProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Match(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) final;
  
  void MatchAll(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) final;
  
  void GetAllMatchedEntries(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) final;
  
  void Keys(::blink::mojom::blink::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) final;
  
  void Batch(::blink::Vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) final;
  
  void WriteSideData(const ::blink::KURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT CacheStorageProxy
    : public CacheStorage {
 public:
  using InterfaceType = CacheStorage;

  explicit CacheStorageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Has(const ::blink::String& cache_name, int64_t trace_id, HasCallback callback) final;
  
  void Delete(const ::blink::String& cache_name, int64_t trace_id, DeleteCallback callback) final;
  
  void Keys(int64_t trace_id, KeysCallback callback) final;
  
  void Match(::blink::mojom::blink::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) final;
  
  void Open(const ::blink::String& cache_name, int64_t trace_id, OpenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT CacheStorageCacheStubDispatch {
 public:
  static bool Accept(CacheStorageCache* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorageCache* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorageCache>>
class CacheStorageCacheStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageCacheStub() = default;
  ~CacheStorageCacheStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageCacheStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageCacheStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT CacheStorageStubDispatch {
 public:
  static bool Accept(CacheStorage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorage>>
class CacheStorageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageStub() = default;
  ~CacheStorageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT CacheStorageCacheRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT CacheStorageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT CacheStorageCacheResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT CacheStorageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT CacheStorageVerboseError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheStorageVerboseError, T>::value>;
  using DataView = CacheStorageVerboseErrorDataView;
  using Data_ = internal::CacheStorageVerboseError_Data;

  template <typename... Args>
  static CacheStorageVerboseErrorPtr New(Args&&... args) {
    return CacheStorageVerboseErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheStorageVerboseErrorPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageVerboseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageVerboseError>::Convert(*this);
  }


  CacheStorageVerboseError();

  CacheStorageVerboseError(
      CacheStorageError value,
      const ::blink::String& message);


  ~CacheStorageVerboseError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheStorageVerboseErrorPtr>
  CacheStorageVerboseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheStorageVerboseError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheStorageVerboseError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageVerboseError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheStorageVerboseError_UnserializedMessageContext<
            UserType, CacheStorageVerboseError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheStorageVerboseError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheStorageVerboseError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheStorageVerboseError_UnserializedMessageContext<
            UserType, CacheStorageVerboseError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheStorageVerboseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CacheStorageError value;
  
  ::blink::String message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CacheQueryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheQueryOptions, T>::value>;
  using DataView = CacheQueryOptionsDataView;
  using Data_ = internal::CacheQueryOptions_Data;

  template <typename... Args>
  static CacheQueryOptionsPtr New(Args&&... args) {
    return CacheQueryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheQueryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CacheQueryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheQueryOptions>::Convert(*this);
  }


  CacheQueryOptions();

  CacheQueryOptions(
      bool ignore_search,
      bool ignore_method,
      bool ignore_vary);


  ~CacheQueryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheQueryOptionsPtr>
  CacheQueryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheQueryOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CacheQueryOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheQueryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheQueryOptions_UnserializedMessageContext<
            UserType, CacheQueryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheQueryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheQueryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheQueryOptions_UnserializedMessageContext<
            UserType, CacheQueryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheQueryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool ignore_search;
  
  bool ignore_method;
  
  bool ignore_vary;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT MatchResponse {
 public:
  using DataView = MatchResponseDataView;
  using Data_ = internal::MatchResponse_Data;
  using Tag = Data_::MatchResponse_Tag;

  template <typename... Args>
  static MatchResponsePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |response|.
  static MatchResponsePtr NewResponse(
      ::blink::mojom::blink::FetchAPIResponsePtr value);
  // Construct an instance holding |eager_response|.
  static MatchResponsePtr NewEagerResponse(
      EagerResponsePtr value);

  template <typename U>
  static MatchResponsePtr From(const U& u) {
    return mojo::TypeConverter<MatchResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MatchResponse>::Convert(*this);
  }
  ~MatchResponse();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MatchResponse(const MatchResponse& other) = delete;
  MatchResponse& operator=(const MatchResponse& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MatchResponsePtr>
  MatchResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchResponse>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MatchResponse>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_response() const { return tag_ == Tag::kResponse; }
  const ::blink::mojom::blink::FetchAPIResponsePtr& get_response() const {
    CHECK(tag_ == Tag::kResponse);
    return data_.response;
  }
  ::blink::mojom::blink::FetchAPIResponsePtr& get_response() {
    CHECK(tag_ == Tag::kResponse);
    return data_.response;
  }
  void set_response(::blink::mojom::blink::FetchAPIResponsePtr response);

  bool is_eager_response() const { return tag_ == Tag::kEagerResponse; }
  const EagerResponsePtr& get_eager_response() const {
    CHECK(tag_ == Tag::kEagerResponse);
    return data_.eager_response;
  }
  EagerResponsePtr& get_eager_response() {
    CHECK(tag_ == Tag::kEagerResponse);
    return data_.eager_response;
  }
  void set_eager_response(EagerResponsePtr eager_response);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MatchResponse::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MatchResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kResponse)>,
        ::blink::mojom::blink::FetchAPIResponsePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEagerResponse)>,
        EagerResponsePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::mojom::blink::FetchAPIResponsePtr response;
    EagerResponsePtr eager_response;
  };

  MatchResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kResponse)>,
      ::blink::mojom::blink::FetchAPIResponsePtr value);
  MatchResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kEagerResponse)>,
      EagerResponsePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorageCache_Match_ResponseParam_Result {
 public:
  using DataView = CacheStorageCache_Match_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorageCache_Match_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorageCache_Match_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorageCache_Match_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorageCache_Match_ResponseParam_ResultPtr NewSuccess(
      MatchResponsePtr value);
  // Construct an instance holding |failure|.
  static CacheStorageCache_Match_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorageCache_Match_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageCache_Match_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageCache_Match_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorageCache_Match_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorageCache_Match_ResponseParam_Result(const CacheStorageCache_Match_ResponseParam_Result& other) = delete;
  CacheStorageCache_Match_ResponseParam_Result& operator=(const CacheStorageCache_Match_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorageCache_Match_ResponseParam_ResultPtr>
  CacheStorageCache_Match_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_Match_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_Match_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const MatchResponsePtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  MatchResponsePtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(MatchResponsePtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageCache_Match_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorageCache_Match_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        MatchResponsePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    MatchResponsePtr success;
    CacheStorageError failure;
  };

  CacheStorageCache_Match_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      MatchResponsePtr value);
  CacheStorageCache_Match_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorageCache_MatchAll_ResponseParam_Result {
 public:
  using DataView = CacheStorageCache_MatchAll_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorageCache_MatchAll_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorageCache_MatchAll_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorageCache_MatchAll_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorageCache_MatchAll_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value);
  // Construct an instance holding |failure|.
  static CacheStorageCache_MatchAll_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorageCache_MatchAll_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageCache_MatchAll_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageCache_MatchAll_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorageCache_MatchAll_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorageCache_MatchAll_ResponseParam_Result(const CacheStorageCache_MatchAll_ResponseParam_Result& other) = delete;
  CacheStorageCache_MatchAll_ResponseParam_Result& operator=(const CacheStorageCache_MatchAll_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorageCache_MatchAll_ResponseParam_ResultPtr>
  CacheStorageCache_MatchAll_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_MatchAll_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_MatchAll_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageCache_MatchAll_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorageCache_MatchAll_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> success;
    CacheStorageError failure;
  };

  CacheStorageCache_MatchAll_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr> value);
  CacheStorageCache_MatchAll_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result {
 public:
  using DataView = CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<CacheEntryPtr> value);
  // Construct an instance holding |failure|.
  static CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(const CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result& other) = delete;
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result& operator=(const CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr>
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<CacheEntryPtr>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<CacheEntryPtr>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<CacheEntryPtr> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<CacheEntryPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<CacheEntryPtr> success;
    CacheStorageError failure;
  };

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<CacheEntryPtr> value);
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorageCache_Keys_ResponseParam_Result {
 public:
  using DataView = CacheStorageCache_Keys_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorageCache_Keys_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorageCache_Keys_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorageCache_Keys_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorageCache_Keys_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value);
  // Construct an instance holding |failure|.
  static CacheStorageCache_Keys_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorageCache_Keys_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorageCache_Keys_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorageCache_Keys_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorageCache_Keys_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorageCache_Keys_ResponseParam_Result(const CacheStorageCache_Keys_ResponseParam_Result& other) = delete;
  CacheStorageCache_Keys_ResponseParam_Result& operator=(const CacheStorageCache_Keys_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorageCache_Keys_ResponseParam_ResultPtr>
  CacheStorageCache_Keys_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_Keys_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorageCache_Keys_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorageCache_Keys_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorageCache_Keys_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> success;
    CacheStorageError failure;
  };

  CacheStorageCache_Keys_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> value);
  CacheStorageCache_Keys_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorage_Match_ResponseParam_Result {
 public:
  using DataView = CacheStorage_Match_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorage_Match_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorage_Match_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorage_Match_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorage_Match_ResponseParam_ResultPtr NewSuccess(
      MatchResponsePtr value);
  // Construct an instance holding |failure|.
  static CacheStorage_Match_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorage_Match_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorage_Match_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorage_Match_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorage_Match_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorage_Match_ResponseParam_Result(const CacheStorage_Match_ResponseParam_Result& other) = delete;
  CacheStorage_Match_ResponseParam_Result& operator=(const CacheStorage_Match_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorage_Match_ResponseParam_ResultPtr>
  CacheStorage_Match_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorage_Match_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorage_Match_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const MatchResponsePtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  MatchResponsePtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(MatchResponsePtr success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorage_Match_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorage_Match_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        MatchResponsePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    MatchResponsePtr success;
    CacheStorageError failure;
  };

  CacheStorage_Match_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      MatchResponsePtr value);
  CacheStorage_Match_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT CacheStorage_Open_ResponseParam_Result {
 public:
  using DataView = CacheStorage_Open_ResponseParam_ResultDataView;
  using Data_ = internal::CacheStorage_Open_ResponseParam_Result_Data;
  using Tag = Data_::CacheStorage_Open_ResponseParam_Result_Tag;

  template <typename... Args>
  static CacheStorage_Open_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CacheStorage_Open_ResponseParam_ResultPtr NewSuccess(
      ::mojo::PendingAssociatedRemote<CacheStorageCache> value);
  // Construct an instance holding |failure|.
  static CacheStorage_Open_ResponseParam_ResultPtr NewFailure(
      CacheStorageError value);

  template <typename U>
  static CacheStorage_Open_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<CacheStorage_Open_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheStorage_Open_ResponseParam_Result>::Convert(*this);
  }
  ~CacheStorage_Open_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CacheStorage_Open_ResponseParam_Result(const CacheStorage_Open_ResponseParam_Result& other) = delete;
  CacheStorage_Open_ResponseParam_Result& operator=(const CacheStorage_Open_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CacheStorage_Open_ResponseParam_ResultPtr>
  CacheStorage_Open_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorage_Open_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CacheStorage_Open_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::mojo::PendingAssociatedRemote<CacheStorageCache>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::mojo::PendingAssociatedRemote<CacheStorageCache>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::mojo::PendingAssociatedRemote<CacheStorageCache> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CacheStorageError get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CacheStorageError failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheStorage_Open_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CacheStorage_Open_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::mojo::PendingAssociatedRemote<CacheStorageCache> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CacheStorageError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo::PendingAssociatedRemote<CacheStorageCache> success;
    CacheStorageError failure;
  };

  CacheStorage_Open_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::mojo::PendingAssociatedRemote<CacheStorageCache> value);
  CacheStorage_Open_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CacheStorageError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class PLATFORM_EXPORT MultiCacheQueryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MultiCacheQueryOptions, T>::value>;
  using DataView = MultiCacheQueryOptionsDataView;
  using Data_ = internal::MultiCacheQueryOptions_Data;

  template <typename... Args>
  static MultiCacheQueryOptionsPtr New(Args&&... args) {
    return MultiCacheQueryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MultiCacheQueryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<MultiCacheQueryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MultiCacheQueryOptions>::Convert(*this);
  }


  MultiCacheQueryOptions();

  MultiCacheQueryOptions(
      CacheQueryOptionsPtr query_options,
      const ::blink::String& cache_name);

MultiCacheQueryOptions(const MultiCacheQueryOptions&) = delete;
MultiCacheQueryOptions& operator=(const MultiCacheQueryOptions&) = delete;

  ~MultiCacheQueryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MultiCacheQueryOptionsPtr>
  MultiCacheQueryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MultiCacheQueryOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MultiCacheQueryOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MultiCacheQueryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MultiCacheQueryOptions_UnserializedMessageContext<
            UserType, MultiCacheQueryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MultiCacheQueryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MultiCacheQueryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MultiCacheQueryOptions_UnserializedMessageContext<
            UserType, MultiCacheQueryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MultiCacheQueryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CacheQueryOptionsPtr query_options;
  
  ::blink::String cache_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT BatchOperation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatchOperation, T>::value>;
  using DataView = BatchOperationDataView;
  using Data_ = internal::BatchOperation_Data;

  template <typename... Args>
  static BatchOperationPtr New(Args&&... args) {
    return BatchOperationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatchOperationPtr From(const U& u) {
    return mojo::TypeConverter<BatchOperationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatchOperation>::Convert(*this);
  }


  BatchOperation();

  BatchOperation(
      OperationType operation_type,
      ::blink::mojom::blink::FetchAPIRequestPtr request,
      ::blink::mojom::blink::FetchAPIResponsePtr response,
      CacheQueryOptionsPtr match_options);

BatchOperation(const BatchOperation&) = delete;
BatchOperation& operator=(const BatchOperation&) = delete;

  ~BatchOperation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatchOperationPtr>
  BatchOperationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatchOperation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatchOperation_UnserializedMessageContext<
            UserType, BatchOperation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatchOperation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatchOperation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatchOperation_UnserializedMessageContext<
            UserType, BatchOperation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatchOperation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  OperationType operation_type;
  
  ::blink::mojom::blink::FetchAPIRequestPtr request;
  
  ::blink::mojom::blink::FetchAPIResponsePtr response;
  
  CacheQueryOptionsPtr match_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatchOperation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT EagerResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EagerResponse, T>::value>;
  using DataView = EagerResponseDataView;
  using Data_ = internal::EagerResponse_Data;

  template <typename... Args>
  static EagerResponsePtr New(Args&&... args) {
    return EagerResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EagerResponsePtr From(const U& u) {
    return mojo::TypeConverter<EagerResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EagerResponse>::Convert(*this);
  }


  EagerResponse();

  EagerResponse(
      ::blink::mojom::blink::FetchAPIResponsePtr response,
      ::mojo::ScopedDataPipeConsumerHandle pipe,
      ::mojo::PendingReceiver<::blink::mojom::blink::BlobReaderClient> client_receiver);

EagerResponse(const EagerResponse&) = delete;
EagerResponse& operator=(const EagerResponse&) = delete;

  ~EagerResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EagerResponsePtr>
  EagerResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EagerResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EagerResponse_UnserializedMessageContext<
            UserType, EagerResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EagerResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EagerResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EagerResponse_UnserializedMessageContext<
            UserType, EagerResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EagerResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::FetchAPIResponsePtr response;
  
  ::mojo::ScopedDataPipeConsumerHandle pipe;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::BlobReaderClient> client_receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EagerResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CacheEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CacheEntry, T>::value>;
  using DataView = CacheEntryDataView;
  using Data_ = internal::CacheEntry_Data;

  template <typename... Args>
  static CacheEntryPtr New(Args&&... args) {
    return CacheEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CacheEntryPtr From(const U& u) {
    return mojo::TypeConverter<CacheEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CacheEntry>::Convert(*this);
  }


  CacheEntry();

  CacheEntry(
      ::blink::mojom::blink::FetchAPIRequestPtr request,
      ::blink::mojom::blink::FetchAPIResponsePtr response);

CacheEntry(const CacheEntry&) = delete;
CacheEntry& operator=(const CacheEntry&) = delete;

  ~CacheEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CacheEntryPtr>
  CacheEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CacheEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CacheEntry_UnserializedMessageContext<
            UserType, CacheEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CacheEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CacheEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CacheEntry_UnserializedMessageContext<
            UserType, CacheEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CacheEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::FetchAPIRequestPtr request;
  
  ::blink::mojom::blink::FetchAPIResponsePtr response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CacheEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MatchResponsePtr MatchResponse::Clone() const {
  switch (tag_) {
    case Tag::kResponse:
      return NewResponse(
          mojo::Clone(data_.response));
    case Tag::kEagerResponse:
      return NewEagerResponse(
          mojo::Clone(data_.eager_response));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MatchResponse>::value>::type*>
bool MatchResponse::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kResponse:
      return mojo::Equals(data_.response, other.data_.response);
    case Tag::kEagerResponse:
      return mojo::Equals(data_.eager_response, other.data_.eager_response);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorageCache_Match_ResponseParam_ResultPtr CacheStorageCache_Match_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorageCache_Match_ResponseParam_Result>::value>::type*>
bool CacheStorageCache_Match_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorageCache_MatchAll_ResponseParam_ResultPtr CacheStorageCache_MatchAll_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorageCache_MatchAll_ResponseParam_Result>::value>::type*>
bool CacheStorageCache_MatchAll_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result>::value>::type*>
bool CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorageCache_Keys_ResponseParam_ResultPtr CacheStorageCache_Keys_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorageCache_Keys_ResponseParam_Result>::value>::type*>
bool CacheStorageCache_Keys_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorage_Match_ResponseParam_ResultPtr CacheStorage_Match_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorage_Match_ResponseParam_Result>::value>::type*>
bool CacheStorage_Match_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
CacheStorage_Open_ResponseParam_ResultPtr CacheStorage_Open_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CacheStorage_Open_ResponseParam_Result>::value>::type*>
bool CacheStorage_Open_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
CacheStorageVerboseErrorPtr CacheStorageVerboseError::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(message)
  );
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>*>
bool CacheStorageVerboseError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, CacheStorageVerboseError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}
template <typename StructPtrType>
CacheQueryOptionsPtr CacheQueryOptions::Clone() const {
  return New(
      mojo::Clone(ignore_search),
      mojo::Clone(ignore_method),
      mojo::Clone(ignore_vary)
  );
}

template <typename T, CacheQueryOptions::EnableIfSame<T>*>
bool CacheQueryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ignore_search, other_struct.ignore_search))
    return false;
  if (!mojo::Equals(this->ignore_method, other_struct.ignore_method))
    return false;
  if (!mojo::Equals(this->ignore_vary, other_struct.ignore_vary))
    return false;
  return true;
}

template <typename T, CacheQueryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ignore_search < rhs.ignore_search)
    return true;
  if (rhs.ignore_search < lhs.ignore_search)
    return false;
  if (lhs.ignore_method < rhs.ignore_method)
    return true;
  if (rhs.ignore_method < lhs.ignore_method)
    return false;
  if (lhs.ignore_vary < rhs.ignore_vary)
    return true;
  if (rhs.ignore_vary < lhs.ignore_vary)
    return false;
  return false;
}
template <typename StructPtrType>
MultiCacheQueryOptionsPtr MultiCacheQueryOptions::Clone() const {
  return New(
      mojo::Clone(query_options),
      mojo::Clone(cache_name)
  );
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>*>
bool MultiCacheQueryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query_options, other_struct.query_options))
    return false;
  if (!mojo::Equals(this->cache_name, other_struct.cache_name))
    return false;
  return true;
}

template <typename T, MultiCacheQueryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query_options < rhs.query_options)
    return true;
  if (rhs.query_options < lhs.query_options)
    return false;
  if (lhs.cache_name < rhs.cache_name)
    return true;
  if (rhs.cache_name < lhs.cache_name)
    return false;
  return false;
}
template <typename StructPtrType>
BatchOperationPtr BatchOperation::Clone() const {
  return New(
      mojo::Clone(operation_type),
      mojo::Clone(request),
      mojo::Clone(response),
      mojo::Clone(match_options)
  );
}

template <typename T, BatchOperation::EnableIfSame<T>*>
bool BatchOperation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->operation_type, other_struct.operation_type))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->match_options, other_struct.match_options))
    return false;
  return true;
}

template <typename T, BatchOperation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.operation_type < rhs.operation_type)
    return true;
  if (rhs.operation_type < lhs.operation_type)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.match_options < rhs.match_options)
    return true;
  if (rhs.match_options < lhs.match_options)
    return false;
  return false;
}
template <typename StructPtrType>
EagerResponsePtr EagerResponse::Clone() const {
  return New(
      mojo::Clone(response),
      mojo::Clone(pipe),
      mojo::Clone(client_receiver)
  );
}

template <typename T, EagerResponse::EnableIfSame<T>*>
bool EagerResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  if (!mojo::Equals(this->pipe, other_struct.pipe))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  return true;
}

template <typename T, EagerResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  if (lhs.pipe < rhs.pipe)
    return true;
  if (rhs.pipe < lhs.pipe)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  return false;
}
template <typename StructPtrType>
CacheEntryPtr CacheEntry::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(response)
  );
}

template <typename T, CacheEntry::EnableIfSame<T>*>
bool CacheEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  return true;
}

template <typename T, CacheEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CacheStorageVerboseError::DataView,
                                         ::blink::mojom::blink::CacheStorageVerboseErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorageVerboseErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorageVerboseErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CacheStorageVerboseError::value) value(
      const ::blink::mojom::blink::CacheStorageVerboseErrorPtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::blink::CacheStorageVerboseError::message)& message(
      const ::blink::mojom::blink::CacheStorageVerboseErrorPtr& input) {
    return input->message;
  }

  static bool Read(::blink::mojom::blink::CacheStorageVerboseError::DataView input, ::blink::mojom::blink::CacheStorageVerboseErrorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CacheQueryOptions::DataView,
                                         ::blink::mojom::blink::CacheQueryOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheQueryOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheQueryOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::CacheQueryOptions::ignore_search) ignore_search(
      const ::blink::mojom::blink::CacheQueryOptionsPtr& input) {
    return input->ignore_search;
  }

  static decltype(::blink::mojom::blink::CacheQueryOptions::ignore_method) ignore_method(
      const ::blink::mojom::blink::CacheQueryOptionsPtr& input) {
    return input->ignore_method;
  }

  static decltype(::blink::mojom::blink::CacheQueryOptions::ignore_vary) ignore_vary(
      const ::blink::mojom::blink::CacheQueryOptionsPtr& input) {
    return input->ignore_vary;
  }

  static bool Read(::blink::mojom::blink::CacheQueryOptions::DataView input, ::blink::mojom::blink::CacheQueryOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MultiCacheQueryOptions::DataView,
                                         ::blink::mojom::blink::MultiCacheQueryOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::MultiCacheQueryOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MultiCacheQueryOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::MultiCacheQueryOptions::query_options)& query_options(
      const ::blink::mojom::blink::MultiCacheQueryOptionsPtr& input) {
    return input->query_options;
  }

  static const decltype(::blink::mojom::blink::MultiCacheQueryOptions::cache_name)& cache_name(
      const ::blink::mojom::blink::MultiCacheQueryOptionsPtr& input) {
    return input->cache_name;
  }

  static bool Read(::blink::mojom::blink::MultiCacheQueryOptions::DataView input, ::blink::mojom::blink::MultiCacheQueryOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BatchOperation::DataView,
                                         ::blink::mojom::blink::BatchOperationPtr> {
  static bool IsNull(const ::blink::mojom::blink::BatchOperationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BatchOperationPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::BatchOperation::operation_type) operation_type(
      const ::blink::mojom::blink::BatchOperationPtr& input) {
    return input->operation_type;
  }

  static  decltype(::blink::mojom::blink::BatchOperation::request)& request(
       ::blink::mojom::blink::BatchOperationPtr& input) {
    return input->request;
  }

  static  decltype(::blink::mojom::blink::BatchOperation::response)& response(
       ::blink::mojom::blink::BatchOperationPtr& input) {
    return input->response;
  }

  static const decltype(::blink::mojom::blink::BatchOperation::match_options)& match_options(
      const ::blink::mojom::blink::BatchOperationPtr& input) {
    return input->match_options;
  }

  static bool Read(::blink::mojom::blink::BatchOperation::DataView input, ::blink::mojom::blink::BatchOperationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::EagerResponse::DataView,
                                         ::blink::mojom::blink::EagerResponsePtr> {
  static bool IsNull(const ::blink::mojom::blink::EagerResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EagerResponsePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::EagerResponse::response)& response(
       ::blink::mojom::blink::EagerResponsePtr& input) {
    return input->response;
  }

  static  decltype(::blink::mojom::blink::EagerResponse::pipe)& pipe(
       ::blink::mojom::blink::EagerResponsePtr& input) {
    return input->pipe;
  }

  static  decltype(::blink::mojom::blink::EagerResponse::client_receiver)& client_receiver(
       ::blink::mojom::blink::EagerResponsePtr& input) {
    return input->client_receiver;
  }

  static bool Read(::blink::mojom::blink::EagerResponse::DataView input, ::blink::mojom::blink::EagerResponsePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CacheEntry::DataView,
                                         ::blink::mojom::blink::CacheEntryPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheEntryPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::CacheEntry::request)& request(
       ::blink::mojom::blink::CacheEntryPtr& input) {
    return input->request;
  }

  static  decltype(::blink::mojom::blink::CacheEntry::response)& response(
       ::blink::mojom::blink::CacheEntryPtr& input) {
    return input->response;
  }

  static bool Read(::blink::mojom::blink::CacheEntry::DataView input, ::blink::mojom::blink::CacheEntryPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::MatchResponse::DataView,
                                        ::blink::mojom::blink::MatchResponsePtr> {
  static bool IsNull(const ::blink::mojom::blink::MatchResponsePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MatchResponsePtr* output) { output->reset(); }

  static ::blink::mojom::blink::MatchResponse::Tag GetTag(const ::blink::mojom::blink::MatchResponsePtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::FetchAPIResponsePtr& response( ::blink::mojom::blink::MatchResponsePtr& input) {
    return input->get_response();
  }

  static  ::blink::mojom::blink::EagerResponsePtr& eager_response( ::blink::mojom::blink::MatchResponsePtr& input) {
    return input->get_eager_response();
  }

  static bool Read(::blink::mojom::blink::MatchResponse::DataView input, ::blink::mojom::blink::MatchResponsePtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::MatchResponsePtr& success( ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorageCache_Match_ResponseParam_ResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::blink::Vector<::blink::mojom::blink::FetchAPIResponsePtr>& success( ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorageCache_MatchAll_ResponseParam_ResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::blink::Vector<::blink::mojom::blink::CacheEntryPtr>& success( ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr>& success( ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorageCache_Keys_ResponseParam_ResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::blink::MatchResponsePtr& success( ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorage_Match_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorage_Match_ResponseParam_ResultPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::mojo::PendingAssociatedRemote<::blink::mojom::blink::CacheStorageCache>& success( ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::blink::mojom::blink::CacheStorageError failure(const ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::CacheStorage_Open_ResponseParam_Result::DataView input, ::blink::mojom::blink::CacheStorage_Open_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_BLINK_H_