// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-params-data.h"
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-import-headers.h"
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-test-utils.h"


namespace blink::mojom {
EpochTopic::EpochTopic()
    : topic(),
      version(),
      config_version(),
      model_version(),
      taxonomy_version() {}

EpochTopic::EpochTopic(
    int32_t topic_in,
    const std::string& version_in,
    const std::string& config_version_in,
    const std::string& model_version_in,
    const std::string& taxonomy_version_in)
    : topic(std::move(topic_in)),
      version(std::move(version_in)),
      config_version(std::move(config_version_in)),
      model_version(std::move(model_version_in)),
      taxonomy_version(std::move(taxonomy_version_in)) {}

EpochTopic::~EpochTopic() = default;
size_t EpochTopic::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->topic);
  seed = mojo::internal::Hash(seed, this->version);
  seed = mojo::internal::Hash(seed, this->config_version);
  seed = mojo::internal::Hash(seed, this->model_version);
  seed = mojo::internal::Hash(seed, this->taxonomy_version);
  return seed;
}

void EpochTopic::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "topic"), this->topic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "config_version"), this->config_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_version"), this->model_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "taxonomy_version"), this->taxonomy_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EpochTopic::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr
BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::NewSuccess(
    std::vector<EpochTopicPtr> value) {
  return BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr
BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::NewFailure(
    const std::string& value) {
  return BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    std::vector<EpochTopicPtr> value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    const std::string& value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::~BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result() {
  DestroyActive();
}

void BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::set_success(std::vector<EpochTopicPtr> success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) std::vector<EpochTopicPtr>(
        std::move(success));
  }
}

void BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::set_failure(const std::string& failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) std::string(
        std::move(failure));
  }
}


BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    std::vector<EpochTopicPtr> value)
    : success(std::move(value)) {}

BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    const std::string& value)
    : failure(std::move(value)) {}

void BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

BrowsingTopicsDocumentService::IPCStableHashFunction BrowsingTopicsDocumentService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BrowsingTopicsDocumentService>(message.name())) {
    case messages::BrowsingTopicsDocumentService::kGetBrowsingTopics: {
      return &BrowsingTopicsDocumentService::GetBrowsingTopics_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BrowsingTopicsDocumentService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BrowsingTopicsDocumentService>(message.name())) {
      case messages::BrowsingTopicsDocumentService::kGetBrowsingTopics:
            return "Receive blink::mojom::BrowsingTopicsDocumentService::GetBrowsingTopics";
    }
  } else {
    switch (static_cast<messages::BrowsingTopicsDocumentService>(message.name())) {
      case messages::BrowsingTopicsDocumentService::kGetBrowsingTopics:
            return "Receive reply blink::mojom::BrowsingTopicsDocumentService::GetBrowsingTopics";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BrowsingTopicsDocumentService::GetBrowsingTopics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47feddba;  // IPCStableHash for blink::mojom::BrowsingTopicsDocumentService::GetBrowsingTopics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback(
      BrowsingTopicsDocumentService::GetBrowsingTopicsCallback callback
      ) : callback_(std::move(callback)) {
  }

  BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback(const BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback&) = delete;
  BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback& operator=(const BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BrowsingTopicsDocumentService::GetBrowsingTopicsCallback callback_;
};

BrowsingTopicsDocumentServiceProxy::BrowsingTopicsDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BrowsingTopicsDocumentServiceProxy::GetBrowsingTopics(
    bool in_observe, GetBrowsingTopicsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BrowsingTopicsDocumentService::GetBrowsingTopics", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observe"), in_observe,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BrowsingTopicsDocumentService::kGetBrowsingTopics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BrowsingTopicsDocumentService_GetBrowsingTopics_Params_Data> params(
          message);
  params.Allocate();

  params->observe = in_observe;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BrowsingTopicsDocumentService::Name_);
  message.set_method_name("GetBrowsingTopics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BrowsingTopicsDocumentService::GetBrowsingTopicsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder> proxy(
        new BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr Transform(base::expected<
  std::vector<EpochTopicPtr>,
  std::string> in) {
    return in.has_value() ? ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BrowsingTopicsDocumentService::GetBrowsingTopicsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr in_result);
};

bool BrowsingTopicsDocumentService_GetBrowsingTopics_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BrowsingTopicsDocumentService.0
  bool success = true;
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr p_result{};
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BrowsingTopicsDocumentService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder::Run(
    BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BrowsingTopicsDocumentService::GetBrowsingTopics", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BrowsingTopicsDocumentService::kGetBrowsingTopics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BrowsingTopicsDocumentService::Name_);
  message.set_method_name("GetBrowsingTopics");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BrowsingTopicsDocumentServiceStubDispatch::Accept(
    BrowsingTopicsDocumentService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BrowsingTopicsDocumentService>(message->header()->name)) {
    case messages::BrowsingTopicsDocumentService::kGetBrowsingTopics: {
      break;
    }
  }
  return false;
}

// static
bool BrowsingTopicsDocumentServiceStubDispatch::AcceptWithResponder(
    BrowsingTopicsDocumentService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BrowsingTopicsDocumentService>(message->header()->name)) {
    case messages::BrowsingTopicsDocumentService::kGetBrowsingTopics: {
      internal::BrowsingTopicsDocumentService_GetBrowsingTopics_Params_Data* params =
          reinterpret_cast<
              internal::BrowsingTopicsDocumentService_GetBrowsingTopics_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BrowsingTopicsDocumentService.0
      bool success = true;
      bool p_observe{};
      BrowsingTopicsDocumentService_GetBrowsingTopics_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_observe = input_data_view.observe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BrowsingTopicsDocumentService::Name_, 0, false);
        return false;
      }
      auto callback =
          BrowsingTopicsDocumentService_GetBrowsingTopics_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBrowsingTopics(        
        std::move(p_observe), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBrowsingTopicsDocumentServiceValidationInfo[] = {
    { &internal::BrowsingTopicsDocumentService_GetBrowsingTopics_Params_Data::Validate,
     &internal::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParams_Data::Validate},
};

bool BrowsingTopicsDocumentServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BrowsingTopicsDocumentService::Name_,
    kBrowsingTopicsDocumentServiceValidationInfo);
}

bool BrowsingTopicsDocumentServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::BrowsingTopicsDocumentService::Name_,
    kBrowsingTopicsDocumentServiceValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::EpochTopic::DataView, ::blink::mojom::EpochTopicPtr>::Read(
    ::blink::mojom::EpochTopic::DataView input,
    ::blink::mojom::EpochTopicPtr* output) {
  bool success = true;
  ::blink::mojom::EpochTopicPtr result(::blink::mojom::EpochTopic::New());
  
      if (success)
        result->topic = input.topic();
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadConfigVersion(&result->config_version))
        success = false;
      if (success && !input.ReadModelVersion(&result->model_version))
        success = false;
      if (success && !input.ReadTaxonomyVersion(&result->taxonomy_version))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView, ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView input,
    ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      std::vector<::blink::mojom::EpochTopicPtr> result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      std::string result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BrowsingTopicsDocumentServiceInterceptorForTesting::GetBrowsingTopics(bool observe, GetBrowsingTopicsCallback callback) {
  GetForwardingInterface()->GetBrowsingTopics(
    std::move(observe)
    , std::move(callback));
}
BrowsingTopicsDocumentServiceAsyncWaiter::BrowsingTopicsDocumentServiceAsyncWaiter(
    BrowsingTopicsDocumentService* proxy) : proxy_(proxy) {}

BrowsingTopicsDocumentServiceAsyncWaiter::~BrowsingTopicsDocumentServiceAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif