// third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/browsing_topics/browsing_topics.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class BrowsingTopicsDocumentServiceProxy;

template <typename ImplRefTraits>
class BrowsingTopicsDocumentServiceStub;

class BrowsingTopicsDocumentServiceRequestValidator;
class BrowsingTopicsDocumentServiceResponseValidator;


class PLATFORM_EXPORT BrowsingTopicsDocumentService
    : public BrowsingTopicsDocumentServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BrowsingTopicsDocumentService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BrowsingTopicsDocumentServiceInterfaceBase;
  using Proxy_ = BrowsingTopicsDocumentServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BrowsingTopicsDocumentServiceStub<ImplRefTraits>;

  using RequestValidator_ = BrowsingTopicsDocumentServiceRequestValidator;
  using ResponseValidator_ = BrowsingTopicsDocumentServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetBrowsingTopicsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetBrowsingTopics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BrowsingTopicsDocumentService() = default;

  using GetBrowsingTopicsCallback = base::OnceCallback<void(base::expected<
  ::blink::Vector<EpochTopicPtr>,
  ::blink::String>)>;
  using GetBrowsingTopicsResult = base::expected<
  ::blink::Vector<EpochTopicPtr>,
  ::blink::String>;
  using GetBrowsingTopicsMojoCallback = base::OnceCallback<void(BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr)>;

  virtual void GetBrowsingTopics(bool observe, GetBrowsingTopicsCallback callback) = 0;
};



class PLATFORM_EXPORT BrowsingTopicsDocumentServiceProxy
    : public BrowsingTopicsDocumentService {
 public:
  using InterfaceType = BrowsingTopicsDocumentService;

  explicit BrowsingTopicsDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetBrowsingTopics(bool observe, GetBrowsingTopicsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT BrowsingTopicsDocumentServiceStubDispatch {
 public:
  static bool Accept(BrowsingTopicsDocumentService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BrowsingTopicsDocumentService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BrowsingTopicsDocumentService>>
class BrowsingTopicsDocumentServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BrowsingTopicsDocumentServiceStub() = default;
  ~BrowsingTopicsDocumentServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowsingTopicsDocumentServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowsingTopicsDocumentServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BrowsingTopicsDocumentServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BrowsingTopicsDocumentServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result {
 public:
  using DataView = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultDataView;
  using Data_ = internal::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result_Data;
  using Tag = Data_::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result_Tag;

  template <typename... Args>
  static BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr NewSuccess(
      ::blink::Vector<EpochTopicPtr> value);
  // Construct an instance holding |failure|.
  static BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr NewFailure(
      const ::blink::String& value);

  template <typename U>
  static BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result>::Convert(*this);
  }
  ~BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(const BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result& other) = delete;
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result& operator=(const BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr>
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::blink::Vector<EpochTopicPtr>& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::blink::Vector<EpochTopicPtr>& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::blink::Vector<EpochTopicPtr> success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::blink::String& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::blink::String& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(const ::blink::String& failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::blink::Vector<EpochTopicPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        const ::blink::String& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<EpochTopicPtr> success;
    ::blink::String failure;
  };

  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::blink::Vector<EpochTopicPtr> value);
  BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      const ::blink::String& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT EpochTopic {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EpochTopic, T>::value>;
  using DataView = EpochTopicDataView;
  using Data_ = internal::EpochTopic_Data;

  template <typename... Args>
  static EpochTopicPtr New(Args&&... args) {
    return EpochTopicPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EpochTopicPtr From(const U& u) {
    return mojo::TypeConverter<EpochTopicPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EpochTopic>::Convert(*this);
  }


  EpochTopic();

  EpochTopic(
      int32_t topic,
      const ::blink::String& version,
      const ::blink::String& config_version,
      const ::blink::String& model_version,
      const ::blink::String& taxonomy_version);


  ~EpochTopic();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EpochTopicPtr>
  EpochTopicPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EpochTopic::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EpochTopic::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EpochTopic::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EpochTopic_UnserializedMessageContext<
            UserType, EpochTopic::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EpochTopic::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EpochTopic::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EpochTopic_UnserializedMessageContext<
            UserType, EpochTopic::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EpochTopic::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t topic;
  
  ::blink::String version;
  
  ::blink::String config_version;
  
  ::blink::String model_version;
  
  ::blink::String taxonomy_version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EpochTopic::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result>::value>::type*>
bool BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
EpochTopicPtr EpochTopic::Clone() const {
  return New(
      mojo::Clone(topic),
      mojo::Clone(version),
      mojo::Clone(config_version),
      mojo::Clone(model_version),
      mojo::Clone(taxonomy_version)
  );
}

template <typename T, EpochTopic::EnableIfSame<T>*>
bool EpochTopic::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->topic, other_struct.topic))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->config_version, other_struct.config_version))
    return false;
  if (!mojo::Equals(this->model_version, other_struct.model_version))
    return false;
  if (!mojo::Equals(this->taxonomy_version, other_struct.taxonomy_version))
    return false;
  return true;
}

template <typename T, EpochTopic::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.topic < rhs.topic)
    return true;
  if (rhs.topic < lhs.topic)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.config_version < rhs.config_version)
    return true;
  if (rhs.config_version < lhs.config_version)
    return false;
  if (lhs.model_version < rhs.model_version)
    return true;
  if (rhs.model_version < lhs.model_version)
    return false;
  if (lhs.taxonomy_version < rhs.taxonomy_version)
    return true;
  if (rhs.taxonomy_version < lhs.taxonomy_version)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::EpochTopic::DataView,
                                         ::blink::mojom::blink::EpochTopicPtr> {
  static bool IsNull(const ::blink::mojom::blink::EpochTopicPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EpochTopicPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::EpochTopic::topic) topic(
      const ::blink::mojom::blink::EpochTopicPtr& input) {
    return input->topic;
  }

  static const decltype(::blink::mojom::blink::EpochTopic::version)& version(
      const ::blink::mojom::blink::EpochTopicPtr& input) {
    return input->version;
  }

  static const decltype(::blink::mojom::blink::EpochTopic::config_version)& config_version(
      const ::blink::mojom::blink::EpochTopicPtr& input) {
    return input->config_version;
  }

  static const decltype(::blink::mojom::blink::EpochTopic::model_version)& model_version(
      const ::blink::mojom::blink::EpochTopicPtr& input) {
    return input->model_version;
  }

  static const decltype(::blink::mojom::blink::EpochTopic::taxonomy_version)& taxonomy_version(
      const ::blink::mojom::blink::EpochTopicPtr& input) {
    return input->taxonomy_version;
  }

  static bool Read(::blink::mojom::blink::EpochTopic::DataView input, ::blink::mojom::blink::EpochTopicPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView,
                                        ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::Tag GetTag(const ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::blink::Vector<::blink::mojom::blink::EpochTopicPtr>& success(const ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::blink::String& failure(const ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_Result::DataView input, ::blink::mojom::blink::BrowsingTopicsDocumentService_GetBrowsingTopics_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BROWSING_TOPICS_BROWSING_TOPICS_MOJOM_BLINK_H_