// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/bluetooth/web_bluetooth_device_id_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WebBluetoothServiceProxy;

template <typename ImplRefTraits>
class WebBluetoothServiceStub;

class WebBluetoothServiceRequestValidator;
class WebBluetoothServiceResponseValidator;


class BLINK_COMMON_EXPORT WebBluetoothService
    : public WebBluetoothServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebBluetoothService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBluetoothServiceInterfaceBase;
  using Proxy_ = WebBluetoothServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothServiceRequestValidator;
  using ResponseValidator_ = WebBluetoothServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAvailabilityMinVersion = 0,
    kRequestDeviceMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kForgetDeviceMinVersion = 0,
    kRemoteServerConnectMinVersion = 0,
    kRemoteServerDisconnectMinVersion = 0,
    kRemoteServerGetPrimaryServicesMinVersion = 0,
    kRemoteServiceGetCharacteristicsMinVersion = 0,
    kRemoteCharacteristicReadValueMinVersion = 0,
    kRemoteCharacteristicWriteValueMinVersion = 0,
    kRemoteCharacteristicStartNotificationsMinVersion = 0,
    kRemoteCharacteristicStopNotificationsMinVersion = 0,
    kRemoteCharacteristicGetDescriptorsMinVersion = 0,
    kRemoteDescriptorReadValueMinVersion = 0,
    kRemoteDescriptorWriteValueMinVersion = 0,
    kRequestScanningStartMinVersion = 0,
    kWatchAdvertisementsForDeviceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAvailability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForgetDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteServerConnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteServerDisconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteServerGetPrimaryServices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteServiceGetCharacteristics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteCharacteristicReadValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteCharacteristicWriteValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteCharacteristicStartNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteCharacteristicStopNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteCharacteristicGetDescriptors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteDescriptorReadValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoteDescriptorWriteValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestScanningStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WatchAdvertisementsForDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBluetoothService() = default;

  using GetAvailabilityCallback = base::OnceCallback<void(bool)>;
  using GetAvailabilityMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetAvailability(GetAvailabilityCallback callback) = 0;

  using RequestDeviceCallback = base::OnceCallback<void(WebBluetoothResult, WebBluetoothDevicePtr)>;
  using RequestDeviceMojoCallback = base::OnceCallback<void(WebBluetoothResult, WebBluetoothDevicePtr)>;

  virtual void RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) = 0;

  using GetDevicesCallback = base::OnceCallback<void(std::vector<WebBluetoothDevicePtr>)>;
  using GetDevicesMojoCallback = base::OnceCallback<void(std::vector<WebBluetoothDevicePtr>)>;

  virtual void GetDevices(GetDevicesCallback callback) = 0;

  using ForgetDeviceCallback = base::OnceCallback<void()>;
  using ForgetDeviceMojoCallback = base::OnceCallback<void()>;

  virtual void ForgetDevice(const ::blink::WebBluetoothDeviceId& device_id, ForgetDeviceCallback callback) = 0;

  using RemoteServerConnectCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using RemoteServerConnectMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void RemoteServerConnect(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) = 0;

  virtual void RemoteServerDisconnect(const ::blink::WebBluetoothDeviceId& device_id) = 0;

  using RemoteServerGetPrimaryServicesCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>)>;
  using RemoteServerGetPrimaryServicesMojoCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTServicePtr>>)>;

  virtual void RemoteServerGetPrimaryServices(const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, RemoteServerGetPrimaryServicesCallback callback) = 0;

  using RemoteServiceGetCharacteristicsCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>)>;
  using RemoteServiceGetCharacteristicsMojoCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTCharacteristicPtr>>)>;

  virtual void RemoteServiceGetCharacteristics(const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) = 0;

  using RemoteCharacteristicReadValueCallback = base::OnceCallback<void(WebBluetoothResult, ::base::span<const ::uint8_t>)>;
  using RemoteCharacteristicReadValueMojoCallback = base::OnceCallback<void(WebBluetoothResult, ::base::span<const ::uint8_t>)>;

  virtual void RemoteCharacteristicReadValue(const std::string& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) = 0;

  using RemoteCharacteristicWriteValueCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using RemoteCharacteristicWriteValueMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void RemoteCharacteristicWriteValue(const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) = 0;

  using RemoteCharacteristicStartNotificationsCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using RemoteCharacteristicStartNotificationsMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void RemoteCharacteristicStartNotifications(const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) = 0;

  using RemoteCharacteristicStopNotificationsCallback = base::OnceCallback<void()>;
  using RemoteCharacteristicStopNotificationsMojoCallback = base::OnceCallback<void()>;

  virtual void RemoteCharacteristicStopNotifications(const std::string& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) = 0;

  using RemoteCharacteristicGetDescriptorsCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>)>;
  using RemoteCharacteristicGetDescriptorsMojoCallback = base::OnceCallback<void(WebBluetoothResult, std::optional<std::vector<WebBluetoothRemoteGATTDescriptorPtr>>)>;

  virtual void RemoteCharacteristicGetDescriptors(const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) = 0;

  using RemoteDescriptorReadValueCallback = base::OnceCallback<void(WebBluetoothResult, ::base::span<const ::uint8_t>)>;
  using RemoteDescriptorReadValueMojoCallback = base::OnceCallback<void(WebBluetoothResult, ::base::span<const ::uint8_t>)>;

  virtual void RemoteDescriptorReadValue(const std::string& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) = 0;

  using RemoteDescriptorWriteValueCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using RemoteDescriptorWriteValueMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void RemoteDescriptorWriteValue(const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, RemoteDescriptorWriteValueCallback callback) = 0;

  using RequestScanningStartCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using RequestScanningStartMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) = 0;

  using WatchAdvertisementsForDeviceCallback = base::OnceCallback<void(WebBluetoothResult)>;
  using WatchAdvertisementsForDeviceMojoCallback = base::OnceCallback<void(WebBluetoothResult)>;

  virtual void WatchAdvertisementsForDevice(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) = 0;
};

class WebBluetoothServerClientProxy;

template <typename ImplRefTraits>
class WebBluetoothServerClientStub;

class WebBluetoothServerClientRequestValidator;


class BLINK_COMMON_EXPORT WebBluetoothServerClient
    : public WebBluetoothServerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebBluetoothServerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBluetoothServerClientInterfaceBase;
  using Proxy_ = WebBluetoothServerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothServerClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothServerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGATTServerDisconnectedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GATTServerDisconnected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBluetoothServerClient() = default;

  virtual void GATTServerDisconnected() = 0;
};

class WebBluetoothCharacteristicClientProxy;

template <typename ImplRefTraits>
class WebBluetoothCharacteristicClientStub;

class WebBluetoothCharacteristicClientRequestValidator;


class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClient
    : public WebBluetoothCharacteristicClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebBluetoothCharacteristicClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBluetoothCharacteristicClientInterfaceBase;
  using Proxy_ = WebBluetoothCharacteristicClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothCharacteristicClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothCharacteristicClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRemoteCharacteristicValueChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RemoteCharacteristicValueChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBluetoothCharacteristicClient() = default;

  virtual void RemoteCharacteristicValueChanged(::base::span<const ::uint8_t> value) = 0;
};

class WebBluetoothAdvertisementClientProxy;

template <typename ImplRefTraits>
class WebBluetoothAdvertisementClientStub;

class WebBluetoothAdvertisementClientRequestValidator;


class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClient
    : public WebBluetoothAdvertisementClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebBluetoothAdvertisementClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebBluetoothAdvertisementClientInterfaceBase;
  using Proxy_ = WebBluetoothAdvertisementClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothAdvertisementClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothAdvertisementClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAdvertisingEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AdvertisingEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebBluetoothAdvertisementClient() = default;

  virtual void AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) = 0;
};



class BLINK_COMMON_EXPORT WebBluetoothServiceProxy
    : public WebBluetoothService {
 public:
  using InterfaceType = WebBluetoothService;

  explicit WebBluetoothServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAvailability(GetAvailabilityCallback callback) final;
  
  void RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void ForgetDevice(const ::blink::WebBluetoothDeviceId& device_id, ForgetDeviceCallback callback) final;
  
  void RemoteServerConnect(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) final;
  
  void RemoteServerDisconnect(const ::blink::WebBluetoothDeviceId& device_id) final;
  
  void RemoteServerGetPrimaryServices(const ::blink::WebBluetoothDeviceId& device_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& services_uuid, RemoteServerGetPrimaryServicesCallback callback) final;
  
  void RemoteServiceGetCharacteristics(const std::string& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) final;
  
  void RemoteCharacteristicReadValue(const std::string& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) final;
  
  void RemoteCharacteristicWriteValue(const std::string& characteristic_instance_id, ::base::span<const ::uint8_t> value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) final;
  
  void RemoteCharacteristicStartNotifications(const std::string& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) final;
  
  void RemoteCharacteristicStopNotifications(const std::string& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) final;
  
  void RemoteCharacteristicGetDescriptors(const std::string& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const std::optional<::device::BluetoothUUID>& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) final;
  
  void RemoteDescriptorReadValue(const std::string& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) final;
  
  void RemoteDescriptorWriteValue(const std::string& descriptor_instance_id, ::base::span<const ::uint8_t> value, RemoteDescriptorWriteValueCallback callback) final;
  
  void RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) final;
  
  void WatchAdvertisementsForDevice(const ::blink::WebBluetoothDeviceId& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebBluetoothServerClientProxy
    : public WebBluetoothServerClient {
 public:
  using InterfaceType = WebBluetoothServerClient;

  explicit WebBluetoothServerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GATTServerDisconnected() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClientProxy
    : public WebBluetoothCharacteristicClient {
 public:
  using InterfaceType = WebBluetoothCharacteristicClient;

  explicit WebBluetoothCharacteristicClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RemoteCharacteristicValueChanged(::base::span<const ::uint8_t> value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClientProxy
    : public WebBluetoothAdvertisementClient {
 public:
  using InterfaceType = WebBluetoothAdvertisementClient;

  explicit WebBluetoothAdvertisementClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WebBluetoothServiceStubDispatch {
 public:
  static bool Accept(WebBluetoothService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothService>>
class WebBluetoothServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothServiceStub() = default;
  ~WebBluetoothServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebBluetoothServerClientStubDispatch {
 public:
  static bool Accept(WebBluetoothServerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothServerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothServerClient>>
class WebBluetoothServerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothServerClientStub() = default;
  ~WebBluetoothServerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClientStubDispatch {
 public:
  static bool Accept(WebBluetoothCharacteristicClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothCharacteristicClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothCharacteristicClient>>
class WebBluetoothCharacteristicClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothCharacteristicClientStub() = default;
  ~WebBluetoothCharacteristicClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothCharacteristicClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothCharacteristicClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClientStubDispatch {
 public:
  static bool Accept(WebBluetoothAdvertisementClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothAdvertisementClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothAdvertisementClient>>
class WebBluetoothAdvertisementClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothAdvertisementClientStub() = default;
  ~WebBluetoothAdvertisementClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothAdvertisementClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothAdvertisementClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebBluetoothServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebBluetoothServerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebBluetoothCharacteristicClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebBluetoothAdvertisementClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebBluetoothServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT WebBluetoothCompany {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothCompany, T>::value>;
  using DataView = WebBluetoothCompanyDataView;
  using Data_ = internal::WebBluetoothCompany_Data;

  template <typename... Args>
  static WebBluetoothCompanyPtr New(Args&&... args) {
    return WebBluetoothCompanyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothCompanyPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothCompanyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothCompany>::Convert(*this);
  }


  WebBluetoothCompany();

  explicit WebBluetoothCompany(
      uint16_t id);


  ~WebBluetoothCompany();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothCompanyPtr>
  WebBluetoothCompanyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothCompany::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothCompany::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothCompany::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothCompany_UnserializedMessageContext<
            UserType, WebBluetoothCompany::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothCompany::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothCompany::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothCompany_UnserializedMessageContext<
            UserType, WebBluetoothCompany::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothCompany::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothCompany::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothDataFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothDataFilter, T>::value>;
  using DataView = WebBluetoothDataFilterDataView;
  using Data_ = internal::WebBluetoothDataFilter_Data;

  template <typename... Args>
  static WebBluetoothDataFilterPtr New(Args&&... args) {
    return WebBluetoothDataFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothDataFilterPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothDataFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothDataFilter>::Convert(*this);
  }


  WebBluetoothDataFilter();

  WebBluetoothDataFilter(
      uint8_t data,
      uint8_t mask);


  ~WebBluetoothDataFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothDataFilterPtr>
  WebBluetoothDataFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDataFilter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDataFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothDataFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothDataFilter_UnserializedMessageContext<
            UserType, WebBluetoothDataFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothDataFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothDataFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothDataFilter_UnserializedMessageContext<
            UserType, WebBluetoothDataFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothDataFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t data;
  
  uint8_t mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothDataFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class BLINK_COMMON_EXPORT WebBluetoothLeScanFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothLeScanFilter, T>::value>;
  using DataView = WebBluetoothLeScanFilterDataView;
  using Data_ = internal::WebBluetoothLeScanFilter_Data;

  template <typename... Args>
  static WebBluetoothLeScanFilterPtr New(Args&&... args) {
    return WebBluetoothLeScanFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothLeScanFilterPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothLeScanFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothLeScanFilter>::Convert(*this);
  }


  WebBluetoothLeScanFilter();

  WebBluetoothLeScanFilter(
      std::optional<std::vector<::device::BluetoothUUID>> services,
      const std::optional<std::string>& name,
      const std::optional<std::string>& name_prefix,
      std::optional<base::flat_map<WebBluetoothCompanyPtr, std::vector<WebBluetoothDataFilterPtr>>> manufacturer_data);

WebBluetoothLeScanFilter(const WebBluetoothLeScanFilter&) = delete;
WebBluetoothLeScanFilter& operator=(const WebBluetoothLeScanFilter&) = delete;

  ~WebBluetoothLeScanFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothLeScanFilterPtr>
  WebBluetoothLeScanFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothLeScanFilter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothLeScanFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothLeScanFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothLeScanFilter_UnserializedMessageContext<
            UserType, WebBluetoothLeScanFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothLeScanFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothLeScanFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothLeScanFilter_UnserializedMessageContext<
            UserType, WebBluetoothLeScanFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothLeScanFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<::device::BluetoothUUID>> services;
  
  std::optional<std::string> name;
  
  std::optional<std::string> name_prefix;
  
  std::optional<base::flat_map<WebBluetoothCompanyPtr, std::vector<WebBluetoothDataFilterPtr>>> manufacturer_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT WebBluetoothRequestDeviceOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRequestDeviceOptions, T>::value>;
  using DataView = WebBluetoothRequestDeviceOptionsDataView;
  using Data_ = internal::WebBluetoothRequestDeviceOptions_Data;

  template <typename... Args>
  static WebBluetoothRequestDeviceOptionsPtr New(Args&&... args) {
    return WebBluetoothRequestDeviceOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRequestDeviceOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRequestDeviceOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRequestDeviceOptions>::Convert(*this);
  }


  WebBluetoothRequestDeviceOptions();

  WebBluetoothRequestDeviceOptions(
      std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters,
      std::optional<std::vector<WebBluetoothLeScanFilterPtr>> exclusion_filters,
      std::vector<::device::BluetoothUUID> optional_services,
      std::vector<uint16_t> optional_manufacturer_data,
      bool accept_all_devices);

WebBluetoothRequestDeviceOptions(const WebBluetoothRequestDeviceOptions&) = delete;
WebBluetoothRequestDeviceOptions& operator=(const WebBluetoothRequestDeviceOptions&) = delete;

  ~WebBluetoothRequestDeviceOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRequestDeviceOptionsPtr>
  WebBluetoothRequestDeviceOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestDeviceOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestDeviceOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRequestDeviceOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestDeviceOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothRequestDeviceOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothRequestDeviceOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestDeviceOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRequestDeviceOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters;
  
  std::optional<std::vector<WebBluetoothLeScanFilterPtr>> exclusion_filters;
  
  std::vector<::device::BluetoothUUID> optional_services;
  
  std::vector<uint16_t> optional_manufacturer_data;
  
  bool accept_all_devices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothRequestLEScanOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRequestLEScanOptions, T>::value>;
  using DataView = WebBluetoothRequestLEScanOptionsDataView;
  using Data_ = internal::WebBluetoothRequestLEScanOptions_Data;

  template <typename... Args>
  static WebBluetoothRequestLEScanOptionsPtr New(Args&&... args) {
    return WebBluetoothRequestLEScanOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRequestLEScanOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRequestLEScanOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRequestLEScanOptions>::Convert(*this);
  }


  WebBluetoothRequestLEScanOptions();

  WebBluetoothRequestLEScanOptions(
      std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters,
      bool keep_repeated_devices,
      bool accept_all_advertisements);

WebBluetoothRequestLEScanOptions(const WebBluetoothRequestLEScanOptions&) = delete;
WebBluetoothRequestLEScanOptions& operator=(const WebBluetoothRequestLEScanOptions&) = delete;

  ~WebBluetoothRequestLEScanOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRequestLEScanOptionsPtr>
  WebBluetoothRequestLEScanOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestLEScanOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestLEScanOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRequestLEScanOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRequestLEScanOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestLEScanOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothRequestLEScanOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothRequestLEScanOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRequestLEScanOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestLEScanOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRequestLEScanOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<WebBluetoothLeScanFilterPtr>> filters;
  
  bool keep_repeated_devices;
  
  bool accept_all_advertisements;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothDeviceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothDeviceId, T>::value>;
  using DataView = WebBluetoothDeviceIdDataView;
  using Data_ = internal::WebBluetoothDeviceId_Data;

  template <typename... Args>
  static WebBluetoothDeviceIdPtr New(Args&&... args) {
    return WebBluetoothDeviceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothDeviceIdPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothDeviceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothDeviceId>::Convert(*this);
  }


  WebBluetoothDeviceId();

  explicit WebBluetoothDeviceId(
      std::vector<uint8_t> device_id);


  ~WebBluetoothDeviceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothDeviceIdPtr>
  WebBluetoothDeviceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDeviceId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDeviceId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothDeviceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothDeviceId_UnserializedMessageContext<
            UserType, WebBluetoothDeviceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothDeviceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothDeviceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothDeviceId_UnserializedMessageContext<
            UserType, WebBluetoothDeviceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothDeviceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> device_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothDevice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothDevice, T>::value>;
  using DataView = WebBluetoothDeviceDataView;
  using Data_ = internal::WebBluetoothDevice_Data;

  template <typename... Args>
  static WebBluetoothDevicePtr New(Args&&... args) {
    return WebBluetoothDevicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothDevicePtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothDevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothDevice>::Convert(*this);
  }


  WebBluetoothDevice();

  WebBluetoothDevice(
      const ::blink::WebBluetoothDeviceId& id,
      const std::optional<std::string>& name);


  ~WebBluetoothDevice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothDevicePtr>
  WebBluetoothDevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDevice::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDevice::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothDevice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothDevice_UnserializedMessageContext<
            UserType, WebBluetoothDevice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothDevice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothDevice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothDevice_UnserializedMessageContext<
            UserType, WebBluetoothDevice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothDevice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::WebBluetoothDeviceId id;
  
  std::optional<std::string> name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothRemoteGATTService {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTService, T>::value>;
  using DataView = WebBluetoothRemoteGATTServiceDataView;
  using Data_ = internal::WebBluetoothRemoteGATTService_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTServicePtr New(Args&&... args) {
    return WebBluetoothRemoteGATTServicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTServicePtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTServicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTService>::Convert(*this);
  }


  WebBluetoothRemoteGATTService();

  WebBluetoothRemoteGATTService(
      const std::string& instance_id,
      const ::device::BluetoothUUID& uuid);


  ~WebBluetoothRemoteGATTService();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTServicePtr>
  WebBluetoothRemoteGATTServicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTService::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTService::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTService::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTService_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTService::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTService::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothRemoteGATTService::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTService_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTService::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTService::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string instance_id;
  
  ::device::BluetoothUUID uuid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothRemoteGATTCharacteristic {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTCharacteristic, T>::value>;
  using DataView = WebBluetoothRemoteGATTCharacteristicDataView;
  using Data_ = internal::WebBluetoothRemoteGATTCharacteristic_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTCharacteristicPtr New(Args&&... args) {
    return WebBluetoothRemoteGATTCharacteristicPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTCharacteristicPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTCharacteristicPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTCharacteristic>::Convert(*this);
  }


  WebBluetoothRemoteGATTCharacteristic();

  WebBluetoothRemoteGATTCharacteristic(
      const std::string& instance_id,
      const ::device::BluetoothUUID& uuid,
      uint32_t properties);


  ~WebBluetoothRemoteGATTCharacteristic();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTCharacteristicPtr>
  WebBluetoothRemoteGATTCharacteristicPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTCharacteristic::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTCharacteristic::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTCharacteristic::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTCharacteristic_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTCharacteristic::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTCharacteristic::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothRemoteGATTCharacteristic::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTCharacteristic_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTCharacteristic::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTCharacteristic::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string instance_id;
  
  ::device::BluetoothUUID uuid;
  
  uint32_t properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothAdvertisingEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothAdvertisingEvent, T>::value>;
  using DataView = WebBluetoothAdvertisingEventDataView;
  using Data_ = internal::WebBluetoothAdvertisingEvent_Data;

  template <typename... Args>
  static WebBluetoothAdvertisingEventPtr New(Args&&... args) {
    return WebBluetoothAdvertisingEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothAdvertisingEventPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothAdvertisingEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothAdvertisingEvent>::Convert(*this);
  }


  WebBluetoothAdvertisingEvent();

  WebBluetoothAdvertisingEvent(
      WebBluetoothDevicePtr device,
      const std::optional<std::string>& name,
      std::vector<::device::BluetoothUUID> uuids,
      bool appearance_is_set,
      uint16_t appearance,
      bool tx_power_is_set,
      uint8_t tx_power,
      bool rssi_is_set,
      uint8_t rssi,
      base::flat_map<WebBluetoothCompanyPtr, std::vector<uint8_t>> manufacturer_data,
      const base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>>& service_data);

WebBluetoothAdvertisingEvent(const WebBluetoothAdvertisingEvent&) = delete;
WebBluetoothAdvertisingEvent& operator=(const WebBluetoothAdvertisingEvent&) = delete;

  ~WebBluetoothAdvertisingEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothAdvertisingEventPtr>
  WebBluetoothAdvertisingEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothAdvertisingEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothAdvertisingEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothAdvertisingEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothAdvertisingEvent_UnserializedMessageContext<
            UserType, WebBluetoothAdvertisingEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothAdvertisingEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothAdvertisingEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothAdvertisingEvent_UnserializedMessageContext<
            UserType, WebBluetoothAdvertisingEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothAdvertisingEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebBluetoothDevicePtr device;
  
  std::optional<std::string> name;
  
  std::vector<::device::BluetoothUUID> uuids;
  
  bool appearance_is_set;
  
  uint16_t appearance;
  
  bool tx_power_is_set;
  
  uint8_t tx_power;
  
  bool rssi_is_set;
  
  uint8_t rssi;
  
  base::flat_map<WebBluetoothCompanyPtr, std::vector<uint8_t>> manufacturer_data;
  
  base::flat_map<::device::BluetoothUUID, std::vector<uint8_t>> service_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT WebBluetoothRemoteGATTDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTDescriptor, T>::value>;
  using DataView = WebBluetoothRemoteGATTDescriptorDataView;
  using Data_ = internal::WebBluetoothRemoteGATTDescriptor_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTDescriptorPtr New(Args&&... args) {
    return WebBluetoothRemoteGATTDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTDescriptor>::Convert(*this);
  }


  WebBluetoothRemoteGATTDescriptor();

  WebBluetoothRemoteGATTDescriptor(
      const std::string& instance_id,
      const ::device::BluetoothUUID& uuid);


  ~WebBluetoothRemoteGATTDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTDescriptorPtr>
  WebBluetoothRemoteGATTDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTDescriptor_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebBluetoothRemoteGATTDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTDescriptor_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string instance_id;
  
  ::device::BluetoothUUID uuid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebBluetoothLeScanFilterPtr WebBluetoothLeScanFilter::Clone() const {
  return New(
      mojo::Clone(services),
      mojo::Clone(name),
      mojo::Clone(name_prefix),
      mojo::Clone(manufacturer_data)
  );
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>*>
bool WebBluetoothLeScanFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->services, other_struct.services))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->name_prefix, other_struct.name_prefix))
    return false;
  if (!mojo::Equals(this->manufacturer_data, other_struct.manufacturer_data))
    return false;
  return true;
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.services < rhs.services)
    return true;
  if (rhs.services < lhs.services)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.name_prefix < rhs.name_prefix)
    return true;
  if (rhs.name_prefix < lhs.name_prefix)
    return false;
  if (lhs.manufacturer_data < rhs.manufacturer_data)
    return true;
  if (rhs.manufacturer_data < lhs.manufacturer_data)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothCompanyPtr WebBluetoothCompany::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, WebBluetoothCompany::EnableIfSame<T>*>
bool WebBluetoothCompany::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, WebBluetoothCompany::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothDataFilterPtr WebBluetoothDataFilter::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(mask)
  );
}

template <typename T, WebBluetoothDataFilter::EnableIfSame<T>*>
bool WebBluetoothDataFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->mask, other_struct.mask))
    return false;
  return true;
}

template <typename T, WebBluetoothDataFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.mask < rhs.mask)
    return true;
  if (rhs.mask < lhs.mask)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRequestDeviceOptionsPtr WebBluetoothRequestDeviceOptions::Clone() const {
  return New(
      mojo::Clone(filters),
      mojo::Clone(exclusion_filters),
      mojo::Clone(optional_services),
      mojo::Clone(optional_manufacturer_data),
      mojo::Clone(accept_all_devices)
  );
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>*>
bool WebBluetoothRequestDeviceOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->exclusion_filters, other_struct.exclusion_filters))
    return false;
  if (!mojo::Equals(this->optional_services, other_struct.optional_services))
    return false;
  if (!mojo::Equals(this->optional_manufacturer_data, other_struct.optional_manufacturer_data))
    return false;
  if (!mojo::Equals(this->accept_all_devices, other_struct.accept_all_devices))
    return false;
  return true;
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.exclusion_filters < rhs.exclusion_filters)
    return true;
  if (rhs.exclusion_filters < lhs.exclusion_filters)
    return false;
  if (lhs.optional_services < rhs.optional_services)
    return true;
  if (rhs.optional_services < lhs.optional_services)
    return false;
  if (lhs.optional_manufacturer_data < rhs.optional_manufacturer_data)
    return true;
  if (rhs.optional_manufacturer_data < lhs.optional_manufacturer_data)
    return false;
  if (lhs.accept_all_devices < rhs.accept_all_devices)
    return true;
  if (rhs.accept_all_devices < lhs.accept_all_devices)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRequestLEScanOptionsPtr WebBluetoothRequestLEScanOptions::Clone() const {
  return New(
      mojo::Clone(filters),
      mojo::Clone(keep_repeated_devices),
      mojo::Clone(accept_all_advertisements)
  );
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>*>
bool WebBluetoothRequestLEScanOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->keep_repeated_devices, other_struct.keep_repeated_devices))
    return false;
  if (!mojo::Equals(this->accept_all_advertisements, other_struct.accept_all_advertisements))
    return false;
  return true;
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.keep_repeated_devices < rhs.keep_repeated_devices)
    return true;
  if (rhs.keep_repeated_devices < lhs.keep_repeated_devices)
    return false;
  if (lhs.accept_all_advertisements < rhs.accept_all_advertisements)
    return true;
  if (rhs.accept_all_advertisements < lhs.accept_all_advertisements)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothDeviceIdPtr WebBluetoothDeviceId::Clone() const {
  return New(
      mojo::Clone(device_id)
  );
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>*>
bool WebBluetoothDeviceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  return true;
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothDevicePtr WebBluetoothDevice::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name)
  );
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>*>
bool WebBluetoothDevice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTServicePtr WebBluetoothRemoteGATTService::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid)
  );
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTService::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTCharacteristicPtr WebBluetoothRemoteGATTCharacteristic::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid),
      mojo::Clone(properties)
  );
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTCharacteristic::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothAdvertisingEventPtr WebBluetoothAdvertisingEvent::Clone() const {
  return New(
      mojo::Clone(device),
      mojo::Clone(name),
      mojo::Clone(uuids),
      mojo::Clone(appearance_is_set),
      mojo::Clone(appearance),
      mojo::Clone(tx_power_is_set),
      mojo::Clone(tx_power),
      mojo::Clone(rssi_is_set),
      mojo::Clone(rssi),
      mojo::Clone(manufacturer_data),
      mojo::Clone(service_data)
  );
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>*>
bool WebBluetoothAdvertisingEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device, other_struct.device))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->uuids, other_struct.uuids))
    return false;
  if (!mojo::Equals(this->appearance_is_set, other_struct.appearance_is_set))
    return false;
  if (!mojo::Equals(this->appearance, other_struct.appearance))
    return false;
  if (!mojo::Equals(this->tx_power_is_set, other_struct.tx_power_is_set))
    return false;
  if (!mojo::Equals(this->tx_power, other_struct.tx_power))
    return false;
  if (!mojo::Equals(this->rssi_is_set, other_struct.rssi_is_set))
    return false;
  if (!mojo::Equals(this->rssi, other_struct.rssi))
    return false;
  if (!mojo::Equals(this->manufacturer_data, other_struct.manufacturer_data))
    return false;
  if (!mojo::Equals(this->service_data, other_struct.service_data))
    return false;
  return true;
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device < rhs.device)
    return true;
  if (rhs.device < lhs.device)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.uuids < rhs.uuids)
    return true;
  if (rhs.uuids < lhs.uuids)
    return false;
  if (lhs.appearance_is_set < rhs.appearance_is_set)
    return true;
  if (rhs.appearance_is_set < lhs.appearance_is_set)
    return false;
  if (lhs.appearance < rhs.appearance)
    return true;
  if (rhs.appearance < lhs.appearance)
    return false;
  if (lhs.tx_power_is_set < rhs.tx_power_is_set)
    return true;
  if (rhs.tx_power_is_set < lhs.tx_power_is_set)
    return false;
  if (lhs.tx_power < rhs.tx_power)
    return true;
  if (rhs.tx_power < lhs.tx_power)
    return false;
  if (lhs.rssi_is_set < rhs.rssi_is_set)
    return true;
  if (rhs.rssi_is_set < lhs.rssi_is_set)
    return false;
  if (lhs.rssi < rhs.rssi)
    return true;
  if (rhs.rssi < lhs.rssi)
    return false;
  if (lhs.manufacturer_data < rhs.manufacturer_data)
    return true;
  if (rhs.manufacturer_data < lhs.manufacturer_data)
    return false;
  if (lhs.service_data < rhs.service_data)
    return true;
  if (rhs.service_data < lhs.service_data)
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTDescriptorPtr WebBluetoothRemoteGATTDescriptor::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid)
  );
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.uuid < rhs.uuid)
    return true;
  if (rhs.uuid < lhs.uuid)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothLeScanFilter::DataView,
                                         ::blink::mojom::WebBluetoothLeScanFilterPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothLeScanFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothLeScanFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothLeScanFilter::services)& services(
      const ::blink::mojom::WebBluetoothLeScanFilterPtr& input) {
    return input->services;
  }

  static const decltype(::blink::mojom::WebBluetoothLeScanFilter::name)& name(
      const ::blink::mojom::WebBluetoothLeScanFilterPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::WebBluetoothLeScanFilter::name_prefix)& name_prefix(
      const ::blink::mojom::WebBluetoothLeScanFilterPtr& input) {
    return input->name_prefix;
  }

  static const decltype(::blink::mojom::WebBluetoothLeScanFilter::manufacturer_data)& manufacturer_data(
      const ::blink::mojom::WebBluetoothLeScanFilterPtr& input) {
    return input->manufacturer_data;
  }

  static bool Read(::blink::mojom::WebBluetoothLeScanFilter::DataView input, ::blink::mojom::WebBluetoothLeScanFilterPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothCompany::DataView,
                                         ::blink::mojom::WebBluetoothCompanyPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothCompanyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothCompanyPtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebBluetoothCompany::id) id(
      const ::blink::mojom::WebBluetoothCompanyPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::WebBluetoothCompany::DataView input, ::blink::mojom::WebBluetoothCompanyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothDataFilter::DataView,
                                         ::blink::mojom::WebBluetoothDataFilterPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothDataFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothDataFilterPtr* output) { output->reset(); }

  static decltype(::blink::mojom::WebBluetoothDataFilter::data) data(
      const ::blink::mojom::WebBluetoothDataFilterPtr& input) {
    return input->data;
  }

  static decltype(::blink::mojom::WebBluetoothDataFilter::mask) mask(
      const ::blink::mojom::WebBluetoothDataFilterPtr& input) {
    return input->mask;
  }

  static bool Read(::blink::mojom::WebBluetoothDataFilter::DataView input, ::blink::mojom::WebBluetoothDataFilterPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothRequestDeviceOptions::DataView,
                                         ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothRequestDeviceOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothRequestDeviceOptions::filters)& filters(
      const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->filters;
  }

  static const decltype(::blink::mojom::WebBluetoothRequestDeviceOptions::exclusion_filters)& exclusion_filters(
      const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->exclusion_filters;
  }

  static const decltype(::blink::mojom::WebBluetoothRequestDeviceOptions::optional_services)& optional_services(
      const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->optional_services;
  }

  static const decltype(::blink::mojom::WebBluetoothRequestDeviceOptions::optional_manufacturer_data)& optional_manufacturer_data(
      const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->optional_manufacturer_data;
  }

  static decltype(::blink::mojom::WebBluetoothRequestDeviceOptions::accept_all_devices) accept_all_devices(
      const ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->accept_all_devices;
  }

  static bool Read(::blink::mojom::WebBluetoothRequestDeviceOptions::DataView input, ::blink::mojom::WebBluetoothRequestDeviceOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothRequestLEScanOptions::DataView,
                                         ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothRequestLEScanOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothRequestLEScanOptions::filters)& filters(
      const ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->filters;
  }

  static decltype(::blink::mojom::WebBluetoothRequestLEScanOptions::keep_repeated_devices) keep_repeated_devices(
      const ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->keep_repeated_devices;
  }

  static decltype(::blink::mojom::WebBluetoothRequestLEScanOptions::accept_all_advertisements) accept_all_advertisements(
      const ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->accept_all_advertisements;
  }

  static bool Read(::blink::mojom::WebBluetoothRequestLEScanOptions::DataView input, ::blink::mojom::WebBluetoothRequestLEScanOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothDeviceId::DataView,
                                         ::blink::mojom::WebBluetoothDeviceIdPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothDeviceIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothDeviceIdPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothDeviceId::device_id)& device_id(
      const ::blink::mojom::WebBluetoothDeviceIdPtr& input) {
    return input->device_id;
  }

  static bool Read(::blink::mojom::WebBluetoothDeviceId::DataView input, ::blink::mojom::WebBluetoothDeviceIdPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothDevice::DataView,
                                         ::blink::mojom::WebBluetoothDevicePtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothDevicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothDevicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothDevice::id)& id(
      const ::blink::mojom::WebBluetoothDevicePtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::WebBluetoothDevice::name)& name(
      const ::blink::mojom::WebBluetoothDevicePtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::WebBluetoothDevice::DataView input, ::blink::mojom::WebBluetoothDevicePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothRemoteGATTService::DataView,
                                         ::blink::mojom::WebBluetoothRemoteGATTServicePtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothRemoteGATTServicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothRemoteGATTServicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTService::instance_id)& instance_id(
      const ::blink::mojom::WebBluetoothRemoteGATTServicePtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTService::uuid)& uuid(
      const ::blink::mojom::WebBluetoothRemoteGATTServicePtr& input) {
    return input->uuid;
  }

  static bool Read(::blink::mojom::WebBluetoothRemoteGATTService::DataView input, ::blink::mojom::WebBluetoothRemoteGATTServicePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristic::DataView,
                                         ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTCharacteristic::instance_id)& instance_id(
      const ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTCharacteristic::uuid)& uuid(
      const ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->uuid;
  }

  static decltype(::blink::mojom::WebBluetoothRemoteGATTCharacteristic::properties) properties(
      const ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->properties;
  }

  static bool Read(::blink::mojom::WebBluetoothRemoteGATTCharacteristic::DataView input, ::blink::mojom::WebBluetoothRemoteGATTCharacteristicPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothAdvertisingEvent::DataView,
                                         ::blink::mojom::WebBluetoothAdvertisingEventPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothAdvertisingEventPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothAdvertisingEvent::device)& device(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->device;
  }

  static const decltype(::blink::mojom::WebBluetoothAdvertisingEvent::name)& name(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::WebBluetoothAdvertisingEvent::uuids)& uuids(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->uuids;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::appearance_is_set) appearance_is_set(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->appearance_is_set;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::appearance) appearance(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->appearance;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::tx_power_is_set) tx_power_is_set(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->tx_power_is_set;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::tx_power) tx_power(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->tx_power;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::rssi_is_set) rssi_is_set(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->rssi_is_set;
  }

  static decltype(::blink::mojom::WebBluetoothAdvertisingEvent::rssi) rssi(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->rssi;
  }

  static const decltype(::blink::mojom::WebBluetoothAdvertisingEvent::manufacturer_data)& manufacturer_data(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->manufacturer_data;
  }

  static const decltype(::blink::mojom::WebBluetoothAdvertisingEvent::service_data)& service_data(
      const ::blink::mojom::WebBluetoothAdvertisingEventPtr& input) {
    return input->service_data;
  }

  static bool Read(::blink::mojom::WebBluetoothAdvertisingEvent::DataView input, ::blink::mojom::WebBluetoothAdvertisingEventPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptor::DataView,
                                         ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTDescriptor::instance_id)& instance_id(
      const ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::WebBluetoothRemoteGATTDescriptor::uuid)& uuid(
      const ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr& input) {
    return input->uuid;
  }

  static bool Read(::blink::mojom::WebBluetoothRemoteGATTDescriptor::DataView input, ::blink::mojom::WebBluetoothRemoteGATTDescriptorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_H_