// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::WebBluetoothResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothResult> {};

template <>
struct hash<::blink::mojom::WebBluetoothGATTQueryQuantity>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothGATTQueryQuantity> {};

template <>
struct hash<::blink::mojom::WebBluetoothWriteType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothWriteType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothGATTQueryQuantity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothGATTQueryQuantity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothGATTQueryQuantity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothWriteType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothWriteType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothWriteType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothLeScanFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothLeScanFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothLeScanFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::services(input)) in_services = Traits::services(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->services)::BaseType>
        services_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
      in_services,
      services_fragment,
      &services_validate_params);

    fragment->services.Set(
        services_fragment.is_null() ? nullptr : services_fragment.data());

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::name_prefix(input)) in_name_prefix = Traits::name_prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_prefix)::BaseType> name_prefix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name_prefix,
      name_prefix_fragment);

    fragment->name_prefix.Set(
        name_prefix_fragment.is_null() ? nullptr : name_prefix_fragment.data());

    decltype(Traits::manufacturer_data(input)) in_manufacturer_data = Traits::manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_data)::BaseType>
        manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>>(
      in_manufacturer_data,
      manufacturer_data_fragment,
      &manufacturer_data_validate_params);

    fragment->manufacturer_data.Set(
        manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothLeScanFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothLeScanFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothCompanyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothCompanyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothCompany_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothCompany_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothCompanyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDataFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDataFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDataFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->data = Traits::data(input);

    fragment->mask = Traits::mask(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDataFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDataFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
      in_filters,
      filters_fragment,
      &filters_validate_params);

    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());

    decltype(Traits::exclusion_filters(input)) in_exclusion_filters = Traits::exclusion_filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclusion_filters)::BaseType>
        exclusion_filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclusion_filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
      in_exclusion_filters,
      exclusion_filters_fragment,
      &exclusion_filters_validate_params);

    fragment->exclusion_filters.Set(
        exclusion_filters_fragment.is_null() ? nullptr : exclusion_filters_fragment.data());

    decltype(Traits::optional_services(input)) in_optional_services = Traits::optional_services(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_services)::BaseType>
        optional_services_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_services_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
      in_optional_services,
      optional_services_fragment,
      &optional_services_validate_params);

    fragment->optional_services.Set(
        optional_services_fragment.is_null() ? nullptr : optional_services_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->optional_services.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null optional_services in WebBluetoothRequestDeviceOptions struct");

    decltype(Traits::optional_manufacturer_data(input)) in_optional_manufacturer_data = Traits::optional_manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_manufacturer_data)::BaseType>
        optional_manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_manufacturer_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_optional_manufacturer_data,
      optional_manufacturer_data_fragment,
      &optional_manufacturer_data_validate_params);

    fragment->optional_manufacturer_data.Set(
        optional_manufacturer_data_fragment.is_null() ? nullptr : optional_manufacturer_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->optional_manufacturer_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null optional_manufacturer_data in WebBluetoothRequestDeviceOptions struct");

    fragment->accept_all_devices = Traits::accept_all_devices(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRequestDeviceOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
      in_filters,
      filters_fragment,
      &filters_validate_params);

    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());

    fragment->keep_repeated_devices = Traits::keep_repeated_devices(input);

    fragment->accept_all_advertisements = Traits::accept_all_advertisements(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRequestLEScanOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDeviceIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDeviceIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDeviceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType>
        device_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_device_id,
      device_id_fragment,
      &device_id_validate_params);

    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in WebBluetoothDeviceId struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDeviceId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDeviceIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDeviceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDeviceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in WebBluetoothDevice struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDevice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDeviceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTServiceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTServiceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTService_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_instance_id,
      instance_id_fragment);

    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_id in WebBluetoothRemoteGATTService struct");

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in WebBluetoothRemoteGATTService struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTService_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTServiceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_instance_id,
      instance_id_fragment);

    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_id in WebBluetoothRemoteGATTCharacteristic struct");

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in WebBluetoothRemoteGATTCharacteristic struct");

    fragment->properties = Traits::properties(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothAdvertisingEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothAdvertisingEventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device(input)) in_device = Traits::device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device)::BaseType> device_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceDataView>(
      in_device,
      device_fragment);

    fragment->device.Set(
        device_fragment.is_null() ? nullptr : device_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device in WebBluetoothAdvertisingEvent struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::uuids(input)) in_uuids = Traits::uuids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuids)::BaseType>
        uuids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
      in_uuids,
      uuids_fragment,
      &uuids_validate_params);

    fragment->uuids.Set(
        uuids_fragment.is_null() ? nullptr : uuids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuids in WebBluetoothAdvertisingEvent struct");

    fragment->appearance_is_set = Traits::appearance_is_set(input);

    fragment->appearance = Traits::appearance(input);

    fragment->tx_power_is_set = Traits::tx_power_is_set(input);

    fragment->tx_power = Traits::tx_power(input);

    fragment->rssi_is_set = Traits::rssi_is_set(input);

    fragment->rssi = Traits::rssi(input);

    decltype(Traits::manufacturer_data(input)) in_manufacturer_data = Traits::manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_data)::BaseType>
        manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>>(
      in_manufacturer_data,
      manufacturer_data_fragment,
      &manufacturer_data_validate_params);

    fragment->manufacturer_data.Set(
        manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->manufacturer_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null manufacturer_data in WebBluetoothAdvertisingEvent struct");

    decltype(Traits::service_data(input)) in_service_data = Traits::service_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_data)::BaseType>
        service_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>>(
      in_service_data,
      service_data_fragment,
      &service_data_validate_params);

    fragment->service_data.Set(
        service_data_fragment.is_null() ? nullptr : service_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->service_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_data in WebBluetoothAdvertisingEvent struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothAdvertisingEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_instance_id,
      instance_id_fragment);

    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_id in WebBluetoothRemoteGATTDescriptor struct");

    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
      in_uuid,
      uuid_fragment);

    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uuid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uuid in WebBluetoothRemoteGATTDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebBluetoothLeScanFilterDataView::GetServicesDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->services.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetNamePrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name_prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetManufacturerDataDataView(
    mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>* output) {
  auto pointer = data_->manufacturer_data.Get();
  *output = mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>(pointer, message_);
}






inline void WebBluetoothRequestDeviceOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetExclusionFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->exclusion_filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetOptionalServicesDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->optional_services.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetOptionalManufacturerDataDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->optional_manufacturer_data.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}


inline void WebBluetoothRequestLEScanOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}


inline void WebBluetoothDeviceIdDataView::GetDeviceIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void WebBluetoothDeviceDataView::GetIdDataView(
    WebBluetoothDeviceIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = WebBluetoothDeviceIdDataView(pointer, message_);
}
inline void WebBluetoothDeviceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebBluetoothRemoteGATTServiceDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTServiceDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void WebBluetoothRemoteGATTCharacteristicDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTCharacteristicDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void WebBluetoothAdvertisingEventDataView::GetDeviceDataView(
    WebBluetoothDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = WebBluetoothDeviceDataView(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetUuidsDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->uuids.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetManufacturerDataDataView(
    mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->manufacturer_data.Get();
  *output = mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetServiceDataDataView(
    mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->service_data.Get();
  *output = mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void WebBluetoothRemoteGATTDescriptorDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTDescriptorDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothGATTQueryQuantity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothGATTQueryQuantity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothWriteType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothWriteType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_