// third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from './blob.mojom.m.js';

import {
  DataElementFile as blink_mojom_DataElementFile,
  DataElementFileSpec as blink_mojom_DataElementFileSpec
} from './data_element.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileBackedBlobFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileBackedBlobFactory', scope);
  }
}

/** @interface */
export class FileBackedBlobFactoryInterface {
  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink_mojom_DataElementFile } file
   */

  registerBlob(blob, uuid, contentType, file) {}
  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink_mojom_DataElementFile } file
   * @return {!Promise}
   */

  registerBlobSync(blob, uuid, contentType, file) {}
}

/**
 * @implements { FileBackedBlobFactoryInterface }
 */
export class FileBackedBlobFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileBackedBlobFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileBackedBlobFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileBackedBlobFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink_mojom_DataElementFile } file
   */

  registerBlob(
      blob,
      uuid,
      contentType,
      file) {
    this.proxy.sendMessage(
        0,
        FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        [
          blob,
          uuid,
          contentType,
          file
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !blink_mojom_DataElementFile } file
   * @return {!Promise}
   */

  registerBlobSync(
      blob,
      uuid,
      contentType,
      file) {
    return this.proxy.sendMessage(
        1,
        FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        [
          blob,
          uuid,
          contentType,
          file
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileBackedBlobFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileBackedBlobFactoryReceiver {
  /**
   * @param {!FileBackedBlobFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileBackedBlobFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileBackedBlobFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileBackedBlobFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        impl.registerBlob.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        impl.registerBlobSync.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileBackedBlobFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileBackedBlobFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileBackedBlobFactoryRemote}
   */
  static getRemote() {
    let remote = new FileBackedBlobFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileBackedBlobFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileBackedBlobFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileBackedBlobFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileBackedBlobFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerBlob =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
        null,
        this.registerBlob.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerBlobSync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
        FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
        this.registerBlobSync.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileBackedBlobFactory_RegisterBlob_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileBackedBlobFactory_RegisterBlobSync_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileBackedBlobFactory_RegisterBlob_ParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlob_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_BlobPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uuid', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        blink_mojom_DataElementFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileBackedBlobFactory_RegisterBlob_Params {
  constructor() {
    /** @type { !blink_mojom_BlobPendingReceiver } */
    this.blob;
    /** @type { !string } */
    this.uuid;
    /** @type { !string } */
    this.contentType;
    /** @type { !blink_mojom_DataElementFile } */
    this.file;
  }
}



mojo.internal.Struct(
    FileBackedBlobFactory_RegisterBlobSync_ParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlobSync_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_BlobPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uuid', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'file', 24,
        0,
        blink_mojom_DataElementFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileBackedBlobFactory_RegisterBlobSync_Params {
  constructor() {
    /** @type { !blink_mojom_BlobPendingReceiver } */
    this.blob;
    /** @type { !string } */
    this.uuid;
    /** @type { !string } */
    this.contentType;
    /** @type { !blink_mojom_DataElementFile } */
    this.file;
  }
}



mojo.internal.Struct(
    FileBackedBlobFactory_RegisterBlobSync_ResponseParamsSpec.$,
    'FileBackedBlobFactory_RegisterBlobSync_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileBackedBlobFactory_RegisterBlobSync_ResponseParams {
  constructor() {
  }
}

