// third_party/blink/public/mojom/blob/data_element.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"


namespace blink::mojom {
class DataElementBytesDataView;

class DataElementFileDataView;

class DataElementBlobDataView;

class DataElementDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DataElementBytesDataView> {
  using Data = ::blink::mojom::internal::DataElementBytes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DataElementFileDataView> {
  using Data = ::blink::mojom::internal::DataElementFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DataElementBlobDataView> {
  using Data = ::blink::mojom::internal::DataElementBlob_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DataElementDataView> {
  using Data = ::blink::mojom::internal::DataElement_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class BytesProviderInterfaceBase {};

using BytesProviderPtrDataView =
    mojo::InterfacePtrDataView<BytesProviderInterfaceBase>;
using BytesProviderRequestDataView =
    mojo::InterfaceRequestDataView<BytesProviderInterfaceBase>;
using BytesProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BytesProviderInterfaceBase>;
using BytesProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BytesProviderInterfaceBase>;


class DataElementBytesDataView {
 public:
  DataElementBytesDataView() = default;

  DataElementBytesDataView(
      internal::DataElementBytes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetEmbeddedDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddedData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `embedded_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEmbeddedData` instead "
    "of `ReadEmbeddedData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->embedded_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeData() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BytesProviderInterfaceBase>>(
            &data_->data, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DataElementBytes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementFileDataView {
 public:
  DataElementFileDataView() = default;

  DataElementFileDataView(
      internal::DataElementFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetExpectedModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedModificationTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `expected_modification_time` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpectedModificationTime` instead "
    "of `ReadExpectedModificationTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expected_modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataElementFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementBlobDataView {
 public:
  DataElementBlobDataView() = default;

  DataElementBlobDataView(
      internal::DataElementBlob_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
 private:
  internal::DataElementBlob_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementDataView {
 public:
  using Tag = internal::DataElement_Data::DataElement_Tag;

  DataElementDataView() = default;

  DataElementDataView(
      internal::DataElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      DataElementBytesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<::blink::mojom::DataElementBytesDataView>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      DataElementFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::DataElementFileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_blob() const { return data_->tag == Tag::kBlob; }
  inline void GetBlobDataView(
      DataElementBlobDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBlob(UserType* output) const {
    
    CHECK(is_blob());
    return mojo::internal::Deserialize<::blink::mojom::DataElementBlobDataView>(
        data_->data.f_blob.Get(), output, message_);
  }

 private:
  internal::DataElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_DATA_VIEW_H_