// third_party/blink/public/mojom/blob/blob_url_store.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  URLLoaderFactoryRemote as network_mojom_URLLoaderFactoryRemote,
  URLLoaderFactoryPendingReceiver as network_mojom_URLLoaderFactoryPendingReceiver
} from '../../../../../services/network/public/mojom/url_loader_factory.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from './blob.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BlobURLStorePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BlobURLStore', scope);
  }
}

/** @interface */
export class BlobURLStoreInterface {
  
  /**
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !url_mojom_Url } url
   * @return {!Promise}
   */

  register(blob, url) {}
  
  /**
   * @param { !url_mojom_Url } url
   */

  revoke(url) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } factory
   */

  resolveAsURLLoaderFactory(url, factory) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !BlobURLTokenPendingReceiver } token
   * @param { !boolean } isTopLevelNavigation
   */

  resolveAsBlobURLToken(url, token, isTopLevelNavigation) {}
}

/**
 * @implements { BlobURLStoreInterface }
 */
export class BlobURLStoreRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BlobURLStorePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BlobURLStorePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BlobURLStorePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_BlobRemote } blob
   * @param { !url_mojom_Url } url
   * @return {!Promise}
   */

  register(
      blob,
      url) {
    return this.proxy.sendMessage(
        0,
        BlobURLStore_Register_ParamsSpec.$,
        BlobURLStore_Register_ResponseParamsSpec.$,
        [
          blob,
          url
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   */

  revoke(
      url) {
    this.proxy.sendMessage(
        1,
        BlobURLStore_Revoke_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } factory
   */

  resolveAsURLLoaderFactory(
      url,
      factory) {
    this.proxy.sendMessage(
        2,
        BlobURLStore_ResolveAsURLLoaderFactory_ParamsSpec.$,
        null,
        [
          url,
          factory
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !BlobURLTokenPendingReceiver } token
   * @param { !boolean } isTopLevelNavigation
   */

  resolveAsBlobURLToken(
      url,
      token,
      isTopLevelNavigation) {
    this.proxy.sendMessage(
        3,
        BlobURLStore_ResolveAsBlobURLToken_ParamsSpec.$,
        null,
        [
          url,
          token,
          isTopLevelNavigation
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BlobURLStore
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BlobURLStoreReceiver {
  /**
   * @param {!BlobURLStoreInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BlobURLStoreRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BlobURLStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobURLStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BlobURLStore_Register_ParamsSpec.$,
        BlobURLStore_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BlobURLStore_Revoke_ParamsSpec.$,
        null,
        impl.revoke.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BlobURLStore_ResolveAsURLLoaderFactory_ParamsSpec.$,
        null,
        impl.resolveAsURLLoaderFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        BlobURLStore_ResolveAsBlobURLToken_ParamsSpec.$,
        null,
        impl.resolveAsBlobURLToken.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BlobURLStore {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BlobURLStore";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BlobURLStoreRemote}
   */
  static getRemote() {
    let remote = new BlobURLStoreRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BlobURLStore
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BlobURLStoreCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BlobURLStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobURLStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BlobURLStore_Register_ParamsSpec.$,
        BlobURLStore_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.revoke =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BlobURLStore_Revoke_ParamsSpec.$,
        null,
        this.revoke.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveAsURLLoaderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BlobURLStore_ResolveAsURLLoaderFactory_ParamsSpec.$,
        null,
        this.resolveAsURLLoaderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveAsBlobURLToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        BlobURLStore_ResolveAsBlobURLToken_ParamsSpec.$,
        null,
        this.resolveAsBlobURLToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BlobURLTokenPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BlobURLToken', scope);
  }
}

/** @interface */
export class BlobURLTokenInterface {
  
  /**
   * @param { !BlobURLTokenPendingReceiver } token
   */

  clone(token) {}
  
  /**
   * @return {!Promise<{
        token: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  getToken() {}
}

/**
 * @implements { BlobURLTokenInterface }
 */
export class BlobURLTokenRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BlobURLTokenPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BlobURLTokenPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BlobURLTokenPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !BlobURLTokenPendingReceiver } token
   */

  clone(
      token) {
    this.proxy.sendMessage(
        0,
        BlobURLToken_Clone_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        token: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  getToken() {
    return this.proxy.sendMessage(
        1,
        BlobURLToken_GetToken_ParamsSpec.$,
        BlobURLToken_GetToken_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BlobURLToken
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BlobURLTokenReceiver {
  /**
   * @param {!BlobURLTokenInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BlobURLTokenRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BlobURLTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobURLTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BlobURLToken_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BlobURLToken_GetToken_ParamsSpec.$,
        BlobURLToken_GetToken_ResponseParamsSpec.$,
        impl.getToken.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BlobURLToken {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BlobURLToken";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BlobURLTokenRemote}
   */
  static getRemote() {
    let remote = new BlobURLTokenRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BlobURLToken
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BlobURLTokenCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BlobURLTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobURLTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BlobURLToken_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BlobURLToken_GetToken_ParamsSpec.$,
        BlobURLToken_GetToken_ResponseParamsSpec.$,
        this.getToken.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLStore_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLStore_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLStore_Revoke_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLStore_ResolveAsURLLoaderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLStore_ResolveAsBlobURLToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLToken_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLToken_GetToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobURLToken_GetToken_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BlobURLStore_Register_ParamsSpec.$,
    'BlobURLStore_Register_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_BlobRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlobURLStore_Register_Params {
  constructor() {
    /** @type { !blink_mojom_BlobRemote } */
    this.blob;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    BlobURLStore_Register_ResponseParamsSpec.$,
    'BlobURLStore_Register_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BlobURLStore_Register_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    BlobURLStore_Revoke_ParamsSpec.$,
    'BlobURLStore_Revoke_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BlobURLStore_Revoke_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    BlobURLStore_ResolveAsURLLoaderFactory_ParamsSpec.$,
    'BlobURLStore_ResolveAsURLLoaderFactory_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'factory', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlobURLStore_ResolveAsURLLoaderFactory_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_URLLoaderFactoryPendingReceiver } */
    this.factory;
  }
}



mojo.internal.Struct(
    BlobURLStore_ResolveAsBlobURLToken_ParamsSpec.$,
    'BlobURLStore_ResolveAsBlobURLToken_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojo.internal.InterfaceRequest(BlobURLTokenPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isTopLevelNavigation', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlobURLStore_ResolveAsBlobURLToken_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !BlobURLTokenPendingReceiver } */
    this.token;
    /** @type { !boolean } */
    this.isTopLevelNavigation;
  }
}



mojo.internal.Struct(
    BlobURLToken_Clone_ParamsSpec.$,
    'BlobURLToken_Clone_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceRequest(BlobURLTokenPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BlobURLToken_Clone_Params {
  constructor() {
    /** @type { !BlobURLTokenPendingReceiver } */
    this.token;
  }
}



mojo.internal.Struct(
    BlobURLToken_GetToken_ParamsSpec.$,
    'BlobURLToken_GetToken_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BlobURLToken_GetToken_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    BlobURLToken_GetToken_ResponseParamsSpec.$,
    'BlobURLToken_GetToken_ResponseParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BlobURLToken_GetToken_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
  }
}

