// third_party/blink/public/mojom/blob/blob.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/blob/blob.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT BlobReaderClientInterceptorForTesting : public BlobReaderClient {
  virtual BlobReaderClient* GetForwardingInterface() = 0;
  void OnCalculatedSize(uint64_t total_size, uint64_t expected_content_size) override;
  void OnComplete(int32_t status, uint64_t data_length) override;
};
class PLATFORM_EXPORT BlobReaderClientAsyncWaiter {
 public:
  explicit BlobReaderClientAsyncWaiter(BlobReaderClient* proxy);

  BlobReaderClientAsyncWaiter(const BlobReaderClientAsyncWaiter&) = delete;
  BlobReaderClientAsyncWaiter& operator=(const BlobReaderClientAsyncWaiter&) = delete;

  ~BlobReaderClientAsyncWaiter();

 private:
  BlobReaderClient* const proxy_;
};


class PLATFORM_EXPORT BlobInterceptorForTesting : public Blob {
  virtual Blob* GetForwardingInterface() = 0;
  void Clone(::mojo::PendingReceiver<Blob> blob) override;
  void AsDataPipeGetter(::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter> data_pipe_getter) override;
  void ReadAll(::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) override;
  void ReadRange(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) override;
  void Load(::mojo::PendingReceiver<::network::mojom::blink::URLLoader> loader, const ::blink::String& request_method, const ::net::HttpRequestHeaders& headers, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> client) override;
  void ReadSideData(ReadSideDataCallback callback) override;
  void CaptureSnapshot(CaptureSnapshotCallback callback) override;
  void GetInternalUUID(GetInternalUUIDCallback callback) override;
};
class PLATFORM_EXPORT BlobAsyncWaiter {
 public:
  explicit BlobAsyncWaiter(Blob* proxy);

  BlobAsyncWaiter(const BlobAsyncWaiter&) = delete;
  BlobAsyncWaiter& operator=(const BlobAsyncWaiter&) = delete;

  ~BlobAsyncWaiter();
  void ReadSideData(
      std::optional<::mojo_base::BigBuffer>* out_data);
  std::optional<::mojo_base::BigBuffer> ReadSideData();
  void CaptureSnapshot(
      uint64_t* out_length, std::optional<::base::Time>* out_modification_time);
  
  void GetInternalUUID(
      ::blink::String* out_uuid);
  ::blink::String GetInternalUUID();

 private:
  Blob* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_TEST_UTILS_H_