// third_party/blink/public/mojom/background_sync/background_sync.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundSyncErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundSyncError = {
  
  NONE: 0,
  STORAGE: 1,
  NOT_FOUND: 2,
  NO_SERVICE_WORKER: 3,
  NOT_ALLOWED: 4,
  PERMISSION_DENIED: 5,
  MAX: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundSyncStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundSyncState = {
  
  PENDING: 0,
  FIRING: 1,
  REREGISTERED_WHILE_FIRING: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundSyncEventLastChanceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundSyncEventLastChance = {
  
  IS_NOT_LAST_CHANCE: 0,
  IS_LAST_CHANCE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BackgroundSyncTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BackgroundSyncType = {
  
  ONE_SHOT: 0,
  PERIODIC: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OneShotBackgroundSyncServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.OneShotBackgroundSyncService', scope);
  }
}

/** @interface */
export class OneShotBackgroundSyncServiceInterface {
  
  /**
   * @param { !SyncRegistrationOptions } options
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        options: ?SyncRegistrationOptions,
   *  }>}
   */

  register(options, serviceWorkerRegistrationId) {}
  
  /**
   * @param { !BackgroundSyncRegistrationInfo } registrationInfo
   */

  didResolveRegistration(registrationInfo) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        registrations: !Array<!SyncRegistrationOptions>,
   *  }>}
   */

  getRegistrations(serviceWorkerRegistrationId) {}
}

/**
 * @implements { OneShotBackgroundSyncServiceInterface }
 */
export class OneShotBackgroundSyncServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OneShotBackgroundSyncServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OneShotBackgroundSyncServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OneShotBackgroundSyncServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SyncRegistrationOptions } options
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        options: ?SyncRegistrationOptions,
   *  }>}
   */

  register(
      options,
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        0,
        OneShotBackgroundSyncService_Register_ParamsSpec.$,
        OneShotBackgroundSyncService_Register_ResponseParamsSpec.$,
        [
          options,
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @param { !BackgroundSyncRegistrationInfo } registrationInfo
   */

  didResolveRegistration(
      registrationInfo) {
    this.proxy.sendMessage(
        1,
        OneShotBackgroundSyncService_DidResolveRegistration_ParamsSpec.$,
        null,
        [
          registrationInfo
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        registrations: !Array<!SyncRegistrationOptions>,
   *  }>}
   */

  getRegistrations(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        OneShotBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        OneShotBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OneShotBackgroundSyncService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OneShotBackgroundSyncServiceReceiver {
  /**
   * @param {!OneShotBackgroundSyncServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OneShotBackgroundSyncServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OneShotBackgroundSyncServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OneShotBackgroundSyncServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OneShotBackgroundSyncService_Register_ParamsSpec.$,
        OneShotBackgroundSyncService_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OneShotBackgroundSyncService_DidResolveRegistration_ParamsSpec.$,
        null,
        impl.didResolveRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OneShotBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        OneShotBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        impl.getRegistrations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OneShotBackgroundSyncService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.OneShotBackgroundSyncService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OneShotBackgroundSyncServiceRemote}
   */
  static getRemote() {
    let remote = new OneShotBackgroundSyncServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OneShotBackgroundSyncService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OneShotBackgroundSyncServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OneShotBackgroundSyncServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OneShotBackgroundSyncServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OneShotBackgroundSyncService_Register_ParamsSpec.$,
        OneShotBackgroundSyncService_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didResolveRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OneShotBackgroundSyncService_DidResolveRegistration_ParamsSpec.$,
        null,
        this.didResolveRegistration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OneShotBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        OneShotBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        this.getRegistrations.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PeriodicBackgroundSyncServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PeriodicBackgroundSyncService', scope);
  }
}

/** @interface */
export class PeriodicBackgroundSyncServiceInterface {
  
  /**
   * @param { !SyncRegistrationOptions } options
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        options: ?SyncRegistrationOptions,
   *  }>}
   */

  register(options, serviceWorkerRegistrationId) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } tag
   * @return {!Promise<{
        err: !BackgroundSyncError,
   *  }>}
   */

  unregister(serviceWorkerRegistrationId, tag) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        registrations: !Array<!SyncRegistrationOptions>,
   *  }>}
   */

  getRegistrations(serviceWorkerRegistrationId) {}
}

/**
 * @implements { PeriodicBackgroundSyncServiceInterface }
 */
export class PeriodicBackgroundSyncServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PeriodicBackgroundSyncServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PeriodicBackgroundSyncServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PeriodicBackgroundSyncServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SyncRegistrationOptions } options
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        options: ?SyncRegistrationOptions,
   *  }>}
   */

  register(
      options,
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        0,
        PeriodicBackgroundSyncService_Register_ParamsSpec.$,
        PeriodicBackgroundSyncService_Register_ResponseParamsSpec.$,
        [
          options,
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } tag
   * @return {!Promise<{
        err: !BackgroundSyncError,
   *  }>}
   */

  unregister(
      serviceWorkerRegistrationId,
      tag) {
    return this.proxy.sendMessage(
        1,
        PeriodicBackgroundSyncService_Unregister_ParamsSpec.$,
        PeriodicBackgroundSyncService_Unregister_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          tag
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        err: !BackgroundSyncError,
        registrations: !Array<!SyncRegistrationOptions>,
   *  }>}
   */

  getRegistrations(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        PeriodicBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PeriodicBackgroundSyncService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PeriodicBackgroundSyncServiceReceiver {
  /**
   * @param {!PeriodicBackgroundSyncServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PeriodicBackgroundSyncServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PeriodicBackgroundSyncServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeriodicBackgroundSyncServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PeriodicBackgroundSyncService_Register_ParamsSpec.$,
        PeriodicBackgroundSyncService_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PeriodicBackgroundSyncService_Unregister_ParamsSpec.$,
        PeriodicBackgroundSyncService_Unregister_ResponseParamsSpec.$,
        impl.unregister.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PeriodicBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        impl.getRegistrations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PeriodicBackgroundSyncService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PeriodicBackgroundSyncService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PeriodicBackgroundSyncServiceRemote}
   */
  static getRemote() {
    let remote = new PeriodicBackgroundSyncServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PeriodicBackgroundSyncService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PeriodicBackgroundSyncServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PeriodicBackgroundSyncServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PeriodicBackgroundSyncServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PeriodicBackgroundSyncService_Register_ParamsSpec.$,
        PeriodicBackgroundSyncService_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unregister =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PeriodicBackgroundSyncService_Unregister_ParamsSpec.$,
        PeriodicBackgroundSyncService_Unregister_ResponseParamsSpec.$,
        this.unregister.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PeriodicBackgroundSyncService_GetRegistrations_ParamsSpec.$,
        PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
        this.getRegistrations.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SyncRegistrationOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BackgroundSyncRegistrationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OneShotBackgroundSyncService_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OneShotBackgroundSyncService_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OneShotBackgroundSyncService_DidResolveRegistration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OneShotBackgroundSyncService_GetRegistrations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OneShotBackgroundSyncService_GetRegistrations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_Unregister_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_Unregister_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_GetRegistrations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SyncRegistrationOptionsSpec.$,
    'SyncRegistrationOptions',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        "",
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minInterval', 8,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SyncRegistrationOptions {
  constructor() {
    /** @type { !string } */
    this.tag;
    /** @type { !bigint } */
    this.minInterval;
  }
}



mojo.internal.Struct(
    BackgroundSyncRegistrationInfoSpec.$,
    'BackgroundSyncRegistrationInfo',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tag', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'syncType', 16,
        0,
        BackgroundSyncTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BackgroundSyncRegistrationInfo {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.tag;
    /** @type { !BackgroundSyncType } */
    this.syncType;
  }
}



mojo.internal.Struct(
    OneShotBackgroundSyncService_Register_ParamsSpec.$,
    'OneShotBackgroundSyncService_Register_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        SyncRegistrationOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OneShotBackgroundSyncService_Register_Params {
  constructor() {
    /** @type { !SyncRegistrationOptions } */
    this.options;
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    OneShotBackgroundSyncService_Register_ResponseParamsSpec.$,
    'OneShotBackgroundSyncService_Register_ResponseParams',
    [
      mojo.internal.StructField(
        'err', 0,
        0,
        BackgroundSyncErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        SyncRegistrationOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OneShotBackgroundSyncService_Register_ResponseParams {
  constructor() {
    /** @type { !BackgroundSyncError } */
    this.err;
    /** @type { (SyncRegistrationOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    OneShotBackgroundSyncService_DidResolveRegistration_ParamsSpec.$,
    'OneShotBackgroundSyncService_DidResolveRegistration_Params',
    [
      mojo.internal.StructField(
        'registrationInfo', 0,
        0,
        BackgroundSyncRegistrationInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OneShotBackgroundSyncService_DidResolveRegistration_Params {
  constructor() {
    /** @type { !BackgroundSyncRegistrationInfo } */
    this.registrationInfo;
  }
}



mojo.internal.Struct(
    OneShotBackgroundSyncService_GetRegistrations_ParamsSpec.$,
    'OneShotBackgroundSyncService_GetRegistrations_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OneShotBackgroundSyncService_GetRegistrations_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    OneShotBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
    'OneShotBackgroundSyncService_GetRegistrations_ResponseParams',
    [
      mojo.internal.StructField(
        'err', 0,
        0,
        BackgroundSyncErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registrations', 8,
        0,
        mojo.internal.Array(SyncRegistrationOptionsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OneShotBackgroundSyncService_GetRegistrations_ResponseParams {
  constructor() {
    /** @type { !BackgroundSyncError } */
    this.err;
    /** @type { !Array<!SyncRegistrationOptions> } */
    this.registrations;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_Register_ParamsSpec.$,
    'PeriodicBackgroundSyncService_Register_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        SyncRegistrationOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_Register_Params {
  constructor() {
    /** @type { !SyncRegistrationOptions } */
    this.options;
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_Register_ResponseParamsSpec.$,
    'PeriodicBackgroundSyncService_Register_ResponseParams',
    [
      mojo.internal.StructField(
        'err', 0,
        0,
        BackgroundSyncErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        SyncRegistrationOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_Register_ResponseParams {
  constructor() {
    /** @type { !BackgroundSyncError } */
    this.err;
    /** @type { (SyncRegistrationOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_Unregister_ParamsSpec.$,
    'PeriodicBackgroundSyncService_Unregister_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tag', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_Unregister_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.tag;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_Unregister_ResponseParamsSpec.$,
    'PeriodicBackgroundSyncService_Unregister_ResponseParams',
    [
      mojo.internal.StructField(
        'err', 0,
        0,
        BackgroundSyncErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_Unregister_ResponseParams {
  constructor() {
    /** @type { !BackgroundSyncError } */
    this.err;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_GetRegistrations_ParamsSpec.$,
    'PeriodicBackgroundSyncService_GetRegistrations_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_GetRegistrations_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    PeriodicBackgroundSyncService_GetRegistrations_ResponseParamsSpec.$,
    'PeriodicBackgroundSyncService_GetRegistrations_ResponseParams',
    [
      mojo.internal.StructField(
        'err', 0,
        0,
        BackgroundSyncErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registrations', 8,
        0,
        mojo.internal.Array(SyncRegistrationOptionsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PeriodicBackgroundSyncService_GetRegistrations_ResponseParams {
  constructor() {
    /** @type { !BackgroundSyncError } */
    this.err;
    /** @type { !Array<!SyncRegistrationOptions> } */
    this.registrations;
  }
}

