// third_party/blink/public/mojom/background_sync/background_sync.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/background_sync/background_sync.mojom-shared-internal.h"


namespace blink::mojom {
class SyncRegistrationOptionsDataView;

class BackgroundSyncRegistrationInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SyncRegistrationOptionsDataView> {
  using Data = ::blink::mojom::internal::SyncRegistrationOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundSyncRegistrationInfoDataView> {
  using Data = ::blink::mojom::internal::BackgroundSyncRegistrationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class BackgroundSyncError : int32_t {
  
  NONE = 0,
  
  STORAGE = 1,
  
  NOT_FOUND = 2,
  
  NO_SERVICE_WORKER = 3,
  
  NOT_ALLOWED = 4,
  
  PERMISSION_DENIED = 5,
  
  MAX = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundSyncError value);
inline bool IsKnownEnumValue(BackgroundSyncError value) {
  return internal::BackgroundSyncError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundSyncState : int32_t {
  
  PENDING = 0,
  
  FIRING = 1,
  
  REREGISTERED_WHILE_FIRING = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundSyncState value);
inline bool IsKnownEnumValue(BackgroundSyncState value) {
  return internal::BackgroundSyncState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundSyncEventLastChance : int32_t {
  
  IS_NOT_LAST_CHANCE = 0,
  
  IS_LAST_CHANCE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundSyncEventLastChance value);
inline bool IsKnownEnumValue(BackgroundSyncEventLastChance value) {
  return internal::BackgroundSyncEventLastChance_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundSyncType : int32_t {
  
  ONE_SHOT = 0,
  
  PERIODIC = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundSyncType value);
inline bool IsKnownEnumValue(BackgroundSyncType value) {
  return internal::BackgroundSyncType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class OneShotBackgroundSyncServiceInterfaceBase {};

using OneShotBackgroundSyncServicePtrDataView =
    mojo::InterfacePtrDataView<OneShotBackgroundSyncServiceInterfaceBase>;
using OneShotBackgroundSyncServiceRequestDataView =
    mojo::InterfaceRequestDataView<OneShotBackgroundSyncServiceInterfaceBase>;
using OneShotBackgroundSyncServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OneShotBackgroundSyncServiceInterfaceBase>;
using OneShotBackgroundSyncServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OneShotBackgroundSyncServiceInterfaceBase>;
class PeriodicBackgroundSyncServiceInterfaceBase {};

using PeriodicBackgroundSyncServicePtrDataView =
    mojo::InterfacePtrDataView<PeriodicBackgroundSyncServiceInterfaceBase>;
using PeriodicBackgroundSyncServiceRequestDataView =
    mojo::InterfaceRequestDataView<PeriodicBackgroundSyncServiceInterfaceBase>;
using PeriodicBackgroundSyncServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PeriodicBackgroundSyncServiceInterfaceBase>;
using PeriodicBackgroundSyncServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PeriodicBackgroundSyncServiceInterfaceBase>;


class SyncRegistrationOptionsDataView {
 public:
  SyncRegistrationOptionsDataView() = default;

  SyncRegistrationOptionsDataView(
      internal::SyncRegistrationOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t min_interval() const {
    return data_->min_interval;
  }
 private:
  internal::SyncRegistrationOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundSyncRegistrationInfoDataView {
 public:
  BackgroundSyncRegistrationInfoDataView() = default;

  BackgroundSyncRegistrationInfoDataView(
      internal::BackgroundSyncRegistrationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t service_worker_registration_id() const {
    return data_->service_worker_registration_id;
  }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSyncType(UserType* output) const {
    auto data_value = data_->sync_type;
    return mojo::internal::Deserialize<::blink::mojom::BackgroundSyncType>(
        data_value, output);
  }
  BackgroundSyncType sync_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BackgroundSyncType>(data_->sync_type));
  }
 private:
  internal::BackgroundSyncRegistrationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_SYNC_BACKGROUND_SYNC_MOJOM_DATA_VIEW_H_