// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.BackgroundFetchErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.BackgroundFetchError = {
  
  NONE: 0,
  DUPLICATED_DEVELOPER_ID: 1,
  INVALID_ARGUMENT: 2,
  INVALID_ID: 3,
  STORAGE_ERROR: 4,
  SERVICE_WORKER_UNAVAILABLE: 5,
  QUOTA_EXCEEDED: 6,
  PERMISSION_DENIED: 7,
  REGISTRATION_LIMIT_EXCEEDED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.BackgroundFetchResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.BackgroundFetchResult = {
  
  UNSET: 0,
  FAILURE: 1,
  SUCCESS: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.BackgroundFetchFailureReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.BackgroundFetchFailureReason = {
  
  NONE: 0,
  CANCELLED_FROM_UI: 1,
  CANCELLED_BY_DEVELOPER: 2,
  BAD_STATUS: 3,
  FETCH_ERROR: 4,
  SERVICE_WORKER_UNAVAILABLE: 5,
  QUOTA_EXCEEDED: 6,
  DOWNLOAD_TOTAL_EXCEEDED: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BackgroundFetchRegistrationObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BackgroundFetchRegistrationObserverInterface }
 */
blink.mojom.BackgroundFetchRegistrationObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BackgroundFetchRegistrationObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BackgroundFetchRegistrationObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BackgroundFetchRegistrationObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } uploadTotal
   * @param { !bigint } uploaded
   * @param { !bigint } downloadTotal
   * @param { !bigint } downloaded
   * @param { !blink.mojom.BackgroundFetchResult } result
   * @param { !blink.mojom.BackgroundFetchFailureReason } failureReason
   */

  onProgress(
      uploadTotal,
      uploaded,
      downloadTotal,
      downloaded,
      result,
      failureReason) {
    this.proxy.sendMessage(
        0,
        blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        [
          uploadTotal,
          uploaded,
          downloadTotal,
          downloaded,
          result,
          failureReason
        ],
        false);
  }

  
  /**
   */

  onRecordsUnavailable() {
    this.proxy.sendMessage(
        1,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FetchAPIRequest } request
   * @param { ?blink.mojom.FetchAPIResponse } response
   */

  onRequestCompleted(
      request,
      response) {
    this.proxy.sendMessage(
        2,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        [
          request,
          response
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BackgroundFetchRegistrationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserverReceiver = class {
  /**
   * @param {!blink.mojom.BackgroundFetchRegistrationObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BackgroundFetchRegistrationObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BackgroundFetchRegistrationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchRegistrationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        impl.onProgress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        impl.onRecordsUnavailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        impl.onRequestCompleted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BackgroundFetchRegistrationObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchRegistrationObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BackgroundFetchRegistrationObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BackgroundFetchRegistrationObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BackgroundFetchRegistrationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BackgroundFetchRegistrationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchRegistrationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
        null,
        this.onProgress.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRecordsUnavailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
        null,
        this.onRecordsUnavailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
        null,
        this.onRequestCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BackgroundFetchServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BackgroundFetchService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BackgroundFetchServiceInterface }
 */
blink.mojom.BackgroundFetchServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BackgroundFetchServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BackgroundFetchServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BackgroundFetchServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @param { !Array<!blink.mojom.FetchAPIRequest> } requests
   * @param { !blink.mojom.BackgroundFetchOptions } options
   * @param { ?skia.mojom.BitmapN32 } icon
   * @param { !blink.mojom.BackgroundFetchUkmData } ukmData
   * @return {!Promise<{
        error: !blink.mojom.BackgroundFetchError,
        registration: ?blink.mojom.BackgroundFetchRegistration,
   *  }>}
   */

  fetch(
      serviceWorkerRegistrationId,
      developerId,
      requests,
      options,
      icon,
      ukmData) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.BackgroundFetchService_Fetch_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          developerId,
          requests,
          options,
          icon,
          ukmData
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } developerId
   * @return {!Promise<{
        error: !blink.mojom.BackgroundFetchError,
        registration: ?blink.mojom.BackgroundFetchRegistration,
   *  }>}
   */

  getRegistration(
      serviceWorkerRegistrationId,
      developerId) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.BackgroundFetchService_GetRegistration_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          developerId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !blink.mojom.BackgroundFetchError,
        developerIds: !Array<!string>,
   *  }>}
   */

  getDeveloperIds(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        iconSizePixels: !gfx.mojom.Size,
   *  }>}
   */

  getIconDisplaySize() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BackgroundFetchService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BackgroundFetchServiceReceiver = class {
  /**
   * @param {!blink.mojom.BackgroundFetchServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BackgroundFetchServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BackgroundFetchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchService_Fetch_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        impl.fetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchService_GetRegistration_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        impl.getRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        impl.getDeveloperIds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        impl.getIconDisplaySize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BackgroundFetchService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BackgroundFetchServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BackgroundFetchServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BackgroundFetchService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BackgroundFetchServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BackgroundFetchServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchService_Fetch_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_Fetch_ResponseParamsSpec.$,
        this.fetch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchService_GetRegistration_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
        this.getRegistration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeveloperIds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
        this.getDeveloperIds.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIconDisplaySize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
        blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
        this.getIconDisplaySize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BackgroundFetchRegistrationService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.BackgroundFetchRegistrationServiceInterface }
 */
blink.mojom.BackgroundFetchRegistrationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BackgroundFetchRegistrationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BackgroundFetchRegistrationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BackgroundFetchRegistrationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?string } title
   * @param { ?skia.mojom.BitmapN32 } icon
   * @return {!Promise<{
        error: !blink.mojom.BackgroundFetchError,
   *  }>}
   */

  updateUI(
      title,
      icon) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        [
          title,
          icon
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.BackgroundFetchError,
   *  }>}
   */

  abort() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.FetchAPIRequest } requestToMatch
   * @param { ?blink.mojom.CacheQueryOptions } cacheQueryOptions
   * @param { !boolean } matchAll
   * @return {!Promise<{
        fetches: !Array<!blink.mojom.BackgroundFetchSettledFetch>,
   *  }>}
   */

  matchRequests(
      requestToMatch,
      cacheQueryOptions,
      matchAll) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        [
          requestToMatch,
          cacheQueryOptions,
          matchAll
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.BackgroundFetchRegistrationObserverRemote } observer
   */

  addRegistrationObserver(
      observer) {
    this.proxy.sendMessage(
        3,
        blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BackgroundFetchRegistrationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BackgroundFetchRegistrationServiceReceiver = class {
  /**
   * @param {!blink.mojom.BackgroundFetchRegistrationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BackgroundFetchRegistrationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BackgroundFetchRegistrationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchRegistrationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        impl.updateUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        impl.matchRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        impl.addRegistrationObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BackgroundFetchRegistrationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BackgroundFetchRegistrationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BackgroundFetchRegistrationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BackgroundFetchRegistrationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BackgroundFetchRegistrationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BackgroundFetchRegistrationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BackgroundFetchRegistrationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BackgroundFetchRegistrationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
        this.updateUI.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
        this.abort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.matchRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
        blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
        this.matchRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRegistrationObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
        null,
        this.addRegistrationObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchSettledFetchSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchUkmDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_Fetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_Fetch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetRegistration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetRegistration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetDeveloperIds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetIconDisplaySize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BackgroundFetchSettledFetchSpec.$,
    'BackgroundFetchSettledFetch',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchSettledFetch = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { (blink.mojom.FetchAPIResponse|undefined) } */
    this.response;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchOptionsSpec.$,
    'BackgroundFetchOptions',
    [
      mojo.internal.StructField(
        'icons', 0,
        0,
        mojo.internal.Array(blink.mojom.ManifestImageResourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadTotal', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.BackgroundFetchOptions = class {
  constructor() {
    /** @export { !Array<!blink.mojom.ManifestImageResource> } */
    this.icons;
    /** @export { !bigint } */
    this.downloadTotal;
    /** @export { !string } */
    this.title;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationDataSpec.$,
    'BackgroundFetchRegistrationData',
    [
      mojo.internal.StructField(
        'developerId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploadTotal', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploaded', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadTotal', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloaded', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 40,
        0,
        blink.mojom.BackgroundFetchResultSpec.$,
        blink.mojom.BackgroundFetchResult.UNSET,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'failureReason', 44,
        0,
        blink.mojom.BackgroundFetchFailureReasonSpec.$,
        blink.mojom.BackgroundFetchFailureReason.NONE,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationData = class {
  constructor() {
    /** @export { !string } */
    this.developerId;
    /** @export { !bigint } */
    this.uploadTotal;
    /** @export { !bigint } */
    this.uploaded;
    /** @export { !bigint } */
    this.downloadTotal;
    /** @export { !bigint } */
    this.downloaded;
    /** @export { !blink.mojom.BackgroundFetchResult } */
    this.result;
    /** @export { !blink.mojom.BackgroundFetchFailureReason } */
    this.failureReason;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationSpec.$,
    'BackgroundFetchRegistration',
    [
      mojo.internal.StructField(
        'registrationData', 0,
        0,
        blink.mojom.BackgroundFetchRegistrationDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registrationInterface', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BackgroundFetchRegistrationServiceRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchRegistration = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistrationData } */
    this.registrationData;
    /** @export { !blink.mojom.BackgroundFetchRegistrationServiceRemote } */
    this.registrationInterface;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchUkmDataSpec.$,
    'BackgroundFetchUkmData',
    [
      mojo.internal.StructField(
        'idealToChosenIconSize', 0,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchUkmData = class {
  constructor() {
    /** @export { !bigint } */
    this.idealToChosenIconSize;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnProgress_Params',
    [
      mojo.internal.StructField(
        'uploadTotal', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploaded', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadTotal', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloaded', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 32,
        0,
        blink.mojom.BackgroundFetchResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'failureReason', 36,
        0,
        blink.mojom.BackgroundFetchFailureReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationObserver_OnProgress_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.uploadTotal;
    /** @export { !bigint } */
    this.uploaded;
    /** @export { !bigint } */
    this.downloadTotal;
    /** @export { !bigint } */
    this.downloaded;
    /** @export { !blink.mojom.BackgroundFetchResult } */
    this.result;
    /** @export { !blink.mojom.BackgroundFetchFailureReason } */
    this.failureReason;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationObserver_OnRecordsUnavailable_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_ParamsSpec.$,
    'BackgroundFetchRegistrationObserver_OnRequestCompleted_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        blink.mojom.FetchAPIResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationObserver_OnRequestCompleted_Params = class {
  constructor() {
    /** @export { !blink.mojom.FetchAPIRequest } */
    this.request;
    /** @export { (blink.mojom.FetchAPIResponse|undefined) } */
    this.response;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_Fetch_ParamsSpec.$,
    'BackgroundFetchService_Fetch_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'developerId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requests', 16,
        0,
        mojo.internal.Array(blink.mojom.FetchAPIRequestSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        blink.mojom.BackgroundFetchOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 32,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ukmData', 40,
        0,
        blink.mojom.BackgroundFetchUkmDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.BackgroundFetchService_Fetch_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !string } */
    this.developerId;
    /** @export { !Array<!blink.mojom.FetchAPIRequest> } */
    this.requests;
    /** @export { !blink.mojom.BackgroundFetchOptions } */
    this.options;
    /** @export { (skia.mojom.BitmapN32|undefined) } */
    this.icon;
    /** @export { !blink.mojom.BackgroundFetchUkmData } */
    this.ukmData;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_Fetch_ResponseParamsSpec.$,
    'BackgroundFetchService_Fetch_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.BackgroundFetchErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registration', 8,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchService_Fetch_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchError } */
    this.error;
    /** @export { (blink.mojom.BackgroundFetchRegistration|undefined) } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetRegistration_ParamsSpec.$,
    'BackgroundFetchService_GetRegistration_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'developerId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchService_GetRegistration_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !string } */
    this.developerId;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetRegistration_ResponseParamsSpec.$,
    'BackgroundFetchService_GetRegistration_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.BackgroundFetchErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registration', 8,
        0,
        blink.mojom.BackgroundFetchRegistrationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchService_GetRegistration_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchError } */
    this.error;
    /** @export { (blink.mojom.BackgroundFetchRegistration|undefined) } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetDeveloperIds_ParamsSpec.$,
    'BackgroundFetchService_GetDeveloperIds_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchService_GetDeveloperIds_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParamsSpec.$,
    'BackgroundFetchService_GetDeveloperIds_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.BackgroundFetchErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'developerIds', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchService_GetDeveloperIds_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchError } */
    this.error;
    /** @export { !Array<!string> } */
    this.developerIds;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetIconDisplaySize_ParamsSpec.$,
    'BackgroundFetchService_GetIconDisplaySize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BackgroundFetchService_GetIconDisplaySize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParamsSpec.$,
    'BackgroundFetchService_GetIconDisplaySize_ResponseParams',
    [
      mojo.internal.StructField(
        'iconSizePixels', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchService_GetIconDisplaySize_ResponseParams = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.iconSizePixels;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ParamsSpec.$,
    'BackgroundFetchRegistrationService_UpdateUI_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 8,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_UpdateUI_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.title;
    /** @export { (skia.mojom.BitmapN32|undefined) } */
    this.icon;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_UpdateUI_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.BackgroundFetchErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_UpdateUI_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_Abort_ParamsSpec.$,
    'BackgroundFetchRegistrationService_Abort_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_Abort_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_Abort_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.BackgroundFetchErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_Abort_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchError } */
    this.error;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ParamsSpec.$,
    'BackgroundFetchRegistrationService_MatchRequests_Params',
    [
      mojo.internal.StructField(
        'requestToMatch', 0,
        0,
        blink.mojom.FetchAPIRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheQueryOptions', 8,
        0,
        blink.mojom.CacheQueryOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchAll', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_MatchRequests_Params = class {
  constructor() {
    /** @export { (blink.mojom.FetchAPIRequest|undefined) } */
    this.requestToMatch;
    /** @export { (blink.mojom.CacheQueryOptions|undefined) } */
    this.cacheQueryOptions;
    /** @export { !boolean } */
    this.matchAll;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParamsSpec.$,
    'BackgroundFetchRegistrationService_MatchRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'fetches', 0,
        0,
        mojo.internal.Array(blink.mojom.BackgroundFetchSettledFetchSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_MatchRequests_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.BackgroundFetchSettledFetch> } */
    this.fetches;
  }
};



mojo.internal.Struct(
    blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_ParamsSpec.$,
    'BackgroundFetchRegistrationService_AddRegistrationObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BackgroundFetchRegistrationObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.BackgroundFetchRegistrationService_AddRegistrationObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.BackgroundFetchRegistrationObserverRemote } */
    this.observer;
  }
};

