// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class BackgroundFetchSettledFetchDataView;

class BackgroundFetchOptionsDataView;

class BackgroundFetchRegistrationDataDataView;

class BackgroundFetchRegistrationDataView;

class BackgroundFetchUkmDataDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchSettledFetchDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchSettledFetch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchOptionsDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchRegistrationDataDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchRegistrationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchRegistrationDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BackgroundFetchUkmDataDataView> {
  using Data = ::blink::mojom::internal::BackgroundFetchUkmData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class BackgroundFetchError : int32_t {
  
  NONE = 0,
  
  DUPLICATED_DEVELOPER_ID = 1,
  
  INVALID_ARGUMENT = 2,
  
  INVALID_ID = 3,
  
  STORAGE_ERROR = 4,
  
  SERVICE_WORKER_UNAVAILABLE = 5,
  
  QUOTA_EXCEEDED = 6,
  
  PERMISSION_DENIED = 7,
  
  REGISTRATION_LIMIT_EXCEEDED = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchError value);
inline bool IsKnownEnumValue(BackgroundFetchError value) {
  return internal::BackgroundFetchError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundFetchResult : int32_t {
  
  UNSET = 0,
  
  FAILURE = 1,
  
  SUCCESS = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchResult value);
inline bool IsKnownEnumValue(BackgroundFetchResult value) {
  return internal::BackgroundFetchResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BackgroundFetchFailureReason : int32_t {
  
  NONE = 0,
  
  CANCELLED_FROM_UI = 1,
  
  CANCELLED_BY_DEVELOPER = 2,
  
  BAD_STATUS = 3,
  
  FETCH_ERROR = 4,
  
  SERVICE_WORKER_UNAVAILABLE = 5,
  
  QUOTA_EXCEEDED = 6,
  
  DOWNLOAD_TOTAL_EXCEEDED = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BackgroundFetchFailureReason value);
inline bool IsKnownEnumValue(BackgroundFetchFailureReason value) {
  return internal::BackgroundFetchFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BackgroundFetchRegistrationObserverInterfaceBase {};

using BackgroundFetchRegistrationObserverPtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
using BackgroundFetchRegistrationObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchRegistrationObserverInterfaceBase>;
class BackgroundFetchServiceInterfaceBase {};

using BackgroundFetchServicePtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchServiceInterfaceBase>;
using BackgroundFetchServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchServiceInterfaceBase>;
class BackgroundFetchRegistrationServiceInterfaceBase {};

using BackgroundFetchRegistrationServicePtrDataView =
    mojo::InterfacePtrDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceRequestDataView =
    mojo::InterfaceRequestDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BackgroundFetchRegistrationServiceInterfaceBase>;
using BackgroundFetchRegistrationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BackgroundFetchRegistrationServiceInterfaceBase>;


class BackgroundFetchSettledFetchDataView {
 public:
  BackgroundFetchSettledFetchDataView() = default;

  BackgroundFetchSettledFetchDataView(
      internal::BackgroundFetchSettledFetch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundFetchSettledFetch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchOptionsDataView {
 public:
  BackgroundFetchOptionsDataView() = default;

  BackgroundFetchOptionsDataView(
      internal::BackgroundFetchOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIconsDataView(
      mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
        pointer, output, message_);
  }
  uint64_t download_total() const {
    return data_->download_total;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundFetchOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchRegistrationDataDataView {
 public:
  BackgroundFetchRegistrationDataDataView() = default;

  BackgroundFetchRegistrationDataDataView(
      internal::BackgroundFetchRegistrationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeveloperIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeveloperId(UserType* output) {
    
    auto* pointer = data_->developer_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t upload_total() const {
    return data_->upload_total;
  }
  uint64_t uploaded() const {
    return data_->uploaded;
  }
  uint64_t download_total() const {
    return data_->download_total;
  }
  uint64_t downloaded() const {
    return data_->downloaded;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchResult>(
        data_value, output);
  }
  BackgroundFetchResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BackgroundFetchResult>(data_->result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    auto data_value = data_->failure_reason;
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchFailureReason>(
        data_value, output);
  }
  BackgroundFetchFailureReason failure_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::BackgroundFetchFailureReason>(data_->failure_reason));
  }
 private:
  internal::BackgroundFetchRegistrationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchRegistrationDataView {
 public:
  BackgroundFetchRegistrationDataView() = default;

  BackgroundFetchRegistrationDataView(
      internal::BackgroundFetchRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistrationDataDataView(
      BackgroundFetchRegistrationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistrationData(UserType* output) {
    
    auto* pointer = data_->registration_data.Get();
    return mojo::internal::Deserialize<::blink::mojom::BackgroundFetchRegistrationDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeRegistrationInterface() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BackgroundFetchRegistrationServiceInterfaceBase>>(
            &data_->registration_interface, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BackgroundFetchRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundFetchUkmDataDataView {
 public:
  BackgroundFetchUkmDataDataView() = default;

  BackgroundFetchUkmDataDataView(
      internal::BackgroundFetchUkmData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t ideal_to_chosen_icon_size() const {
    return data_->ideal_to_chosen_icon_size;
  }
 private:
  internal::BackgroundFetchUkmData_Data* data_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_DATA_VIEW_H_