// third_party/blink/public/mojom/app_banner/app_banner.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AppBannerPromptReplySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AppBannerPromptReply = {
  
  NONE: 0,
  CANCEL: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AppBannerControllerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AppBannerController', scope);
  }
}

/** @interface */
export class AppBannerControllerInterface {
  
  /**
   * @param { !AppBannerServiceRemote } service
   * @param { !AppBannerEventPendingReceiver } eventReceiver
   * @param { !Array<!string> } platform
   * @return {!Promise<{
        reply: !AppBannerPromptReply,
   *  }>}
   */

  bannerPromptRequest(service, eventReceiver, platform) {}
}

/**
 * @implements { AppBannerControllerInterface }
 */
export class AppBannerControllerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AppBannerControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AppBannerControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AppBannerControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AppBannerServiceRemote } service
   * @param { !AppBannerEventPendingReceiver } eventReceiver
   * @param { !Array<!string> } platform
   * @return {!Promise<{
        reply: !AppBannerPromptReply,
   *  }>}
   */

  bannerPromptRequest(
      service,
      eventReceiver,
      platform) {
    return this.proxy.sendMessage(
        0,
        AppBannerController_BannerPromptRequest_ParamsSpec.$,
        AppBannerController_BannerPromptRequest_ResponseParamsSpec.$,
        [
          service,
          eventReceiver,
          platform
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AppBannerController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppBannerControllerReceiver {
  /**
   * @param {!AppBannerControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AppBannerControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AppBannerControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AppBannerController_BannerPromptRequest_ParamsSpec.$,
        AppBannerController_BannerPromptRequest_ResponseParamsSpec.$,
        impl.bannerPromptRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AppBannerController {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AppBannerController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AppBannerControllerRemote}
   */
  static getRemote() {
    let remote = new AppBannerControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AppBannerController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppBannerControllerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AppBannerControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bannerPromptRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AppBannerController_BannerPromptRequest_ParamsSpec.$,
        AppBannerController_BannerPromptRequest_ResponseParamsSpec.$,
        this.bannerPromptRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AppBannerEventPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AppBannerEvent', scope);
  }
}

/** @interface */
export class AppBannerEventInterface {
  
  /**
   * @param { !string } platform
   */

  bannerAccepted(platform) {}
  
  /**
   */

  bannerDismissed() {}
}

/**
 * @implements { AppBannerEventInterface }
 */
export class AppBannerEventRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AppBannerEventPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AppBannerEventPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AppBannerEventPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } platform
   */

  bannerAccepted(
      platform) {
    this.proxy.sendMessage(
        0,
        AppBannerEvent_BannerAccepted_ParamsSpec.$,
        null,
        [
          platform
        ],
        false);
  }

  
  /**
   */

  bannerDismissed() {
    this.proxy.sendMessage(
        1,
        AppBannerEvent_BannerDismissed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AppBannerEvent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppBannerEventReceiver {
  /**
   * @param {!AppBannerEventInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AppBannerEventRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AppBannerEventRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerEventRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AppBannerEvent_BannerAccepted_ParamsSpec.$,
        null,
        impl.bannerAccepted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AppBannerEvent_BannerDismissed_ParamsSpec.$,
        null,
        impl.bannerDismissed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AppBannerEvent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AppBannerEvent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AppBannerEventRemote}
   */
  static getRemote() {
    let remote = new AppBannerEventRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AppBannerEvent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppBannerEventCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AppBannerEventRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerEventRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bannerAccepted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AppBannerEvent_BannerAccepted_ParamsSpec.$,
        null,
        this.bannerAccepted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bannerDismissed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AppBannerEvent_BannerDismissed_ParamsSpec.$,
        null,
        this.bannerDismissed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AppBannerServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AppBannerService', scope);
  }
}

/** @interface */
export class AppBannerServiceInterface {
  
  /**
   */

  displayAppBanner() {}
}

/**
 * @implements { AppBannerServiceInterface }
 */
export class AppBannerServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AppBannerServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AppBannerServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AppBannerServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  displayAppBanner() {
    this.proxy.sendMessage(
        0,
        AppBannerService_DisplayAppBanner_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AppBannerService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AppBannerServiceReceiver {
  /**
   * @param {!AppBannerServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AppBannerServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AppBannerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AppBannerService_DisplayAppBanner_ParamsSpec.$,
        null,
        impl.displayAppBanner.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AppBannerService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AppBannerService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AppBannerServiceRemote}
   */
  static getRemote() {
    let remote = new AppBannerServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AppBannerService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AppBannerServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AppBannerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AppBannerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displayAppBanner =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AppBannerService_DisplayAppBanner_ParamsSpec.$,
        null,
        this.displayAppBanner.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppBannerController_BannerPromptRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppBannerController_BannerPromptRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppBannerEvent_BannerAccepted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppBannerEvent_BannerDismissed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AppBannerService_DisplayAppBanner_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AppBannerController_BannerPromptRequest_ParamsSpec.$,
    'AppBannerController_BannerPromptRequest_Params',
    [
      mojo.internal.StructField(
        'service', 0,
        0,
        mojo.internal.InterfaceProxy(AppBannerServiceRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(AppBannerEventPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'platform', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AppBannerController_BannerPromptRequest_Params {
  constructor() {
    /** @type { !AppBannerServiceRemote } */
    this.service;
    /** @type { !AppBannerEventPendingReceiver } */
    this.eventReceiver;
    /** @type { !Array<!string> } */
    this.platform;
  }
}



mojo.internal.Struct(
    AppBannerController_BannerPromptRequest_ResponseParamsSpec.$,
    'AppBannerController_BannerPromptRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'reply', 0,
        0,
        AppBannerPromptReplySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AppBannerController_BannerPromptRequest_ResponseParams {
  constructor() {
    /** @type { !AppBannerPromptReply } */
    this.reply;
  }
}



mojo.internal.Struct(
    AppBannerEvent_BannerAccepted_ParamsSpec.$,
    'AppBannerEvent_BannerAccepted_Params',
    [
      mojo.internal.StructField(
        'platform', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AppBannerEvent_BannerAccepted_Params {
  constructor() {
    /** @type { !string } */
    this.platform;
  }
}



mojo.internal.Struct(
    AppBannerEvent_BannerDismissed_ParamsSpec.$,
    'AppBannerEvent_BannerDismissed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AppBannerEvent_BannerDismissed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AppBannerService_DisplayAppBanner_ParamsSpec.$,
    'AppBannerService_DisplayAppBanner_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AppBannerService_DisplayAppBanner_Params {
  constructor() {
  }
}

