// third_party/blink/public/mojom/app_banner/app_banner.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/app_banner/app_banner.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/app_banner/app_banner.mojom-params-data.h"
#include "third_party/blink/public/mojom/app_banner/app_banner.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/app_banner/app_banner.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/app_banner/app_banner.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

AppBannerController::IPCStableHashFunction AppBannerController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppBannerController>(message.name())) {
    case messages::AppBannerController::kBannerPromptRequest: {
      return &AppBannerController::BannerPromptRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppBannerController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppBannerController>(message.name())) {
      case messages::AppBannerController::kBannerPromptRequest:
            return "Receive blink::mojom::AppBannerController::BannerPromptRequest";
    }
  } else {
    switch (static_cast<messages::AppBannerController>(message.name())) {
      case messages::AppBannerController::kBannerPromptRequest:
            return "Receive reply blink::mojom::AppBannerController::BannerPromptRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppBannerController::BannerPromptRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70519c34;  // IPCStableHash for blink::mojom::AppBannerController::BannerPromptRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AppBannerController_BannerPromptRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppBannerController_BannerPromptRequest_ForwardToCallback(
      AppBannerController::BannerPromptRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  AppBannerController_BannerPromptRequest_ForwardToCallback(const AppBannerController_BannerPromptRequest_ForwardToCallback&) = delete;
  AppBannerController_BannerPromptRequest_ForwardToCallback& operator=(const AppBannerController_BannerPromptRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AppBannerController::BannerPromptRequestCallback callback_;
};

AppBannerControllerProxy::AppBannerControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppBannerControllerProxy::BannerPromptRequest(
    ::mojo::PendingRemote<AppBannerService> in_service, ::mojo::PendingReceiver<AppBannerEvent> in_event_receiver, const ::blink::Vector<::blink::String>& in_platform, BannerPromptRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AppBannerController::BannerPromptRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::PendingRemote<AppBannerService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_receiver"), in_event_receiver,
                        "<value of type ::mojo::PendingReceiver<AppBannerEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform"), in_platform,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppBannerController::kBannerPromptRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AppBannerController_BannerPromptRequest_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AppBannerServiceInterfaceBase>>(
    in_service,
    &params->service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid service in AppBannerController.BannerPromptRequest request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::AppBannerEventInterfaceBase>>(
    in_event_receiver,
    &params->event_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->event_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid event_receiver in AppBannerController.BannerPromptRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->platform)::BaseType>
      platform_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& platform_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_platform,
    platform_fragment,
    &platform_validate_params);

  params->platform.Set(
      platform_fragment.is_null() ? nullptr : platform_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->platform.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null platform in AppBannerController.BannerPromptRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppBannerController::Name_);
  message.set_method_name("BannerPromptRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppBannerController_BannerPromptRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AppBannerController_BannerPromptRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AppBannerController::BannerPromptRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AppBannerController_BannerPromptRequest_ProxyToResponder> proxy(
        new AppBannerController_BannerPromptRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AppBannerController_BannerPromptRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppBannerController_BannerPromptRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AppBannerController_BannerPromptRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AppBannerController::BannerPromptRequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AppBannerPromptReply in_reply);
};

bool AppBannerController_BannerPromptRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AppBannerController_BannerPromptRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppBannerController_BannerPromptRequest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AppBannerController.0
  bool success = true;
  AppBannerPromptReply p_reply{};
  AppBannerController_BannerPromptRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppBannerController::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reply));
  }
  return true;
}

void AppBannerController_BannerPromptRequest_ProxyToResponder::Run(
    AppBannerPromptReply in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AppBannerController::BannerPromptRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type AppBannerPromptReply>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppBannerController::kBannerPromptRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AppBannerController_BannerPromptRequest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AppBannerPromptReply>(
    in_reply,
    &params->reply);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppBannerController::Name_);
  message.set_method_name("BannerPromptRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AppBannerControllerStubDispatch::Accept(
    AppBannerController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppBannerController>(message->header()->name)) {
    case messages::AppBannerController::kBannerPromptRequest: {
      break;
    }
  }
  return false;
}

// static
bool AppBannerControllerStubDispatch::AcceptWithResponder(
    AppBannerController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppBannerController>(message->header()->name)) {
    case messages::AppBannerController::kBannerPromptRequest: {
      internal::AppBannerController_BannerPromptRequest_Params_Data* params =
          reinterpret_cast<
              internal::AppBannerController_BannerPromptRequest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AppBannerController.0
      bool success = true;
      ::mojo::PendingRemote<AppBannerService> p_service{};
      ::mojo::PendingReceiver<AppBannerEvent> p_event_receiver{};
      ::blink::Vector<::blink::String> p_platform{};
      AppBannerController_BannerPromptRequest_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_service =
            input_data_view.TakeService<decltype(p_service)>();
      }
      if (success) {
        p_event_receiver =
            input_data_view.TakeEventReceiver<decltype(p_event_receiver)>();
      }
      if (success && !input_data_view.ReadPlatform(&p_platform))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppBannerController::Name_, 0, false);
        return false;
      }
      auto callback =
          AppBannerController_BannerPromptRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BannerPromptRequest(        
        std::move(p_service), 
        std::move(p_event_receiver), 
        std::move(p_platform), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppBannerControllerValidationInfo[] = {
    { &internal::AppBannerController_BannerPromptRequest_Params_Data::Validate,
     &internal::AppBannerController_BannerPromptRequest_ResponseParams_Data::Validate},
};

bool AppBannerControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AppBannerController::Name_,
    kAppBannerControllerValidationInfo);
}

bool AppBannerControllerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::AppBannerController::Name_,
    kAppBannerControllerValidationInfo);
}
// The declaration includes the definition on other builds.

AppBannerEvent::IPCStableHashFunction AppBannerEvent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppBannerEvent>(message.name())) {
    case messages::AppBannerEvent::kBannerAccepted: {
      return &AppBannerEvent::BannerAccepted_Sym::IPCStableHash;
    }
    case messages::AppBannerEvent::kBannerDismissed: {
      return &AppBannerEvent::BannerDismissed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppBannerEvent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppBannerEvent>(message.name())) {
      case messages::AppBannerEvent::kBannerAccepted:
            return "Receive blink::mojom::AppBannerEvent::BannerAccepted";
      case messages::AppBannerEvent::kBannerDismissed:
            return "Receive blink::mojom::AppBannerEvent::BannerDismissed";
    }
  } else {
    switch (static_cast<messages::AppBannerEvent>(message.name())) {
      case messages::AppBannerEvent::kBannerAccepted:
            return "Receive reply blink::mojom::AppBannerEvent::BannerAccepted";
      case messages::AppBannerEvent::kBannerDismissed:
            return "Receive reply blink::mojom::AppBannerEvent::BannerDismissed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppBannerEvent::BannerAccepted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b688654;  // IPCStableHash for blink::mojom::AppBannerEvent::BannerAccepted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppBannerEvent::BannerDismissed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b936faf;  // IPCStableHash for blink::mojom::AppBannerEvent::BannerDismissed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AppBannerEventProxy::AppBannerEventProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppBannerEventProxy::BannerAccepted(
    const ::blink::String& in_platform) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AppBannerEvent::BannerAccepted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform"), in_platform,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppBannerEvent::kBannerAccepted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AppBannerEvent_BannerAccepted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->platform)::BaseType> platform_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_platform,
    platform_fragment);

  params->platform.Set(
      platform_fragment.is_null() ? nullptr : platform_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->platform.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null platform in AppBannerEvent.BannerAccepted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppBannerEvent::Name_);
  message.set_method_name("BannerAccepted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppBannerEventProxy::BannerDismissed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AppBannerEvent::BannerDismissed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppBannerEvent::kBannerDismissed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AppBannerEvent_BannerDismissed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppBannerEvent::Name_);
  message.set_method_name("BannerDismissed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AppBannerEventStubDispatch::Accept(
    AppBannerEvent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppBannerEvent>(message->header()->name)) {
    case messages::AppBannerEvent::kBannerAccepted: {
      DCHECK(message->is_serialized());
      internal::AppBannerEvent_BannerAccepted_Params_Data* params =
          reinterpret_cast<internal::AppBannerEvent_BannerAccepted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppBannerEvent.0
      bool success = true;
      ::blink::String p_platform{};
      AppBannerEvent_BannerAccepted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPlatform(&p_platform))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppBannerEvent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BannerAccepted(        
        std::move(p_platform));
      return true;
    }
    case messages::AppBannerEvent::kBannerDismissed: {
      DCHECK(message->is_serialized());
      internal::AppBannerEvent_BannerDismissed_Params_Data* params =
          reinterpret_cast<internal::AppBannerEvent_BannerDismissed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppBannerEvent.1
      bool success = true;
      AppBannerEvent_BannerDismissed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppBannerEvent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BannerDismissed(        );
      return true;
    }
  }
  return false;
}

// static
bool AppBannerEventStubDispatch::AcceptWithResponder(
    AppBannerEvent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppBannerEvent>(message->header()->name)) {
    case messages::AppBannerEvent::kBannerAccepted: {
      break;
    }
    case messages::AppBannerEvent::kBannerDismissed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppBannerEventValidationInfo[] = {
    { &internal::AppBannerEvent_BannerAccepted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppBannerEvent_BannerDismissed_Params_Data::Validate,
     nullptr /* no response */},
};

bool AppBannerEventRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AppBannerEvent::Name_,
    kAppBannerEventValidationInfo);
}

// The declaration includes the definition on other builds.

AppBannerService::IPCStableHashFunction AppBannerService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppBannerService>(message.name())) {
    case messages::AppBannerService::kDisplayAppBanner: {
      return &AppBannerService::DisplayAppBanner_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppBannerService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppBannerService>(message.name())) {
      case messages::AppBannerService::kDisplayAppBanner:
            return "Receive blink::mojom::AppBannerService::DisplayAppBanner";
    }
  } else {
    switch (static_cast<messages::AppBannerService>(message.name())) {
      case messages::AppBannerService::kDisplayAppBanner:
            return "Receive reply blink::mojom::AppBannerService::DisplayAppBanner";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppBannerService::DisplayAppBanner_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2edb3579;  // IPCStableHash for blink::mojom::AppBannerService::DisplayAppBanner
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AppBannerServiceProxy::AppBannerServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppBannerServiceProxy::DisplayAppBanner(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AppBannerService::DisplayAppBanner");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppBannerService::kDisplayAppBanner), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AppBannerService_DisplayAppBanner_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppBannerService::Name_);
  message.set_method_name("DisplayAppBanner");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AppBannerServiceStubDispatch::Accept(
    AppBannerService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppBannerService>(message->header()->name)) {
    case messages::AppBannerService::kDisplayAppBanner: {
      DCHECK(message->is_serialized());
      internal::AppBannerService_DisplayAppBanner_Params_Data* params =
          reinterpret_cast<internal::AppBannerService_DisplayAppBanner_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppBannerService.0
      bool success = true;
      AppBannerService_DisplayAppBanner_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppBannerService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayAppBanner(        );
      return true;
    }
  }
  return false;
}

// static
bool AppBannerServiceStubDispatch::AcceptWithResponder(
    AppBannerService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppBannerService>(message->header()->name)) {
    case messages::AppBannerService::kDisplayAppBanner: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppBannerServiceValidationInfo[] = {
    { &internal::AppBannerService_DisplayAppBanner_Params_Data::Validate,
     nullptr /* no response */},
};

bool AppBannerServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AppBannerService::Name_,
    kAppBannerServiceValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AppBannerControllerInterceptorForTesting::BannerPromptRequest(::mojo::PendingRemote<AppBannerService> service, ::mojo::PendingReceiver<AppBannerEvent> event_receiver, const ::blink::Vector<::blink::String>& platform, BannerPromptRequestCallback callback) {
  GetForwardingInterface()->BannerPromptRequest(
    std::move(service)
    , 
    std::move(event_receiver)
    , 
    std::move(platform)
    , std::move(callback));
}
AppBannerControllerAsyncWaiter::AppBannerControllerAsyncWaiter(
    AppBannerController* proxy) : proxy_(proxy) {}

AppBannerControllerAsyncWaiter::~AppBannerControllerAsyncWaiter() = default;


void AppBannerControllerAsyncWaiter::BannerPromptRequest(
    ::mojo::PendingRemote<AppBannerService> service, ::mojo::PendingReceiver<AppBannerEvent> event_receiver, const ::blink::Vector<::blink::String>& platform, AppBannerPromptReply* out_reply) {
  base::RunLoop loop;
  proxy_->BannerPromptRequest(
      std::move(service),
      std::move(event_receiver),
      std::move(platform),
      base::BindOnce(
          [](base::RunLoop* loop,
             AppBannerPromptReply* out_reply
,
             AppBannerPromptReply reply) {*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_reply));
  loop.Run();
}

AppBannerPromptReply AppBannerControllerAsyncWaiter::BannerPromptRequest(
    ::mojo::PendingRemote<AppBannerService> service, ::mojo::PendingReceiver<AppBannerEvent> event_receiver, const ::blink::Vector<::blink::String>& platform) {
  AppBannerPromptReply async_wait_result;
  BannerPromptRequest(std::move(service),std::move(event_receiver),std::move(platform),&async_wait_result);
  return async_wait_result;
}




void AppBannerEventInterceptorForTesting::BannerAccepted(const ::blink::String& platform) {
  GetForwardingInterface()->BannerAccepted(
    std::move(platform)
    );
}
void AppBannerEventInterceptorForTesting::BannerDismissed() {
  GetForwardingInterface()->BannerDismissed();
}
AppBannerEventAsyncWaiter::AppBannerEventAsyncWaiter(
    AppBannerEvent* proxy) : proxy_(proxy) {}

AppBannerEventAsyncWaiter::~AppBannerEventAsyncWaiter() = default;





void AppBannerServiceInterceptorForTesting::DisplayAppBanner() {
  GetForwardingInterface()->DisplayAppBanner();
}
AppBannerServiceAsyncWaiter::AppBannerServiceAsyncWaiter(
    AppBannerService* proxy) : proxy_(proxy) {}

AppBannerServiceAsyncWaiter::~AppBannerServiceAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif