// third_party/blink/public/mojom/annotation/annotation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/annotation/annotation.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/annotation/annotation.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AnnotationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AnnotationType> {};

template <>
struct hash<::blink::mojom::AttachmentResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AttachmentResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AnnotationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AnnotationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AnnotationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AttachmentResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AttachmentResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AttachmentResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SelectorCreationResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SelectorCreationResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SelectorCreationResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::host_receiver(input)) in_host_receiver = Traits::host_receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::AnnotationAgentHostInterfaceBase>>(
      in_host_receiver,
      &fragment->host_receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->host_receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host_receiver in SelectorCreationResult struct");

    decltype(Traits::agent_remote(input)) in_agent_remote = Traits::agent_remote(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AnnotationAgentInterfaceBase>>(
      in_agent_remote,
      &fragment->agent_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->agent_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent_remote in SelectorCreationResult struct");

    decltype(Traits::serialized_selector(input)) in_serialized_selector = Traits::serialized_selector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_selector)::BaseType> serialized_selector_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serialized_selector,
      serialized_selector_fragment);

    fragment->serialized_selector.Set(
        serialized_selector_fragment.is_null() ? nullptr : serialized_selector_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serialized_selector.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_selector in SelectorCreationResult struct");

    decltype(Traits::selected_text(input)) in_selected_text = Traits::selected_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_text)::BaseType> selected_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_selected_text,
      selected_text_fragment);

    fragment->selected_text.Set(
        selected_text_fragment.is_null() ? nullptr : selected_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_text in SelectorCreationResult struct");
  }

  static bool Deserialize(::blink::mojom::internal::SelectorCreationResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SelectorCreationResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SelectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::SelectorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::Selector_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::SelectorDataView::Tag::kSerializedSelector: {
    decltype(Traits::serialized_selector(input))
    in_serialized_selector = Traits::serialized_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_serialized_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_serialized_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null serialized_selector in Selector union");
    fragment->data.f_serialized_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::SelectorDataView::Tag::kNodeId: {
    decltype(Traits::node_id(input))
    in_node_id = Traits::node_id(input);
    fragment->data.f_node_id = in_node_id;
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::Selector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SelectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SelectorCreationResultDataView::GetSerializedSelectorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serialized_selector.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SelectorCreationResultDataView::GetSelectedTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->selected_text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SelectorDataView::GetSerializedSelectorDataView(
    mojo::StringDataView* output) const {
  CHECK(is_serialized_selector());
  *output = mojo::StringDataView(data_->data.f_serialized_selector.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AnnotationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AnnotationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AttachmentResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AttachmentResult value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_SHARED_H_