// third_party/blink/public/mojom/annotation/annotation.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/annotation/annotation.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared.h"


namespace blink::mojom {
class SelectorCreationResultDataView;

class SelectorDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SelectorCreationResultDataView> {
  using Data = ::blink::mojom::internal::SelectorCreationResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SelectorDataView> {
  using Data = ::blink::mojom::internal::Selector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AnnotationType : int32_t {
  
  kSharedHighlight = 0,
  
  kUserNote = 1,
  
  kTextFinder = 2,
  
  kGlic = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AnnotationType value);
inline bool IsKnownEnumValue(AnnotationType value) {
  return internal::AnnotationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AttachmentResult : int32_t {
  
  kSuccess = 0,
  
  kSelectorNotMatched = 1,
  
  kRangeInvalid = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AttachmentResult value);
inline bool IsKnownEnumValue(AttachmentResult value) {
  return internal::AttachmentResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AnnotationAgentInterfaceBase {};

using AnnotationAgentPtrDataView =
    mojo::InterfacePtrDataView<AnnotationAgentInterfaceBase>;
using AnnotationAgentRequestDataView =
    mojo::InterfaceRequestDataView<AnnotationAgentInterfaceBase>;
using AnnotationAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AnnotationAgentInterfaceBase>;
using AnnotationAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AnnotationAgentInterfaceBase>;
class AnnotationAgentHostInterfaceBase {};

using AnnotationAgentHostPtrDataView =
    mojo::InterfacePtrDataView<AnnotationAgentHostInterfaceBase>;
using AnnotationAgentHostRequestDataView =
    mojo::InterfaceRequestDataView<AnnotationAgentHostInterfaceBase>;
using AnnotationAgentHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AnnotationAgentHostInterfaceBase>;
using AnnotationAgentHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AnnotationAgentHostInterfaceBase>;
class AnnotationAgentContainerInterfaceBase {};

using AnnotationAgentContainerPtrDataView =
    mojo::InterfacePtrDataView<AnnotationAgentContainerInterfaceBase>;
using AnnotationAgentContainerRequestDataView =
    mojo::InterfaceRequestDataView<AnnotationAgentContainerInterfaceBase>;
using AnnotationAgentContainerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AnnotationAgentContainerInterfaceBase>;
using AnnotationAgentContainerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AnnotationAgentContainerInterfaceBase>;


class SelectorCreationResultDataView {
 public:
  SelectorCreationResultDataView() = default;

  SelectorCreationResultDataView(
      internal::SelectorCreationResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeHostReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::AnnotationAgentHostInterfaceBase>>(
            &data_->host_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAgentRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::AnnotationAgentInterfaceBase>>(
            &data_->agent_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetSerializedSelectorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedSelector(UserType* output) {
    
    auto* pointer = data_->serialized_selector.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedText(UserType* output) {
    
    auto* pointer = data_->selected_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectorCreationResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectorDataView {
 public:
  using Tag = internal::Selector_Data::Selector_Tag;

  SelectorDataView() = default;

  SelectorDataView(
      internal::Selector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_serialized_selector() const { return data_->tag == Tag::kSerializedSelector; }
  inline void GetSerializedSelectorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedSelector(UserType* output) const {
    
    CHECK(is_serialized_selector());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_serialized_selector.Get(), output, message_);
  }
  bool is_node_id() const { return data_->tag == Tag::kNodeId; }
  int32_t node_id() const {
    CHECK(is_node_id());
    return data_->data.f_node_id;
  }

 private:
  internal::Selector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ANNOTATION_ANNOTATION_MOJOM_DATA_VIEW_H_