// third_party/blink/public/mojom/ai/model_streaming_responder.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.QuotaErrorInfo');




goog.provide('blink.mojom.ModelStreamingResponseStatus');
goog.provide('blink.mojom.ModelStreamingResponseStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ModelStreamingResponseStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ModelStreamingResponseStatus = {
  
  kOngoing: 0,
  kComplete: 1,
  kErrorUnknown: 2,
  kErrorInvalidRequest: 3,
  kErrorRequestThrottled: 4,
  kErrorPermissionDenied: 5,
  kErrorGenericFailure: 6,
  kErrorRetryableError: 7,
  kErrorNonRetryableError: 8,
  kErrorUnsupportedLanguage: 9,
  kErrorFiltered: 10,
  kErrorDisabled: 11,
  kErrorCancelled: 12,
  kErrorSessionDestroyed: 13,
  kErrorInputTooLarge: 14,
  kErrorResponseLowQuality: 15,
  MIN_VALUE: 0,
  MAX_VALUE: 15,
};



goog.provide('blink.mojom.ModelStreamingResponder');
goog.provide('blink.mojom.ModelStreamingResponderReceiver');
goog.provide('blink.mojom.ModelStreamingResponderCallbackRouter');
goog.provide('blink.mojom.ModelStreamingResponderInterface');
goog.provide('blink.mojom.ModelStreamingResponderRemote');
goog.provide('blink.mojom.ModelStreamingResponderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ModelStreamingResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ModelStreamingResponder.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ModelStreamingResponderInterface = class {
  
  /**
   * @param { ?blink.mojom.ModelExecutionContextInfo } contextInfo
   */

  onCompletion(contextInfo) {}
  
  /**
   * @param { !blink.mojom.ModelStreamingResponseStatus } status
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(status, quotaErrorInfo) {}
  
  /**
   * @param { !string } text
   */

  onStreaming(text) {}
  
  /**
   */

  onQuotaOverflow() {}
};

/**
 * @export
 * @implements { blink.mojom.ModelStreamingResponderInterface }
 */
blink.mojom.ModelStreamingResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ModelStreamingResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ModelStreamingResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ModelStreamingResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?blink.mojom.ModelExecutionContextInfo } contextInfo
   */

  onCompletion(
      contextInfo) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        [
          contextInfo
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ModelStreamingResponseStatus } status
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      status,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        [
          status,
          quotaErrorInfo
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  onStreaming(
      text) {
    this.proxy.sendMessage(
        2,
        blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  onQuotaOverflow() {
    this.proxy.sendMessage(
        3,
        blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ModelStreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ModelStreamingResponderReceiver = class {
  /**
   * @param {!blink.mojom.ModelStreamingResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ModelStreamingResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ModelStreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ModelStreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        impl.onCompletion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        impl.onStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        impl.onQuotaOverflow.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ModelStreamingResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ModelStreamingResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ModelStreamingResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ModelStreamingResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ModelStreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ModelStreamingResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ModelStreamingResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ModelStreamingResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompletion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec.$,
        null,
        this.onCompletion.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ModelStreamingResponder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec.$,
        null,
        this.onStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onQuotaOverflow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
        null,
        this.onQuotaOverflow.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ModelExecutionContextInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelExecutionContextInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ModelStreamingResponder_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelStreamingResponder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ModelExecutionContextInfoSpec.$,
    'ModelExecutionContextInfo',
    [
      mojo.internal.StructField(
        'currentTokens', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ModelExecutionContextInfo');

/** @record */
blink.mojom.ModelExecutionContextInfo = class {
  constructor() {
    /** @export { !bigint } */
    this.currentTokens;
  }
};



mojo.internal.Struct(
    blink.mojom.ModelStreamingResponder_OnCompletion_ParamsSpec.$,
    'ModelStreamingResponder_OnCompletion_Params',
    [
      mojo.internal.StructField(
        'contextInfo', 0,
        0,
        blink.mojom.ModelExecutionContextInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ModelStreamingResponder_OnCompletion_Params');

/** @record */
blink.mojom.ModelStreamingResponder_OnCompletion_Params = class {
  constructor() {
    /** @export { (blink.mojom.ModelExecutionContextInfo|undefined) } */
    this.contextInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.ModelStreamingResponder_OnError_ParamsSpec.$,
    'ModelStreamingResponder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ModelStreamingResponseStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ModelStreamingResponder_OnError_Params');

/** @record */
blink.mojom.ModelStreamingResponder_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.ModelStreamingResponseStatus } */
    this.status;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.ModelStreamingResponder_OnStreaming_ParamsSpec.$,
    'ModelStreamingResponder_OnStreaming_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ModelStreamingResponder_OnStreaming_Params');

/** @record */
blink.mojom.ModelStreamingResponder_OnStreaming_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    blink.mojom.ModelStreamingResponder_OnQuotaOverflow_ParamsSpec.$,
    'ModelStreamingResponder_OnQuotaOverflow_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ModelStreamingResponder_OnQuotaOverflow_Params');

/** @record */
blink.mojom.ModelStreamingResponder_OnQuotaOverflow_Params = class {
  constructor() {
  }
};

