// third_party/blink/public/mojom/ai/ai_writer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_writer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', 'model_streaming_responder.mojom.js');
  }


  var AIWriterTone = {};
  AIWriterTone.kFormal = 0;
  AIWriterTone.kNeutral = 1;
  AIWriterTone.kCasual = 2;
  AIWriterTone.MIN_VALUE = 0;
  AIWriterTone.MAX_VALUE = 2;

  AIWriterTone.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIWriterTone.toKnownEnumValue = function(value) {
    return value;
  };

  AIWriterTone.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIWriterFormat = {};
  AIWriterFormat.kPlainText = 0;
  AIWriterFormat.kMarkdown = 1;
  AIWriterFormat.MIN_VALUE = 0;
  AIWriterFormat.MAX_VALUE = 1;

  AIWriterFormat.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AIWriterFormat.toKnownEnumValue = function(value) {
    return value;
  };

  AIWriterFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIWriterLength = {};
  AIWriterLength.kShort = 0;
  AIWriterLength.kMedium = 1;
  AIWriterLength.kLong = 2;
  AIWriterLength.MIN_VALUE = 0;
  AIWriterLength.MAX_VALUE = 2;

  AIWriterLength.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIWriterLength.toKnownEnumValue = function(value) {
    return value;
  };

  AIWriterLength.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AIWriterCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIWriterCreateOptions.prototype.initDefaults_ = function() {
    this.sharedContext = null;
    this.tone = 0;
    this.format = 0;
    this.length = 0;
    this.expectedInputLanguages = null;
    this.expectedContextLanguages = null;
    this.outputLanguage = null;
  };
  AIWriterCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIWriterCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.sharedContext
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.tone
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AIWriterTone);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AIWriterFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.length
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, AIWriterLength);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.expectedInputLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.expectedContextLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriterCreateOptions.outputLanguage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ai_common$.AILanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIWriterCreateOptions.encodedSize = codec.kStructHeaderSize + 48;

  AIWriterCreateOptions.decode = function(decoder) {
    var packed;
    var val = new AIWriterCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedContext =
        decoder.decodeStruct(codec.String);
    val.tone =
        decoder.decodeStruct(new codec.Enum(AIWriterTone));
    val.format =
        decoder.decodeStruct(new codec.Enum(AIWriterFormat));
    val.length =
        decoder.decodeStruct(new codec.Enum(AIWriterLength));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.expectedInputLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.expectedContextLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.outputLanguage =
        decoder.decodeStructPointer(ai_common$.AILanguageCode);
    return val;
  };

  AIWriterCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIWriterCreateOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sharedContext);
    encoder.encodeStruct(codec.Int32, val.tone);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.encodeStruct(codec.Int32, val.length);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedInputLanguages);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedContextLanguages);
    encoder.encodeStructPointer(ai_common$.AILanguageCode, val.outputLanguage);
  };
  function AIWriter_Write_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIWriter_Write_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AIWriter_Write_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIWriter_Write_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriter_Write_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriter_Write_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriter_Write_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIWriter_Write_Params.encodedSize = codec.kStructHeaderSize + 24;

  AIWriter_Write_Params.decode = function(decoder) {
    var packed;
    var val = new AIWriter_Write_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AIWriter_Write_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIWriter_Write_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function AIWriter_MeasureUsage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIWriter_MeasureUsage_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
  };
  AIWriter_MeasureUsage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIWriter_MeasureUsage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriter_MeasureUsage_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIWriter_MeasureUsage_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIWriter_MeasureUsage_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIWriter_MeasureUsage_Params.decode = function(decoder) {
    var packed;
    var val = new AIWriter_MeasureUsage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIWriter_MeasureUsage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIWriter_MeasureUsage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
  };
  function AIWriter_MeasureUsage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIWriter_MeasureUsage_ResponseParams.prototype.initDefaults_ = function() {
    this.number_of_tokens_$flag = false;
    this.number_of_tokens_$value = 0;
  };
  AIWriter_MeasureUsage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIWriter_MeasureUsage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIWriter_MeasureUsage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIWriter_MeasureUsage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIWriter_MeasureUsage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.number_of_tokens_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.number_of_tokens_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AIWriter_MeasureUsage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIWriter_MeasureUsage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.number_of_tokens_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.number_of_tokens_$value);
  };
  var kAIWriter_Write_Name = 0;
  var kAIWriter_MeasureUsage_Name = 1;

  function AIWriterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIWriter,
                                                   handleOrPtrInfo);
  }

  function AIWriterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIWriter, associatedInterfacePtrInfo);
  }

  AIWriterAssociatedPtr.prototype =
      Object.create(AIWriterPtr.prototype);
  AIWriterAssociatedPtr.prototype.constructor =
      AIWriterAssociatedPtr;

  function AIWriterProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIWriterPtr.prototype.write = function() {
    return AIWriterProxy.prototype.write
        .apply(this.ptr.getProxy(), arguments);
  };

  AIWriterProxy.prototype.write = function(input, context, pendingResponder) {
    var params_ = new AIWriter_Write_Params();
    params_.input = input;
    params_.context = context;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAIWriter_Write_Name,
        codec.align(AIWriter_Write_Params.encodedSize));
    builder.encodeStruct(AIWriter_Write_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIWriterPtr.prototype.measureUsage = function() {
    return AIWriterProxy.prototype.measureUsage
        .apply(this.ptr.getProxy(), arguments);
  };

  AIWriterProxy.prototype.measureUsage = function(input, context) {
    var params_ = new AIWriter_MeasureUsage_Params();
    params_.input = input;
    params_.context = context;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIWriter_MeasureUsage_Name,
          codec.align(AIWriter_MeasureUsage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIWriter_MeasureUsage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIWriter_MeasureUsage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AIWriterStub(delegate) {
    this.delegate_ = delegate;
  }
  AIWriterStub.prototype.write = function(input, context, pendingResponder) {
    return this.delegate_ && this.delegate_.write && this.delegate_.write(input, context, pendingResponder);
  }
  AIWriterStub.prototype.measureUsage = function(input, context) {
    return this.delegate_ && this.delegate_.measureUsage && this.delegate_.measureUsage(input, context);
  }

  AIWriterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIWriter_Write_Name:
      var params = reader.decodeStruct(AIWriter_Write_Params);
      this.write(params.input, params.context, params.pendingResponder);
      return true;
    default:
      return false;
    }
  };

  AIWriterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIWriter_MeasureUsage_Name:
      var params = reader.decodeStruct(AIWriter_MeasureUsage_Params);
      this.measureUsage(params.input, params.context).then(function(response) {
        var responseParams =
            new AIWriter_MeasureUsage_ResponseParams();
        responseParams.numberOfTokens = response.numberOfTokens;
        var builder = new codec.MessageV1Builder(
            kAIWriter_MeasureUsage_Name,
            codec.align(AIWriter_MeasureUsage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIWriter_MeasureUsage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAIWriterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIWriter_Write_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIWriter_Write_Params;
      break;
      case kAIWriter_MeasureUsage_Name:
        if (message.expectsResponse())
          paramsClass = AIWriter_MeasureUsage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIWriterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAIWriter_MeasureUsage_Name:
        if (message.isResponse())
          paramsClass = AIWriter_MeasureUsage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AIWriter = {
    name: 'blink.mojom.AIWriter',
    kVersion: 0,
    ptrClass: AIWriterPtr,
    proxyClass: AIWriterProxy,
    stubClass: AIWriterStub,
    validateRequest: validateAIWriterRequest,
    validateResponse: validateAIWriterResponse,
  };
  AIWriterStub.prototype.validator = validateAIWriterRequest;
  AIWriterProxy.prototype.validator = validateAIWriterResponse;
  exports.AIWriterTone = AIWriterTone;
  exports.AIWriterFormat = AIWriterFormat;
  exports.AIWriterLength = AIWriterLength;
  exports.AIWriterCreateOptions = AIWriterCreateOptions;
  exports.AIWriter = AIWriter;
  exports.AIWriterPtr = AIWriterPtr;
  exports.AIWriterAssociatedPtr = AIWriterAssociatedPtr;
})();