// third_party/blink/public/mojom/ai/ai_summarizer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ModelStreamingResponder');
goog.require('blink.mojom.AILanguageCode');




goog.provide('blink.mojom.AISummarizerType');
goog.provide('blink.mojom.AISummarizerTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AISummarizerTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AISummarizerType = {
  
  kTLDR: 0,
  kKeyPoints: 1,
  kTeaser: 2,
  kHeadline: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.AISummarizerFormat');
goog.provide('blink.mojom.AISummarizerFormatSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AISummarizerFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AISummarizerFormat = {
  
  kPlainText: 0,
  kMarkDown: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.AISummarizerLength');
goog.provide('blink.mojom.AISummarizerLengthSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AISummarizerLengthSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AISummarizerLength = {
  
  kShort: 0,
  kMedium: 1,
  kLong: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.AISummarizer');
goog.provide('blink.mojom.AISummarizerReceiver');
goog.provide('blink.mojom.AISummarizerCallbackRouter');
goog.provide('blink.mojom.AISummarizerInterface');
goog.provide('blink.mojom.AISummarizerRemote');
goog.provide('blink.mojom.AISummarizerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AISummarizerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AISummarizer.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AISummarizerInterface = class {
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  summarize(input, context, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(input, context) {}
};

/**
 * @export
 * @implements { blink.mojom.AISummarizerInterface }
 */
blink.mojom.AISummarizerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AISummarizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AISummarizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AISummarizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  summarize(
      input,
      context,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AISummarizer_Summarize_ParamsSpec.$,
        null,
        [
          input,
          context,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(
      input,
      context) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.AISummarizer_MeasureUsage_ParamsSpec.$,
        blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        [
          input,
          context
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AISummarizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AISummarizerReceiver = class {
  /**
   * @param {!blink.mojom.AISummarizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AISummarizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AISummarizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AISummarizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AISummarizer_Summarize_ParamsSpec.$,
        null,
        impl.summarize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AISummarizer_MeasureUsage_ParamsSpec.$,
        blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        impl.measureUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AISummarizer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AISummarizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AISummarizerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AISummarizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AISummarizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AISummarizerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AISummarizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AISummarizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.summarize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AISummarizer_Summarize_ParamsSpec.$,
        null,
        this.summarize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AISummarizer_MeasureUsage_ParamsSpec.$,
        blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec.$,
        this.measureUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AISummarizerCreateOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AISummarizerCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AISummarizer_Summarize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AISummarizer_Summarize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AISummarizer_MeasureUsage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AISummarizer_MeasureUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AISummarizerCreateOptionsSpec.$,
    'AISummarizerCreateOptions',
    [
      mojo.internal.StructField(
        'sharedContext', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        blink.mojom.AISummarizerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'format', 12,
        0,
        blink.mojom.AISummarizerFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        blink.mojom.AISummarizerLengthSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 24,
        0,
        mojo.internal.Array(blink.mojom.AILanguageCodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedContextLanguages', 32,
        0,
        mojo.internal.Array(blink.mojom.AILanguageCodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputLanguage', 40,
        0,
        blink.mojom.AILanguageCodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.AISummarizerCreateOptions');

/** @record */
blink.mojom.AISummarizerCreateOptions = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.sharedContext;
    /** @export { !blink.mojom.AISummarizerType } */
    this.type;
    /** @export { !blink.mojom.AISummarizerFormat } */
    this.format;
    /** @export { !blink.mojom.AISummarizerLength } */
    this.length;
    /** @export { !Array<!blink.mojom.AILanguageCode> } */
    this.expectedInputLanguages;
    /** @export { !Array<!blink.mojom.AILanguageCode> } */
    this.expectedContextLanguages;
    /** @export { !blink.mojom.AILanguageCode } */
    this.outputLanguage;
  }
};



mojo.internal.Struct(
    blink.mojom.AISummarizer_Summarize_ParamsSpec.$,
    'AISummarizer_Summarize_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 16,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AISummarizer_Summarize_Params');

/** @record */
blink.mojom.AISummarizer_Summarize_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !string } */
    this.context;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};



mojo.internal.Struct(
    blink.mojom.AISummarizer_MeasureUsage_ParamsSpec.$,
    'AISummarizer_MeasureUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AISummarizer_MeasureUsage_Params');

/** @record */
blink.mojom.AISummarizer_MeasureUsage_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !string } */
    this.context;
  }
};



mojo.internal.Struct(
    blink.mojom.AISummarizer_MeasureUsage_ResponseParamsSpec.$,
    'AISummarizer_MeasureUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AISummarizer_MeasureUsage_ResponseParams');

/** @record */
blink.mojom.AISummarizer_MeasureUsage_ResponseParams = class {
  constructor() {
    /** @export { (number|undefined) } */
    this.numberOfTokens;
  }
};

