// third_party/blink/public/mojom/ai/ai_rewriter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/ai/ai_common.mojom-shared.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AIRewriterTone>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AIRewriterTone> {};

template <>
struct hash<::blink::mojom::AIRewriterFormat>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AIRewriterFormat> {};

template <>
struct hash<::blink::mojom::AIRewriterLength>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AIRewriterLength> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AIRewriterTone, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AIRewriterTone, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AIRewriterTone>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AIRewriterFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AIRewriterFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AIRewriterFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AIRewriterLength, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AIRewriterLength, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AIRewriterLength>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AIRewriterCreateOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AIRewriterCreateOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AIRewriterCreateOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::shared_context(input)) in_shared_context = Traits::shared_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_context)::BaseType> shared_context_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_shared_context,
      shared_context_fragment);

    fragment->shared_context.Set(
        shared_context_fragment.is_null() ? nullptr : shared_context_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::AIRewriterTone>(
      Traits::tone(input),
      &fragment->tone);

    
    mojo::internal::Serialize<::blink::mojom::AIRewriterFormat>(
      Traits::format(input),
      &fragment->format);

    
    mojo::internal::Serialize<::blink::mojom::AIRewriterLength>(
      Traits::length(input),
      &fragment->length);

    decltype(Traits::expected_input_languages(input)) in_expected_input_languages = Traits::expected_input_languages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_input_languages)::BaseType>
        expected_input_languages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_input_languages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>>(
      in_expected_input_languages,
      expected_input_languages_fragment,
      &expected_input_languages_validate_params);

    fragment->expected_input_languages.Set(
        expected_input_languages_fragment.is_null() ? nullptr : expected_input_languages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expected_input_languages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_input_languages in AIRewriterCreateOptions struct");

    decltype(Traits::expected_context_languages(input)) in_expected_context_languages = Traits::expected_context_languages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_context_languages)::BaseType>
        expected_context_languages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_context_languages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>>(
      in_expected_context_languages,
      expected_context_languages_fragment,
      &expected_context_languages_validate_params);

    fragment->expected_context_languages.Set(
        expected_context_languages_fragment.is_null() ? nullptr : expected_context_languages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expected_context_languages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expected_context_languages in AIRewriterCreateOptions struct");

    decltype(Traits::output_language(input)) in_output_language = Traits::output_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_language)::BaseType> output_language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AILanguageCodeDataView>(
      in_output_language,
      output_language_fragment);

    fragment->output_language.Set(
        output_language_fragment.is_null() ? nullptr : output_language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_language in AIRewriterCreateOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::AIRewriterCreateOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AIRewriterCreateOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AIRewriterCreateOptionsDataView::GetSharedContextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shared_context.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AIRewriterCreateOptionsDataView::GetExpectedInputLanguagesDataView(
    mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>* output) {
  auto pointer = data_->expected_input_languages.Get();
  *output = mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>(pointer, message_);
}
inline void AIRewriterCreateOptionsDataView::GetExpectedContextLanguagesDataView(
    mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>* output) {
  auto pointer = data_->expected_context_languages.Get();
  *output = mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>(pointer, message_);
}
inline void AIRewriterCreateOptionsDataView::GetOutputLanguageDataView(
    ::blink::mojom::AILanguageCodeDataView* output) {
  auto pointer = data_->output_language.Get();
  *output = ::blink::mojom::AILanguageCodeDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AIRewriterTone> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AIRewriterTone value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AIRewriterFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AIRewriterFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AIRewriterLength> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AIRewriterLength value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_REWRITER_MOJOM_SHARED_H_