// third_party/blink/public/mojom/ai/ai_language_model.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_language_model.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var on_device_model$ =
      mojo.internal.exposeNamespace('onDeviceModel.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/on_device_model/public/mojom/on_device_model.mojom', '../../../../../services/on_device_model/public/mojom/on_device_model.mojom.js');
  }
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', 'model_streaming_responder.mojom.js');
  }


  var AILanguageModelPromptRole = {};
  AILanguageModelPromptRole.kSystem = 0;
  AILanguageModelPromptRole.kUser = 1;
  AILanguageModelPromptRole.kAssistant = 2;
  AILanguageModelPromptRole.kToolCall = 3;
  AILanguageModelPromptRole.kToolResponse = 4;
  AILanguageModelPromptRole.MIN_VALUE = 0;
  AILanguageModelPromptRole.MAX_VALUE = 4;

  AILanguageModelPromptRole.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AILanguageModelPromptRole.toKnownEnumValue = function(value) {
    return value;
  };

  AILanguageModelPromptRole.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AILanguageModelPromptType = {};
  AILanguageModelPromptType.kText = 0;
  AILanguageModelPromptType.kImage = 1;
  AILanguageModelPromptType.kAudio = 2;
  AILanguageModelPromptType.kToolCall = 3;
  AILanguageModelPromptType.kToolResponse = 4;
  AILanguageModelPromptType.MIN_VALUE = 0;
  AILanguageModelPromptType.MAX_VALUE = 4;

  AILanguageModelPromptType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AILanguageModelPromptType.toKnownEnumValue = function(value) {
    return value;
  };

  AILanguageModelPromptType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AILanguageModelSamplingParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelSamplingParams.prototype.initDefaults_ = function() {
    this.topK = 0;
    this.temperature = 0;
  };
  AILanguageModelSamplingParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelSamplingParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AILanguageModelSamplingParams.encodedSize = codec.kStructHeaderSize + 8;

  AILanguageModelSamplingParams.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelSamplingParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.topK =
        decoder.decodeStruct(codec.Uint32);
    val.temperature =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  AILanguageModelSamplingParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelSamplingParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.topK);
    encoder.encodeStruct(codec.Float, val.temperature);
  };
  function AILanguageModelParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelParams.prototype.initDefaults_ = function() {
    this.defaultSamplingParams = null;
    this.maxSamplingParams = null;
  };
  AILanguageModelParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelParams.defaultSamplingParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AILanguageModelSamplingParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelParams.maxSamplingParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AILanguageModelSamplingParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModelParams.encodedSize = codec.kStructHeaderSize + 16;

  AILanguageModelParams.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.defaultSamplingParams =
        decoder.decodeStructPointer(AILanguageModelSamplingParams);
    val.maxSamplingParams =
        decoder.decodeStructPointer(AILanguageModelSamplingParams);
    return val;
  };

  AILanguageModelParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AILanguageModelSamplingParams, val.defaultSamplingParams);
    encoder.encodeStructPointer(AILanguageModelSamplingParams, val.maxSamplingParams);
  };
  function AILanguageModelInstanceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelInstanceInfo.prototype.initDefaults_ = function() {
    this.inputQuota = 0;
    this.inputUsage = 0;
    this.samplingParams = null;
    this.inputTypes = null;
  };
  AILanguageModelInstanceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelInstanceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AILanguageModelInstanceInfo.samplingParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AILanguageModelSamplingParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelInstanceInfo.inputTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, new codec.Enum(AILanguageModelPromptType), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModelInstanceInfo.encodedSize = codec.kStructHeaderSize + 32;

  AILanguageModelInstanceInfo.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelInstanceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputQuota =
        decoder.decodeStruct(codec.Uint64);
    val.inputUsage =
        decoder.decodeStruct(codec.Uint64);
    val.samplingParams =
        decoder.decodeStructPointer(AILanguageModelSamplingParams);
    val.inputTypes =
        decoder.decodeArrayPointer(new codec.Enum(AILanguageModelPromptType));
    return val;
  };

  AILanguageModelInstanceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelInstanceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.inputQuota);
    encoder.encodeStruct(codec.Uint64, val.inputUsage);
    encoder.encodeStructPointer(AILanguageModelSamplingParams, val.samplingParams);
    encoder.encodeArrayPointer(new codec.Enum(AILanguageModelPromptType), val.inputTypes);
  };
  function AILanguageModelExpected(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelExpected.prototype.initDefaults_ = function() {
    this.type = 0;
    this.languages = null;
  };
  AILanguageModelExpected.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelExpected.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelExpected.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AILanguageModelPromptType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelExpected.languages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(ai_common$.AILanguageCode), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModelExpected.encodedSize = codec.kStructHeaderSize + 16;

  AILanguageModelExpected.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelExpected();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(AILanguageModelPromptType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.languages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    return val;
  };

  AILanguageModelExpected.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelExpected.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.languages);
  };
  function AILanguageModelPrompt(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelPrompt.prototype.initDefaults_ = function() {
    this.role = 0;
    this.isPrefix = false;
    this.content = null;
  };
  AILanguageModelPrompt.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelPrompt.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelPrompt.role
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AILanguageModelPromptRole);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelPrompt.content
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, AILanguageModelPromptContent, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AILanguageModelPrompt.encodedSize = codec.kStructHeaderSize + 16;

  AILanguageModelPrompt.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelPrompt();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.role =
        decoder.decodeStruct(new codec.Enum(AILanguageModelPromptRole));
    packed = decoder.readUint8();
    val.isPrefix = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.content =
        decoder.decodeArrayPointer(AILanguageModelPromptContent);
    return val;
  };

  AILanguageModelPrompt.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelPrompt.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.role);
    packed = 0;
    packed |= (val.isPrefix & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(AILanguageModelPromptContent, val.content);
  };
  function AILanguageModelCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModelCreateOptions.prototype.initDefaults_ = function() {
    this.samplingParams = null;
    this.initialPrompts = null;
    this.expectedInputs = null;
    this.expectedOutputs = null;
  };
  AILanguageModelCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModelCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelCreateOptions.samplingParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AILanguageModelSamplingParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelCreateOptions.initialPrompts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(AILanguageModelPrompt), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelCreateOptions.expectedInputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(AILanguageModelExpected), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModelCreateOptions.expectedOutputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(AILanguageModelExpected), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModelCreateOptions.encodedSize = codec.kStructHeaderSize + 32;

  AILanguageModelCreateOptions.decode = function(decoder) {
    var packed;
    var val = new AILanguageModelCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.samplingParams =
        decoder.decodeStructPointer(AILanguageModelSamplingParams);
    val.initialPrompts =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt));
    val.expectedInputs =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelExpected));
    val.expectedOutputs =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelExpected));
    return val;
  };

  AILanguageModelCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModelCreateOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AILanguageModelSamplingParams, val.samplingParams);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt), val.initialPrompts);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelExpected), val.expectedInputs);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelExpected), val.expectedOutputs);
  };
  function AIManagerCreateLanguageModelClient_OnResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateLanguageModelClient_OnResult_Params.prototype.initDefaults_ = function() {
    this.languageModelRemote = new AILanguageModelPtr();
    this.info = null;
  };
  AIManagerCreateLanguageModelClient_OnResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateLanguageModelClient_OnResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateLanguageModelClient_OnResult_Params.languageModelRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateLanguageModelClient_OnResult_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AILanguageModelInstanceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateLanguageModelClient_OnResult_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateLanguageModelClient_OnResult_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateLanguageModelClient_OnResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.languageModelRemote =
        decoder.decodeStruct(new codec.Interface(AILanguageModelPtr));
    val.info =
        decoder.decodeStructPointer(AILanguageModelInstanceInfo);
    return val;
  };

  AIManagerCreateLanguageModelClient_OnResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateLanguageModelClient_OnResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AILanguageModelPtr), val.languageModelRemote);
    encoder.encodeStructPointer(AILanguageModelInstanceInfo, val.info);
  };
  function AIManagerCreateLanguageModelClient_OnError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIManagerCreateLanguageModelClient_OnError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
    this.quotaErrorInfo = null;
  };
  AIManagerCreateLanguageModelClient_OnError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIManagerCreateLanguageModelClient_OnError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateLanguageModelClient_OnError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ai_common$.AIManagerCreateClientError);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIManagerCreateLanguageModelClient_OnError_Params.quotaErrorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ai_common$.QuotaErrorInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIManagerCreateLanguageModelClient_OnError_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIManagerCreateLanguageModelClient_OnError_Params.decode = function(decoder) {
    var packed;
    var val = new AIManagerCreateLanguageModelClient_OnError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(ai_common$.AIManagerCreateClientError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quotaErrorInfo =
        decoder.decodeStructPointer(ai_common$.QuotaErrorInfo);
    return val;
  };

  AIManagerCreateLanguageModelClient_OnError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIManagerCreateLanguageModelClient_OnError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ai_common$.QuotaErrorInfo, val.quotaErrorInfo);
  };
  function AILanguageModel_Prompt_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_Prompt_Params.prototype.initDefaults_ = function() {
    this.prompts = null;
    this.constraint = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AILanguageModel_Prompt_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_Prompt_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Prompt_Params.prompts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AILanguageModelPrompt), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Prompt_Params.constraint
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, on_device_model$.ResponseConstraint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Prompt_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModel_Prompt_Params.encodedSize = codec.kStructHeaderSize + 32;

  AILanguageModel_Prompt_Params.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_Prompt_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prompts =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt));
    val.constraint =
        decoder.decodeStruct(on_device_model$.ResponseConstraint);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AILanguageModel_Prompt_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_Prompt_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt), val.prompts);
    encoder.encodeStruct(on_device_model$.ResponseConstraint, val.constraint);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function AILanguageModel_Append_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_Append_Params.prototype.initDefaults_ = function() {
    this.prompts = null;
    this.client = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AILanguageModel_Append_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_Append_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Append_Params.prompts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AILanguageModelPrompt), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Append_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModel_Append_Params.encodedSize = codec.kStructHeaderSize + 16;

  AILanguageModel_Append_Params.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_Append_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prompts =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt));
    val.client =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AILanguageModel_Append_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_Append_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt), val.prompts);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.client);
  };
  function AILanguageModel_Fork_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_Fork_Params.prototype.initDefaults_ = function() {
    this.client = new AIManagerCreateLanguageModelClientPtr();
  };
  AILanguageModel_Fork_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_Fork_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_Fork_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModel_Fork_Params.encodedSize = codec.kStructHeaderSize + 8;

  AILanguageModel_Fork_Params.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_Fork_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(AIManagerCreateLanguageModelClientPtr));
    return val;
  };

  AILanguageModel_Fork_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_Fork_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AIManagerCreateLanguageModelClientPtr), val.client);
  };
  function AILanguageModel_Destroy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_Destroy_Params.prototype.initDefaults_ = function() {
  };
  AILanguageModel_Destroy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_Destroy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModel_Destroy_Params.encodedSize = codec.kStructHeaderSize + 0;

  AILanguageModel_Destroy_Params.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_Destroy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AILanguageModel_Destroy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_Destroy_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AILanguageModel_MeasureInputUsage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_MeasureInputUsage_Params.prototype.initDefaults_ = function() {
    this.input = null;
  };
  AILanguageModel_MeasureInputUsage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_MeasureInputUsage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageModel_MeasureInputUsage_Params.input
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AILanguageModelPrompt), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageModel_MeasureInputUsage_Params.encodedSize = codec.kStructHeaderSize + 8;

  AILanguageModel_MeasureInputUsage_Params.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_MeasureInputUsage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt));
    return val;
  };

  AILanguageModel_MeasureInputUsage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_MeasureInputUsage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AILanguageModelPrompt), val.input);
  };
  function AILanguageModel_MeasureInputUsage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageModel_MeasureInputUsage_ResponseParams.prototype.initDefaults_ = function() {
    this.number_of_tokens_$flag = false;
    this.number_of_tokens_$value = 0;
  };
  AILanguageModel_MeasureInputUsage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageModel_MeasureInputUsage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AILanguageModel_MeasureInputUsage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AILanguageModel_MeasureInputUsage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AILanguageModel_MeasureInputUsage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.number_of_tokens_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.number_of_tokens_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AILanguageModel_MeasureInputUsage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageModel_MeasureInputUsage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.number_of_tokens_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.number_of_tokens_$value);
  };

  function AILanguageModelPromptContent(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AILanguageModelPromptContent.Tags = {
    text: 0,
    bitmap: 1,
    audio: 2,
  };

  AILanguageModelPromptContent.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AILanguageModelPromptContent.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "text",
        "bitmap",
        "audio",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AILanguageModelPromptContent member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AILanguageModelPromptContent.prototype, "text", {
    get: function() {
      if (this.$tag != AILanguageModelPromptContent.Tags.text) {
        throw new ReferenceError(
            "AILanguageModelPromptContent.text is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AILanguageModelPromptContent.Tags.text;
      this.$data = value;
    }
  });
  Object.defineProperty(AILanguageModelPromptContent.prototype, "bitmap", {
    get: function() {
      if (this.$tag != AILanguageModelPromptContent.Tags.bitmap) {
        throw new ReferenceError(
            "AILanguageModelPromptContent.bitmap is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AILanguageModelPromptContent.Tags.bitmap;
      this.$data = value;
    }
  });
  Object.defineProperty(AILanguageModelPromptContent.prototype, "audio", {
    get: function() {
      if (this.$tag != AILanguageModelPromptContent.Tags.audio) {
        throw new ReferenceError(
            "AILanguageModelPromptContent.audio is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AILanguageModelPromptContent.Tags.audio;
      this.$data = value;
    }
  });


    AILanguageModelPromptContent.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AILanguageModelPromptContent.Tags.text:
          encoder.encodeStruct(codec.String, val.text);
          break;
        case AILanguageModelPromptContent.Tags.bitmap:
          encoder.encodeStructPointer(bitmap$.BitmapN32, val.bitmap);
          break;
        case AILanguageModelPromptContent.Tags.audio:
          encoder.encodeStructPointer(on_device_model$.AudioData, val.audio);
          break;
      }
      encoder.align();
    };


    AILanguageModelPromptContent.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AILanguageModelPromptContent();
      var tag = decoder.readUint32();
      switch (tag) {
        case AILanguageModelPromptContent.Tags.text:
          result.text = decoder.decodeStruct(codec.String);
          break;
        case AILanguageModelPromptContent.Tags.bitmap:
          result.bitmap = decoder.decodeStructPointer(bitmap$.BitmapN32);
          break;
        case AILanguageModelPromptContent.Tags.audio:
          result.audio = decoder.decodeStructPointer(on_device_model$.AudioData);
          break;
      }
      decoder.align();

      return result;
    };


    AILanguageModelPromptContent.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AILanguageModelPromptContent.Tags.text:
          

    // validate AILanguageModelPromptContent.text
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AILanguageModelPromptContent.Tags.bitmap:
          

    // validate AILanguageModelPromptContent.bitmap
    err = messageValidator.validateStructPointer(data_offset, bitmap$.BitmapN32, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AILanguageModelPromptContent.Tags.audio:
          

    // validate AILanguageModelPromptContent.audio
    err = messageValidator.validateStructPointer(data_offset, on_device_model$.AudioData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AILanguageModelPromptContent.encodedSize = 16;
  var kAIManagerCreateLanguageModelClient_OnResult_Name = 0;
  var kAIManagerCreateLanguageModelClient_OnError_Name = 1;

  function AIManagerCreateLanguageModelClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIManagerCreateLanguageModelClient,
                                                   handleOrPtrInfo);
  }

  function AIManagerCreateLanguageModelClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIManagerCreateLanguageModelClient, associatedInterfacePtrInfo);
  }

  AIManagerCreateLanguageModelClientAssociatedPtr.prototype =
      Object.create(AIManagerCreateLanguageModelClientPtr.prototype);
  AIManagerCreateLanguageModelClientAssociatedPtr.prototype.constructor =
      AIManagerCreateLanguageModelClientAssociatedPtr;

  function AIManagerCreateLanguageModelClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIManagerCreateLanguageModelClientPtr.prototype.onResult = function() {
    return AIManagerCreateLanguageModelClientProxy.prototype.onResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateLanguageModelClientProxy.prototype.onResult = function(languageModelRemote, info) {
    var params_ = new AIManagerCreateLanguageModelClient_OnResult_Params();
    params_.languageModelRemote = languageModelRemote;
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateLanguageModelClient_OnResult_Name,
        codec.align(AIManagerCreateLanguageModelClient_OnResult_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateLanguageModelClient_OnResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIManagerCreateLanguageModelClientPtr.prototype.onError = function() {
    return AIManagerCreateLanguageModelClientProxy.prototype.onError
        .apply(this.ptr.getProxy(), arguments);
  };

  AIManagerCreateLanguageModelClientProxy.prototype.onError = function(error, quotaErrorInfo) {
    var params_ = new AIManagerCreateLanguageModelClient_OnError_Params();
    params_.error = error;
    params_.quotaErrorInfo = quotaErrorInfo;
    var builder = new codec.MessageV0Builder(
        kAIManagerCreateLanguageModelClient_OnError_Name,
        codec.align(AIManagerCreateLanguageModelClient_OnError_Params.encodedSize));
    builder.encodeStruct(AIManagerCreateLanguageModelClient_OnError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AIManagerCreateLanguageModelClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AIManagerCreateLanguageModelClientStub.prototype.onResult = function(languageModelRemote, info) {
    return this.delegate_ && this.delegate_.onResult && this.delegate_.onResult(languageModelRemote, info);
  }
  AIManagerCreateLanguageModelClientStub.prototype.onError = function(error, quotaErrorInfo) {
    return this.delegate_ && this.delegate_.onError && this.delegate_.onError(error, quotaErrorInfo);
  }

  AIManagerCreateLanguageModelClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIManagerCreateLanguageModelClient_OnResult_Name:
      var params = reader.decodeStruct(AIManagerCreateLanguageModelClient_OnResult_Params);
      this.onResult(params.languageModelRemote, params.info);
      return true;
    case kAIManagerCreateLanguageModelClient_OnError_Name:
      var params = reader.decodeStruct(AIManagerCreateLanguageModelClient_OnError_Params);
      this.onError(params.error, params.quotaErrorInfo);
      return true;
    default:
      return false;
    }
  };

  AIManagerCreateLanguageModelClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAIManagerCreateLanguageModelClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIManagerCreateLanguageModelClient_OnResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateLanguageModelClient_OnResult_Params;
      break;
      case kAIManagerCreateLanguageModelClient_OnError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIManagerCreateLanguageModelClient_OnError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIManagerCreateLanguageModelClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AIManagerCreateLanguageModelClient = {
    name: 'blink.mojom.AIManagerCreateLanguageModelClient',
    kVersion: 0,
    ptrClass: AIManagerCreateLanguageModelClientPtr,
    proxyClass: AIManagerCreateLanguageModelClientProxy,
    stubClass: AIManagerCreateLanguageModelClientStub,
    validateRequest: validateAIManagerCreateLanguageModelClientRequest,
    validateResponse: null,
  };
  AIManagerCreateLanguageModelClientStub.prototype.validator = validateAIManagerCreateLanguageModelClientRequest;
  AIManagerCreateLanguageModelClientProxy.prototype.validator = null;
  var kAILanguageModel_Prompt_Name = 0;
  var kAILanguageModel_Append_Name = 1;
  var kAILanguageModel_Fork_Name = 2;
  var kAILanguageModel_Destroy_Name = 3;
  var kAILanguageModel_MeasureInputUsage_Name = 4;

  function AILanguageModelPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AILanguageModel,
                                                   handleOrPtrInfo);
  }

  function AILanguageModelAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AILanguageModel, associatedInterfacePtrInfo);
  }

  AILanguageModelAssociatedPtr.prototype =
      Object.create(AILanguageModelPtr.prototype);
  AILanguageModelAssociatedPtr.prototype.constructor =
      AILanguageModelAssociatedPtr;

  function AILanguageModelProxy(receiver) {
    this.receiver_ = receiver;
  }
  AILanguageModelPtr.prototype.prompt = function() {
    return AILanguageModelProxy.prototype.prompt
        .apply(this.ptr.getProxy(), arguments);
  };

  AILanguageModelProxy.prototype.prompt = function(prompts, constraint, pendingResponder) {
    var params_ = new AILanguageModel_Prompt_Params();
    params_.prompts = prompts;
    params_.constraint = constraint;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAILanguageModel_Prompt_Name,
        codec.align(AILanguageModel_Prompt_Params.encodedSize));
    builder.encodeStruct(AILanguageModel_Prompt_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AILanguageModelPtr.prototype.append = function() {
    return AILanguageModelProxy.prototype.append
        .apply(this.ptr.getProxy(), arguments);
  };

  AILanguageModelProxy.prototype.append = function(prompts, client) {
    var params_ = new AILanguageModel_Append_Params();
    params_.prompts = prompts;
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kAILanguageModel_Append_Name,
        codec.align(AILanguageModel_Append_Params.encodedSize));
    builder.encodeStruct(AILanguageModel_Append_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AILanguageModelPtr.prototype.fork = function() {
    return AILanguageModelProxy.prototype.fork
        .apply(this.ptr.getProxy(), arguments);
  };

  AILanguageModelProxy.prototype.fork = function(client) {
    var params_ = new AILanguageModel_Fork_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kAILanguageModel_Fork_Name,
        codec.align(AILanguageModel_Fork_Params.encodedSize));
    builder.encodeStruct(AILanguageModel_Fork_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AILanguageModelPtr.prototype.destroy = function() {
    return AILanguageModelProxy.prototype.destroy
        .apply(this.ptr.getProxy(), arguments);
  };

  AILanguageModelProxy.prototype.destroy = function() {
    var params_ = new AILanguageModel_Destroy_Params();
    var builder = new codec.MessageV0Builder(
        kAILanguageModel_Destroy_Name,
        codec.align(AILanguageModel_Destroy_Params.encodedSize));
    builder.encodeStruct(AILanguageModel_Destroy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AILanguageModelPtr.prototype.measureInputUsage = function() {
    return AILanguageModelProxy.prototype.measureInputUsage
        .apply(this.ptr.getProxy(), arguments);
  };

  AILanguageModelProxy.prototype.measureInputUsage = function(input) {
    var params_ = new AILanguageModel_MeasureInputUsage_Params();
    params_.input = input;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAILanguageModel_MeasureInputUsage_Name,
          codec.align(AILanguageModel_MeasureInputUsage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AILanguageModel_MeasureInputUsage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AILanguageModel_MeasureInputUsage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AILanguageModelStub(delegate) {
    this.delegate_ = delegate;
  }
  AILanguageModelStub.prototype.prompt = function(prompts, constraint, pendingResponder) {
    return this.delegate_ && this.delegate_.prompt && this.delegate_.prompt(prompts, constraint, pendingResponder);
  }
  AILanguageModelStub.prototype.append = function(prompts, client) {
    return this.delegate_ && this.delegate_.append && this.delegate_.append(prompts, client);
  }
  AILanguageModelStub.prototype.fork = function(client) {
    return this.delegate_ && this.delegate_.fork && this.delegate_.fork(client);
  }
  AILanguageModelStub.prototype.destroy = function() {
    return this.delegate_ && this.delegate_.destroy && this.delegate_.destroy();
  }
  AILanguageModelStub.prototype.measureInputUsage = function(input) {
    return this.delegate_ && this.delegate_.measureInputUsage && this.delegate_.measureInputUsage(input);
  }

  AILanguageModelStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAILanguageModel_Prompt_Name:
      var params = reader.decodeStruct(AILanguageModel_Prompt_Params);
      this.prompt(params.prompts, params.constraint, params.pendingResponder);
      return true;
    case kAILanguageModel_Append_Name:
      var params = reader.decodeStruct(AILanguageModel_Append_Params);
      this.append(params.prompts, params.client);
      return true;
    case kAILanguageModel_Fork_Name:
      var params = reader.decodeStruct(AILanguageModel_Fork_Params);
      this.fork(params.client);
      return true;
    case kAILanguageModel_Destroy_Name:
      var params = reader.decodeStruct(AILanguageModel_Destroy_Params);
      this.destroy();
      return true;
    default:
      return false;
    }
  };

  AILanguageModelStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAILanguageModel_MeasureInputUsage_Name:
      var params = reader.decodeStruct(AILanguageModel_MeasureInputUsage_Params);
      this.measureInputUsage(params.input).then(function(response) {
        var responseParams =
            new AILanguageModel_MeasureInputUsage_ResponseParams();
        responseParams.numberOfTokens = response.numberOfTokens;
        var builder = new codec.MessageV1Builder(
            kAILanguageModel_MeasureInputUsage_Name,
            codec.align(AILanguageModel_MeasureInputUsage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AILanguageModel_MeasureInputUsage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAILanguageModelRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAILanguageModel_Prompt_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AILanguageModel_Prompt_Params;
      break;
      case kAILanguageModel_Append_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AILanguageModel_Append_Params;
      break;
      case kAILanguageModel_Fork_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AILanguageModel_Fork_Params;
      break;
      case kAILanguageModel_Destroy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AILanguageModel_Destroy_Params;
      break;
      case kAILanguageModel_MeasureInputUsage_Name:
        if (message.expectsResponse())
          paramsClass = AILanguageModel_MeasureInputUsage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAILanguageModelResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAILanguageModel_MeasureInputUsage_Name:
        if (message.isResponse())
          paramsClass = AILanguageModel_MeasureInputUsage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AILanguageModel = {
    name: 'blink.mojom.AILanguageModel',
    kVersion: 0,
    ptrClass: AILanguageModelPtr,
    proxyClass: AILanguageModelProxy,
    stubClass: AILanguageModelStub,
    validateRequest: validateAILanguageModelRequest,
    validateResponse: validateAILanguageModelResponse,
  };
  AILanguageModelStub.prototype.validator = validateAILanguageModelRequest;
  AILanguageModelProxy.prototype.validator = validateAILanguageModelResponse;
  exports.AILanguageModelPromptRole = AILanguageModelPromptRole;
  exports.AILanguageModelPromptType = AILanguageModelPromptType;
  exports.AILanguageModelSamplingParams = AILanguageModelSamplingParams;
  exports.AILanguageModelParams = AILanguageModelParams;
  exports.AILanguageModelInstanceInfo = AILanguageModelInstanceInfo;
  exports.AILanguageModelExpected = AILanguageModelExpected;
  exports.AILanguageModelPrompt = AILanguageModelPrompt;
  exports.AILanguageModelCreateOptions = AILanguageModelCreateOptions;
  exports.AILanguageModelPromptContent = AILanguageModelPromptContent;
  exports.AIManagerCreateLanguageModelClient = AIManagerCreateLanguageModelClient;
  exports.AIManagerCreateLanguageModelClientPtr = AIManagerCreateLanguageModelClientPtr;
  exports.AIManagerCreateLanguageModelClientAssociatedPtr = AIManagerCreateLanguageModelClientAssociatedPtr;
  exports.AILanguageModel = AILanguageModel;
  exports.AILanguageModelPtr = AILanguageModelPtr;
  exports.AILanguageModelAssociatedPtr = AILanguageModelAssociatedPtr;
})();