// third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared-internal.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/ai/ai_common.mojom-shared.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AILanguageModelPromptRole>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AILanguageModelPromptRole> {};

template <>
struct hash<::blink::mojom::AILanguageModelPromptType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AILanguageModelPromptType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelPromptRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AILanguageModelPromptRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AILanguageModelPromptRole>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelPromptType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AILanguageModelPromptType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AILanguageModelPromptType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelSamplingParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelSamplingParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelSamplingParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->top_k = Traits::top_k(input);

    fragment->temperature = Traits::temperature(input);
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelSamplingParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelSamplingParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::default_sampling_params(input)) in_default_sampling_params = Traits::default_sampling_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_sampling_params)::BaseType> default_sampling_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
      in_default_sampling_params,
      default_sampling_params_fragment);

    fragment->default_sampling_params.Set(
        default_sampling_params_fragment.is_null() ? nullptr : default_sampling_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_sampling_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_sampling_params in AILanguageModelParams struct");

    decltype(Traits::max_sampling_params(input)) in_max_sampling_params = Traits::max_sampling_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_sampling_params)::BaseType> max_sampling_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
      in_max_sampling_params,
      max_sampling_params_fragment);

    fragment->max_sampling_params.Set(
        max_sampling_params_fragment.is_null() ? nullptr : max_sampling_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_sampling_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_sampling_params in AILanguageModelParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelInstanceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelInstanceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelInstanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->input_quota = Traits::input_quota(input);

    fragment->input_usage = Traits::input_usage(input);

    decltype(Traits::sampling_params(input)) in_sampling_params = Traits::sampling_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sampling_params)::BaseType> sampling_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
      in_sampling_params,
      sampling_params_fragment);

    fragment->sampling_params.Set(
        sampling_params_fragment.is_null() ? nullptr : sampling_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sampling_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sampling_params in AILanguageModelInstanceInfo struct");

    decltype(Traits::input_types(input)) in_input_types = Traits::input_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_types)::BaseType>
        input_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_types_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AILanguageModelPromptType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptType>>(
      in_input_types,
      input_types_fragment,
      &input_types_validate_params);

    fragment->input_types.Set(
        input_types_fragment.is_null() ? nullptr : input_types_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelInstanceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelInstanceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelExpectedDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelExpectedDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelExpected_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelPromptType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::languages(input)) in_languages = Traits::languages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->languages)::BaseType>
        languages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& languages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>>(
      in_languages,
      languages_fragment,
      &languages_validate_params);

    fragment->languages.Set(
        languages_fragment.is_null() ? nullptr : languages_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelExpected_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelExpectedDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelPromptDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelPromptDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelPrompt_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelPromptRole>(
      Traits::role(input),
      &fragment->role);

    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType>
        content_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptContentDataView>>(
      in_content,
      content_fragment,
      &content_validate_params);

    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in AILanguageModelPrompt struct");

    fragment->is_prefix = Traits::is_prefix(input);
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelPrompt_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelPromptDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelCreateOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AILanguageModelCreateOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AILanguageModelCreateOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sampling_params(input)) in_sampling_params = Traits::sampling_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sampling_params)::BaseType> sampling_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AILanguageModelSamplingParamsDataView>(
      in_sampling_params,
      sampling_params_fragment);

    fragment->sampling_params.Set(
        sampling_params_fragment.is_null() ? nullptr : sampling_params_fragment.data());

    decltype(Traits::initial_prompts(input)) in_initial_prompts = Traits::initial_prompts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_prompts)::BaseType>
        initial_prompts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& initial_prompts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelPromptDataView>>(
      in_initial_prompts,
      initial_prompts_fragment,
      &initial_prompts_validate_params);

    fragment->initial_prompts.Set(
        initial_prompts_fragment.is_null() ? nullptr : initial_prompts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initial_prompts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initial_prompts in AILanguageModelCreateOptions struct");

    decltype(Traits::expected_inputs(input)) in_expected_inputs = Traits::expected_inputs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_inputs)::BaseType>
        expected_inputs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_inputs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>>(
      in_expected_inputs,
      expected_inputs_fragment,
      &expected_inputs_validate_params);

    fragment->expected_inputs.Set(
        expected_inputs_fragment.is_null() ? nullptr : expected_inputs_fragment.data());

    decltype(Traits::expected_outputs(input)) in_expected_outputs = Traits::expected_outputs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_outputs)::BaseType>
        expected_outputs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_outputs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AILanguageModelExpectedDataView>>(
      in_expected_outputs,
      expected_outputs_fragment,
      &expected_outputs_validate_params);

    fragment->expected_outputs.Set(
        expected_outputs_fragment.is_null() ? nullptr : expected_outputs_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelCreateOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelCreateOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AILanguageModelPromptContentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::AILanguageModelPromptContentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::AILanguageModelPromptContent_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::AILanguageModelPromptContentDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in AILanguageModelPromptContent union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::AILanguageModelPromptContentDataView::Tag::kBitmap: {
    decltype(Traits::bitmap(input))
    in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bitmap)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
  in_bitmap,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bitmap in AILanguageModelPromptContent union");
    fragment->data.f_bitmap.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::AILanguageModelPromptContentDataView::Tag::kAudio: {
    decltype(Traits::audio(input))
    in_audio = Traits::audio(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_audio)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::on_device_model::mojom::AudioDataDataView>(
  in_audio,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null audio in AILanguageModelPromptContent union");
    fragment->data.f_audio.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::AILanguageModelPromptContent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AILanguageModelPromptContentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void AILanguageModelParamsDataView::GetDefaultSamplingParamsDataView(
    AILanguageModelSamplingParamsDataView* output) {
  auto pointer = data_->default_sampling_params.Get();
  *output = AILanguageModelSamplingParamsDataView(pointer, message_);
}
inline void AILanguageModelParamsDataView::GetMaxSamplingParamsDataView(
    AILanguageModelSamplingParamsDataView* output) {
  auto pointer = data_->max_sampling_params.Get();
  *output = AILanguageModelSamplingParamsDataView(pointer, message_);
}


inline void AILanguageModelInstanceInfoDataView::GetSamplingParamsDataView(
    AILanguageModelSamplingParamsDataView* output) {
  auto pointer = data_->sampling_params.Get();
  *output = AILanguageModelSamplingParamsDataView(pointer, message_);
}
inline void AILanguageModelInstanceInfoDataView::GetInputTypesDataView(
    mojo::ArrayDataView<AILanguageModelPromptType>* output) {
  auto pointer = data_->input_types.Get();
  *output = mojo::ArrayDataView<AILanguageModelPromptType>(pointer, message_);
}


inline void AILanguageModelExpectedDataView::GetLanguagesDataView(
    mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>* output) {
  auto pointer = data_->languages.Get();
  *output = mojo::ArrayDataView<::blink::mojom::AILanguageCodeDataView>(pointer, message_);
}


inline void AILanguageModelPromptDataView::GetContentDataView(
    mojo::ArrayDataView<AILanguageModelPromptContentDataView>* output) {
  auto pointer = data_->content.Get();
  *output = mojo::ArrayDataView<AILanguageModelPromptContentDataView>(pointer, message_);
}


inline void AILanguageModelCreateOptionsDataView::GetSamplingParamsDataView(
    AILanguageModelSamplingParamsDataView* output) {
  auto pointer = data_->sampling_params.Get();
  *output = AILanguageModelSamplingParamsDataView(pointer, message_);
}
inline void AILanguageModelCreateOptionsDataView::GetInitialPromptsDataView(
    mojo::ArrayDataView<AILanguageModelPromptDataView>* output) {
  auto pointer = data_->initial_prompts.Get();
  *output = mojo::ArrayDataView<AILanguageModelPromptDataView>(pointer, message_);
}
inline void AILanguageModelCreateOptionsDataView::GetExpectedInputsDataView(
    mojo::ArrayDataView<AILanguageModelExpectedDataView>* output) {
  auto pointer = data_->expected_inputs.Get();
  *output = mojo::ArrayDataView<AILanguageModelExpectedDataView>(pointer, message_);
}
inline void AILanguageModelCreateOptionsDataView::GetExpectedOutputsDataView(
    mojo::ArrayDataView<AILanguageModelExpectedDataView>* output) {
  auto pointer = data_->expected_outputs.Get();
  *output = mojo::ArrayDataView<AILanguageModelExpectedDataView>(pointer, message_);
}


inline void AILanguageModelPromptContentDataView::GetTextDataView(
    mojo::StringDataView* output) const {
  CHECK(is_text());
  *output = mojo::StringDataView(data_->data.f_text.Get(), message_);
}
inline void AILanguageModelPromptContentDataView::GetBitmapDataView(
    ::skia::mojom::BitmapN32DataView* output) const {
  CHECK(is_bitmap());
  *output = ::skia::mojom::BitmapN32DataView(data_->data.f_bitmap.Get(), message_);
}
inline void AILanguageModelPromptContentDataView::GetAudioDataView(
    ::on_device_model::mojom::AudioDataDataView* output) const {
  CHECK(is_audio());
  *output = ::on_device_model::mojom::AudioDataDataView(data_->data.f_audio.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AILanguageModelPromptRole> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AILanguageModelPromptRole value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AILanguageModelPromptType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AILanguageModelPromptType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_SHARED_H_