// third_party/blink/public/mojom/ai/ai_common.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_common.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var WRITING_ASSISTANCE_MAX_INPUT_TOKEN_SIZE = 6000;
  var AIManagerCreateClientError = {};
  AIManagerCreateClientError.kUnableToCreateSession = 0;
  AIManagerCreateClientError.kUnableToCalculateTokenSize = 1;
  AIManagerCreateClientError.kInitialInputTooLarge = 2;
  AIManagerCreateClientError.kUnsupportedLanguage = 3;
  AIManagerCreateClientError.MIN_VALUE = 0;
  AIManagerCreateClientError.MAX_VALUE = 3;

  AIManagerCreateClientError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AIManagerCreateClientError.toKnownEnumValue = function(value) {
    return value;
  };

  AIManagerCreateClientError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AILanguageCode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AILanguageCode.prototype.initDefaults_ = function() {
    this.code = null;
  };
  AILanguageCode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AILanguageCode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AILanguageCode.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AILanguageCode.encodedSize = codec.kStructHeaderSize + 8;

  AILanguageCode.decode = function(decoder) {
    var packed;
    var val = new AILanguageCode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AILanguageCode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AILanguageCode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
  };
  function QuotaErrorInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  QuotaErrorInfo.prototype.initDefaults_ = function() {
    this.requested = 0;
    this.quota = 0;
  };
  QuotaErrorInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  QuotaErrorInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  QuotaErrorInfo.encodedSize = codec.kStructHeaderSize + 8;

  QuotaErrorInfo.decode = function(decoder) {
    var packed;
    var val = new QuotaErrorInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requested =
        decoder.decodeStruct(codec.Uint32);
    val.quota =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  QuotaErrorInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(QuotaErrorInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.requested);
    encoder.encodeStruct(codec.Uint32, val.quota);
  };
  exports.WRITING_ASSISTANCE_MAX_INPUT_TOKEN_SIZE = WRITING_ASSISTANCE_MAX_INPUT_TOKEN_SIZE;
  exports.AIManagerCreateClientError = AIManagerCreateClientError;
  exports.AILanguageCode = AILanguageCode;
  exports.QuotaErrorInfo = QuotaErrorInfo;
})();