// third_party/blink/public/mojom/ai/ai_common.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/blink/public/mojom/ai/ai_common.mojom-shared-internal.h"


namespace blink::mojom {
class AILanguageCodeDataView;

class QuotaErrorInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AILanguageCodeDataView> {
  using Data = ::blink::mojom::internal::AILanguageCode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::QuotaErrorInfoDataView> {
  using Data = ::blink::mojom::internal::QuotaErrorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AIManagerCreateClientError : int32_t {
  
  kUnableToCreateSession = 0,
  
  kUnableToCalculateTokenSize = 1,
  
  kInitialInputTooLarge = 2,
  
  kUnsupportedLanguage = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AIManagerCreateClientError value);
inline bool IsKnownEnumValue(AIManagerCreateClientError value) {
  return internal::AIManagerCreateClientError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AILanguageCodeDataView {
 public:
  AILanguageCodeDataView() = default;

  AILanguageCodeDataView(
      internal::AILanguageCode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AILanguageCode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QuotaErrorInfoDataView {
 public:
  QuotaErrorInfoDataView() = default;

  QuotaErrorInfoDataView(
      internal::QuotaErrorInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t requested() const {
    return data_->requested;
  }
  uint32_t quota() const {
    return data_->quota;
  }
 private:
  internal::QuotaErrorInfo_Data* data_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_DATA_VIEW_H_