// third_party/blink/public/mojom/ai/ai_common.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_common.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_common.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_common.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT AILanguageCode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageCode, T>::value>;
  using DataView = AILanguageCodeDataView;
  using Data_ = internal::AILanguageCode_Data;

  template <typename... Args>
  static AILanguageCodePtr New(Args&&... args) {
    return AILanguageCodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageCodePtr From(const U& u) {
    return mojo::TypeConverter<AILanguageCodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageCode>::Convert(*this);
  }


  AILanguageCode();

  explicit AILanguageCode(
      const ::blink::String& code);


  ~AILanguageCode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageCodePtr>
  AILanguageCodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageCode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageCode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageCode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageCode_UnserializedMessageContext<
            UserType, AILanguageCode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageCode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageCode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageCode_UnserializedMessageContext<
            UserType, AILanguageCode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageCode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String code;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageCode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT QuotaErrorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QuotaErrorInfo, T>::value>;
  using DataView = QuotaErrorInfoDataView;
  using Data_ = internal::QuotaErrorInfo_Data;

  template <typename... Args>
  static QuotaErrorInfoPtr New(Args&&... args) {
    return QuotaErrorInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuotaErrorInfoPtr From(const U& u) {
    return mojo::TypeConverter<QuotaErrorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QuotaErrorInfo>::Convert(*this);
  }


  QuotaErrorInfo();

  QuotaErrorInfo(
      uint32_t requested,
      uint32_t quota);


  ~QuotaErrorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuotaErrorInfoPtr>
  QuotaErrorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuotaErrorInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuotaErrorInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QuotaErrorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QuotaErrorInfo_UnserializedMessageContext<
            UserType, QuotaErrorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QuotaErrorInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QuotaErrorInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QuotaErrorInfo_UnserializedMessageContext<
            UserType, QuotaErrorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QuotaErrorInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t requested;
  
  uint32_t quota;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QuotaErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
AILanguageCodePtr AILanguageCode::Clone() const {
  return New(
      mojo::Clone(code)
  );
}

template <typename T, AILanguageCode::EnableIfSame<T>*>
bool AILanguageCode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  return true;
}

template <typename T, AILanguageCode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  return false;
}
template <typename StructPtrType>
QuotaErrorInfoPtr QuotaErrorInfo::Clone() const {
  return New(
      mojo::Clone(requested),
      mojo::Clone(quota)
  );
}

template <typename T, QuotaErrorInfo::EnableIfSame<T>*>
bool QuotaErrorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requested, other_struct.requested))
    return false;
  if (!mojo::Equals(this->quota, other_struct.quota))
    return false;
  return true;
}

template <typename T, QuotaErrorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.requested < rhs.requested)
    return true;
  if (rhs.requested < lhs.requested)
    return false;
  if (lhs.quota < rhs.quota)
    return true;
  if (rhs.quota < lhs.quota)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageCode::DataView,
                                         ::blink::mojom::blink::AILanguageCodePtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageCodePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageCodePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AILanguageCode::code)& code(
      const ::blink::mojom::blink::AILanguageCodePtr& input) {
    return input->code;
  }

  static bool Read(::blink::mojom::blink::AILanguageCode::DataView input, ::blink::mojom::blink::AILanguageCodePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::QuotaErrorInfo::DataView,
                                         ::blink::mojom::blink::QuotaErrorInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::QuotaErrorInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::QuotaErrorInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::QuotaErrorInfo::requested) requested(
      const ::blink::mojom::blink::QuotaErrorInfoPtr& input) {
    return input->requested;
  }

  static decltype(::blink::mojom::blink::QuotaErrorInfo::quota) quota(
      const ::blink::mojom::blink::QuotaErrorInfoPtr& input) {
    return input->quota;
  }

  static bool Read(::blink::mojom::blink::QuotaErrorInfo::DataView input, ::blink::mojom::blink::QuotaErrorInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_COMMON_MOJOM_BLINK_H_