// third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ad_tagging/ad_evidence.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var FilterListResult = {};
  FilterListResult.kNotChecked = 0;
  FilterListResult.kMatchedAllowingRule = 1;
  FilterListResult.kMatchedNoRules = 2;
  FilterListResult.kMatchedBlockingRule = 3;
  FilterListResult.MIN_VALUE = 0;
  FilterListResult.MAX_VALUE = 3;

  FilterListResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  FilterListResult.toKnownEnumValue = function(value) {
    return value;
  };

  FilterListResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FrameCreationStackEvidence = {};
  FrameCreationStackEvidence.kNotCreatedByAdScript = 0;
  FrameCreationStackEvidence.kCreatedByAdScript = 1;
  FrameCreationStackEvidence.MIN_VALUE = 0;
  FrameCreationStackEvidence.MAX_VALUE = 1;

  FrameCreationStackEvidence.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  FrameCreationStackEvidence.toKnownEnumValue = function(value) {
    return value;
  };

  FrameCreationStackEvidence.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FrameAdEvidence(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameAdEvidence.prototype.initDefaults_ = function() {
    this.isComplete = false;
    this.parentIsAd = false;
    this.latestFilterListResult = FilterListResult.kNotChecked;
    this.mostRestrictiveFilterListResult = FilterListResult.kNotChecked;
    this.createdByAdScript = FrameCreationStackEvidence.kNotCreatedByAdScript;
  };
  FrameAdEvidence.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameAdEvidence.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FrameAdEvidence.latestFilterListResult
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, FilterListResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameAdEvidence.mostRestrictiveFilterListResult
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, FilterListResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameAdEvidence.createdByAdScript
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, FrameCreationStackEvidence);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameAdEvidence.encodedSize = codec.kStructHeaderSize + 16;

  FrameAdEvidence.decode = function(decoder) {
    var packed;
    var val = new FrameAdEvidence();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isComplete = (packed >> 0) & 1 ? true : false;
    val.parentIsAd = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.latestFilterListResult =
        decoder.decodeStruct(new codec.Enum(FilterListResult));
    val.mostRestrictiveFilterListResult =
        decoder.decodeStruct(new codec.Enum(FilterListResult));
    val.createdByAdScript =
        decoder.decodeStruct(new codec.Enum(FrameCreationStackEvidence));
    return val;
  };

  FrameAdEvidence.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameAdEvidence.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isComplete & 1) << 0
    packed |= (val.parentIsAd & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.latestFilterListResult);
    encoder.encodeStruct(codec.Int32, val.mostRestrictiveFilterListResult);
    encoder.encodeStruct(codec.Int32, val.createdByAdScript);
  };
  exports.FilterListResult = FilterListResult;
  exports.FrameCreationStackEvidence = FrameCreationStackEvidence;
  exports.FrameAdEvidence = FrameAdEvidence;
})();