// storage/browser/quota/quota_internals.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_TEST_UTILS_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_TEST_UTILS_H_

#include "storage/browser/quota/quota_internals.mojom.h"
#include "base/component_export.h"


namespace storage::mojom {


class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerInterceptorForTesting : public QuotaInternalsHandler {
  virtual QuotaInternalsHandler* GetForwardingInterface() = 0;
  void GetDiskAvailabilityAndTempPoolSize(GetDiskAvailabilityAndTempPoolSizeCallback callback) override;
  void GetStatistics(GetStatisticsCallback callback) override;
  void SimulateStoragePressure(const ::url::Origin& origin_url) override;
  void RetrieveBucketsTable(RetrieveBucketsTableCallback callback) override;
  void GetGlobalUsageForInternals(GetGlobalUsageForInternalsCallback callback) override;
  void IsSimulateStoragePressureAvailable(IsSimulateStoragePressureAvailableCallback callback) override;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerAsyncWaiter {
 public:
  explicit QuotaInternalsHandlerAsyncWaiter(QuotaInternalsHandler* proxy);

  QuotaInternalsHandlerAsyncWaiter(const QuotaInternalsHandlerAsyncWaiter&) = delete;
  QuotaInternalsHandlerAsyncWaiter& operator=(const QuotaInternalsHandlerAsyncWaiter&) = delete;

  ~QuotaInternalsHandlerAsyncWaiter();
  void GetDiskAvailabilityAndTempPoolSize(
      int64_t* out_total_space, int64_t* out_available_space, int64_t* out_temp_pool_size);
  
  void GetStatistics(
      base::flat_map<std::string, std::string>* out_eviction_statistics);
  base::flat_map<std::string, std::string> GetStatistics();
  void RetrieveBucketsTable(
      std::vector<BucketTableEntryPtr>* out_entries);
  std::vector<BucketTableEntryPtr> RetrieveBucketsTable();
  void GetGlobalUsageForInternals(
      int64_t* out_usage, int64_t* out_unlimited_usage);
  
  void IsSimulateStoragePressureAvailable(
      bool* out_available);
  bool IsSimulateStoragePressureAvailable();

 private:
  QuotaInternalsHandler* const proxy_;
};




}  // storage::mojom

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_TEST_UTILS_H_