// storage/browser/quota/quota_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "storage/browser/quota/quota_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"

#include "storage/browser/quota/quota_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::BucketTableEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BucketTableEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BucketTableEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->bucket_id = Traits::bucket_id(input);

      decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_storage_key,
        storage_key_fragment);

      fragment->storage_key.Set(
          storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->storage_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage_key in BucketTableEntry struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in BucketTableEntry struct");

      fragment->usage = Traits::usage(input);

      fragment->use_count = Traits::use_count(input);

      decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_accessed,
        last_accessed_fragment);

      fragment->last_accessed.Set(
          last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_accessed.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_accessed in BucketTableEntry struct");

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in BucketTableEntry struct");
  }
};

}  // namespace mojo::internal

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_SEND_VALIDATION_H_