// skia/public/mojom/skcolorspace_primaries.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLORSPACE_PRIMARIES_MOJOM_H_
#define SKIA_PUBLIC_MOJOM_SKCOLORSPACE_PRIMARIES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/skcolorspace_primaries.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace_primaries.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "skia/public/mojom/skcolorspace_primaries_mojom_traits.h"




namespace skia::mojom {








class  SkColorSpacePrimaries {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkColorSpacePrimaries, T>::value>;
  using DataView = SkColorSpacePrimariesDataView;
  using Data_ = internal::SkColorSpacePrimaries_Data;

  template <typename... Args>
  static SkColorSpacePrimariesPtr New(Args&&... args) {
    return SkColorSpacePrimariesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkColorSpacePrimariesPtr From(const U& u) {
    return mojo::TypeConverter<SkColorSpacePrimariesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkColorSpacePrimaries>::Convert(*this);
  }


  SkColorSpacePrimaries();

  SkColorSpacePrimaries(
      float rX,
      float rY,
      float gX,
      float gY,
      float bX,
      float bY,
      float wX,
      float wY);


  ~SkColorSpacePrimaries();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkColorSpacePrimariesPtr>
  SkColorSpacePrimariesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColorSpacePrimaries::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColorSpacePrimaries::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkColorSpacePrimaries::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkColorSpacePrimaries_UnserializedMessageContext<
            UserType, SkColorSpacePrimaries::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkColorSpacePrimaries::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkColorSpacePrimaries::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkColorSpacePrimaries_UnserializedMessageContext<
            UserType, SkColorSpacePrimaries::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkColorSpacePrimaries::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float rX;
  
  float rY;
  
  float gX;
  
  float gY;
  
  float bX;
  
  float bY;
  
  float wX;
  
  float wY;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkColorSpacePrimaries::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SkColorSpacePrimariesPtr SkColorSpacePrimaries::Clone() const {
  return New(
      mojo::Clone(rX),
      mojo::Clone(rY),
      mojo::Clone(gX),
      mojo::Clone(gY),
      mojo::Clone(bX),
      mojo::Clone(bY),
      mojo::Clone(wX),
      mojo::Clone(wY)
  );
}

template <typename T, SkColorSpacePrimaries::EnableIfSame<T>*>
bool SkColorSpacePrimaries::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rX, other_struct.rX))
    return false;
  if (!mojo::Equals(this->rY, other_struct.rY))
    return false;
  if (!mojo::Equals(this->gX, other_struct.gX))
    return false;
  if (!mojo::Equals(this->gY, other_struct.gY))
    return false;
  if (!mojo::Equals(this->bX, other_struct.bX))
    return false;
  if (!mojo::Equals(this->bY, other_struct.bY))
    return false;
  if (!mojo::Equals(this->wX, other_struct.wX))
    return false;
  if (!mojo::Equals(this->wY, other_struct.wY))
    return false;
  return true;
}

template <typename T, SkColorSpacePrimaries::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rX < rhs.rX)
    return true;
  if (rhs.rX < lhs.rX)
    return false;
  if (lhs.rY < rhs.rY)
    return true;
  if (rhs.rY < lhs.rY)
    return false;
  if (lhs.gX < rhs.gX)
    return true;
  if (rhs.gX < lhs.gX)
    return false;
  if (lhs.gY < rhs.gY)
    return true;
  if (rhs.gY < lhs.gY)
    return false;
  if (lhs.bX < rhs.bX)
    return true;
  if (rhs.bX < lhs.bX)
    return false;
  if (lhs.bY < rhs.bY)
    return true;
  if (rhs.bY < lhs.bY)
    return false;
  if (lhs.wX < rhs.wX)
    return true;
  if (rhs.wX < lhs.wX)
    return false;
  if (lhs.wY < rhs.wY)
    return true;
  if (rhs.wY < lhs.wY)
    return false;
  return false;
}


}  // skia::mojom

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::SkColorSpacePrimaries::DataView,
                                         ::skia::mojom::SkColorSpacePrimariesPtr> {
  static bool IsNull(const ::skia::mojom::SkColorSpacePrimariesPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkColorSpacePrimariesPtr* output) { output->reset(); }

  static decltype(::skia::mojom::SkColorSpacePrimaries::rX) rX(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->rX;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::rY) rY(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->rY;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::gX) gX(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->gX;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::gY) gY(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->gY;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::bX) bX(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->bX;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::bY) bY(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->bY;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::wX) wX(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->wX;
  }

  static decltype(::skia::mojom::SkColorSpacePrimaries::wY) wY(
      const ::skia::mojom::SkColorSpacePrimariesPtr& input) {
    return input->wY;
  }

  static bool Read(::skia::mojom::SkColorSpacePrimaries::DataView input, ::skia::mojom::SkColorSpacePrimariesPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_SKCOLORSPACE_PRIMARIES_MOJOM_H_