// skia/public/mojom/skcolorspace.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'skia/public/mojom/skcolorspace.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('skia.mojom');



  function SkcmsMatrix3x3(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SkcmsMatrix3x3.prototype.initDefaults_ = function() {
    this.vals = null;
  };
  SkcmsMatrix3x3.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SkcmsMatrix3x3.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SkcmsMatrix3x3.vals
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Float, false, [9], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SkcmsMatrix3x3.encodedSize = codec.kStructHeaderSize + 8;

  SkcmsMatrix3x3.decode = function(decoder) {
    var packed;
    var val = new SkcmsMatrix3x3();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.vals =
        decoder.decodeArrayPointer(codec.Float);
    return val;
  };

  SkcmsMatrix3x3.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SkcmsMatrix3x3.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Float, val.vals);
  };
  function SkcmsTransferFunction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SkcmsTransferFunction.prototype.initDefaults_ = function() {
    this.g = 0;
    this.a = 0;
    this.b = 0;
    this.c = 0;
    this.d = 0;
    this.e = 0;
    this.f = 0;
  };
  SkcmsTransferFunction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SkcmsTransferFunction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  SkcmsTransferFunction.encodedSize = codec.kStructHeaderSize + 32;

  SkcmsTransferFunction.decode = function(decoder) {
    var packed;
    var val = new SkcmsTransferFunction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.g =
        decoder.decodeStruct(codec.Float);
    val.a =
        decoder.decodeStruct(codec.Float);
    val.b =
        decoder.decodeStruct(codec.Float);
    val.c =
        decoder.decodeStruct(codec.Float);
    val.d =
        decoder.decodeStruct(codec.Float);
    val.e =
        decoder.decodeStruct(codec.Float);
    val.f =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SkcmsTransferFunction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SkcmsTransferFunction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.g);
    encoder.encodeStruct(codec.Float, val.a);
    encoder.encodeStruct(codec.Float, val.b);
    encoder.encodeStruct(codec.Float, val.c);
    encoder.encodeStruct(codec.Float, val.d);
    encoder.encodeStruct(codec.Float, val.e);
    encoder.encodeStruct(codec.Float, val.f);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SkColorSpace(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SkColorSpace.prototype.initDefaults_ = function() {
    this.toLinear = null;
    this.toXyzd50 = null;
  };
  SkColorSpace.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SkColorSpace.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SkColorSpace.toLinear
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SkcmsTransferFunction, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SkColorSpace.toXyzd50
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SkcmsMatrix3x3, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SkColorSpace.encodedSize = codec.kStructHeaderSize + 16;

  SkColorSpace.decode = function(decoder) {
    var packed;
    var val = new SkColorSpace();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.toLinear =
        decoder.decodeStructPointer(SkcmsTransferFunction);
    val.toXyzd50 =
        decoder.decodeStructPointer(SkcmsMatrix3x3);
    return val;
  };

  SkColorSpace.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SkColorSpace.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SkcmsTransferFunction, val.toLinear);
    encoder.encodeStructPointer(SkcmsMatrix3x3, val.toXyzd50);
  };
  exports.SkcmsMatrix3x3 = SkcmsMatrix3x3;
  exports.SkcmsTransferFunction = SkcmsTransferFunction;
  exports.SkColorSpace = SkColorSpace;
})();