// skia/public/mojom/skcolor4f.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLOR4F_MOJOM_H_
#define SKIA_PUBLIC_MOJOM_SKCOLOR4F_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/skcolor4f.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor4f.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor4f.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "skia/public/mojom/skcolor4f_mojom_traits.h"




namespace skia::mojom {





class  SkColor4f {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkColor4f, T>::value>;
  using DataView = SkColor4fDataView;
  using Data_ = internal::SkColor4f_Data;

  template <typename... Args>
  static SkColor4fPtr New(Args&&... args) {
    return SkColor4fPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkColor4fPtr From(const U& u) {
    return mojo::TypeConverter<SkColor4fPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkColor4f>::Convert(*this);
  }


  SkColor4f();

  SkColor4f(
      float r,
      float g,
      float b,
      float a);


  ~SkColor4f();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkColor4fPtr>
  SkColor4fPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColor4f::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColor4f::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkColor4f::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkColor4f_UnserializedMessageContext<
            UserType, SkColor4f::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkColor4f::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkColor4f::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkColor4f_UnserializedMessageContext<
            UserType, SkColor4f::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkColor4f::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float r;
  
  float g;
  
  float b;
  
  float a;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkColor4f::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SkColor4fPtr SkColor4f::Clone() const {
  return New(
      mojo::Clone(r),
      mojo::Clone(g),
      mojo::Clone(b),
      mojo::Clone(a)
  );
}

template <typename T, SkColor4f::EnableIfSame<T>*>
bool SkColor4f::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->r, other_struct.r))
    return false;
  if (!mojo::Equals(this->g, other_struct.g))
    return false;
  if (!mojo::Equals(this->b, other_struct.b))
    return false;
  if (!mojo::Equals(this->a, other_struct.a))
    return false;
  return true;
}

template <typename T, SkColor4f::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.r < rhs.r)
    return true;
  if (rhs.r < lhs.r)
    return false;
  if (lhs.g < rhs.g)
    return true;
  if (rhs.g < lhs.g)
    return false;
  if (lhs.b < rhs.b)
    return true;
  if (rhs.b < lhs.b)
    return false;
  if (lhs.a < rhs.a)
    return true;
  if (rhs.a < lhs.a)
    return false;
  return false;
}


}  // skia::mojom

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::SkColor4f::DataView,
                                         ::skia::mojom::SkColor4fPtr> {
  static bool IsNull(const ::skia::mojom::SkColor4fPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkColor4fPtr* output) { output->reset(); }

  static decltype(::skia::mojom::SkColor4f::r) r(
      const ::skia::mojom::SkColor4fPtr& input) {
    return input->r;
  }

  static decltype(::skia::mojom::SkColor4f::g) g(
      const ::skia::mojom::SkColor4fPtr& input) {
    return input->g;
  }

  static decltype(::skia::mojom::SkColor4f::b) b(
      const ::skia::mojom::SkColor4fPtr& input) {
    return input->b;
  }

  static decltype(::skia::mojom::SkColor4f::a) a(
      const ::skia::mojom::SkColor4fPtr& input) {
    return input->a;
  }

  static bool Read(::skia::mojom::SkColor4f::DataView input, ::skia::mojom::SkColor4fPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_SKCOLOR4F_MOJOM_H_