// skia/public/mojom/skcolor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLOR_MOJOM_H_
#define SKIA_PUBLIC_MOJOM_SKCOLOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/skcolor.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "skia/public/mojom/skcolor_mojom_traits.h"




namespace skia::mojom {





class  SkColor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkColor, T>::value>;
  using DataView = SkColorDataView;
  using Data_ = internal::SkColor_Data;

  template <typename... Args>
  static SkColorPtr New(Args&&... args) {
    return SkColorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkColorPtr From(const U& u) {
    return mojo::TypeConverter<SkColorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkColor>::Convert(*this);
  }


  SkColor();

  explicit SkColor(
      uint32_t value);


  ~SkColor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkColorPtr>
  SkColorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkColor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkColor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkColor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkColor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkColor_UnserializedMessageContext<
            UserType, SkColor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkColor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkColor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkColor_UnserializedMessageContext<
            UserType, SkColor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkColor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkColor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkColor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkColor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkColor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SkColorPtr SkColor::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, SkColor::EnableIfSame<T>*>
bool SkColor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SkColor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // skia::mojom

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::SkColor::DataView,
                                         ::skia::mojom::SkColorPtr> {
  static bool IsNull(const ::skia::mojom::SkColorPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkColorPtr* output) { output->reset(); }

  static decltype(::skia::mojom::SkColor::value) value(
      const ::skia::mojom::SkColorPtr& input) {
    return input->value;
  }

  static bool Read(::skia::mojom::SkColor::DataView input, ::skia::mojom::SkColorPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_SKCOLOR_MOJOM_H_