// skia/public/mojom/image_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'skia/public/mojom/image_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('skia.mojom');


  var ColorType = {};
  ColorType.UNKNOWN = 0;
  ColorType.ALPHA_8 = 1;
  ColorType.RGB_565 = 2;
  ColorType.ARGB_4444 = 3;
  ColorType.RGBA_8888 = 4;
  ColorType.BGRA_8888 = 5;
  ColorType.DEPRECATED_INDEX_8 = 6;
  ColorType.GRAY_8 = 7;
  ColorType.MIN_VALUE = 0;
  ColorType.MAX_VALUE = 7;
  ColorType.DEFAULT_VALUE = 0;

  ColorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  ColorType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ColorType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AlphaType = {};
  AlphaType.UNKNOWN = 0;
  AlphaType.ALPHA_TYPE_OPAQUE = 1;
  AlphaType.PREMUL = 2;
  AlphaType.UNPREMUL = 3;
  AlphaType.MIN_VALUE = 0;
  AlphaType.MAX_VALUE = 3;
  AlphaType.DEFAULT_VALUE = 0;

  AlphaType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AlphaType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AlphaType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ImageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageInfo.prototype.initDefaults_ = function() {
    this.colorType = 0;
    this.alphaType = 0;
    this.width = 0;
    this.height = 0;
    this.colorTransferFunction = null;
    this.colorToXyzMatrix = null;
  };
  ImageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageInfo.colorType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ColorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageInfo.alphaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, AlphaType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ImageInfo.colorTransferFunction
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Float, true, [7], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageInfo.colorToXyzMatrix
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, codec.Float, true, [9], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageInfo.encodedSize = codec.kStructHeaderSize + 32;

  ImageInfo.decode = function(decoder) {
    var packed;
    var val = new ImageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.colorType =
        decoder.decodeStruct(new codec.Enum(ColorType));
    val.alphaType =
        decoder.decodeStruct(new codec.Enum(AlphaType));
    val.width =
        decoder.decodeStruct(codec.Uint32);
    val.height =
        decoder.decodeStruct(codec.Uint32);
    val.colorTransferFunction =
        decoder.decodeArrayPointer(codec.Float);
    val.colorToXyzMatrix =
        decoder.decodeArrayPointer(codec.Float);
    return val;
  };

  ImageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.colorType);
    encoder.encodeStruct(codec.Int32, val.alphaType);
    encoder.encodeStruct(codec.Uint32, val.width);
    encoder.encodeStruct(codec.Uint32, val.height);
    encoder.encodeArrayPointer(codec.Float, val.colorTransferFunction);
    encoder.encodeArrayPointer(codec.Float, val.colorToXyzMatrix);
  };
  function BitmapN32ImageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BitmapN32ImageInfo.prototype.initDefaults_ = function() {
    this.alphaType = 0;
    this.width = 0;
    this.height = 0;
    this.colorTransferFunction = null;
    this.colorToXyzMatrix = null;
  };
  BitmapN32ImageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BitmapN32ImageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapN32ImageInfo.alphaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AlphaType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BitmapN32ImageInfo.colorTransferFunction
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Float, true, [7], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BitmapN32ImageInfo.colorToXyzMatrix
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, codec.Float, true, [9], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BitmapN32ImageInfo.encodedSize = codec.kStructHeaderSize + 32;

  BitmapN32ImageInfo.decode = function(decoder) {
    var packed;
    var val = new BitmapN32ImageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.alphaType =
        decoder.decodeStruct(new codec.Enum(AlphaType));
    val.width =
        decoder.decodeStruct(codec.Uint32);
    val.height =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.colorTransferFunction =
        decoder.decodeArrayPointer(codec.Float);
    val.colorToXyzMatrix =
        decoder.decodeArrayPointer(codec.Float);
    return val;
  };

  BitmapN32ImageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BitmapN32ImageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.alphaType);
    encoder.encodeStruct(codec.Uint32, val.width);
    encoder.encodeStruct(codec.Uint32, val.height);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Float, val.colorTransferFunction);
    encoder.encodeArrayPointer(codec.Float, val.colorToXyzMatrix);
  };
  exports.ColorType = ColorType;
  exports.AlphaType = AlphaType;
  exports.ImageInfo = ImageInfo;
  exports.BitmapN32ImageInfo = BitmapN32ImageInfo;
})();