// skia/public/mojom/image_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/image_info.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/image_info.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/image_info.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "skia/public/mojom/image_info_mojom_traits.h"




namespace skia::mojom {









class  ImageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageInfo, T>::value>;
  using DataView = ImageInfoDataView;
  using Data_ = internal::ImageInfo_Data;

  template <typename... Args>
  static ImageInfoPtr New(Args&&... args) {
    return ImageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageInfoPtr From(const U& u) {
    return mojo::TypeConverter<ImageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageInfo>::Convert(*this);
  }


  ImageInfo();

  ImageInfo(
      ::SkColorType color_type,
      ::SkAlphaType alpha_type,
      uint32_t width,
      uint32_t height,
      std::optional<std::vector<float>> color_transfer_function,
      std::optional<std::vector<float>> color_to_xyz_matrix);


  ~ImageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageInfoPtr>
  ImageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageInfo_UnserializedMessageContext<
            UserType, ImageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageInfo_UnserializedMessageContext<
            UserType, ImageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColorType color_type;
  
  ::SkAlphaType alpha_type;
  
  uint32_t width;
  
  uint32_t height;
  
  std::optional<std::vector<float>> color_transfer_function;
  
  std::optional<std::vector<float>> color_to_xyz_matrix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BitmapN32ImageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitmapN32ImageInfo, T>::value>;
  using DataView = BitmapN32ImageInfoDataView;
  using Data_ = internal::BitmapN32ImageInfo_Data;

  template <typename... Args>
  static BitmapN32ImageInfoPtr New(Args&&... args) {
    return BitmapN32ImageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitmapN32ImageInfoPtr From(const U& u) {
    return mojo::TypeConverter<BitmapN32ImageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitmapN32ImageInfo>::Convert(*this);
  }


  BitmapN32ImageInfo();

  BitmapN32ImageInfo(
      ::SkAlphaType alpha_type,
      uint32_t width,
      uint32_t height,
      std::optional<std::vector<float>> color_transfer_function,
      std::optional<std::vector<float>> color_to_xyz_matrix);


  ~BitmapN32ImageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitmapN32ImageInfoPtr>
  BitmapN32ImageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BitmapN32ImageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BitmapN32ImageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitmapN32ImageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitmapN32ImageInfo_UnserializedMessageContext<
            UserType, BitmapN32ImageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BitmapN32ImageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BitmapN32ImageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitmapN32ImageInfo_UnserializedMessageContext<
            UserType, BitmapN32ImageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitmapN32ImageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkAlphaType alpha_type;
  
  uint32_t width;
  
  uint32_t height;
  
  std::optional<std::vector<float>> color_transfer_function;
  
  std::optional<std::vector<float>> color_to_xyz_matrix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitmapN32ImageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImageInfoPtr ImageInfo::Clone() const {
  return New(
      mojo::Clone(color_type),
      mojo::Clone(alpha_type),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(color_transfer_function),
      mojo::Clone(color_to_xyz_matrix)
  );
}

template <typename T, ImageInfo::EnableIfSame<T>*>
bool ImageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color_type, other_struct.color_type))
    return false;
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->color_transfer_function, other_struct.color_transfer_function))
    return false;
  if (!mojo::Equals(this->color_to_xyz_matrix, other_struct.color_to_xyz_matrix))
    return false;
  return true;
}

template <typename T, ImageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color_type < rhs.color_type)
    return true;
  if (rhs.color_type < lhs.color_type)
    return false;
  if (lhs.alpha_type < rhs.alpha_type)
    return true;
  if (rhs.alpha_type < lhs.alpha_type)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.color_transfer_function < rhs.color_transfer_function)
    return true;
  if (rhs.color_transfer_function < lhs.color_transfer_function)
    return false;
  if (lhs.color_to_xyz_matrix < rhs.color_to_xyz_matrix)
    return true;
  if (rhs.color_to_xyz_matrix < lhs.color_to_xyz_matrix)
    return false;
  return false;
}
template <typename StructPtrType>
BitmapN32ImageInfoPtr BitmapN32ImageInfo::Clone() const {
  return New(
      mojo::Clone(alpha_type),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(color_transfer_function),
      mojo::Clone(color_to_xyz_matrix)
  );
}

template <typename T, BitmapN32ImageInfo::EnableIfSame<T>*>
bool BitmapN32ImageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->color_transfer_function, other_struct.color_transfer_function))
    return false;
  if (!mojo::Equals(this->color_to_xyz_matrix, other_struct.color_to_xyz_matrix))
    return false;
  return true;
}

template <typename T, BitmapN32ImageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.alpha_type < rhs.alpha_type)
    return true;
  if (rhs.alpha_type < lhs.alpha_type)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.color_transfer_function < rhs.color_transfer_function)
    return true;
  if (rhs.color_transfer_function < lhs.color_transfer_function)
    return false;
  if (lhs.color_to_xyz_matrix < rhs.color_to_xyz_matrix)
    return true;
  if (rhs.color_to_xyz_matrix < lhs.color_to_xyz_matrix)
    return false;
  return false;
}


}  // skia::mojom

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::ImageInfo::DataView,
                                         ::skia::mojom::ImageInfoPtr> {
  static bool IsNull(const ::skia::mojom::ImageInfoPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::ImageInfoPtr* output) { output->reset(); }

  static decltype(::skia::mojom::ImageInfo::color_type) color_type(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->color_type;
  }

  static decltype(::skia::mojom::ImageInfo::alpha_type) alpha_type(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->alpha_type;
  }

  static decltype(::skia::mojom::ImageInfo::width) width(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->width;
  }

  static decltype(::skia::mojom::ImageInfo::height) height(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->height;
  }

  static const decltype(::skia::mojom::ImageInfo::color_transfer_function)& color_transfer_function(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->color_transfer_function;
  }

  static const decltype(::skia::mojom::ImageInfo::color_to_xyz_matrix)& color_to_xyz_matrix(
      const ::skia::mojom::ImageInfoPtr& input) {
    return input->color_to_xyz_matrix;
  }

  static bool Read(::skia::mojom::ImageInfo::DataView input, ::skia::mojom::ImageInfoPtr* output);
};


template <>
struct  StructTraits<::skia::mojom::BitmapN32ImageInfo::DataView,
                                         ::skia::mojom::BitmapN32ImageInfoPtr> {
  static bool IsNull(const ::skia::mojom::BitmapN32ImageInfoPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::BitmapN32ImageInfoPtr* output) { output->reset(); }

  static decltype(::skia::mojom::BitmapN32ImageInfo::alpha_type) alpha_type(
      const ::skia::mojom::BitmapN32ImageInfoPtr& input) {
    return input->alpha_type;
  }

  static decltype(::skia::mojom::BitmapN32ImageInfo::width) width(
      const ::skia::mojom::BitmapN32ImageInfoPtr& input) {
    return input->width;
  }

  static decltype(::skia::mojom::BitmapN32ImageInfo::height) height(
      const ::skia::mojom::BitmapN32ImageInfoPtr& input) {
    return input->height;
  }

  static const decltype(::skia::mojom::BitmapN32ImageInfo::color_transfer_function)& color_transfer_function(
      const ::skia::mojom::BitmapN32ImageInfoPtr& input) {
    return input->color_transfer_function;
  }

  static const decltype(::skia::mojom::BitmapN32ImageInfo::color_to_xyz_matrix)& color_to_xyz_matrix(
      const ::skia::mojom::BitmapN32ImageInfoPtr& input) {
    return input->color_to_xyz_matrix;
  }

  static bool Read(::skia::mojom::BitmapN32ImageInfo::DataView input, ::skia::mojom::BitmapN32ImageInfoPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_H_