// skia/public/mojom/image_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/image_info.mojom-shared-internal.h"




#include "skia/public/mojom/image_info.mojom-data-view.h"




namespace std {

template <>
struct hash<::skia::mojom::ColorType>
    : public mojo::internal::EnumHashImpl<::skia::mojom::ColorType> {};

template <>
struct hash<::skia::mojom::AlphaType>
    : public mojo::internal::EnumHashImpl<::skia::mojom::AlphaType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::ColorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::skia::mojom::ColorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::skia::mojom::ColorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::AlphaType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::skia::mojom::AlphaType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::skia::mojom::AlphaType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::ImageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::ImageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::ImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::skia::mojom::ColorType>(
      Traits::color_type(input),
      &fragment->color_type);

    
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
      Traits::alpha_type(input),
      &fragment->alpha_type);

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);

    decltype(Traits::color_transfer_function(input)) in_color_transfer_function = Traits::color_transfer_function(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_transfer_function)::BaseType>
        color_transfer_function_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
        mojo::internal::GetArrayValidator<7, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_color_transfer_function,
      color_transfer_function_fragment,
      &color_transfer_function_validate_params);

    fragment->color_transfer_function.Set(
        color_transfer_function_fragment.is_null() ? nullptr : color_transfer_function_fragment.data());

    decltype(Traits::color_to_xyz_matrix(input)) in_color_to_xyz_matrix = Traits::color_to_xyz_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_to_xyz_matrix)::BaseType>
        color_to_xyz_matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_color_to_xyz_matrix,
      color_to_xyz_matrix_fragment,
      &color_to_xyz_matrix_validate_params);

    fragment->color_to_xyz_matrix.Set(
        color_to_xyz_matrix_fragment.is_null() ? nullptr : color_to_xyz_matrix_fragment.data());
  }

  static bool Deserialize(::skia::mojom::internal::ImageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::ImageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::BitmapN32ImageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::BitmapN32ImageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::BitmapN32ImageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
      Traits::alpha_type(input),
      &fragment->alpha_type);

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);

    decltype(Traits::color_transfer_function(input)) in_color_transfer_function = Traits::color_transfer_function(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_transfer_function)::BaseType>
        color_transfer_function_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
        mojo::internal::GetArrayValidator<7, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_color_transfer_function,
      color_transfer_function_fragment,
      &color_transfer_function_validate_params);

    fragment->color_transfer_function.Set(
        color_transfer_function_fragment.is_null() ? nullptr : color_transfer_function_fragment.data());

    decltype(Traits::color_to_xyz_matrix(input)) in_color_to_xyz_matrix = Traits::color_to_xyz_matrix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_to_xyz_matrix)::BaseType>
        color_to_xyz_matrix_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
        mojo::internal::GetArrayValidator<9, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_color_to_xyz_matrix,
      color_to_xyz_matrix_fragment,
      &color_to_xyz_matrix_validate_params);

    fragment->color_to_xyz_matrix.Set(
        color_to_xyz_matrix_fragment.is_null() ? nullptr : color_to_xyz_matrix_fragment.data());
  }

  static bool Deserialize(::skia::mojom::internal::BitmapN32ImageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::BitmapN32ImageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace skia::mojom {

inline void ImageInfoDataView::GetColorTransferFunctionDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_transfer_function.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void ImageInfoDataView::GetColorToXyzMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_to_xyz_matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}


inline void BitmapN32ImageInfoDataView::GetColorTransferFunctionDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_transfer_function.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void BitmapN32ImageInfoDataView::GetColorToXyzMatrixDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->color_to_xyz_matrix.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}



}  // skia::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::skia::mojom::ColorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::skia::mojom::ColorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::skia::mojom::AlphaType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::skia::mojom::AlphaType value);
};

} // namespace perfetto

#endif  // SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_SHARED_H_