// skia/public/mojom/bitmap.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_SHARED_H_
#define SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/bitmap.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "skia/public/mojom/bitmap.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::BitmapN32DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::BitmapN32DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::BitmapN32_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32ImageInfoDataView>(
      in_image_info,
      image_info_fragment);

    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_info in BitmapN32 struct");

    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<decltype(fragment->pixel_data)>
        pixel_data_fragment(fragment.message());
    pixel_data_fragment.Claim(&fragment->pixel_data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_pixel_data,
      pixel_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pixel_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_data in BitmapN32 struct");
  }

  static bool Deserialize(::skia::mojom::internal::BitmapN32_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::BitmapN32DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::BitmapWithArbitraryBppDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::BitmapWithArbitraryBppDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::BitmapWithArbitraryBpp_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::ImageInfoDataView>(
      in_image_info,
      image_info_fragment);

    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_info in BitmapWithArbitraryBpp struct");

    fragment->UNUSED_row_bytes = Traits::UNUSED_row_bytes(input);

    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<decltype(fragment->pixel_data)>
        pixel_data_fragment(fragment.message());
    pixel_data_fragment.Claim(&fragment->pixel_data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_pixel_data,
      pixel_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pixel_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_data in BitmapWithArbitraryBpp struct");
  }

  static bool Deserialize(::skia::mojom::internal::BitmapWithArbitraryBpp_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::BitmapWithArbitraryBppDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::BitmapMappedFromTrustedProcessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::BitmapMappedFromTrustedProcessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::BitmapMappedFromTrustedProcess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::ImageInfoDataView>(
      in_image_info,
      image_info_fragment);

    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_info in BitmapMappedFromTrustedProcess struct");

    fragment->UNUSED_row_bytes = Traits::UNUSED_row_bytes(input);

    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<decltype(fragment->pixel_data)>
        pixel_data_fragment(fragment.message());
    pixel_data_fragment.Claim(&fragment->pixel_data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_pixel_data,
      pixel_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pixel_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_data in BitmapMappedFromTrustedProcess struct");
  }

  static bool Deserialize(::skia::mojom::internal::BitmapMappedFromTrustedProcess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::BitmapMappedFromTrustedProcessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::skia::mojom::InlineBitmapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::skia::mojom::InlineBitmapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::skia::mojom::internal::InlineBitmap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_info)::BaseType> image_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32ImageInfoDataView>(
      in_image_info,
      image_info_fragment);

    fragment->image_info.Set(
        image_info_fragment.is_null() ? nullptr : image_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_info in InlineBitmap struct");

    decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixel_data)::BaseType>
        pixel_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pixel_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_pixel_data,
      pixel_data_fragment,
      &pixel_data_validate_params);

    fragment->pixel_data.Set(
        pixel_data_fragment.is_null() ? nullptr : pixel_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pixel_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_data in InlineBitmap struct");
  }

  static bool Deserialize(::skia::mojom::internal::InlineBitmap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::skia::mojom::InlineBitmapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace skia::mojom {

inline void BitmapN32DataView::GetImageInfoDataView(
    ::skia::mojom::BitmapN32ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::BitmapN32ImageInfoDataView(pointer, message_);
}
inline void BitmapN32DataView::GetPixelDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->pixel_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void BitmapWithArbitraryBppDataView::GetImageInfoDataView(
    ::skia::mojom::ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::ImageInfoDataView(pointer, message_);
}
inline void BitmapWithArbitraryBppDataView::GetPixelDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->pixel_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void BitmapMappedFromTrustedProcessDataView::GetImageInfoDataView(
    ::skia::mojom::ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::ImageInfoDataView(pointer, message_);
}
inline void BitmapMappedFromTrustedProcessDataView::GetPixelDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->pixel_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void InlineBitmapDataView::GetImageInfoDataView(
    ::skia::mojom::BitmapN32ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::BitmapN32ImageInfoDataView(pointer, message_);
}
inline void InlineBitmapDataView::GetPixelDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pixel_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // skia::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_SHARED_H_