// services/webnn/public/mojom/webnn_tensor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_tensor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-blink-import-headers.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace webnn::mojom::blink {
TensorUsage::TensorUsage()
    : web_gpu_interop(),
      read(),
      write(),
      graph_constant() {}

TensorUsage::TensorUsage(
    bool web_gpu_interop_in,
    bool read_in,
    bool write_in,
    bool graph_constant_in)
    : web_gpu_interop(std::move(web_gpu_interop_in)),
      read(std::move(read_in)),
      write(std::move(write_in)),
      graph_constant(std::move(graph_constant_in)) {}

TensorUsage::~TensorUsage() = default;

void TensorUsage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_gpu_interop"), this->web_gpu_interop,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read"), this->read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "write"), this->write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "graph_constant"), this->graph_constant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TensorUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TensorInfo::TensorInfo()
    : descriptor(mojo::internal::DefaultConstructTag()),
      usage() {}

TensorInfo::TensorInfo(
    const ::webnn::OperandDescriptor& descriptor_in,
    ::webnn::MLTensorUsage usage_in)
    : descriptor(std::move(descriptor_in)),
      usage(std::move(usage_in)) {}

TensorInfo::~TensorInfo() = default;

void TensorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor"), this->descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandDescriptor&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::webnn::MLTensorUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TensorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadTensorResultPtr
ReadTensorResult::NewBuffer(
    ::mojo_base::BigBuffer value) {
  return ReadTensorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBuffer)>,
      std::move(value));
}

ReadTensorResultPtr
ReadTensorResult::NewError(
    ::webnn::mojom::blink::ErrorPtr value) {
  return ReadTensorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

ReadTensorResult::ReadTensorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
    ::mojo_base::BigBuffer value)
    : tag_(Tag::kBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBuffer)>,
            std::move(value)) {}

ReadTensorResult::ReadTensorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
ReadTensorResult::~ReadTensorResult() {
  DestroyActive();
}

void ReadTensorResult::set_buffer(::mojo_base::BigBuffer buffer) {
  if (tag_ == Tag::kBuffer) {
    data_.buffer = std::move(buffer);
  } else {
    DestroyActive();
    tag_ = Tag::kBuffer;
    new (&data_.buffer) ::mojo_base::BigBuffer(
        std::move(buffer));
  }
}

void ReadTensorResult::set_error(::webnn::mojom::blink::ErrorPtr error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) ::webnn::mojom::blink::ErrorPtr(
        std::move(error));
  }
}


ReadTensorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBuffer)>,
    ::mojo_base::BigBuffer value)
    : buffer(std::move(value)) {}

ReadTensorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : error(std::move(value)) {}

void ReadTensorResult::DestroyActive() {
  switch (tag_) {

    case Tag::kBuffer:
      std::destroy_at(&data_.buffer);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool ReadTensorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebNNTensor_ExportTensor_ResponseParam_ResultPtr
WebNNTensor_ExportTensor_ResponseParam_Result::NewSuccess(
    const ::gpu::SyncToken& value) {
  return WebNNTensor_ExportTensor_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

WebNNTensor_ExportTensor_ResponseParam_ResultPtr
WebNNTensor_ExportTensor_ResponseParam_Result::NewFailure(
    ::webnn::mojom::blink::ErrorPtr value) {
  return WebNNTensor_ExportTensor_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

WebNNTensor_ExportTensor_ResponseParam_Result::WebNNTensor_ExportTensor_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::gpu::SyncToken& value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

WebNNTensor_ExportTensor_ResponseParam_Result::WebNNTensor_ExportTensor_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
WebNNTensor_ExportTensor_ResponseParam_Result::~WebNNTensor_ExportTensor_ResponseParam_Result() {
  DestroyActive();
}

void WebNNTensor_ExportTensor_ResponseParam_Result::set_success(const ::gpu::SyncToken& success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::gpu::SyncToken(
        std::move(success));
  }
}

void WebNNTensor_ExportTensor_ResponseParam_Result::set_failure(::webnn::mojom::blink::ErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) ::webnn::mojom::blink::ErrorPtr(
        std::move(failure));
  }
}


WebNNTensor_ExportTensor_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    const ::gpu::SyncToken& value)
    : success(std::move(value)) {}

WebNNTensor_ExportTensor_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : failure(std::move(value)) {}

void WebNNTensor_ExportTensor_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool WebNNTensor_ExportTensor_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebNNTensor::IPCStableHashFunction WebNNTensor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebNNTensor>(message.name())) {
    case messages::WebNNTensor::kReadTensor: {
      return &WebNNTensor::ReadTensor_Sym::IPCStableHash;
    }
    case messages::WebNNTensor::kWriteTensor: {
      return &WebNNTensor::WriteTensor_Sym::IPCStableHash;
    }
    case messages::WebNNTensor::kExportTensor: {
      return &WebNNTensor::ExportTensor_Sym::IPCStableHash;
    }
    case messages::WebNNTensor::kImportTensor: {
      return &WebNNTensor::ImportTensor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebNNTensor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebNNTensor>(message.name())) {
      case messages::WebNNTensor::kReadTensor:
            return "Receive webnn::mojom::WebNNTensor::ReadTensor";
      case messages::WebNNTensor::kWriteTensor:
            return "Receive webnn::mojom::WebNNTensor::WriteTensor";
      case messages::WebNNTensor::kExportTensor:
            return "Receive webnn::mojom::WebNNTensor::ExportTensor";
      case messages::WebNNTensor::kImportTensor:
            return "Receive webnn::mojom::WebNNTensor::ImportTensor";
    }
  } else {
    switch (static_cast<messages::WebNNTensor>(message.name())) {
      case messages::WebNNTensor::kReadTensor:
            return "Receive reply webnn::mojom::WebNNTensor::ReadTensor";
      case messages::WebNNTensor::kWriteTensor:
            return "Receive reply webnn::mojom::WebNNTensor::WriteTensor";
      case messages::WebNNTensor::kExportTensor:
            return "Receive reply webnn::mojom::WebNNTensor::ExportTensor";
      case messages::WebNNTensor::kImportTensor:
            return "Receive reply webnn::mojom::WebNNTensor::ImportTensor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebNNTensor::ReadTensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54c05450;  // IPCStableHash for webnn::mojom::WebNNTensor::ReadTensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNTensor::WriteTensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5447e0c;  // IPCStableHash for webnn::mojom::WebNNTensor::WriteTensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNTensor::ExportTensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x084cb78d;  // IPCStableHash for webnn::mojom::WebNNTensor::ExportTensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebNNTensor::ImportTensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf092844;  // IPCStableHash for webnn::mojom::WebNNTensor::ImportTensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebNNTensor_ReadTensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNTensor_ReadTensor_ForwardToCallback(
      WebNNTensor::ReadTensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNTensor_ReadTensor_ForwardToCallback(const WebNNTensor_ReadTensor_ForwardToCallback&) = delete;
  WebNNTensor_ReadTensor_ForwardToCallback& operator=(const WebNNTensor_ReadTensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNTensor::ReadTensorCallback callback_;
};

class WebNNTensor_ExportTensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNTensor_ExportTensor_ForwardToCallback(
      WebNNTensor::ExportTensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNTensor_ExportTensor_ForwardToCallback(const WebNNTensor_ExportTensor_ForwardToCallback&) = delete;
  WebNNTensor_ExportTensor_ForwardToCallback& operator=(const WebNNTensor_ExportTensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNTensor::ExportTensorCallback callback_;
};

WebNNTensorProxy::WebNNTensorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebNNTensorProxy::ReadTensor(
    ReadTensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webnn::mojom::WebNNTensor::ReadTensor");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kReadTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_ReadTensor_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("ReadTensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNTensor_ReadTensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebNNTensorProxy::WriteTensor(
    ::mojo_base::BigBuffer in_src_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNTensor::WriteTensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_buffer"), in_src_buffer,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kWriteTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_WriteTensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->src_buffer)>
      src_buffer_fragment(params.message());
  src_buffer_fragment.Claim(&params->src_buffer);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_src_buffer,
    src_buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_buffer in WebNNTensor.WriteTensor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("WriteTensor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebNNTensorProxy::ExportTensor(
    ExportTensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send webnn::mojom::WebNNTensor::ExportTensor");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kExportTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_ExportTensor_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("ExportTensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNTensor_ExportTensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebNNTensorProxy::ImportTensor(
    const ::gpu::SyncToken& in_fence) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNTensor::ImportTensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fence"), in_fence,
                        "<value of type const ::gpu::SyncToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kImportTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_ImportTensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->fence)::BaseType> fence_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
    in_fence,
    fence_fragment);

  params->fence.Set(
      fence_fragment.is_null() ? nullptr : fence_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fence.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fence in WebNNTensor.ImportTensor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("ImportTensor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebNNTensor_ReadTensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNTensor::ReadTensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNTensor_ReadTensor_ProxyToResponder> proxy(
        new WebNNTensor_ReadTensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebNNTensor_ReadTensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebNNTensor_ReadTensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNTensor_ReadTensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNTensor::ReadTensorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ReadTensorResultPtr in_result);
};

bool WebNNTensor_ReadTensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNTensor_ReadTensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNTensor_ReadTensor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNTensor.0
  bool success = true;
  ReadTensorResultPtr p_result{};
  WebNNTensor_ReadTensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNTensor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebNNTensor_ReadTensor_ProxyToResponder::Run(
    ReadTensorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNTensor::ReadTensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ReadTensorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kReadTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_ReadTensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::ReadTensorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("ReadTensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebNNTensor_ExportTensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNTensor::ExportTensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNTensor_ExportTensor_ProxyToResponder> proxy(
        new WebNNTensor_ExportTensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&WebNNTensor_ExportTensor_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static WebNNTensor_ExportTensor_ResponseParam_ResultPtr Transform(base::expected<
  ::gpu::SyncToken,
  ::webnn::mojom::blink::ErrorPtr> in) {
    return in.has_value() ? ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~WebNNTensor_ExportTensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNTensor_ExportTensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNTensor::ExportTensorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebNNTensor_ExportTensor_ResponseParam_ResultPtr in_result);
};

bool WebNNTensor_ExportTensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNTensor_ExportTensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNTensor_ExportTensor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNTensor.2
  bool success = true;
  WebNNTensor_ExportTensor_ResponseParam_ResultPtr p_result{};
  WebNNTensor_ExportTensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNTensor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void WebNNTensor_ExportTensor_ProxyToResponder::Run(
    WebNNTensor_ExportTensor_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNTensor::ExportTensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebNNTensor_ExportTensor_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNTensor::kExportTensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNTensor_ExportTensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNTensor::Name_);
  message.set_method_name("ExportTensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebNNTensorStubDispatch::Accept(
    WebNNTensor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebNNTensor>(message->header()->name)) {
    case messages::WebNNTensor::kReadTensor: {
      break;
    }
    case messages::WebNNTensor::kWriteTensor: {
      DCHECK(message->is_serialized());
      internal::WebNNTensor_WriteTensor_Params_Data* params =
          reinterpret_cast<internal::WebNNTensor_WriteTensor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebNNTensor.1
      bool success = true;
      ::mojo_base::BigBuffer p_src_buffer{};
      WebNNTensor_WriteTensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSrcBuffer(&p_src_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNTensor::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteTensor(        
        std::move(p_src_buffer));
      return true;
    }
    case messages::WebNNTensor::kExportTensor: {
      break;
    }
    case messages::WebNNTensor::kImportTensor: {
      DCHECK(message->is_serialized());
      internal::WebNNTensor_ImportTensor_Params_Data* params =
          reinterpret_cast<internal::WebNNTensor_ImportTensor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebNNTensor.3
      bool success = true;
      ::gpu::SyncToken p_fence{};
      WebNNTensor_ImportTensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFence(&p_fence))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNTensor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportTensor(        
        std::move(p_fence));
      return true;
    }
  }
  return false;
}

// static
bool WebNNTensorStubDispatch::AcceptWithResponder(
    WebNNTensor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebNNTensor>(message->header()->name)) {
    case messages::WebNNTensor::kReadTensor: {
      internal::WebNNTensor_ReadTensor_Params_Data* params =
          reinterpret_cast<
              internal::WebNNTensor_ReadTensor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNTensor.0
      bool success = true;
      WebNNTensor_ReadTensor_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNTensor::Name_, 0, false);
        return false;
      }
      auto callback =
          WebNNTensor_ReadTensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadTensor(std::move(callback));
      return true;
    }
    case messages::WebNNTensor::kWriteTensor: {
      break;
    }
    case messages::WebNNTensor::kExportTensor: {
      internal::WebNNTensor_ExportTensor_Params_Data* params =
          reinterpret_cast<
              internal::WebNNTensor_ExportTensor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNTensor.2
      bool success = true;
      WebNNTensor_ExportTensor_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNTensor::Name_, 2, false);
        return false;
      }
      auto callback =
          WebNNTensor_ExportTensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExportTensor(std::move(callback));
      return true;
    }
    case messages::WebNNTensor::kImportTensor: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebNNTensorValidationInfo[] = {
    { &internal::WebNNTensor_ReadTensor_Params_Data::Validate,
     &internal::WebNNTensor_ReadTensor_ResponseParams_Data::Validate},
    { &internal::WebNNTensor_WriteTensor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebNNTensor_ExportTensor_Params_Data::Validate,
     &internal::WebNNTensor_ExportTensor_ResponseParams_Data::Validate},
    { &internal::WebNNTensor_ImportTensor_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebNNTensorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNTensor::Name_,
    kWebNNTensorValidationInfo);
}

bool WebNNTensorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNTensor::Name_,
    kWebNNTensorValidationInfo);
}


}  // webnn::mojom::blink


namespace mojo {


// static
bool StructTraits<::webnn::mojom::blink::TensorUsage::DataView, ::webnn::mojom::blink::TensorUsagePtr>::Read(
    ::webnn::mojom::blink::TensorUsage::DataView input,
    ::webnn::mojom::blink::TensorUsagePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TensorUsagePtr result(::webnn::mojom::blink::TensorUsage::New());
  
      if (success)
        result->web_gpu_interop = input.web_gpu_interop();
      if (success)
        result->read = input.read();
      if (success)
        result->write = input.write();
      if (success)
        result->graph_constant = input.graph_constant();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::TensorInfo::DataView, ::webnn::mojom::blink::TensorInfoPtr>::Read(
    ::webnn::mojom::blink::TensorInfo::DataView input,
    ::webnn::mojom::blink::TensorInfoPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TensorInfoPtr result(::webnn::mojom::blink::TensorInfo::New());
  
      if (success && !input.ReadDescriptor(&result->descriptor))
        success = false;
      if (success && !input.ReadUsage(&result->usage))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::webnn::mojom::blink::ReadTensorResult::DataView, ::webnn::mojom::blink::ReadTensorResultPtr>::Read(
    ::webnn::mojom::blink::ReadTensorResult::DataView input,
    ::webnn::mojom::blink::ReadTensorResultPtr* output) {
  using UnionType = ::webnn::mojom::blink::ReadTensorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBuffer: {
      ::mojo_base::BigBuffer result_buffer{};
      if (!input.ReadBuffer(&result_buffer))
        return false;

      *output = UnionType::NewBuffer(
          std::move(result_buffer));
      break;
    }
    case Tag::kError: {
      ::webnn::mojom::blink::ErrorPtr result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_Result::DataView, ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_ResultPtr>::Read(
    ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_Result::DataView input,
    ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_ResultPtr* output) {
  using UnionType = ::webnn::mojom::blink::WebNNTensor_ExportTensor_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::gpu::SyncToken result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::webnn::mojom::blink::ErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom::blink {


void WebNNTensorInterceptorForTesting::ReadTensor(ReadTensorCallback callback) {
  GetForwardingInterface()->ReadTensor(std::move(callback));
}
void WebNNTensorInterceptorForTesting::WriteTensor(::mojo_base::BigBuffer src_buffer) {
  GetForwardingInterface()->WriteTensor(
    std::move(src_buffer)
    );
}
void WebNNTensorInterceptorForTesting::ExportTensor(ExportTensorCallback callback) {
  GetForwardingInterface()->ExportTensor(std::move(callback));
}
void WebNNTensorInterceptorForTesting::ImportTensor(const ::gpu::SyncToken& fence) {
  GetForwardingInterface()->ImportTensor(
    std::move(fence)
    );
}
WebNNTensorAsyncWaiter::WebNNTensorAsyncWaiter(
    WebNNTensor* proxy) : proxy_(proxy) {}

WebNNTensorAsyncWaiter::~WebNNTensorAsyncWaiter() = default;


void WebNNTensorAsyncWaiter::ReadTensor(
    ReadTensorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ReadTensor(
      base::BindOnce(
          [](base::RunLoop* loop,
             ReadTensorResultPtr* out_result
,
             ReadTensorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ReadTensorResultPtr WebNNTensorAsyncWaiter::ReadTensor(
    ) {
  ReadTensorResultPtr async_wait_result;
  ReadTensor(&async_wait_result);
  return async_wait_result;
}






}  // webnn::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif