// services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SHARED_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/webnn/public/mojom/webnn_graph_builder.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateGraphSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateGraphSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateGraphSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::graph_remote(input)) in_graph_remote = Traits::graph_remote(input);

    
    mojo::internal::Serialize<::webnn::mojom::WebNNGraphAssociatedPtrInfoDataView>(
      in_graph_remote,
      &fragment->graph_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->graph_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid graph_remote in CreateGraphSuccess struct");

    decltype(Traits::devices(input)) in_devices = Traits::devices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devices)::BaseType>
        devices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::webnn::mojom::internal::Device_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webnn::mojom::Device>>(
      in_devices,
      devices_fragment,
      &devices_validate_params);

    fragment->devices.Set(
        devices_fragment.is_null() ? nullptr : devices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in CreateGraphSuccess struct");
  }

  static bool Deserialize(::webnn::mojom::internal::CreateGraphSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateGraphSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateGraphSuccessDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebNNGraphBuilder_CreateGraph_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in WebNNGraphBuilder_CreateGraph_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webnn::mojom {

inline void CreateGraphSuccessDataView::GetDevicesDataView(
    mojo::ArrayDataView<::webnn::mojom::Device>* output) {
  auto pointer = data_->devices.Get();
  *output = mojo::ArrayDataView<::webnn::mojom::Device>(pointer, message_);
}


inline void WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::GetSuccessDataView(
    CreateGraphSuccessDataView* output) const {
  CHECK(is_success());
  *output = CreateGraphSuccessDataView(data_->data.f_success.Get(), message_);
}
inline void WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView::GetFailureDataView(
    ::webnn::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::webnn::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}


}  // webnn::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_SHARED_H_