// services/webnn/public/mojom/webnn_graph_builder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_PARAMS_DATA_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace webnn::mojom {
namespace internal {
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNGraphBuilder_CreatePendingConstant_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::WebNNPendingConstantToken_Data> constant_handle;
  int32_t data_type;
  uint8_t pad1_[4];
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  friend class mojo::internal::MessageFragment<WebNNGraphBuilder_CreatePendingConstant_Params_Data>;

  WebNNGraphBuilder_CreatePendingConstant_Params_Data();
  ~WebNNGraphBuilder_CreatePendingConstant_Params_Data() = delete;
};
static_assert(sizeof(WebNNGraphBuilder_CreatePendingConstant_Params_Data) == 40,
              "Bad sizeof(WebNNGraphBuilder_CreatePendingConstant_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNGraphBuilder_CreateGraph_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::webnn::mojom::internal::GraphInfo_Data> graph_info;

 private:
  friend class mojo::internal::MessageFragment<WebNNGraphBuilder_CreateGraph_Params_Data>;

  WebNNGraphBuilder_CreateGraph_Params_Data();
  ~WebNNGraphBuilder_CreateGraph_Params_Data() = delete;
};
static_assert(sizeof(WebNNGraphBuilder_CreateGraph_Params_Data) == 16,
              "Bad sizeof(WebNNGraphBuilder_CreateGraph_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNGraphBuilder_CreateGraph_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data result;

 private:
  friend class mojo::internal::MessageFragment<WebNNGraphBuilder_CreateGraph_ResponseParams_Data>;

  WebNNGraphBuilder_CreateGraph_ResponseParams_Data();
  ~WebNNGraphBuilder_CreateGraph_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebNNGraphBuilder_CreateGraph_ResponseParams_Data) == 24,
              "Bad sizeof(WebNNGraphBuilder_CreateGraph_ResponseParams_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNGraphBuilder_IsValidGraphForTesting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::webnn::mojom::internal::ContextProperties_Data> context_properties;
  mojo::internal::Pointer<::webnn::mojom::internal::GraphInfo_Data> graph_info;

 private:
  friend class mojo::internal::MessageFragment<WebNNGraphBuilder_IsValidGraphForTesting_Params_Data>;

  WebNNGraphBuilder_IsValidGraphForTesting_Params_Data();
  ~WebNNGraphBuilder_IsValidGraphForTesting_Params_Data() = delete;
};
static_assert(sizeof(WebNNGraphBuilder_IsValidGraphForTesting_Params_Data) == 24,
              "Bad sizeof(WebNNGraphBuilder_IsValidGraphForTesting_Params_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_valid : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data>;

  WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data();
  ~WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data) == 16,
              "Bad sizeof(WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data)");

}  // namespace internal


class WebNNGraphBuilder_CreatePendingConstant_ParamsDataView {
 public:
  WebNNGraphBuilder_CreatePendingConstant_ParamsDataView() = default;

  WebNNGraphBuilder_CreatePendingConstant_ParamsDataView(
      internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConstantHandleDataView(
      ::blink::mojom::WebNNPendingConstantTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstantHandle(UserType* output) {
    
    auto* pointer = data_->constant_handle.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebNNPendingConstantTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDataType(UserType* output) const {
    auto data_value = data_->data_type;
    return mojo::internal::Deserialize<::webnn::mojom::DataType>(
        data_value, output);
  }
  ::webnn::mojom::DataType data_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::DataType>(data_->data_type));
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNGraphBuilder_CreatePendingConstant_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNGraphBuilder_CreateGraph_ParamsDataView {
 public:
  WebNNGraphBuilder_CreateGraph_ParamsDataView() = default;

  WebNNGraphBuilder_CreateGraph_ParamsDataView(
      internal::WebNNGraphBuilder_CreateGraph_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGraphInfoDataView(
      ::webnn::mojom::GraphInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGraphInfo(UserType* output) {
    
    auto* pointer = data_->graph_info.Get();
    return mojo::internal::Deserialize<::webnn::mojom::GraphInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNGraphBuilder_CreateGraph_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNGraphBuilder_CreateGraph_ResponseParamsDataView {
 public:
  WebNNGraphBuilder_CreateGraph_ResponseParamsDataView() = default;

  WebNNGraphBuilder_CreateGraph_ResponseParamsDataView(
      internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNGraphBuilder_CreateGraph_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView {
 public:
  WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView() = default;

  WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView(
      internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContextPropertiesDataView(
      ::webnn::mojom::ContextPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextProperties(UserType* output) {
    
    auto* pointer = data_->context_properties.Get();
    return mojo::internal::Deserialize<::webnn::mojom::ContextPropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetGraphInfoDataView(
      ::webnn::mojom::GraphInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGraphInfo(UserType* output) {
    
    auto* pointer = data_->graph_info.Get();
    return mojo::internal::Deserialize<::webnn::mojom::GraphInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebNNGraphBuilder_IsValidGraphForTesting_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNGraphBuilder_IsValidGraphForTesting_ResponseParamsDataView {
 public:
  WebNNGraphBuilder_IsValidGraphForTesting_ResponseParamsDataView() = default;

  WebNNGraphBuilder_IsValidGraphForTesting_ResponseParamsDataView(
      internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_valid() const {
    return data_->is_valid;
  }
 private:
  internal::WebNNGraphBuilder_IsValidGraphForTesting_ResponseParams_Data* data_ = nullptr;
};

inline void WebNNGraphBuilder_CreatePendingConstant_ParamsDataView::GetConstantHandleDataView(
    ::blink::mojom::WebNNPendingConstantTokenDataView* output) {
  auto pointer = data_->constant_handle.Get();
  *output = ::blink::mojom::WebNNPendingConstantTokenDataView(pointer, message_);
}
inline void WebNNGraphBuilder_CreatePendingConstant_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void WebNNGraphBuilder_CreateGraph_ParamsDataView::GetGraphInfoDataView(
    ::webnn::mojom::GraphInfoDataView* output) {
  auto pointer = data_->graph_info.Get();
  *output = ::webnn::mojom::GraphInfoDataView(pointer, message_);
}


inline void WebNNGraphBuilder_CreateGraph_ResponseParamsDataView::GetResultDataView(
    WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView* output) {
  auto pointer = &data_->result;
  *output = WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView(pointer, message_);
}


inline void WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView::GetContextPropertiesDataView(
    ::webnn::mojom::ContextPropertiesDataView* output) {
  auto pointer = data_->context_properties.Get();
  *output = ::webnn::mojom::ContextPropertiesDataView(pointer, message_);
}
inline void WebNNGraphBuilder_IsValidGraphForTesting_ParamsDataView::GetGraphInfoDataView(
    ::webnn::mojom::GraphInfoDataView* output) {
  auto pointer = data_->graph_info.Get();
  *output = ::webnn::mojom::GraphInfoDataView(pointer, message_);
}





}  // webnn::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_PARAMS_DATA_H_