// services/webnn/public/mojom/webnn_graph_builder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace webnn::mojom {
class CreateGraphSuccessDataView;

class WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView;


}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::CreateGraphSuccessDataView> {
  using Data = ::webnn::mojom::internal::CreateGraphSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView> {
  using Data = ::webnn::mojom::internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {
// Interface base classes. They are used for type safety check.
class WebNNGraphBuilderInterfaceBase {};

using WebNNGraphBuilderPtrDataView =
    mojo::InterfacePtrDataView<WebNNGraphBuilderInterfaceBase>;
using WebNNGraphBuilderRequestDataView =
    mojo::InterfaceRequestDataView<WebNNGraphBuilderInterfaceBase>;
using WebNNGraphBuilderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebNNGraphBuilderInterfaceBase>;
using WebNNGraphBuilderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebNNGraphBuilderInterfaceBase>;


class CreateGraphSuccessDataView {
 public:
  CreateGraphSuccessDataView() = default;

  CreateGraphSuccessDataView(
      internal::CreateGraphSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeGraphRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::webnn::mojom::WebNNGraphAssociatedPtrInfoDataView>(
            &data_->graph_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDevicesDataView(
      mojo::ArrayDataView<::webnn::mojom::Device>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevices(UserType* output) {
    
    auto* pointer = data_->devices.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::Device>>(
        pointer, output, message_);
  }
 private:
  internal::CreateGraphSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView {
 public:
  using Tag = internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Tag;

  WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView() = default;

  WebNNGraphBuilder_CreateGraph_ResponseParam_ResultDataView(
      internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      CreateGraphSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::webnn::mojom::CreateGraphSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::webnn::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::webnn::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::WebNNGraphBuilder_CreateGraph_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_BUILDER_MOJOM_DATA_VIEW_H_