// services/webnn/public/mojom/webnn_graph.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-shared-internal.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace webnn::mojom {
class OperandDescriptorDataView;

class OperandIdDataView;

class OperandDataView;

class ArgMinMaxDataView;

class BatchNormalizationDataView;

class ClampDataView;

class ConcatDataView;

class Size2dDataView;

class Padding2dDataView;

class Conv2dDataView;

class CumulativeSumDataView;

class DequantizeLinearDataView;

class ElementWiseBinaryDataView;

class ElementWiseUnaryDataView;

class ExpandDataView;

class ConstantPaddingDataView;

class EdgePaddingDataView;

class ReflectionPaddingDataView;

class InstanceNormalizationDataView;

class MatmulDataView;

class PadDataView;

class ReduceDataView;

class Pool2dDataView;

class RangeDataView;

class SliceDataView;

class EluDataView;

class GatherDataView;

class GatherElementsDataView;

class GatherNDDataView;

class GeluDataView;

class GruDataView;

class GruCellDataView;

class GemmDataView;

class HardSigmoidDataView;

class HardSwishDataView;

class LayerNormalizationDataView;

class LeakyReluDataView;

class LinearDataView;

class LstmDataView;

class LstmCellDataView;

class PreluDataView;

class QuantizeLinearDataView;

class ReluDataView;

class ReshapeDataView;

class ReverseDataView;

class ScatterElementsDataView;

class ScatterNDDataView;

class SigmoidDataView;

class SoftmaxDataView;

class SoftplusDataView;

class SoftsignDataView;

class SplitDataView;

class TanhDataView;

class TileDataView;

class TransposeDataView;

class TriangularDataView;

class Resample2dDataView;

class WhereDataView;

class GraphInfoDataView;

class NumberDataView;
class PaddingModeDataView;
class OperationDataView;


}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::OperandDescriptorDataView> {
  using Data = ::webnn::mojom::internal::OperandDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::OperandIdDataView> {
  using Data = ::webnn::mojom::internal::OperandId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::OperandDataView> {
  using Data = ::webnn::mojom::internal::Operand_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ArgMinMaxDataView> {
  using Data = ::webnn::mojom::internal::ArgMinMax_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::BatchNormalizationDataView> {
  using Data = ::webnn::mojom::internal::BatchNormalization_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ClampDataView> {
  using Data = ::webnn::mojom::internal::Clamp_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ConcatDataView> {
  using Data = ::webnn::mojom::internal::Concat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::Size2dDataView> {
  using Data = ::webnn::mojom::internal::Size2d_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::Padding2dDataView> {
  using Data = ::webnn::mojom::internal::Padding2d_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::Conv2dDataView> {
  using Data = ::webnn::mojom::internal::Conv2d_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::CumulativeSumDataView> {
  using Data = ::webnn::mojom::internal::CumulativeSum_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::DequantizeLinearDataView> {
  using Data = ::webnn::mojom::internal::DequantizeLinear_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ElementWiseBinaryDataView> {
  using Data = ::webnn::mojom::internal::ElementWiseBinary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ElementWiseUnaryDataView> {
  using Data = ::webnn::mojom::internal::ElementWiseUnary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ExpandDataView> {
  using Data = ::webnn::mojom::internal::Expand_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ConstantPaddingDataView> {
  using Data = ::webnn::mojom::internal::ConstantPadding_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::EdgePaddingDataView> {
  using Data = ::webnn::mojom::internal::EdgePadding_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReflectionPaddingDataView> {
  using Data = ::webnn::mojom::internal::ReflectionPadding_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::InstanceNormalizationDataView> {
  using Data = ::webnn::mojom::internal::InstanceNormalization_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::MatmulDataView> {
  using Data = ::webnn::mojom::internal::Matmul_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::PadDataView> {
  using Data = ::webnn::mojom::internal::Pad_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReduceDataView> {
  using Data = ::webnn::mojom::internal::Reduce_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::Pool2dDataView> {
  using Data = ::webnn::mojom::internal::Pool2d_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::RangeDataView> {
  using Data = ::webnn::mojom::internal::Range_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SliceDataView> {
  using Data = ::webnn::mojom::internal::Slice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::EluDataView> {
  using Data = ::webnn::mojom::internal::Elu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GatherDataView> {
  using Data = ::webnn::mojom::internal::Gather_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GatherElementsDataView> {
  using Data = ::webnn::mojom::internal::GatherElements_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GatherNDDataView> {
  using Data = ::webnn::mojom::internal::GatherND_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GeluDataView> {
  using Data = ::webnn::mojom::internal::Gelu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GruDataView> {
  using Data = ::webnn::mojom::internal::Gru_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GruCellDataView> {
  using Data = ::webnn::mojom::internal::GruCell_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GemmDataView> {
  using Data = ::webnn::mojom::internal::Gemm_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::HardSigmoidDataView> {
  using Data = ::webnn::mojom::internal::HardSigmoid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::HardSwishDataView> {
  using Data = ::webnn::mojom::internal::HardSwish_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::LayerNormalizationDataView> {
  using Data = ::webnn::mojom::internal::LayerNormalization_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::LeakyReluDataView> {
  using Data = ::webnn::mojom::internal::LeakyRelu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::LinearDataView> {
  using Data = ::webnn::mojom::internal::Linear_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::LstmDataView> {
  using Data = ::webnn::mojom::internal::Lstm_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::LstmCellDataView> {
  using Data = ::webnn::mojom::internal::LstmCell_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::PreluDataView> {
  using Data = ::webnn::mojom::internal::Prelu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::QuantizeLinearDataView> {
  using Data = ::webnn::mojom::internal::QuantizeLinear_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReluDataView> {
  using Data = ::webnn::mojom::internal::Relu_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReshapeDataView> {
  using Data = ::webnn::mojom::internal::Reshape_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReverseDataView> {
  using Data = ::webnn::mojom::internal::Reverse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ScatterElementsDataView> {
  using Data = ::webnn::mojom::internal::ScatterElements_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ScatterNDDataView> {
  using Data = ::webnn::mojom::internal::ScatterND_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SigmoidDataView> {
  using Data = ::webnn::mojom::internal::Sigmoid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SoftmaxDataView> {
  using Data = ::webnn::mojom::internal::Softmax_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SoftplusDataView> {
  using Data = ::webnn::mojom::internal::Softplus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SoftsignDataView> {
  using Data = ::webnn::mojom::internal::Softsign_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SplitDataView> {
  using Data = ::webnn::mojom::internal::Split_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::TanhDataView> {
  using Data = ::webnn::mojom::internal::Tanh_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::TileDataView> {
  using Data = ::webnn::mojom::internal::Tile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::TransposeDataView> {
  using Data = ::webnn::mojom::internal::Transpose_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::TriangularDataView> {
  using Data = ::webnn::mojom::internal::Triangular_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::Resample2dDataView> {
  using Data = ::webnn::mojom::internal::Resample2d_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::WhereDataView> {
  using Data = ::webnn::mojom::internal::Where_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::GraphInfoDataView> {
  using Data = ::webnn::mojom::internal::GraphInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::NumberDataView> {
  using Data = ::webnn::mojom::internal::Number_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::webnn::mojom::PaddingModeDataView> {
  using Data = ::webnn::mojom::internal::PaddingMode_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::webnn::mojom::OperationDataView> {
  using Data = ::webnn::mojom::internal::Operation_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {


enum class DataType : int32_t {
  
  kFloat32 = 0,
  
  kFloat16 = 1,
  
  kInt32 = 2,
  
  kUint32 = 3,
  
  kInt64 = 4,
  
  kUint64 = 5,
  
  kInt8 = 6,
  
  kUint8 = 7,
  
  kInt4 = 8,
  
  kUint4 = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DataType value);
inline bool IsKnownEnumValue(DataType value) {
  return internal::DataType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RecurrentNetworkActivation : int32_t {
  
  kRelu = 0,
  
  kSigmoid = 1,
  
  kTanh = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, RecurrentNetworkActivation value);
inline bool IsKnownEnumValue(RecurrentNetworkActivation value) {
  return internal::RecurrentNetworkActivation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RecurrentNetworkDirection : int32_t {
  
  kForward = 0,
  
  kBackward = 1,
  
  kBoth = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, RecurrentNetworkDirection value);
inline bool IsKnownEnumValue(RecurrentNetworkDirection value) {
  return internal::RecurrentNetworkDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GruWeightLayout : int32_t {
  
  kZrn = 0,
  
  kRzn = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GruWeightLayout value);
inline bool IsKnownEnumValue(GruWeightLayout value) {
  return internal::GruWeightLayout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LstmWeightLayout : int32_t {
  
  kIofg = 0,
  
  kIfgo = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, LstmWeightLayout value);
inline bool IsKnownEnumValue(LstmWeightLayout value) {
  return internal::LstmWeightLayout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Operand_Kind : int32_t {
  
  kInput = 0,
  
  kConstant = 1,
  
  kOutput = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Operand_Kind value);
inline bool IsKnownEnumValue(Operand_Kind value) {
  return internal::Operand_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ArgMinMax_Kind : int32_t {
  
  kMin = 0,
  
  kMax = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ArgMinMax_Kind value);
inline bool IsKnownEnumValue(ArgMinMax_Kind value) {
  return internal::ArgMinMax_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Conv2d_Kind : int32_t {
  
  kDirect = 0,
  
  kTransposed = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Conv2d_Kind value);
inline bool IsKnownEnumValue(Conv2d_Kind value) {
  return internal::Conv2d_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ElementWiseBinary_Kind : int32_t {
  
  kAdd = 0,
  
  kSub = 1,
  
  kMul = 2,
  
  kDiv = 3,
  
  kMax = 4,
  
  kMin = 5,
  
  kPow = 6,
  
  kEqual = 7,
  
  kGreater = 8,
  
  kGreaterOrEqual = 9,
  
  kLesser = 10,
  
  kLesserOrEqual = 11,
  
  kNotEqual = 12,
  
  kLogicalAnd = 13,
  
  kLogicalOr = 14,
  
  kLogicalXor = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ElementWiseBinary_Kind value);
inline bool IsKnownEnumValue(ElementWiseBinary_Kind value) {
  return internal::ElementWiseBinary_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ElementWiseUnary_Kind : int32_t {
  
  kAbs = 0,
  
  kCeil = 1,
  
  kCos = 2,
  
  kExp = 3,
  
  kFloor = 4,
  
  kLog = 5,
  
  kNeg = 6,
  
  kSign = 7,
  
  kRoundEven = 8,
  
  kSin = 9,
  
  kTan = 10,
  
  kIsNaN = 11,
  
  kIsInfinite = 12,
  
  kLogicalNot = 13,
  
  kIdentity = 14,
  
  kSqrt = 15,
  
  kErf = 16,
  
  kReciprocal = 17,
  
  kCast = 18,
  kMinValue = 0,
  kMaxValue = 18,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ElementWiseUnary_Kind value);
inline bool IsKnownEnumValue(ElementWiseUnary_Kind value) {
  return internal::ElementWiseUnary_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Reduce_Kind : int32_t {
  
  kL1 = 0,
  
  kL2 = 1,
  
  kLogSum = 2,
  
  kLogSumExp = 3,
  
  kMax = 4,
  
  kMean = 5,
  
  kMin = 6,
  
  kProduct = 7,
  
  kSum = 8,
  
  kSumSquare = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Reduce_Kind value);
inline bool IsKnownEnumValue(Reduce_Kind value) {
  return internal::Reduce_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Pool2d_Kind : int32_t {
  
  kAveragePool2d = 0,
  
  kL2Pool2d = 1,
  
  kMaxPool2d = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Pool2d_Kind value);
inline bool IsKnownEnumValue(Pool2d_Kind value) {
  return internal::Pool2d_Kind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Resample2d_InterpolationMode : int32_t {
  
  kNearestNeighbor = 0,
  
  kLinear = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Resample2d_InterpolationMode value);
inline bool IsKnownEnumValue(Resample2d_InterpolationMode value) {
  return internal::Resample2d_InterpolationMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebNNGraphInterfaceBase {};

using WebNNGraphPtrDataView =
    mojo::InterfacePtrDataView<WebNNGraphInterfaceBase>;
using WebNNGraphRequestDataView =
    mojo::InterfaceRequestDataView<WebNNGraphInterfaceBase>;
using WebNNGraphAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebNNGraphInterfaceBase>;
using WebNNGraphAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebNNGraphInterfaceBase>;


class OperandDescriptorDataView {
 public:
  OperandDescriptorDataView() = default;

  OperandDescriptorDataView(
      internal::OperandDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDataType(UserType* output) const {
    auto data_value = data_->data_type;
    return mojo::internal::Deserialize<::webnn::mojom::DataType>(
        data_value, output);
  }
  DataType data_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::DataType>(data_->data_type));
  }
  inline void GetShapeDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShape(UserType* output) {
    
    auto* pointer = data_->shape.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetPendingPermutationDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPendingPermutation(UserType* output) {
    
    auto* pointer = data_->pending_permutation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::OperandDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OperandIdDataView {
 public:
  OperandIdDataView() = default;

  OperandIdDataView(
      internal::OperandId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
 private:
  internal::OperandId_Data* data_ = nullptr;
};


class OperandDataView {
 public:
  OperandDataView() = default;

  OperandDataView(
      internal::Operand_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::Operand_Kind>(
        data_value, output);
  }
  Operand_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Operand_Kind>(data_->kind));
  }
  inline void GetDescriptorDataView(
      OperandDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptor(UserType* output) {
    
    auto* pointer = data_->descriptor.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Operand_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ArgMinMaxDataView {
 public:
  ArgMinMaxDataView() = default;

  ArgMinMaxDataView(
      internal::ArgMinMax_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::ArgMinMax_Kind>(
        data_value, output);
  }
  ArgMinMax_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::ArgMinMax_Kind>(data_->kind));
  }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  bool keep_dimensions() const {
    return data_->keep_dimensions;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ArgMinMax_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BatchNormalizationDataView {
 public:
  BatchNormalizationDataView() = default;

  BatchNormalizationDataView(
      internal::BatchNormalization_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetMeanOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMeanOperandId(UserType* output) {
    
    auto* pointer = data_->mean_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetVarianceOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVarianceOperandId(UserType* output) {
    
    auto* pointer = data_->variance_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetScaleOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `scale_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScaleOperandId` instead "
    "of `ReadScaleOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scale_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  float epsilon() const {
    return data_->epsilon;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::BatchNormalization_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClampDataView {
 public:
  ClampDataView() = default;

  ClampDataView(
      internal::Clamp_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetMinValueDataView(
      NumberDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinValue(UserType* output) {
    
    auto* pointer = !data_->min_value.is_null() ? &data_->min_value : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::NumberDataView>(
        pointer, output, message_);
  }
  inline void GetMaxValueDataView(
      NumberDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxValue(UserType* output) {
    
    auto* pointer = !data_->max_value.is_null() ? &data_->max_value : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::NumberDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Clamp_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConcatDataView {
 public:
  ConcatDataView() = default;

  ConcatDataView(
      internal::Concat_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandIds(UserType* output) {
    
    auto* pointer = data_->input_operand_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Concat_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Size2dDataView {
 public:
  Size2dDataView() = default;

  Size2dDataView(
      internal::Size2d_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t height() const {
    return data_->height;
  }
  uint32_t width() const {
    return data_->width;
  }
 private:
  internal::Size2d_Data* data_ = nullptr;
};


class Padding2dDataView {
 public:
  Padding2dDataView() = default;

  Padding2dDataView(
      internal::Padding2d_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBeginningDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeginning(UserType* output) {
    
    auto* pointer = data_->beginning.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  inline void GetEndingDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnding(UserType* output) {
    
    auto* pointer = data_->ending.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
 private:
  internal::Padding2d_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Conv2dDataView {
 public:
  Conv2dDataView() = default;

  Conv2dDataView(
      internal::Conv2d_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::Conv2d_Kind>(
        data_value, output);
  }
  Conv2d_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Conv2d_Kind>(data_->kind));
  }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetFilterOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilterOperandId(UserType* output) {
    
    auto* pointer = data_->filter_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetPaddingDataView(
      Padding2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPadding(UserType* output) {
    
    auto* pointer = data_->padding.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Padding2dDataView>(
        pointer, output, message_);
  }
  inline void GetStridesDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  inline void GetDilationsDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDilations(UserType* output) {
    
    auto* pointer = data_->dilations.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  uint32_t groups() const {
    return data_->groups;
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Conv2d_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CumulativeSumDataView {
 public:
  CumulativeSumDataView() = default;

  CumulativeSumDataView(
      internal::CumulativeSum_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  bool exclusive() const {
    return data_->exclusive;
  }
  bool reversed() const {
    return data_->reversed;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CumulativeSum_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DequantizeLinearDataView {
 public:
  DequantizeLinearDataView() = default;

  DequantizeLinearDataView(
      internal::DequantizeLinear_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetScaleOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleOperandId(UserType* output) {
    
    auto* pointer = data_->scale_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetZeroPointOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZeroPointOperandId(UserType* output) {
    
    auto* pointer = data_->zero_point_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DequantizeLinear_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ElementWiseBinaryDataView {
 public:
  ElementWiseBinaryDataView() = default;

  ElementWiseBinaryDataView(
      internal::ElementWiseBinary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::ElementWiseBinary_Kind>(
        data_value, output);
  }
  ElementWiseBinary_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::ElementWiseBinary_Kind>(data_->kind));
  }
  inline void GetLhsOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLhsOperandId(UserType* output) {
    
    auto* pointer = data_->lhs_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRhsOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRhsOperandId(UserType* output) {
    
    auto* pointer = data_->rhs_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ElementWiseBinary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ElementWiseUnaryDataView {
 public:
  ElementWiseUnaryDataView() = default;

  ElementWiseUnaryDataView(
      internal::ElementWiseUnary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::ElementWiseUnary_Kind>(
        data_value, output);
  }
  ElementWiseUnary_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::ElementWiseUnary_Kind>(data_->kind));
  }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ElementWiseUnary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExpandDataView {
 public:
  ExpandDataView() = default;

  ExpandDataView(
      internal::Expand_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Expand_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConstantPaddingDataView {
 public:
  ConstantPaddingDataView() = default;

  ConstantPaddingDataView(
      internal::ConstantPadding_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      NumberDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::NumberDataView>(
        pointer, output, message_);
  }
 private:
  internal::ConstantPadding_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EdgePaddingDataView {
 public:
  EdgePaddingDataView() = default;

  EdgePaddingDataView(
      internal::EdgePadding_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::EdgePadding_Data* data_ = nullptr;
};


class ReflectionPaddingDataView {
 public:
  ReflectionPaddingDataView() = default;

  ReflectionPaddingDataView(
      internal::ReflectionPadding_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ReflectionPadding_Data* data_ = nullptr;
};


class InstanceNormalizationDataView {
 public:
  InstanceNormalizationDataView() = default;

  InstanceNormalizationDataView(
      internal::InstanceNormalization_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetScaleOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `scale_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScaleOperandId` instead "
    "of `ReadScaleOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scale_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float epsilon() const {
    return data_->epsilon;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::InstanceNormalization_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MatmulDataView {
 public:
  MatmulDataView() = default;

  MatmulDataView(
      internal::Matmul_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAOperandId(UserType* output) {
    
    auto* pointer = data_->a_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBOperandId(UserType* output) {
    
    auto* pointer = data_->b_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Matmul_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PadDataView {
 public:
  PadDataView() = default;

  PadDataView(
      internal::Pad_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBeginningPaddingDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeginningPadding(UserType* output) {
    
    auto* pointer = data_->beginning_padding.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetEndingPaddingDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndingPadding(UserType* output) {
    
    auto* pointer = data_->ending_padding.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetModeDataView(
      PaddingModeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) {
    
    auto* pointer = !data_->mode.is_null() ? &data_->mode : nullptr;
    return mojo::internal::Deserialize<::webnn::mojom::PaddingModeDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Pad_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReduceDataView {
 public:
  ReduceDataView() = default;

  ReduceDataView(
      internal::Reduce_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::Reduce_Kind>(
        data_value, output);
  }
  Reduce_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Reduce_Kind>(data_->kind));
  }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetAxesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxes(UserType* output) {
    
    auto* pointer = data_->axes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  bool keep_dimensions() const {
    return data_->keep_dimensions;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Reduce_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Pool2dDataView {
 public:
  Pool2dDataView() = default;

  Pool2dDataView(
      internal::Pool2d_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::webnn::mojom::Pool2d_Kind>(
        data_value, output);
  }
  Pool2d_Kind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Pool2d_Kind>(data_->kind));
  }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetWindowDimensionsDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowDimensions(UserType* output) {
    
    auto* pointer = data_->window_dimensions.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  inline void GetPaddingDataView(
      Padding2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPadding(UserType* output) {
    
    auto* pointer = data_->padding.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Padding2dDataView>(
        pointer, output, message_);
  }
  inline void GetStridesDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  inline void GetDilationsDataView(
      Size2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDilations(UserType* output) {
    
    auto* pointer = data_->dilations.Get();
    return mojo::internal::Deserialize<::webnn::mojom::Size2dDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Pool2d_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RangeDataView {
 public:
  RangeDataView() = default;

  RangeDataView(
      internal::Range_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t start() const {
    return data_->start;
  }
  uint32_t size() const {
    return data_->size;
  }
  uint32_t stride() const {
    return data_->stride;
  }
 private:
  internal::Range_Data* data_ = nullptr;
};


class SliceDataView {
 public:
  SliceDataView() = default;

  SliceDataView(
      internal::Slice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRangesDataView(
      mojo::ArrayDataView<RangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRanges(UserType* output) {
    
    auto* pointer = data_->ranges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::RangeDataView>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Slice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EluDataView {
 public:
  EluDataView() = default;

  EluDataView(
      internal::Elu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float alpha() const {
    return data_->alpha;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Elu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GatherDataView {
 public:
  GatherDataView() = default;

  GatherDataView(
      internal::Gather_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetIndicesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndicesOperandId(UserType* output) {
    
    auto* pointer = data_->indices_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Gather_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GatherElementsDataView {
 public:
  GatherElementsDataView() = default;

  GatherElementsDataView(
      internal::GatherElements_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetIndicesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndicesOperandId(UserType* output) {
    
    auto* pointer = data_->indices_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GatherElements_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GatherNDDataView {
 public:
  GatherNDDataView() = default;

  GatherNDDataView(
      internal::GatherND_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetIndicesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndicesOperandId(UserType* output) {
    
    auto* pointer = data_->indices_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GatherND_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeluDataView {
 public:
  GeluDataView() = default;

  GeluDataView(
      internal::Gelu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Gelu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GruDataView {
 public:
  GruDataView() = default;

  GruDataView(
      internal::Gru_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeightOperandId(UserType* output) {
    
    auto* pointer = data_->weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentWeightOperandId(UserType* output) {
    
    auto* pointer = data_->recurrent_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t steps() const {
    return data_->steps;
  }
  uint32_t hidden_size() const {
    return data_->hidden_size;
  }
  inline void GetOutputOperandIdsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandIds(UserType* output) {
    
    auto* pointer = data_->output_operand_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `recurrent_bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecurrentBiasOperandId` instead "
    "of `ReadRecurrentBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recurrent_bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetInitialHiddenStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialHiddenStateOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `initial_hidden_state_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialHiddenStateOperandId` instead "
    "of `ReadInitialHiddenStateOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_hidden_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  bool reset_after() const {
    return data_->reset_after;
  }
  bool return_sequence() const {
    return data_->return_sequence;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::webnn::mojom::RecurrentNetworkDirection>(
        data_value, output);
  }
  RecurrentNetworkDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::RecurrentNetworkDirection>(data_->direction));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::webnn::mojom::GruWeightLayout>(
        data_value, output);
  }
  GruWeightLayout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::GruWeightLayout>(data_->layout));
  }
  inline void GetActivationsDataView(
      mojo::ArrayDataView<RecurrentNetworkActivation>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivations(UserType* output) {
    
    auto* pointer = data_->activations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Gru_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GruCellDataView {
 public:
  GruCellDataView() = default;

  GruCellDataView(
      internal::GruCell_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeightOperandId(UserType* output) {
    
    auto* pointer = data_->weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentWeightOperandId(UserType* output) {
    
    auto* pointer = data_->recurrent_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetHiddenStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHiddenStateOperandId(UserType* output) {
    
    auto* pointer = data_->hidden_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t hidden_size() const {
    return data_->hidden_size;
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `recurrent_bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecurrentBiasOperandId` instead "
    "of `ReadRecurrentBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recurrent_bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  bool reset_after() const {
    return data_->reset_after;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::webnn::mojom::GruWeightLayout>(
        data_value, output);
  }
  GruWeightLayout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::GruWeightLayout>(data_->layout));
  }
  inline void GetActivationsDataView(
      mojo::ArrayDataView<RecurrentNetworkActivation>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivations(UserType* output) {
    
    auto* pointer = data_->activations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GruCell_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GemmDataView {
 public:
  GemmDataView() = default;

  GemmDataView(
      internal::Gemm_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAOperandId(UserType* output) {
    
    auto* pointer = data_->a_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBOperandId(UserType* output) {
    
    auto* pointer = data_->b_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetCOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `c_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCOperandId` instead "
    "of `ReadCOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->c_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float alpha() const {
    return data_->alpha;
  }
  float beta() const {
    return data_->beta;
  }
  bool a_transpose() const {
    return data_->a_transpose;
  }
  bool b_transpose() const {
    return data_->b_transpose;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Gemm_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HardSigmoidDataView {
 public:
  HardSigmoidDataView() = default;

  HardSigmoidDataView(
      internal::HardSigmoid_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float alpha() const {
    return data_->alpha;
  }
  float beta() const {
    return data_->beta;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HardSigmoid_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HardSwishDataView {
 public:
  HardSwishDataView() = default;

  HardSwishDataView(
      internal::HardSwish_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HardSwish_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerNormalizationDataView {
 public:
  LayerNormalizationDataView() = default;

  LayerNormalizationDataView(
      internal::LayerNormalization_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetScaleOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `scale_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScaleOperandId` instead "
    "of `ReadScaleOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scale_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetAxesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxes(UserType* output) {
    
    auto* pointer = data_->axes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  float epsilon() const {
    return data_->epsilon;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LayerNormalization_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LeakyReluDataView {
 public:
  LeakyReluDataView() = default;

  LeakyReluDataView(
      internal::LeakyRelu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float alpha() const {
    return data_->alpha;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LeakyRelu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LinearDataView {
 public:
  LinearDataView() = default;

  LinearDataView(
      internal::Linear_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  float alpha() const {
    return data_->alpha;
  }
  float beta() const {
    return data_->beta;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Linear_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LstmDataView {
 public:
  LstmDataView() = default;

  LstmDataView(
      internal::Lstm_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeightOperandId(UserType* output) {
    
    auto* pointer = data_->weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentWeightOperandId(UserType* output) {
    
    auto* pointer = data_->recurrent_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandIds(UserType* output) {
    
    auto* pointer = data_->output_operand_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  uint32_t steps() const {
    return data_->steps;
  }
  uint32_t hidden_size() const {
    return data_->hidden_size;
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `recurrent_bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecurrentBiasOperandId` instead "
    "of `ReadRecurrentBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recurrent_bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetPeepholeWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPeepholeWeightOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `peephole_weight_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPeepholeWeightOperandId` instead "
    "of `ReadPeepholeWeightOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->peephole_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetInitialHiddenStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialHiddenStateOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `initial_hidden_state_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialHiddenStateOperandId` instead "
    "of `ReadInitialHiddenStateOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_hidden_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetInitialCellStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialCellStateOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `initial_cell_state_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialCellStateOperandId` instead "
    "of `ReadInitialCellStateOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_cell_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  bool return_sequence() const {
    return data_->return_sequence;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::webnn::mojom::RecurrentNetworkDirection>(
        data_value, output);
  }
  RecurrentNetworkDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::RecurrentNetworkDirection>(data_->direction));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::webnn::mojom::LstmWeightLayout>(
        data_value, output);
  }
  LstmWeightLayout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::LstmWeightLayout>(data_->layout));
  }
  inline void GetActivationsDataView(
      mojo::ArrayDataView<RecurrentNetworkActivation>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivations(UserType* output) {
    
    auto* pointer = data_->activations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Lstm_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LstmCellDataView {
 public:
  LstmCellDataView() = default;

  LstmCellDataView(
      internal::LstmCell_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeightOperandId(UserType* output) {
    
    auto* pointer = data_->weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentWeightOperandId(UserType* output) {
    
    auto* pointer = data_->recurrent_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetHiddenStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHiddenStateOperandId(UserType* output) {
    
    auto* pointer = data_->hidden_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetCellStateOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCellStateOperandId(UserType* output) {
    
    auto* pointer = data_->cell_state_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandIds(UserType* output) {
    
    auto* pointer = data_->output_operand_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  uint32_t hidden_size() const {
    return data_->hidden_size;
  }
  inline void GetBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBiasOperandId` instead "
    "of `ReadBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRecurrentBiasOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecurrentBiasOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `recurrent_bias_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecurrentBiasOperandId` instead "
    "of `ReadRecurrentBiasOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recurrent_bias_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetPeepholeWeightOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPeepholeWeightOperandId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::webnn::mojom::OperandIdDataView, UserType>(),
    "Attempting to read the optional `peephole_weight_operand_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPeepholeWeightOperandId` instead "
    "of `ReadPeepholeWeightOperandId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->peephole_weight_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::webnn::mojom::LstmWeightLayout>(
        data_value, output);
  }
  LstmWeightLayout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::LstmWeightLayout>(data_->layout));
  }
  inline void GetActivationsDataView(
      mojo::ArrayDataView<RecurrentNetworkActivation>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivations(UserType* output) {
    
    auto* pointer = data_->activations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::RecurrentNetworkActivation>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LstmCell_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PreluDataView {
 public:
  PreluDataView() = default;

  PreluDataView(
      internal::Prelu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetSlopeOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSlopeOperandId(UserType* output) {
    
    auto* pointer = data_->slope_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Prelu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class QuantizeLinearDataView {
 public:
  QuantizeLinearDataView() = default;

  QuantizeLinearDataView(
      internal::QuantizeLinear_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetScaleOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScaleOperandId(UserType* output) {
    
    auto* pointer = data_->scale_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetZeroPointOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZeroPointOperandId(UserType* output) {
    
    auto* pointer = data_->zero_point_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::QuantizeLinear_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReluDataView {
 public:
  ReluDataView() = default;

  ReluDataView(
      internal::Relu_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Relu_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReshapeDataView {
 public:
  ReshapeDataView() = default;

  ReshapeDataView(
      internal::Reshape_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Reshape_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReverseDataView {
 public:
  ReverseDataView() = default;

  ReverseDataView(
      internal::Reverse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetAxesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxes(UserType* output) {
    
    auto* pointer = data_->axes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Reverse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScatterElementsDataView {
 public:
  ScatterElementsDataView() = default;

  ScatterElementsDataView(
      internal::ScatterElements_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetIndicesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndicesOperandId(UserType* output) {
    
    auto* pointer = data_->indices_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetUpdatesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatesOperandId(UserType* output) {
    
    auto* pointer = data_->updates_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScatterElements_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScatterNDDataView {
 public:
  ScatterNDDataView() = default;

  ScatterNDDataView(
      internal::ScatterND_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetIndicesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIndicesOperandId(UserType* output) {
    
    auto* pointer = data_->indices_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetUpdatesOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdatesOperandId(UserType* output) {
    
    auto* pointer = data_->updates_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScatterND_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SigmoidDataView {
 public:
  SigmoidDataView() = default;

  SigmoidDataView(
      internal::Sigmoid_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Sigmoid_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SoftmaxDataView {
 public:
  SoftmaxDataView() = default;

  SoftmaxDataView(
      internal::Softmax_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Softmax_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SoftplusDataView {
 public:
  SoftplusDataView() = default;

  SoftplusDataView(
      internal::Softplus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Softplus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SoftsignDataView {
 public:
  SoftsignDataView() = default;

  SoftsignDataView(
      internal::Softsign_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Softsign_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitDataView {
 public:
  SplitDataView() = default;

  SplitDataView(
      internal::Split_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandIds(UserType* output) {
    
    auto* pointer = data_->output_operand_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  uint32_t axis() const {
    return data_->axis;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Split_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TanhDataView {
 public:
  TanhDataView() = default;

  TanhDataView(
      internal::Tanh_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tanh_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileDataView {
 public:
  TileDataView() = default;

  TileDataView(
      internal::Tile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetRepetitionsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRepetitions(UserType* output) {
    
    auto* pointer = data_->repetitions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TransposeDataView {
 public:
  TransposeDataView() = default;

  TransposeDataView(
      internal::Transpose_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetPermutationDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermutation(UserType* output) {
    
    auto* pointer = data_->permutation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Transpose_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TriangularDataView {
 public:
  TriangularDataView() = default;

  TriangularDataView(
      internal::Triangular_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  bool upper() const {
    return data_->upper;
  }
  int32_t diagonal() const {
    return data_->diagonal;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Triangular_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Resample2dDataView {
 public:
  Resample2dDataView() = default;

  Resample2dDataView(
      internal::Resample2d_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandId(UserType* output) {
    
    auto* pointer = data_->input_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::webnn::mojom::Resample2d_InterpolationMode>(
        data_value, output);
  }
  Resample2d_InterpolationMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Resample2d_InterpolationMode>(data_->mode));
  }
  inline void GetScalesDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScales(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `scales` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScales` instead "
    "of `ReadScales if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scales.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetAxesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAxes(UserType* output) {
    
    auto* pointer = data_->axes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Resample2d_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WhereDataView {
 public:
  WhereDataView() = default;

  WhereDataView(
      internal::Where_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConditionOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConditionOperandId(UserType* output) {
    
    auto* pointer = data_->condition_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetTrueValueOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrueValueOperandId(UserType* output) {
    
    auto* pointer = data_->true_value_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetFalseValueOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFalseValueOperandId(UserType* output) {
    
    auto* pointer = data_->false_value_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetOutputOperandIdDataView(
      OperandIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperandId(UserType* output) {
    
    auto* pointer = data_->output_operand_id.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandIdDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Where_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GraphInfoDataView {
 public:
  GraphInfoDataView() = default;

  GraphInfoDataView(
      internal::GraphInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOperandsDataView(
      mojo::ArrayDataView<OperandDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOperands(UserType* output) {
    
    auto* pointer = data_->operands.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandDataView>>(
        pointer, output, message_);
  }
  inline void GetInputOperandsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputOperands(UserType* output) {
    
    auto* pointer = data_->input_operands.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  inline void GetOutputOperandsDataView(
      mojo::ArrayDataView<OperandIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputOperands(UserType* output) {
    
    auto* pointer = data_->output_operands.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperandIdDataView>>(
        pointer, output, message_);
  }
  inline void GetOperationsDataView(
      mojo::ArrayDataView<OperationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOperations(UserType* output) {
    
    auto* pointer = data_->operations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::webnn::mojom::OperationDataView>>(
        pointer, output, message_);
  }
  inline void GetConstantOperandIdsToHandlesDataView(
      mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNPendingConstantTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstantOperandIdsToHandles(UserType* output) {
    
    auto* pointer = data_->constant_operand_ids_to_handles.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::webnn::mojom::OperandIdDataView, ::blink::mojom::WebNNPendingConstantTokenDataView>>(
        pointer, output, message_);
  }
  inline void GetIdToConstantTensorOperandMapDataView(
      mojo::MapDataView<OperandIdDataView, ::blink::mojom::WebNNTensorTokenDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdToConstantTensorOperandMap(UserType* output) {
    
    auto* pointer = data_->id_to_constant_tensor_operand_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::webnn::mojom::OperandIdDataView, ::blink::mojom::WebNNTensorTokenDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GraphInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NumberDataView {
 public:
  using Tag = internal::Number_Data::Number_Tag;

  NumberDataView() = default;

  NumberDataView(
      internal::Number_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_floating_point() const { return data_->tag == Tag::kFloatingPoint; }
  double floating_point() const {
    CHECK(is_floating_point());
    return data_->data.f_floating_point;
  }
  bool is_signed_integer() const { return data_->tag == Tag::kSignedInteger; }
  int64_t signed_integer() const {
    CHECK(is_signed_integer());
    return data_->data.f_signed_integer;
  }
  bool is_unsigned_integer() const { return data_->tag == Tag::kUnsignedInteger; }
  uint64_t unsigned_integer() const {
    CHECK(is_unsigned_integer());
    return data_->data.f_unsigned_integer;
  }

 private:
  internal::Number_Data* data_ = nullptr;
};



class PaddingModeDataView {
 public:
  using Tag = internal::PaddingMode_Data::PaddingMode_Tag;

  PaddingModeDataView() = default;

  PaddingModeDataView(
      internal::PaddingMode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_constant() const { return data_->tag == Tag::kConstant; }
  inline void GetConstantDataView(
      ConstantPaddingDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadConstant(UserType* output) const {
    
    CHECK(is_constant());
    return mojo::internal::Deserialize<::webnn::mojom::ConstantPaddingDataView>(
        data_->data.f_constant.Get(), output, message_);
  }
  bool is_edge() const { return data_->tag == Tag::kEdge; }
  inline void GetEdgeDataView(
      EdgePaddingDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEdge(UserType* output) const {
    
    CHECK(is_edge());
    return mojo::internal::Deserialize<::webnn::mojom::EdgePaddingDataView>(
        data_->data.f_edge.Get(), output, message_);
  }
  bool is_reflection() const { return data_->tag == Tag::kReflection; }
  inline void GetReflectionDataView(
      ReflectionPaddingDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReflection(UserType* output) const {
    
    CHECK(is_reflection());
    return mojo::internal::Deserialize<::webnn::mojom::ReflectionPaddingDataView>(
        data_->data.f_reflection.Get(), output, message_);
  }

 private:
  internal::PaddingMode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class OperationDataView {
 public:
  using Tag = internal::Operation_Data::Operation_Tag;

  OperationDataView() = default;

  OperationDataView(
      internal::Operation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_arg_min_max() const { return data_->tag == Tag::kArgMinMax; }
  inline void GetArgMinMaxDataView(
      ArgMinMaxDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadArgMinMax(UserType* output) const {
    
    CHECK(is_arg_min_max());
    return mojo::internal::Deserialize<::webnn::mojom::ArgMinMaxDataView>(
        data_->data.f_arg_min_max.Get(), output, message_);
  }
  bool is_batch_normalization() const { return data_->tag == Tag::kBatchNormalization; }
  inline void GetBatchNormalizationDataView(
      BatchNormalizationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBatchNormalization(UserType* output) const {
    
    CHECK(is_batch_normalization());
    return mojo::internal::Deserialize<::webnn::mojom::BatchNormalizationDataView>(
        data_->data.f_batch_normalization.Get(), output, message_);
  }
  bool is_clamp() const { return data_->tag == Tag::kClamp; }
  inline void GetClampDataView(
      ClampDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClamp(UserType* output) const {
    
    CHECK(is_clamp());
    return mojo::internal::Deserialize<::webnn::mojom::ClampDataView>(
        data_->data.f_clamp.Get(), output, message_);
  }
  bool is_concat() const { return data_->tag == Tag::kConcat; }
  inline void GetConcatDataView(
      ConcatDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadConcat(UserType* output) const {
    
    CHECK(is_concat());
    return mojo::internal::Deserialize<::webnn::mojom::ConcatDataView>(
        data_->data.f_concat.Get(), output, message_);
  }
  bool is_conv2d() const { return data_->tag == Tag::kConv2d; }
  inline void GetConv2dDataView(
      Conv2dDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadConv2d(UserType* output) const {
    
    CHECK(is_conv2d());
    return mojo::internal::Deserialize<::webnn::mojom::Conv2dDataView>(
        data_->data.f_conv2d.Get(), output, message_);
  }
  bool is_cumulative_sum() const { return data_->tag == Tag::kCumulativeSum; }
  inline void GetCumulativeSumDataView(
      CumulativeSumDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCumulativeSum(UserType* output) const {
    
    CHECK(is_cumulative_sum());
    return mojo::internal::Deserialize<::webnn::mojom::CumulativeSumDataView>(
        data_->data.f_cumulative_sum.Get(), output, message_);
  }
  bool is_dequantize_linear() const { return data_->tag == Tag::kDequantizeLinear; }
  inline void GetDequantizeLinearDataView(
      DequantizeLinearDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDequantizeLinear(UserType* output) const {
    
    CHECK(is_dequantize_linear());
    return mojo::internal::Deserialize<::webnn::mojom::DequantizeLinearDataView>(
        data_->data.f_dequantize_linear.Get(), output, message_);
  }
  bool is_element_wise_binary() const { return data_->tag == Tag::kElementWiseBinary; }
  inline void GetElementWiseBinaryDataView(
      ElementWiseBinaryDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadElementWiseBinary(UserType* output) const {
    
    CHECK(is_element_wise_binary());
    return mojo::internal::Deserialize<::webnn::mojom::ElementWiseBinaryDataView>(
        data_->data.f_element_wise_binary.Get(), output, message_);
  }
  bool is_elu() const { return data_->tag == Tag::kElu; }
  inline void GetEluDataView(
      EluDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadElu(UserType* output) const {
    
    CHECK(is_elu());
    return mojo::internal::Deserialize<::webnn::mojom::EluDataView>(
        data_->data.f_elu.Get(), output, message_);
  }
  bool is_element_wise_unary() const { return data_->tag == Tag::kElementWiseUnary; }
  inline void GetElementWiseUnaryDataView(
      ElementWiseUnaryDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadElementWiseUnary(UserType* output) const {
    
    CHECK(is_element_wise_unary());
    return mojo::internal::Deserialize<::webnn::mojom::ElementWiseUnaryDataView>(
        data_->data.f_element_wise_unary.Get(), output, message_);
  }
  bool is_expand() const { return data_->tag == Tag::kExpand; }
  inline void GetExpandDataView(
      ExpandDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExpand(UserType* output) const {
    
    CHECK(is_expand());
    return mojo::internal::Deserialize<::webnn::mojom::ExpandDataView>(
        data_->data.f_expand.Get(), output, message_);
  }
  bool is_gather() const { return data_->tag == Tag::kGather; }
  inline void GetGatherDataView(
      GatherDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGather(UserType* output) const {
    
    CHECK(is_gather());
    return mojo::internal::Deserialize<::webnn::mojom::GatherDataView>(
        data_->data.f_gather.Get(), output, message_);
  }
  bool is_gather_elements() const { return data_->tag == Tag::kGatherElements; }
  inline void GetGatherElementsDataView(
      GatherElementsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGatherElements(UserType* output) const {
    
    CHECK(is_gather_elements());
    return mojo::internal::Deserialize<::webnn::mojom::GatherElementsDataView>(
        data_->data.f_gather_elements.Get(), output, message_);
  }
  bool is_gather_nd() const { return data_->tag == Tag::kGatherNd; }
  inline void GetGatherNdDataView(
      GatherNDDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGatherNd(UserType* output) const {
    
    CHECK(is_gather_nd());
    return mojo::internal::Deserialize<::webnn::mojom::GatherNDDataView>(
        data_->data.f_gather_nd.Get(), output, message_);
  }
  bool is_gelu() const { return data_->tag == Tag::kGelu; }
  inline void GetGeluDataView(
      GeluDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGelu(UserType* output) const {
    
    CHECK(is_gelu());
    return mojo::internal::Deserialize<::webnn::mojom::GeluDataView>(
        data_->data.f_gelu.Get(), output, message_);
  }
  bool is_gemm() const { return data_->tag == Tag::kGemm; }
  inline void GetGemmDataView(
      GemmDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGemm(UserType* output) const {
    
    CHECK(is_gemm());
    return mojo::internal::Deserialize<::webnn::mojom::GemmDataView>(
        data_->data.f_gemm.Get(), output, message_);
  }
  bool is_gru() const { return data_->tag == Tag::kGru; }
  inline void GetGruDataView(
      GruDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGru(UserType* output) const {
    
    CHECK(is_gru());
    return mojo::internal::Deserialize<::webnn::mojom::GruDataView>(
        data_->data.f_gru.Get(), output, message_);
  }
  bool is_gru_cell() const { return data_->tag == Tag::kGruCell; }
  inline void GetGruCellDataView(
      GruCellDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGruCell(UserType* output) const {
    
    CHECK(is_gru_cell());
    return mojo::internal::Deserialize<::webnn::mojom::GruCellDataView>(
        data_->data.f_gru_cell.Get(), output, message_);
  }
  bool is_hard_sigmoid() const { return data_->tag == Tag::kHardSigmoid; }
  inline void GetHardSigmoidDataView(
      HardSigmoidDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHardSigmoid(UserType* output) const {
    
    CHECK(is_hard_sigmoid());
    return mojo::internal::Deserialize<::webnn::mojom::HardSigmoidDataView>(
        data_->data.f_hard_sigmoid.Get(), output, message_);
  }
  bool is_hard_swish() const { return data_->tag == Tag::kHardSwish; }
  inline void GetHardSwishDataView(
      HardSwishDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHardSwish(UserType* output) const {
    
    CHECK(is_hard_swish());
    return mojo::internal::Deserialize<::webnn::mojom::HardSwishDataView>(
        data_->data.f_hard_swish.Get(), output, message_);
  }
  bool is_layer_normalization() const { return data_->tag == Tag::kLayerNormalization; }
  inline void GetLayerNormalizationDataView(
      LayerNormalizationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLayerNormalization(UserType* output) const {
    
    CHECK(is_layer_normalization());
    return mojo::internal::Deserialize<::webnn::mojom::LayerNormalizationDataView>(
        data_->data.f_layer_normalization.Get(), output, message_);
  }
  bool is_instance_normalization() const { return data_->tag == Tag::kInstanceNormalization; }
  inline void GetInstanceNormalizationDataView(
      InstanceNormalizationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceNormalization(UserType* output) const {
    
    CHECK(is_instance_normalization());
    return mojo::internal::Deserialize<::webnn::mojom::InstanceNormalizationDataView>(
        data_->data.f_instance_normalization.Get(), output, message_);
  }
  bool is_leaky_relu() const { return data_->tag == Tag::kLeakyRelu; }
  inline void GetLeakyReluDataView(
      LeakyReluDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLeakyRelu(UserType* output) const {
    
    CHECK(is_leaky_relu());
    return mojo::internal::Deserialize<::webnn::mojom::LeakyReluDataView>(
        data_->data.f_leaky_relu.Get(), output, message_);
  }
  bool is_linear() const { return data_->tag == Tag::kLinear; }
  inline void GetLinearDataView(
      LinearDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLinear(UserType* output) const {
    
    CHECK(is_linear());
    return mojo::internal::Deserialize<::webnn::mojom::LinearDataView>(
        data_->data.f_linear.Get(), output, message_);
  }
  bool is_lstm() const { return data_->tag == Tag::kLstm; }
  inline void GetLstmDataView(
      LstmDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLstm(UserType* output) const {
    
    CHECK(is_lstm());
    return mojo::internal::Deserialize<::webnn::mojom::LstmDataView>(
        data_->data.f_lstm.Get(), output, message_);
  }
  bool is_lstm_cell() const { return data_->tag == Tag::kLstmCell; }
  inline void GetLstmCellDataView(
      LstmCellDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLstmCell(UserType* output) const {
    
    CHECK(is_lstm_cell());
    return mojo::internal::Deserialize<::webnn::mojom::LstmCellDataView>(
        data_->data.f_lstm_cell.Get(), output, message_);
  }
  bool is_matmul() const { return data_->tag == Tag::kMatmul; }
  inline void GetMatmulDataView(
      MatmulDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMatmul(UserType* output) const {
    
    CHECK(is_matmul());
    return mojo::internal::Deserialize<::webnn::mojom::MatmulDataView>(
        data_->data.f_matmul.Get(), output, message_);
  }
  bool is_pad() const { return data_->tag == Tag::kPad; }
  inline void GetPadDataView(
      PadDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPad(UserType* output) const {
    
    CHECK(is_pad());
    return mojo::internal::Deserialize<::webnn::mojom::PadDataView>(
        data_->data.f_pad.Get(), output, message_);
  }
  bool is_pool2d() const { return data_->tag == Tag::kPool2d; }
  inline void GetPool2dDataView(
      Pool2dDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPool2d(UserType* output) const {
    
    CHECK(is_pool2d());
    return mojo::internal::Deserialize<::webnn::mojom::Pool2dDataView>(
        data_->data.f_pool2d.Get(), output, message_);
  }
  bool is_prelu() const { return data_->tag == Tag::kPrelu; }
  inline void GetPreluDataView(
      PreluDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPrelu(UserType* output) const {
    
    CHECK(is_prelu());
    return mojo::internal::Deserialize<::webnn::mojom::PreluDataView>(
        data_->data.f_prelu.Get(), output, message_);
  }
  bool is_quantize_linear() const { return data_->tag == Tag::kQuantizeLinear; }
  inline void GetQuantizeLinearDataView(
      QuantizeLinearDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadQuantizeLinear(UserType* output) const {
    
    CHECK(is_quantize_linear());
    return mojo::internal::Deserialize<::webnn::mojom::QuantizeLinearDataView>(
        data_->data.f_quantize_linear.Get(), output, message_);
  }
  bool is_reduce() const { return data_->tag == Tag::kReduce; }
  inline void GetReduceDataView(
      ReduceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReduce(UserType* output) const {
    
    CHECK(is_reduce());
    return mojo::internal::Deserialize<::webnn::mojom::ReduceDataView>(
        data_->data.f_reduce.Get(), output, message_);
  }
  bool is_relu() const { return data_->tag == Tag::kRelu; }
  inline void GetReluDataView(
      ReluDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRelu(UserType* output) const {
    
    CHECK(is_relu());
    return mojo::internal::Deserialize<::webnn::mojom::ReluDataView>(
        data_->data.f_relu.Get(), output, message_);
  }
  bool is_resample2d() const { return data_->tag == Tag::kResample2d; }
  inline void GetResample2dDataView(
      Resample2dDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResample2d(UserType* output) const {
    
    CHECK(is_resample2d());
    return mojo::internal::Deserialize<::webnn::mojom::Resample2dDataView>(
        data_->data.f_resample2d.Get(), output, message_);
  }
  bool is_reshape() const { return data_->tag == Tag::kReshape; }
  inline void GetReshapeDataView(
      ReshapeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReshape(UserType* output) const {
    
    CHECK(is_reshape());
    return mojo::internal::Deserialize<::webnn::mojom::ReshapeDataView>(
        data_->data.f_reshape.Get(), output, message_);
  }
  bool is_reverse() const { return data_->tag == Tag::kReverse; }
  inline void GetReverseDataView(
      ReverseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReverse(UserType* output) const {
    
    CHECK(is_reverse());
    return mojo::internal::Deserialize<::webnn::mojom::ReverseDataView>(
        data_->data.f_reverse.Get(), output, message_);
  }
  bool is_scatter_elements() const { return data_->tag == Tag::kScatterElements; }
  inline void GetScatterElementsDataView(
      ScatterElementsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScatterElements(UserType* output) const {
    
    CHECK(is_scatter_elements());
    return mojo::internal::Deserialize<::webnn::mojom::ScatterElementsDataView>(
        data_->data.f_scatter_elements.Get(), output, message_);
  }
  bool is_scatter_nd() const { return data_->tag == Tag::kScatterNd; }
  inline void GetScatterNdDataView(
      ScatterNDDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScatterNd(UserType* output) const {
    
    CHECK(is_scatter_nd());
    return mojo::internal::Deserialize<::webnn::mojom::ScatterNDDataView>(
        data_->data.f_scatter_nd.Get(), output, message_);
  }
  bool is_sigmoid() const { return data_->tag == Tag::kSigmoid; }
  inline void GetSigmoidDataView(
      SigmoidDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSigmoid(UserType* output) const {
    
    CHECK(is_sigmoid());
    return mojo::internal::Deserialize<::webnn::mojom::SigmoidDataView>(
        data_->data.f_sigmoid.Get(), output, message_);
  }
  bool is_slice() const { return data_->tag == Tag::kSlice; }
  inline void GetSliceDataView(
      SliceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSlice(UserType* output) const {
    
    CHECK(is_slice());
    return mojo::internal::Deserialize<::webnn::mojom::SliceDataView>(
        data_->data.f_slice.Get(), output, message_);
  }
  bool is_softmax() const { return data_->tag == Tag::kSoftmax; }
  inline void GetSoftmaxDataView(
      SoftmaxDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSoftmax(UserType* output) const {
    
    CHECK(is_softmax());
    return mojo::internal::Deserialize<::webnn::mojom::SoftmaxDataView>(
        data_->data.f_softmax.Get(), output, message_);
  }
  bool is_softplus() const { return data_->tag == Tag::kSoftplus; }
  inline void GetSoftplusDataView(
      SoftplusDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSoftplus(UserType* output) const {
    
    CHECK(is_softplus());
    return mojo::internal::Deserialize<::webnn::mojom::SoftplusDataView>(
        data_->data.f_softplus.Get(), output, message_);
  }
  bool is_softsign() const { return data_->tag == Tag::kSoftsign; }
  inline void GetSoftsignDataView(
      SoftsignDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSoftsign(UserType* output) const {
    
    CHECK(is_softsign());
    return mojo::internal::Deserialize<::webnn::mojom::SoftsignDataView>(
        data_->data.f_softsign.Get(), output, message_);
  }
  bool is_split() const { return data_->tag == Tag::kSplit; }
  inline void GetSplitDataView(
      SplitDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSplit(UserType* output) const {
    
    CHECK(is_split());
    return mojo::internal::Deserialize<::webnn::mojom::SplitDataView>(
        data_->data.f_split.Get(), output, message_);
  }
  bool is_tanh() const { return data_->tag == Tag::kTanh; }
  inline void GetTanhDataView(
      TanhDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTanh(UserType* output) const {
    
    CHECK(is_tanh());
    return mojo::internal::Deserialize<::webnn::mojom::TanhDataView>(
        data_->data.f_tanh.Get(), output, message_);
  }
  bool is_tile() const { return data_->tag == Tag::kTile; }
  inline void GetTileDataView(
      TileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTile(UserType* output) const {
    
    CHECK(is_tile());
    return mojo::internal::Deserialize<::webnn::mojom::TileDataView>(
        data_->data.f_tile.Get(), output, message_);
  }
  bool is_transpose() const { return data_->tag == Tag::kTranspose; }
  inline void GetTransposeDataView(
      TransposeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTranspose(UserType* output) const {
    
    CHECK(is_transpose());
    return mojo::internal::Deserialize<::webnn::mojom::TransposeDataView>(
        data_->data.f_transpose.Get(), output, message_);
  }
  bool is_triangular() const { return data_->tag == Tag::kTriangular; }
  inline void GetTriangularDataView(
      TriangularDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTriangular(UserType* output) const {
    
    CHECK(is_triangular());
    return mojo::internal::Deserialize<::webnn::mojom::TriangularDataView>(
        data_->data.f_triangular.Get(), output, message_);
  }
  bool is_where() const { return data_->tag == Tag::kWhere; }
  inline void GetWhereDataView(
      WhereDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadWhere(UserType* output) const {
    
    CHECK(is_where());
    return mojo::internal::Deserialize<::webnn::mojom::WhereDataView>(
        data_->data.f_where.Get(), output, message_);
  }

 private:
  internal::Operation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_DATA_VIEW_H_